using System;
using System.Collections.Generic;
using System.Text;
using SIPPBXv3;

namespace CSCallIdle
{
    public class Class1 : ISIPPBXPluginClient
    {
        private string m_strName;
        private string m_strType;

        private ISIPPBXPluginHost m_Host;

        public Class1()
        {
            m_strName = "Call Hangup Plugin";
            m_strType = "CallIdle"; //"CallOffered", "CallRinging", or "CallDialing", or "CallConnected"
        }

        public string Name
        {
            get { return m_strName; }
            set { m_strName = value; }
        }

        public string Type
        {
            get { return m_strType; }
            set { m_strType = value; }
        }

        public ISIPPBXPluginHost Host
        {
            get { return m_Host; }
            set
            {
                m_Host = value;
            }
        }

        public void Start()
        {
            //get the caller and callee number
            string caller_addr = Host.Channel.caller_num;
            string callee_addr = Host.Channel.callee_num;

            string caller_num = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_addr);
            string callee_num = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, callee_addr);

            //channel index
            int ch = Host.Channel.ch_index;
            
            //call time
            //Host.Channel.call_start_time;
            //Host.Channel.call_end_time;

            //write CDR here


            Host.WriteLog("Channel " + ch.ToString() + " Call Ends");
        }

        public void Done()
        {
        }

        #region ICloneable Members

        public Class1 Clone()
        {
            Class1 client = new Class1();
            client.Name = Name;
            client.Type = Type;
            return client;
        }

        object ICloneable.Clone()
        {
            return Clone();
        }

        #endregion
    }
}
