using System;
using System.Collections.Generic;
using System.Text;
using SIPPBXv3;
using System.Windows.Forms;

namespace CSTestAgentLogin
{
    public class Class1 : ISIPPBXPluginClient
    {
        public const string RESULT_DISCONNECTED = "Disconnected";
        public const string RESULT_ERROR = "Error";

        private string m_strName;
        private string m_strType;

        private ISIPPBXPluginHost m_Host;

        public Class1()
        {
            m_strName = "TestAgentLogin";
            m_strType = "IVRMenu";
        }

        public string Name
        {
            get{return m_strName;}
            set{m_strName=value;}
        }

        public string Type
        {
            get{return m_strType;}
            set{m_strType=value;}
        }
 
        public ISIPPBXPluginHost Host
        {
            get{return m_Host;}
            set
            {
                m_Host=value;
            }
        }

        public void Start()
        {
            //get the caller and callee number
            string caller_addr = Host.Channel.caller_num;
            string callee_addr = Host.Channel.callee_num;

            string caller_num = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_addr);
            string callee_num = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, callee_addr);

            string audio_fn1 = Application.StartupPath + "\\audio\\Please-enter-acd-group-name.wav";
            //Host.WriteLog("Start to excute! Step 1 -> DisplayMenu " + audio_fn1);
            string sDTMF = Host.DisplayMenu(audio_fn1, 4, "#", 15000, true);

            Host.WriteLog("Display Menu Returned " + sDTMF);

            //if (Host.AgentLogin("2001", caller_num, sDTMF.TrimEnd('#')))
			if (Host.AgentLogin("2000", "1000", "800"))	
                Host.DisplayMenu(Application.StartupPath + "\\audio\\login-ok.wav", 0, "", 0, true);
            else
                Host.DisplayMenu(Application.StartupPath + "\\audio\\login-failed.wav", 0, "", 0, true);
        }

        public void Done()
        {
            Host.WriteLog("Done! Disconnected the call.");

            //only if you want the call ends after running the this plugin
            Host.HangUp();
        }

        #region ICloneable Members

        public Class1 Clone()
        {
            Class1 client = new Class1();
            client.Name = Name;
            client.Type = Type;
            return client;
        }

        object ICloneable.Clone()
        {
            return Clone();
        }

        #endregion
    }
}
