Imports System
Imports System.Windows.Forms
Imports SIPPBXv3

Public Class MySIPPBXPluginClient
    Implements ISIPPBXPluginClient
    Public Const RESULT_DISCONNECTED As String = "Disconnected"
    Public Const RESULT_ERROR As String = "Error"

    Private m_strName As String
    Private m_strType As String

    Private m_Host As ISIPPBXPluginHost

    Public Sub New()
        m_strName = "VBNetSample"
        m_strType = "IVRMenu"
    End Sub

    Public Property Name() As String Implements ISIPPBXPluginClient.Name
        Get
            Return m_strName
        End Get
        Set(ByVal value As String)
            m_strName = value
        End Set
    End Property

    Public Property Type() As String Implements ISIPPBXPluginClient.Type
        Get
            Return m_strType
        End Get
        Set(ByVal value As String)
            m_strType = value
        End Set
    End Property

    Public Property Host() As ISIPPBXPluginHost Implements ISIPPBXPluginClient.Host
        Get
            Return m_Host
        End Get
        Set(ByVal value As ISIPPBXPluginHost)
            m_Host = value
        End Set
    End Property

    Public Sub Start() Implements ISIPPBXPluginClient.Start
        'get the caller and callee number
        Dim caller_addr As String = Host.Channel.caller_num
        Dim callee_addr As String = Host.Channel.callee_num

        Dim caller_num As String = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_addr)
        Dim callee_num As String = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, callee_addr)

        'if it is a job of auto dialer task for human/answer machine detection,
        'use the following code to access detection result:

        'If Host.PBX_Channel.call_job IsNot Nothing Then
        'Select Case Host.PBX_Channel.call_job.DetectResult
        'Case 0
        ' = Answering Machine
        'Exit Select
        'Case 1
        ' Human voice
        'Exit Select
        'Case 2
        ' = Fax
        'Exit Select
        'Case -1
        ' silence (no voice at all)
        'Exit Select
        'Case -2
        ' detected voice, but unknown
        'Exit Select
        'Case -3
        ' = unknown
        'Exit Select
        'End Select
        'End If



        'There are twenty shared objects you can access and save object non-related to channel
        Dim obj As Object = Host.GetUserObj(0) 'Index from 0-19. for example, the last one is GetUserObj(19)
        Host.SetUserObj(0, caller_addr) 'Index from 0-19. for example, the last one is SetUserObj(19, object)

        'There are also twenty shared objects associated channel
        'you use channel index and object index to access them
        obj = Host.GetChanUserObj(Host.PBX_Channel.index, 0) 'Get this channel's first object
        Host.SetChanUserObj(Host.PBX_Channel.index, 0, caller_num) 'Set this channel's first object
        Host.GetChanUserObj(2, 0) 'Get channel 2's first object
        Host.SetChanUserObj(2, 0, New Integer) 'Set channel 2's first object

        Dim audio_fn1 As String = Application.StartupPath + "\audio\Please-enter-extension-number.wav"

        Host.WriteLog("Start to excute! Step 1 -> DisplayMenu Demo(please enter 4 digits extension number)")
        Dim sDTMF As String = Host.DisplayMenu(audio_fn1, 4, "#*98", 15000, True)

        Host.WriteLog("Display Menu Returned " & sDTMF)

        If sDTMF = RESULT_DISCONNECTED OrElse sDTMF = RESULT_ERROR Then
            'call is disconnected or got error
            Return
        End If

        'you can save your result into DB, or according to user's selection,
        'do something
        Dim audio_fn2 As String = Application.StartupPath + "\audio\Please-leave-your-message-after-beep.wav"
        Host.WriteLog("Step 2 -> PlayAudio Demo - WavFile:" & audio_fn2)

        sDTMF = Host.PlayAudio(audio_fn2, 0, "", 0)

        Host.WriteLog("PlayAudio returned " & sDTMF)

        If sDTMF = RESULT_DISCONNECTED OrElse sDTMF = RESULT_ERROR Then
            'call is disconnected or got error
            Return
        End If

        Host.WriteLog("Step 3: -> RecordAudio Demo(Record to c:\recording.wav, press # key to stop recording)")

        If Not System.IO.Directory.Exists("c:\temp") Then
            System.IO.Directory.CreateDirectory("c:\temp")
        End If

        sDTMF = Host.RecordAudio("c:\temp\recording-" + Host.Channel.ch_index.ToString() + ".wav", 0, "*#", 0)

        Host.WriteLog("RecordAudio returned " & sDTMF)

        If sDTMF = RESULT_DISCONNECTED OrElse sDTMF = RESULT_ERROR Then
            'call is disconnected or got error
            Return
        End If

        Host.WriteLog("Step 4: -> DetectDTMF Demo(Detecting DTMFs, please enter two digits)")

        sDTMF = Host.DetectDTMF(2, "#", 10000)

        Host.WriteLog("DetectDTMF returned " & sDTMF)

        If sDTMF = RESULT_DISCONNECTED OrElse sDTMF = RESULT_ERROR Then
            'call is disconnected or got error
            Return
        End If

        Host.WriteLog("Reached End!")

    End Sub

    Public Sub Done() Implements ISIPPBXPluginClient.Done
        Host.WriteLog("Done! Disconnected the call.")

        'only if you want the call ends after running the this plugin
        Host.HangUp()

        'otherwise you can use one of Host's To function to route the call
        'Host.ToExtension("110");
        'Host.ToIVRMenu("Another IVR Menu Name set already in PBX");
        'Host.ToMonitorGroup("Monitor Group Name");
        'Host.ToHuntGroup("ACD group name", false);
        'Host.ToRingGroup("Ring Group Name");
        'Host.ToVoiceMailBox("Extension Name");
        'Host.ToConferenceRoom("conference room name");
        'Host.ToPlugin("Another plugin's name");

        'to another outside number
        'Host.ToNumber("<sip:123@192.168.1.100>", null);
        'Host.ToNumber("<sip:6781992@callcentric.com>", null);
        'or
        'SIPAccount acct1;
        'acct1.DisplayName = "any";
        'acct1.UserName = "1234";
        'acct1.DomainServer = "sip.callwithus.com";
        'acct1.ProxyServer = "sip.callwithus.com";
        'acct1.AuthName = "1234";
        'acct1.Password = "xxxxx";
        'Host.ToNumber("655112", acct1);

        'Host.Channel.pEnv.Send_Transfer(Host.Channel.ch_index, "<sip:0116@192.168.1.177>");

    End Sub

#Region "ICloneable Members"

    Public Function Clone() As MySIPPBXPluginClient
        Dim client As New MySIPPBXPluginClient()
        client.Name = Name
        client.Type = Type
        Return client
    End Function

    Private Function ICloneable_Clone() As Object Implements ICloneable.Clone
        Return Clone()
    End Function

#End Region

End Class
