using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace ManagerClient
{
    public partial class Form1 : Form
    {
        private PBXManagerClient mc;
        private bool server_connected;

        public Form1()
        {
            InitializeComponent();
            mc = new PBXManagerClient();
            mc.main_form = this;
            server_connected = false;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            tbServerIP.Text = "127.0.0.1";
            tbServerPort.Text = "9232";

            tabControl1.Enabled = false;

            //Text = "iSevr PBX Manager Client Sample";

            /*
            btnAgentLogin.Enabled = false;
            btnResetACD.Enabled = false;
            btnResetChan.Enabled = false;
            btnAgentLogout.Enabled = false;

            btnListen.Enabled = false;
            btnWhisper.Enabled = false;
            btnBargin.Enabled = false;
            btnStop.Enabled = false;

            tbCalloutExtn.Enabled = false;
            tbCalloutNum.Enabled = false;
            tbCalloutSIPAcct.Enabled = false;
            tbCalloutTimeout.Enabled = false;
            btnCallout.Enabled = false;

            btnMakeCall.Enabled = false;
            btnAnswerCall.Enabled = false;
            btnHangUpCall.Enabled = false;
            tbChanID.Enabled = false;
            tbCaller.Enabled = false;
            tbCallee.Enabled = false;

            btnCallExtension.Enabled = false;
            tbCallExten.Enabled = false;
            tbCallExtenChan.Enabled = false;

            btnConnect.Enabled = false;
            tbBridgeCall1.Enabled = false;
            tbBridgeCall2.Enabled = false;

            tbChanRunDialplan.Enabled = false;
            tbDialplanName.Enabled = false;
            btnRunDialPlan.Enabled = false;
            tbMagicTransferChan.Enabled = false;
            tbMagicCode.Enabled = false;
            btnRunMagicCode.Enabled = false;
            */
        }


        public void LogoutText(string sLogInfo/*, bool bTrace*/)
        {
            lock (this)
            {
                sLogInfo = "[" + SIPPBXWinUtil.GetSQLDateTime(DateTime.Now) + "]" + " " + sLogInfo;
                if (LogRichEdit.Text.Length > 1024 * 512)
                    LogRichEdit.Text = "";
                LogRichEdit.Text = LogRichEdit.Text + sLogInfo + "\r\n";
                LogRichEdit.Select(LogRichEdit.Text.Length - 2, 1);
                LogRichEdit.ScrollToCaret();
            }
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            mc.ProcessEvents();
        }

        private void btnConnectToServer_Click(object sender, EventArgs e)
        {
            if (!server_connected)
            {
                if (mc.ConnectTo(tbServerIP.Text, Convert.ToUInt16(tbServerPort.Text)) != null)
                {
                }
            }
            else
            {
                mc.Disconnect();
            }
        }

        public void ServerConnected(bool bConnected)
        {
            server_connected = bConnected;
            if (bConnected)
            {
                LogoutText("Server Connected!");
                btnConnectToServer.Text = "Disconnect";

                tabControl1.Enabled = true;
                /*
                btnAgentLogin.Enabled = true;
                btnResetACD.Enabled = true;
                btnResetChan.Enabled = true;
                btnAgentLogout.Enabled = true;

                btnListen.Enabled = true;
                btnWhisper.Enabled = true;
                btnBargin.Enabled = true;
                btnStop.Enabled = true;

                tbCalloutExtn.Enabled = true;
                tbCalloutNum.Enabled = true;
                tbCalloutSIPAcct.Enabled = true;
                tbCalloutTimeout.Enabled = true;
                btnCallout.Enabled = true;

                btnMakeCall.Enabled = true;
                btnAnswerCall.Enabled = true;
                btnHangUpCall.Enabled = true;
                tbChanID.Enabled = true;
                tbCaller.Enabled = true;
                tbCallee.Enabled = true;

                btnCallExtension.Enabled = true;
                tbCallExten.Enabled = true;
                tbCallExtenChan.Enabled = true;

                btnConnect.Enabled = true;
                tbBridgeCall1.Enabled = true;
                tbBridgeCall2.Enabled = true;

                tbChanRunDialplan.Enabled = true;
                tbDialplanName.Enabled = true;
                btnRunDialPlan.Enabled = true;
                tbMagicTransferChan.Enabled = true;
                tbMagicCode.Enabled = true;
                btnRunMagicCode.Enabled = true;
                */
            }
            else
            {
                LogoutText("Server Disconnected!");
                btnConnectToServer.Text = "Connect To Server";

                tabControl1.Enabled = false;

                /*
                btnAgentLogin.Enabled = false;
                btnResetACD.Enabled = false;
                btnResetChan.Enabled = false;
                btnAgentLogout.Enabled = false;

                btnListen.Enabled = false;
                btnWhisper.Enabled = false;
                btnBargin.Enabled = false;
                btnStop.Enabled = false;

                tbCalloutExtn.Enabled = false;
                tbCalloutNum.Enabled = false;
                tbCalloutSIPAcct.Enabled = false;
                tbCalloutTimeout.Enabled = false;
                btnCallout.Enabled = false;

                btnMakeCall.Enabled = false;
                btnAnswerCall.Enabled = false;
                btnHangUpCall.Enabled = false;
                tbChanID.Enabled = false;
                tbCaller.Enabled = false;
                tbCallee.Enabled = false;

                btnCallExtension.Enabled = false;
                tbCallExten.Enabled = false;
                tbCallExtenChan.Enabled = false;

                btnConnect.Enabled = false;
                tbBridgeCall1.Enabled = false;
                tbBridgeCall2.Enabled = false;

                tbChanRunDialplan.Enabled = false;
                tbDialplanName.Enabled = false;
                btnRunDialPlan.Enabled = false;
                tbMagicTransferChan.Enabled = false;
                tbMagicCode.Enabled = false;
                btnRunMagicCode.Enabled = false;
                */
            }
        }

        private void btnResetChan_Click(object sender, EventArgs e)
        {
            if (tbChanIndex.Text.Length > 0)
            {
                try
                {
                    mc.ResetChannel(Convert.ToInt32(tbChanIndex.Text));
                }
                catch (Exception)
                {
                }
            }
        }

        private void btnAgentLogin_Click(object sender, EventArgs e)
        {
            if (tbAgentCode.Text.Length > 0 && tbExtension.Text.Length > 0)
                mc.AgentLogin(tbAgentCode.Text, tbExtension.Text, true, tbACDGroupName.Text, "", "");
        }

        private void btnAgentLogout_Click(object sender, EventArgs e)
        {
            if (tbAgentCode.Text.Length > 0 && tbExtension.Text.Length > 0)
                mc.AgentLogin(tbAgentCode.Text, tbExtension.Text, false, tbACDGroupName.Text, "", "");
        }

        private void btnResetACD_Click(object sender, EventArgs e)
        {
            if (tbACDGroup.Text.Length > 0)
                mc.ResetACD(tbACDGroup.Text);
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (server_connected)
                mc.Disconnect();
        }

        private void btnListen_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                if (tbExtnSupervisor.Text.Trim().Length > 0 && tbExtnAgent.Text.Trim().Length > 0)
                {
                    mc.MonitorCall(tbExtnSupervisor.Text.Trim(), tbExtnAgent.Text.Trim(), 0);
                }
            }
        }

        private void btnWhisper_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                if (tbExtnSupervisor.Text.Trim().Length > 0 && tbExtnAgent.Text.Trim().Length > 0)
                {
                    mc.MonitorCall(tbExtnSupervisor.Text.Trim(), tbExtnAgent.Text.Trim(), 1);
                }
            }
        }

        private void btnBargin_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                if (tbExtnSupervisor.Text.Trim().Length > 0 && tbExtnAgent.Text.Trim().Length > 0)
                {
                    mc.MonitorCall(tbExtnSupervisor.Text.Trim(), tbExtnAgent.Text.Trim(), 2);
                }
            }
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                if (tbExtnSupervisor.Text.Trim().Length > 0 && tbExtnAgent.Text.Trim().Length > 0)
                {
                    mc.MonitorCall(tbExtnSupervisor.Text.Trim(), tbExtnAgent.Text.Trim(), -1);
                }
            }
        }

        private void btnCallout_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                mc.ExtenCallOut(tbCalloutExtn.Text, tbCalloutNum.Text, tbCalloutSIPAcct.Text, Convert.ToInt32(tbCalloutTimeout.Text));
            }
        }

        private void btnMakeCall_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                int ch = Convert.ToInt32(tbChanID.Text);

                mc.MakeCall(ch, tbCaller.Text, tbCallee.Text);
            }
        }

        private void btnAnswerCall_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                int ch = Convert.ToInt32(tbChanID.Text);

                mc.AnswerCall(ch);
            }
        }

        private void btnHangUpCall_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                int ch = Convert.ToInt32(tbChanID.Text);

                mc.HangupCall(ch);
            }
        }

        private void btnCallExtension_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                int ch = Convert.ToInt32(tbCallExtenChan.Text);
                mc.MakeExtensionCall(ch, tbCallExten.Text, txtCallExtnCaller.Text);
            }
        }

        private void btnConnect_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                int ch1 = Convert.ToInt32(tbBridgeCall1.Text);
                int ch2 = Convert.ToInt32(tbBridgeCall2.Text);
                mc.BridgeTwoCalls(ch1, ch2);
            }
        }

        private void btnRunDialPlan_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                int ch = Convert.ToInt32(tbChanRunDialplan.Text);
                mc.RunDialPlan(ch, tbDialplanName.Text);
            }
        }

        private void btnRunMagicCode_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                int ch = Convert.ToInt32(tbMagicTransferChan.Text);
                mc.MagicTransfer(ch, tbMagicCode.Text);
            }
        }

        private void btnCreateConf_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                mc.CreateConferenceRoom(tbConfName.Text.Trim());
            }
        }

        private void btnDestroyConf_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                mc.DestroyConferenceRoom(tbConfName.Text.Trim());
            }
        }

        private void btnAddConf1_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                int ch = Convert.ToInt32(tbConfChanID.Text);
                mc.SetChanInConferenceRoom(ch, tbConfName.Text.Trim(), 1);
            }
        }

        private void btnAddConf2_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                int ch = Convert.ToInt32(tbConfChanID.Text);
                mc.SetChanInConferenceRoom(ch, tbConfName.Text.Trim(), 0); //just in case it was added first, so remove it.
                mc.SetChanInConferenceRoom(ch, tbConfName.Text.Trim(), 2); //add it as listening model = 2.
            }
        }

        private void btnRemoveConf_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                int ch = Convert.ToInt32(tbConfChanID.Text);
                mc.SetChanInConferenceRoom(ch, tbConfName.Text.Trim(), 0);
            }

        }

        private void btnGetConfStatus_Click(object sender, EventArgs e)
        {
            if (server_connected)
            {
                mc.GetConferenceRoomStatus(tbConfName.Text.Trim());
            }
        }



    }

    public class PBXManagerClient :  SIPPBXManagerClient
    {
        public Form1 main_form;

        public override void OnCallOffered(int ch, string unique_id, string caller, string callee, string dialplan_name, string audio_fn)
        {
            main_form.LogoutText("OnCallOffered " + ch.ToString() + " " /*+ unique_id + " "*/ + caller + " " + callee + " " + dialplan_name + " " + audio_fn);
        }

        public override void OnCallDialing(int ch, string unique_id, string caller, string callee, string dialplan_name, string audio_fn)
        {
            main_form.LogoutText("OnCallDialing " + ch.ToString() + " " /*+ unique_id + " "*/ + caller + " " + callee + " " + dialplan_name + " " + audio_fn);
        }

        public override void OnCallRinging(int ch, string unique_id, string dialplan_name, string audio_fn)
        {
            main_form.LogoutText("OnCallRinging " + ch.ToString() + " " /*+ unique_id + " "*/  + dialplan_name + " " + audio_fn);
        }

        public override void OnCallConnected(int ch, string unique_id, string dialplan_name, string audio_fn)
        {
            main_form.LogoutText("OnCallConnected " + ch.ToString() + " " /*+ unique_id + " "*/ + dialplan_name + " " + audio_fn);
        }

        public override void OnCallIdle(int ch, string unique_id, string dialplan_name, string audio_fn)
        {
            main_form.LogoutText("OnCallIdle " + ch.ToString() + " " /*+ unique_id + " "*/ + dialplan_name + " " + audio_fn);
        }

        public override void ServerConnected(bool bConnected)
        {
            main_form.ServerConnected(bConnected);
        }

        public override void OnCallMonitoring(string extenSupervisor, string extenNormal, int monitorType)
        {
            main_form.LogoutText("OnCallMonitoring " + extenSupervisor + " " + extenNormal + " " + monitorType.ToString());
        }

        public override void OnAgentLog(bool bLogIn, string agentCode, string extenNum, string p1, string p2, string p3)
        {
            base.OnAgentLog(bLogIn, agentCode, extenNum, p1, p2, p3);

            main_form.LogoutText("OnAgentLog " + (bLogIn ? "1" : "0") + " " + agentCode + " " + extenNum);
        }

        public override void OnAgentStatus(string agentCode, string atExten, string callStatus)
        {
            base.OnAgentStatus(agentCode, atExten, callStatus);

            main_form.LogoutText("OnAgentStatus " + agentCode + " " + atExten + " " + callStatus);
        }

        public override void OnExtenStatus(string extenNum, string callStatus)
        {
            base.OnExtenStatus(extenNum, callStatus);

            main_form.LogoutText("OnExtenStatus " + extenNum + " " + callStatus);
        }

        public override void OnConferenceRoomStatus(string roomName, string channels)
        {
            base.OnConferenceRoomStatus(roomName, channels);

            main_form.LogoutText("OnConferenceRoomStatus " + roomName + " " + channels);

        }
    }
}