﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Diagnostics;
using System.Linq;
using System.ServiceProcess;
using System.Text;
using System.Threading;

namespace PBXv3Watcher
{
    public partial class Service1 : ServiceBase
    {
        public CSPBXv3WatcherEnv m_pEnv;
        public Thread mainThread;
        public bool bExit;

        public Service1()
        {
            InitializeComponent();

            mainThread = new Thread(Run);
        }

        static void Run(object obj)
        {
            Service1 host = (Service1)obj;
            while (!host.bExit)
            {
                host.m_pEnv.ProcessGTAPIEvent();
                Thread.Sleep(100);
            }

        }

        protected override void OnStart(string[] args)
        {
            InitSIPServer();

            bExit = false;
            mainThread.Start(this);
        }

        protected override void OnStop()
        {
            bExit = true;
            Thread.Sleep(300);
            FreeSIPServer();
        }

        public void InitSIPServer()
        {
            m_pEnv = new CSPBXv3WatcherEnv();

            m_pEnv.CreateEnv();
            //m_pEnv.SetMainWnd(null);

            System.IO.Directory.SetCurrentDirectory(System.AppDomain.CurrentDomain.BaseDirectory);

            //Configuration file, if you want to define parameters in a file
            m_pEnv.CFG_SetValue("gtsrv.config.filename", System.AppDomain.CurrentDomain.BaseDirectory + "PBXv3Watcher.ini");

            m_pEnv.CFG_SetValue("gtsrv.log.level", "4");
            m_pEnv.CFG_SetValue("gtsrv.log.filename", System.AppDomain.CurrentDomain.BaseDirectory + "PBXv3Watcher.log");

            m_pEnv.SetAppName("PBXv3Watcher");
            m_pEnv.CFG_SetValue("gtsrv.licence.key", "");
     
            if (!m_pEnv.StartServer())
            {
                //MessageBox.Show("StartServer failed! Please make sure the SIP port set in INI file is not being using by another application.");
            }

            m_pEnv.LOG_Trace(4, "Running path:" + System.AppDomain.CurrentDomain.BaseDirectory);
            m_pEnv.LOG_Trace(4, "Config file:" + System.AppDomain.CurrentDomain.BaseDirectory + "PBXv3Watcher.ini");

            m_pEnv.TimerValue = Convert.ToUInt32(m_pEnv.CFG_GetValue("pbxv3.timer.value", "10000"));
            m_pEnv.StartTimer(0, m_pEnv.TimerValue);
            m_pEnv.LOG_Trace(4, "TimerValue:" + m_pEnv.TimerValue.ToString());

            m_pEnv.CallerId = m_pEnv.CFG_GetValue("pbxv3.caller.id", "<sip:1001@127.0.0.1>");
            m_pEnv.CalledId = m_pEnv.CFG_GetValue("pbxv3.called.id", "");
            m_pEnv.LOG_Trace(4, "Caller:" + m_pEnv.CallerId + " called:" + m_pEnv.CalledId);

            m_pEnv.MaxNotConnectedNum = Convert.ToInt32(m_pEnv.CFG_GetValue("pbxv3.max.num.not.connected", "1"));
            m_pEnv.LOG_Trace(4, "MaxNotConnectedNum:" + m_pEnv.MaxNotConnectedNum.ToString());
            
        }

        public void FreeSIPServer()
        {
            //m_pEnv.LOG_Trace(4, "FreeSIPServer StopServer");
            m_pEnv.StopServer();
            //m_pEnv.LOG_Trace(4, "FreeSIPServer DestroyEnv");
            m_pEnv.DestroyEnv();
            //m_pEnv.LOG_Trace(4, "FreeSIPServer ending");
            m_pEnv = null;
        }

    }
}
