using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class ACDAgentList : Form
    {
        public SIPPBX pbx;
        public ACDAgentList()
        {
            InitializeComponent();
        }

        private void ACDAgentList_Load(object sender, EventArgs e)
        {
            lvACDAgentList.Columns.Clear();
            lvACDAgentList.Columns.Add("Code", 120, HorizontalAlignment.Left);
            lvACDAgentList.Columns.Add("Status", 120, HorizontalAlignment.Left);
            lvACDAgentList.Columns.Add("LoginTime", 240, HorizontalAlignment.Left);

            ShowACDAgentList();
        }

        public void ShowACDAgentList()
        {
            lvACDAgentList.Items.Clear();

            for (int i = 0; i < pbx.sip_agents.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(pbx.sip_agents[i].Code);
                if (pbx.sip_agents[i].AtExten != null)
                {
                    aItem.SubItems.Add("Logged in(" + pbx.sip_agents[i].AtExten.UserName + ")");
                    aItem.SubItems.Add(pbx.sip_agents[i].LogInTime.ToString("yyyy-MM-dd HH:mm:ss"));
                }
                else
                {
                    aItem.SubItems.Add("Offline");
                    aItem.SubItems.Add(pbx.sip_agents[i].LogInTime.ToString("N/A"));
                }
                lvACDAgentList.Items.Add(aItem);
            }
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            SIPPBXAgent agent = new SIPPBXAgent();
            ACDAgentEdit dlg = new ACDAgentEdit();
            dlg.agent = agent;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                //check if the agent code is unique
                bool bFound = false;
                for (int i = 0; i < pbx.sip_agents.Count; i++)
                {
                    if (pbx.sip_agents[i].Code == agent.Code)
                    {
                        bFound = true;
                        break;
                    }
                }
                if (!bFound)
                {
                    if (SIPPBXCFGDB.AddAgentToDB(agent, null, pbx, null, pbx.db_set, PBXMainForm.log))
                    {
                        pbx.sip_agents.Add(agent);
                        ShowACDAgentList();
                    }
                    else
                    {
                        MessageBox.Show("Cannot add this agent into DB.", "Error");
                    }
                }
                else
                {
                    MessageBox.Show("Agent code " + agent.Code + " already exists in list.", "Error");
                }
            }
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            if (lvACDAgentList.SelectedIndices.Count > 0)
            {
                int idx = lvACDAgentList.SelectedIndices[0];
                ACDAgentEdit dlg = new ACDAgentEdit();
                SIPPBXAgent agent = new SIPPBXAgent();
                agent.Code = pbx.sip_agents[idx].Code;
                agent.Name = pbx.sip_agents[idx].Name;
                agent.Password = pbx.sip_agents[idx].Password;
                agent.RecordCall = pbx.sip_agents[idx].RecordCall;
                agent.SkillLevel = pbx.sip_agents[idx].SkillLevel;

                dlg.agent = agent;
                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    bool bFound = false;
                    for (int i = 0; i < pbx.sip_agents.Count; i++)
                    {
                        if (i != idx)
                        {
                            if (pbx.sip_agents[i].Code == agent.Code)
                            {
                                bFound = true;
                                break;
                            }
                        }
                    }
                    if (!bFound)
                    {
                        pbx.sip_agents[idx].Code = agent.Code;
                        pbx.sip_agents[idx].Name = agent.Name;
                        pbx.sip_agents[idx].Password = agent.Password;
                        pbx.sip_agents[idx].RecordCall = agent.RecordCall;
                        pbx.sip_agents[idx].SkillLevel = agent.SkillLevel;

                        if (SIPPBXCFGDB.UpdateAgentInDB(pbx.sip_agents[idx], null, pbx, null, pbx.db_set, PBXMainForm.log))
                        {
                            ShowACDAgentList();
                        }
                        else
                        {
                            MessageBox.Show("Cannot update this agent in DB!", "Error");
                        }
                    }
                    else
                    {
                        MessageBox.Show("Agent code " + agent.Code + "already exists in list.", "Error");
                    }
                }
            }
            else
            {
                MessageBox.Show("Please select an agent first!", "Error");
            }

        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            if (lvACDAgentList.SelectedIndices.Count > 0)
            {
                DialogResult dialogResult = MessageBox.Show("Are you sure to delete the item?", "Confirmation", MessageBoxButtons.YesNo);
                if (dialogResult == DialogResult.Yes)
                {
                    //do something
                }
                else if (dialogResult == DialogResult.No)
                {
                    //do something else
                    return;
                }

                if (SIPPBXCFGDB.RemoveAgentFromDB(pbx.sip_agents[lvACDAgentList.SelectedIndices[0]], null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    pbx.sip_agents.RemoveAt(lvACDAgentList.SelectedIndices[0]);
                    ShowACDAgentList();
                }
                else
                {
                    MessageBox.Show("Cannot delete this agent from DB!", "Error");
                }
            }
            else
            {
                MessageBox.Show("Please select an agent first!", "Error");
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void btnAgentCallPrompt_Click(object sender, EventArgs e)
        {
            ACDAgentPrompts dlg = new ACDAgentPrompts();
            dlg.pbx = pbx;
            dlg.ShowDialog();
        }



    }
}