using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Data.Common;
using System.Data.SqlTypes;
using System.Data.SQLite;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Data.SqlClient;
using System.IO;
using Microsoft.Win32;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class AutoDialerCallAdd : Form
    {
        public SIPPBX pbx;
        List<string[]> parsedData;
        int lineCnt;

        public AutoDialerCallAdd()
        {
            InitializeComponent();
            lineCnt = 0;
            parsedData = new List<string[]>();
        }

        private void AutoDialerCallAdd_Load(object sender, EventArgs e)
        {
            tbCallCount.Text = "1";
            tbTypeCode.Text = "1";
            dtPicker.Value = DateTime.Now;
        }

        private Int64 GetStartID()
        {
            Int64 ret = 0;
            DBServerSetting db_set = new DBServerSetting();
            db_set.CopyFrom(pbx.db_set);
            try
            {
                if (db_set.ConnectDB())
                {
                    try
                    {
                        string sqlstr = "SELECT MAX(ID) FROM auto_dialer_jobs";
                        DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, null);
                        try
                        {
                            if (myReader.Read())
                            {
                                ret = myReader.GetInt64(0);
                            }
                        }
                        catch (Exception)
                        {
                        }
                        finally
                        {
                            myReader.Close();
                        }
                    }
                    catch (Exception)
                    {
                    }
                    finally
                    {
                    }

                    try
                    {
                        string sqlstr = "SELECT MAX(ID) FROM auto_dialer_done";
                        DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, null);
                        try
                        {
                            if (myReader.Read())
                            {
                                if (ret < myReader.GetInt64(0))
                                    ret = myReader.GetInt64(0);
                            }
                        }
                        catch (Exception)
                        {
                        }
                        finally
                        {
                            myReader.Close();
                        }
                    }
                    catch (Exception)
                    {
                    }

                    db_set.DisconnectDB();
                }
            }
            catch (Exception)
            {
            }

            return ret + 1;
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            Int64 idStart = GetStartID();

            if (tabControl1.SelectedIndex == 0)
            {
                int nCount = Convert.ToInt32(tbCallCount.Text);
                short nTypeCode = Convert.ToInt16(tbTypeCode.Text);
                string sCaller = tbCaller.Text;
                string sCallee = tbCallee.Text;
                string sDateNeed = SIPPBXWinUtil.GetSQLDateTime(dtPicker.Value);
                string sJobId = tbJobID.Text;

                if (nCount == 0 || nTypeCode == 0 || sCallee.Length == 0)
                {
                    MessageBox.Show("Not right data", "Error");
                    return;
                }

                DBServerSetting db_set = pbx.GetDBServerSet();

                if (!db_set.ConnectDB())
                {
                    MessageBox.Show("Cannot connect to DB!", "Error");
                    return;
                }

                for (int i = 0; i < nCount; i++)
                {
                    string sqlstr = "INSERT INTO auto_dialer_jobs VALUES(" + idStart.ToString() + ", " + nTypeCode.ToString() + ", '";
                    sqlstr += sCaller + "', '" + sCallee + "', '";

                    if(sJobId.Length > 0)
                        sqlstr += sDateNeed + "', '" + sJobId + "')";
                    else
                        sqlstr += sDateNeed + "', '" + SIPPBXWinUtil.RandomString(12, false) + "')";

                    if (db_set.ExcuteNonQuerySQL(sqlstr, null) == 1)
                    {
                    }
                    else
                    {
                        MessageBox.Show("Cannot insert call task!", "Error");
                        break;
                    }

                    idStart++;
                }

                db_set.DisconnectDB();
            }
            else
            {
                if (parsedData.Count > 0)
                {
                    int lines = 0;
                    DBServerSetting db_set = pbx.GetDBServerSet();

                    if (!db_set.ConnectDB())
                    {
                        MessageBox.Show("Cannot connect to DB!", "Error");
                        return;
                    }

                    for (int i = 0; i < parsedData.Count; i++)
                    {
                        string[] row = parsedData[i];

                        short nTypeCode = Convert.ToInt16(row[0].Trim());
                        string sCaller = row[1].Trim();
                        string sCallee = row[2].Trim();
                        string sDateNeed = row[3].Trim();
                        string sUniqeKey = row[4].Trim();

                        if (nTypeCode == 0 || sCallee.Length == 0)
                        {
                            continue;
                        }

                        if (sDateNeed.Length == 0)
                        {
                            sDateNeed = SIPPBXWinUtil.GetSQLDateTime(DateTime.Now);
                        }

                        string sqlstr = "INSERT INTO auto_dialer_jobs VALUES(" + idStart.ToString() + ", " + nTypeCode.ToString() + ", '";
                        sqlstr += sCaller + "', '" + sCallee + "', '";
                        sqlstr += sDateNeed + "', '" + sUniqeKey + "')";

                        if (db_set.ExcuteNonQuerySQL(sqlstr, null) == 1)
                        {
                        }
                        else
                        {
                            MessageBox.Show("Cannot insert call task!", "Error");
                            break;
                        }

                        idStart++;
                        lines++;
                    }

                    db_set.DisconnectDB();

                    MessageBox.Show(lines + " records are loaded and inserted into database!");
                }
                else
                {
                    MessageBox.Show("File(" + tbCSVFilePath.Text + ") doesn't exist!");
                    return;
                }
                
            }

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void btnBrowser_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = "CSV files (*.csv)|*.csv|TXT files (*.txt)|*.txt|All files (*.*)|*.*";
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbCSVFilePath.Text = openFileDialog1.FileName;

                if (File.Exists(tbCSVFilePath.Text))
                {
                    lineCnt = 0;
                    parsedData.Clear();
                    rtbRecords.Text = "";

                    try
                    {
                        using (StreamReader readFile = new StreamReader(tbCSVFilePath.Text))
                        {
                            string line;
                            string[] row;
                            char[] delimiters = new char[] { ';', ',', '|' };

                            while ((line = readFile.ReadLine()) != null)
                            {
                                row = line.Split(delimiters, StringSplitOptions.None);
                                if (row.Length >= 5)
                                {
                                    parsedData.Add(row);
                                    lineCnt++;
                                    rtbRecords.Text += line + "\r\n";
                                }
                                else
                                {
                                    MessageBox.Show("Format error at line: " + line);
                                    lineCnt = 0;
                                    parsedData.Clear();
                                    rtbRecords.Text = "";
                                    return;
                                }
                            }
                        }
                    }
                    catch (Exception ex)
                    {
                        MessageBox.Show(ex.ToString());
                        lineCnt = 0;
                        parsedData.Clear();
                        rtbRecords.Text = "";
                        return;
                    }

                    if (lineCnt == 0)
                    {
                        MessageBox.Show("There is no records in the file(" + tbCSVFilePath.Text + ")");
                    }
                    else
                    {
                        lbRecords.Text = lineCnt.ToString() + " jobs(calls) are loaded!";
                    }

                }
                else
                {
                    MessageBox.Show("File(" + tbCSVFilePath.Text + ") doesn't exist!");
                }
            }

        }


    }
}