using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class AutoDialerTaskEdit : Form
    {
        public SIPPBX pbx;
        public AutoDialerTask task;

        public AutoDialerTaskEdit()
        {
            InitializeComponent();
        }

        private void AutoDialerTaskEdit_Load(object sender, EventArgs e)
        {
            tbName.Text = task.task_name;
            cbEnable.Checked = task.isOn;
            tbTypeCode.Text = task.type_code.ToString();
            tbRingTimeout.Text = task.m_ringTimeout.ToString();
            //cbWriteSIPCode.Checked = task.m_bWriteSIPCode;
            tbMaxSimCalls.Text = task.m_maxSimCalls.ToString();

            cbEnableDetection.Checked = task.m_bEnableDetect;
            cbDiscAfterDetection.Checked = task.m_bDiscAfterDetect;

            if (pbx.sip_acct.Count > 0)
            {
                int selIndex = 0;

                for (int i = 0; i < pbx.sip_acct.Count; i++)
                {
                    cbSIPAcct.Items.Add(pbx.sip_acct[i].UserName);
                    if (task.sip_acc.Length > 0 && task.sip_acc == pbx.sip_acct[i].UserName)
                        selIndex = i;
                }

                cbSIPAcct.SelectedIndex = selIndex;
            }
            else
            {
            }

            if (pbx.sip_dialplan.Count > 0)
            {
                int selIndex = 0;
                int nCount = 0;

                for (int i = 0; i < pbx.sip_dialplan.Count; i++)
                {
                    if (pbx.sip_dialplan[i].CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND)
                    {
                        cbDialPlan.Items.Add(pbx.sip_dialplan[i].planName);
                        nCount++;

                        if (task.dial_plan.Length > 0 && task.dial_plan == pbx.sip_dialplan[i].planName)
                            selIndex = nCount-1;
                    }
                }

                if(nCount > 0)
                    cbDialPlan.SelectedIndex = selIndex;
            }
            else
            {
            }

        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (tbName.Text.Trim().Length == 0)
            {
                MessageBox.Show("Task name cannot be null! It must be an unique name!");
                return;
            }

            DialogResult = DialogResult.OK;
            task.task_name = tbName.Text;
            task.isOn = cbEnable.Checked;
            task.type_code = Convert.ToInt16(tbTypeCode.Text);
            task.sip_acc = cbSIPAcct.Text;
            task.dial_plan = cbDialPlan.Text;
            task.m_ringTimeout = Convert.ToInt32(tbRingTimeout.Text);
            //task.m_bWriteSIPCode = cbWriteSIPCode.Checked;
            task.m_maxSimCalls = Convert.ToInt32(tbMaxSimCalls.Text);

            task.m_bEnableDetect = cbEnableDetection.Checked;
            task.m_bDiscAfterDetect = cbDiscAfterDetection.Checked;

            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}