using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class CallLimitEdit : Form
    {
        public CallLimit cl;
        public SIPPBX pbx;
        
        public CallLimitEdit()
        {
            InitializeComponent();
        }

        private void CallLimitEdit_Load(object sender, EventArgs e)
        {
            for (int i = 0; i < pbx.sip_dialplan.Count; i++)
            {
                cbName.Items.Add(pbx.sip_dialplan[i].planName);
            }
            for (int i = 0; i < pbx.sip_exten.Count; i++)
            {
                cbName.Items.Add(pbx.sip_exten[i].UserName);
            }
            for (int i = 0; i < pbx.sip_acct.Count; i++)
            {
                cbName.Items.Add(pbx.sip_acct[i].UserName);
            }

            cbName.Text = cl.Name;

            tbSeconds.Text = cl.Seconds.ToString();

            tbRoundupSeconds.Text = cl.roundupSeconds.ToString();
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;
            cl.Name = cbName.Text.Trim();
            cl.Seconds = Convert.ToInt32(tbSeconds.Text);
            cl.roundupSeconds = Convert.ToInt32(tbRoundupSeconds.Text);
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}