using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class DBSetForm : Form
    {
        public SIPPBX pbx;
        public GTSIPPBXEnv env;

        DBServerSetting db_set;

        public DBSetForm()
        {
            InitializeComponent();
        }

        private void DBSetForm_Load(object sender, EventArgs e)
        {
            db_set = new DBServerSetting();
            if (pbx.db_set != null)
            {
                db_set.sDBServer = pbx.db_set.sDBServer;
                db_set.sDBName = pbx.db_set.sDBName;
                db_set.sUserName = pbx.db_set.sUserName;
                db_set.sPassword = pbx.db_set.sPassword;
                db_set.dbType = pbx.db_set.dbType;
                db_set.authType = pbx.db_set.authType;
            }

            tbDBServer.Text = db_set.sDBServer;
            tbDBName.Text = db_set.sDBName;
            tbUserName.Text = db_set.sUserName;
            tbPassword.Text = db_set.sPassword;

            cbDBType.Items.Add("SQL Server Express 2005/2008");
            cbDBType.Items.Add("SQL Server 2000/2005/2008");
            cbDBType.SelectedIndex = db_set.dbType;

            cbAuth.Items.Add("SQL Authentication");
            cbAuth.Items.Add("Windows Authentication");
            cbAuth.SelectedIndex = db_set.authType;
        }

        private void btnTest_Click(object sender, EventArgs e)
        {
            db_set.authType = cbAuth.SelectedIndex;
            db_set.dbType = cbDBType.SelectedIndex;
            db_set.sDBServer = tbDBServer.Text;
            db_set.sDBName = tbDBName.Text;
            db_set.sUserName = tbUserName.Text;
            db_set.sPassword = tbPassword.Text;

            if (db_set.ConnectDB())
            {
                db_set.TestTables();
                SIPPBXDBUtil.InitAllStatusTables(pbx, env, db_set);
                db_set.DisconnectDB();

                MessageBox.Show("Database successfully connected.", "Info");
            }
            else
            {
                MessageBox.Show("Database failed!", "Error");
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            db_set.sDBServer = tbDBServer.Text;
            db_set.sDBName = tbDBName.Text;
            db_set.sUserName = tbUserName.Text;
            db_set.sPassword = tbPassword.Text;
            db_set.dbType = cbDBType.SelectedIndex;
            db_set.authType = cbAuth.SelectedIndex;

			if(db_set.ConnectDB())
			{
                db_set.TestTables();
                SIPPBXDBUtil.InitAllStatusTables(pbx, env, db_set);
				db_set.DisconnectDB();
			}
			else
			{
                MessageBox.Show("Database is not available, please change your DB settings!", "Error");
				return;
			}

            pbx.db_set = db_set;
            DialogResult = DialogResult.OK;

            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }


    }
}