using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;
//using System.Data.SqlClient;

namespace SIPPBXGUI
{
    public partial class DialPlanAutoAttendForm : Form
    {
        public SIPPBX pbx;
        //public SIPPBXDialPlan dp;
        //public DialPlanList dplist;
        public SIPPBXIVR ivr;

        public DialPlanAutoAttendForm()
        {
            InitializeComponent();
        }

        private void DialPlanAutoAttendFrom_Load(object sender, EventArgs e)
        {
            ComboBox[] cb, cb1, cb2;
            TextBox[] tb;
            cb = new ComboBox[7];
            cb1 = new ComboBox[7];
            cb2 = new ComboBox[7];

            tb = new TextBox[7];

            cb[0] = cbOption1;
            cb[1] = cbOption2;
            cb[2] = cbOption3;
            cb[3] = cbOption4;
            cb[4] = cbOption5;
            cb[5] = cbOption6;
            cb[6] = cbOption7;

            cb1[0] = cbActionOption1;
            cb1[1] = cbActionOption2;
            cb1[2] = cbActionOption3;
            cb1[3] = cbActionOption4;
            cb1[4] = cbActionOption5;
            cb1[5] = cbActionOption6;
            cb1[6] = cbActionOption7;

            tb[0] = tbSoundFileOption1;
            tb[1] = tbSoundFileOption2;
            tb[2] = tbSoundFileOption3;
            tb[3] = tbSoundFileOption4;
            tb[4] = tbSoundFileOption5;
            tb[5] = tbSoundFileOption6;
            tb[6] = tbSoundFileOption7;

            cb2[0] = cbDest1;
            cb2[1] = cbDest2;
            cb2[2] = cbDest3;
            cb2[3] = cbDest4;
            cb2[4] = cbDest5;
            cb2[5] = cbDest6;
            cb2[6] = cbDest7;

            for(int i=0; i<7; i++)
            {
                cb[i].Items.Add("N/A");
                cb[i].Items.Add("0");
                cb[i].Items.Add("1");
                cb[i].Items.Add("2");
                cb[i].Items.Add("3");
                cb[i].Items.Add("4");
                cb[i].Items.Add("5");
                cb[i].Items.Add("6");
                cb[i].Items.Add("7");
                cb[i].Items.Add("8");
                cb[i].Items.Add("9");
                cb[i].Items.Add("No Input");
                cb[i].SelectedIndex = 0;
            }

            for (int i = 0; i < 7; i++)
            {
                cb1[i].Items.Add("To another menu");
                cb1[i].Items.Add("Dial extension");
                cb1[i].Items.Add("To hunt group(ACD)");
                //cb1[i].Items.Add("Forward call to");
                cb1[i].Items.Add("To monitor group");
                cb1[i].Items.Add("To ring group");
                cb1[i].Items.Add("Conference room");
                cb1[i].Items.Add("Voice mail box");
                cb1[i].Items.Add("Hung up");
                cb1[i].Items.Add("Run Plugin");
                cb1[i].Items.Add("To inbound dialplan");
                cb1[i].SelectedIndex = 0;
            }

            tbIVRName.Text = ivr.name;
            tbSoundFile.Text = ivr.sound_file;
            tbMenuDTMFWaitMS.Text = ivr.menu_dtmf_wait_ms.ToString();

            SIPPBXDTMF dtmf;
            for (int i = 0; i < ivr.dtmfs.Count; i++)
            {
                dtmf = ivr.dtmfs[i];
                cb[i].Text = dtmf.DTMFStr;

                if (dtmf.IVRMenu != null)
                {
                    tb[i].Text = dtmf.IVRMenu.sound_file;
                    switch(dtmf.IVRMenu.action)
                    {
                        case 0: //doing nothing. should never reached
                            break;
                        case 1: //
                            break;
                        case 2: //dial extension
                            cb1[i].SelectedIndex = 1;
                            SIPPBXWinUtil.AddExtensionsIntoComboBox(pbx, cb2[i], dtmf.IVRMenu.transfer_to);
                            break;
                        case 3: 
                            cb1[i].SelectedIndex = 0;
                            SIPPBXWinUtil.AddIVRMenusIntoComboBox(pbx, cb2[i], dtmf.IVRMenu.transfer_to);
                            break;
                        case 4: //hunt group
                            cb1[i].SelectedIndex = 2;
                            SIPPBXWinUtil.AddHuntgroupsIntoComboBox(pbx, cb2[i], dtmf.IVRMenu.transfer_to);
                            break;
/*
                        case 5:      //play sound(if available) and forward call to
                            cb1[i].SelectedIndex = 3;
                            cb2[i].Items.Clear();
                            cb2[i].Enabled = true;
                            break;
 */
                        case 6:      //play sound(if available) and go to "Monitor" group
                            cb1[i].SelectedIndex = 3;
                            SIPPBXWinUtil.AddMonitorgroupsIntoComboBox(pbx, cb2[i], dtmf.IVRMenu.transfer_to);
                            break;
                        case 7:      //play sound(if available) and go to "Ring group"
                            cb1[i].SelectedIndex = 4;
                            SIPPBXWinUtil.AddRinggroupsIntoComboBox(pbx, cb2[i], dtmf.IVRMenu.transfer_to);
                            break;
                        case 8:      //play sound(if available) and go to "Conference room"
                            cb1[i].SelectedIndex = 5;
                            SIPPBXWinUtil.AddConferoomsIntoComboBox(pbx, cb2[i], dtmf.IVRMenu.transfer_to);
                            break;
                        case 9:     //play sound(if available) and go to "Voice mail box"
                            cb1[i].SelectedIndex = 6;
                            SIPPBXWinUtil.AddExtensionsIntoComboBox(pbx, cb2[i], dtmf.IVRMenu.transfer_to);
                            break;
                        case 10:    //play sound(if available) and hung up
                            cb1[i].SelectedIndex = 7;
                            break;
                        case 11:
                            cb1[i].SelectedIndex = 8;
                            //SIPPBXWinUtil.AddPluginsIntoComboBox(pbx, cb2[i], dtmf.IVRMenu.transfer_to);
                            SIPPBXDBUtil.AddPluginsIntoComboBox(pbx, cb2[i], dtmf.IVRMenu.transfer_to, pbx.db_set, PBXMainForm.log);
                            break;
                        case 12:
                            cb1[i].SelectedIndex = 9;
                            SIPPBXWinUtil.AddDialplanIntoComboBox(pbx, cb2[i], dtmf.IVRMenu.transfer_to);
                            break;
                    }
                }
            }

            cbAccpetExten.Checked = ivr.dtmf_accept_exten;
            if (cbAccpetExten.Checked)
            {
                tbDTMFWait.Enabled = true;
                tbDTMFWait.Text = ivr.dtmf_accept_exten_wait_ms.ToString();
            }
            else
            {
                tbDTMFWait.Enabled = false;
            }
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = Constants.SoundFileFilter;
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbSoundFile.Text = openFileDialog1.FileName;
            }

        }

        private void btnBrowseOption1_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = Constants.SoundFileFilter;
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbSoundFileOption1.Text = openFileDialog1.FileName;
            }

        }

        private void btnBrowseOption2_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = Constants.SoundFileFilter;
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbSoundFileOption2.Text = openFileDialog1.FileName;
            }

        }

        private void btnBrowseOption3_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = Constants.SoundFileFilter;
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbSoundFileOption3.Text = openFileDialog1.FileName;
            }

        }

        private void btnBrowseOption4_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = Constants.SoundFileFilter;
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbSoundFileOption4.Text = openFileDialog1.FileName;
            }

        }

        private void btnBrowseOption5_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = Constants.SoundFileFilter;
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbSoundFileOption5.Text = openFileDialog1.FileName;
            }

        }

        private void btnBrowseOption6_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = Constants.SoundFileFilter;
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbSoundFileOption6.Text = openFileDialog1.FileName;
            }

        }

        private void btnBrowseOption7_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = Constants.SoundFileFilter;
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbSoundFileOption7.Text = openFileDialog1.FileName;
            }

        }

        public SIPPBXDTMF GetDTMFItem(ComboBox dtmf_choice, TextBox snd_file, ComboBox act, ComboBox dest, SIPPBXIVR parent_ivr)
        {
            SIPPBXDTMF dtmf_item = null;

            if (dtmf_choice.Text != "N/A")
            {
                dtmf_item = new SIPPBXDTMF();

                //if(dtmf_choice.Text != "No Input")
                    dtmf_item.DTMFStr = dtmf_choice.Text;

                dtmf_item.IVRMenu = new SIPPBXIVR();
                //dtmf_item.IVRMenu.ParentIVRMenu = parent_ivr;
                dtmf_item.IVRMenu.sound_file = snd_file.Text;

        //action definition
        //0 = nothing, no defined yet.
        //1 = play sound(if available) and detect dtmf, 
        //2 = play sound(if available) and dial extension, 
        //3 = play sound(if available) and parent menu
        //4 = play sound(if available) and go hunt group
        //5 = play sound(if available) and forward call to
        //6 = play sound(if available) and go to "Monitor" group
        //7 = play sound(if available) and go to "Ring group"
        //8 = play sound(if available) and go to "Conference room"
        //9 = play sound(if available) and go to "Voice mail box"
        //10 = play sound(if available) and hung up
        //11 = play sound(if available) and run plugin.
        //12 = play sound(if available) and go to another dialplan by name

                switch (act.SelectedIndex)
                {
                    case 0: //Goto another menu
                        dtmf_item.IVRMenu.action = 3;
                        dtmf_item.IVRMenu.transfer_to = dest.Text;
                        break;
                    case 1: //Dial extension
                        dtmf_item.IVRMenu.action = 2;
                        dtmf_item.IVRMenu.transfer_to = dest.Text;
                        break;
                    case 2: //To hunt group
                        dtmf_item.IVRMenu.action = 4;
                        dtmf_item.IVRMenu.transfer_to = dest.Text;
                        break;
                    case 3: //Monitor group
                        dtmf_item.IVRMenu.action = 6;
                        dtmf_item.IVRMenu.transfer_to = dest.Text;
                        break;
                    case 4: //Ring group
                        dtmf_item.IVRMenu.action = 7;
                        dtmf_item.IVRMenu.transfer_to = dest.Text;
                        break;
                    case 5: //Conference room
                        dtmf_item.IVRMenu.action = 8;
                        dtmf_item.IVRMenu.transfer_to = dest.Text;
                        break;
                    case 6: //Voice mail box
                        dtmf_item.IVRMenu.action = 9;
                        dtmf_item.IVRMenu.transfer_to = dest.Text;
                        break;
                    case 7: //Hung up
                        dtmf_item.IVRMenu.action = 10;
                        break;
                    case 8: //Run plugin
                        dtmf_item.IVRMenu.action = 11;
                        dtmf_item.IVRMenu.transfer_to = dest.Text;
                        break;
                    case 9: //goto another dialplan
                        dtmf_item.IVRMenu.action = 12;
                        dtmf_item.IVRMenu.transfer_to = dest.Text;
                        break;
                }
            }

            return dtmf_item;
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.OK;

            ivr.name = tbIVRName.Text;
            ivr.sound_file = tbSoundFile.Text;
            ivr.menu_dtmf_wait_ms = Convert.ToInt32(tbMenuDTMFWaitMS.Text);
            ivr.action = 1;

            if (cbAccpetExten.Checked)
            {
                ivr.dtmf_accept_exten = true;
                ivr.dtmf_accept_exten_wait_ms = Convert.ToInt32(tbDTMFWait.Text);
            }
            else
            {
                ivr.dtmf_accept_exten = false;
            }

            ivr.dtmfs.Clear();

            SIPPBXDTMF dtmf_item = GetDTMFItem(cbOption1, tbSoundFileOption1, cbActionOption1, cbDest1, ivr);
            if (dtmf_item != null)
                ivr.dtmfs.Add(dtmf_item);

            dtmf_item = GetDTMFItem(cbOption2, tbSoundFileOption2, cbActionOption2, cbDest2, ivr);
            if (dtmf_item != null)
                ivr.dtmfs.Add(dtmf_item);

            dtmf_item = GetDTMFItem(cbOption3, tbSoundFileOption3, cbActionOption3, cbDest3, ivr);
            if (dtmf_item != null)
                ivr.dtmfs.Add(dtmf_item);

            dtmf_item = GetDTMFItem(cbOption4, tbSoundFileOption4, cbActionOption4, cbDest4, ivr);
            if (dtmf_item != null)
                ivr.dtmfs.Add(dtmf_item);

            dtmf_item = GetDTMFItem(cbOption5, tbSoundFileOption5, cbActionOption5, cbDest5, ivr);
            if (dtmf_item != null)
                ivr.dtmfs.Add(dtmf_item);

            dtmf_item = GetDTMFItem(cbOption6, tbSoundFileOption6, cbActionOption6, cbDest6, ivr);
            if (dtmf_item != null)
                ivr.dtmfs.Add(dtmf_item);

            dtmf_item = GetDTMFItem(cbOption7, tbSoundFileOption7, cbActionOption7, cbDest7, ivr);
            if (dtmf_item != null)
                ivr.dtmfs.Add(dtmf_item);

            Close();

            //save the dialplan
            //dplist.ShowDialPlanList();

        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void OnActionOptionChanged(ComboBox actOption, ComboBox cb)
        {
            if (actOption.SelectedIndex == 0) //play main menu
            {
                SIPPBXWinUtil.AddIVRMenusIntoComboBox(pbx, cb, "");
            }
            else if (actOption.SelectedIndex == 1) //dial extension.
            {
                SIPPBXWinUtil.AddExtensionsIntoComboBox(pbx, cb, "");
            }
            else if (actOption.SelectedIndex == 2) //To hunt group
            {
                SIPPBXWinUtil.AddHuntgroupsIntoComboBox(pbx, cb, "");
            }
            /*
                        else if (actOption.SelectedIndex == 3) //Forward to
                        {
                            cb.Items.Clear();
                            cb.Enabled = true;
                        }
             */
            else if (actOption.SelectedIndex == 3) //Monitor group
            {
                SIPPBXWinUtil.AddMonitorgroupsIntoComboBox(pbx, cb, "");
            }
            else if (actOption.SelectedIndex == 4) //Ring Group
            {
                SIPPBXWinUtil.AddRinggroupsIntoComboBox(pbx, cb, "");
            }
            else if (actOption.SelectedIndex == 5) //Conference room
            {
                SIPPBXWinUtil.AddConferoomsIntoComboBox(pbx, cb, "");
            }
            else if (actOption.SelectedIndex == 6) //voice mail box
            {
                SIPPBXWinUtil.AddExtensionsIntoComboBox(pbx, cb, "");
            }
            else if (actOption.SelectedIndex == 7) //Hungup
            {
                cb.Enabled = false;
            }
            else if (actOption.SelectedIndex == 8) //Run plugin
            {
                //SIPPBXWinUtil.AddPluginsIntoComboBox(pbx, cb, "");
                SIPPBXDBUtil.AddPluginsIntoComboBox(pbx, cb, "", pbx.db_set, PBXMainForm.log);
            }
            else if (actOption.SelectedIndex == 9) //Go another dialplan
            {
                SIPPBXWinUtil.AddDialplanIntoComboBox(pbx, cb, "");
            }
        }

        private void cbActionOption1_SelectedIndexChanged(object sender, EventArgs e)
        {
            OnActionOptionChanged(cbActionOption1, cbDest1);
        }

        private void cbActionOption2_SelectedIndexChanged(object sender, EventArgs e)
        {
            OnActionOptionChanged(cbActionOption2, cbDest2);
        }

        private void cbActionOption3_SelectedIndexChanged(object sender, EventArgs e)
        {
            OnActionOptionChanged(cbActionOption3, cbDest3);
        }

        private void cbActionOption4_SelectedIndexChanged(object sender, EventArgs e)
        {
            OnActionOptionChanged(cbActionOption4, cbDest4);
        }

        private void cbActionOption5_SelectedIndexChanged(object sender, EventArgs e)
        {
            OnActionOptionChanged(cbActionOption5, cbDest5);
        }

        private void cbActionOption6_SelectedIndexChanged(object sender, EventArgs e)
        {
            OnActionOptionChanged(cbActionOption6, cbDest6);
        }

        private void cbActionOption7_SelectedIndexChanged(object sender, EventArgs e)
        {
            OnActionOptionChanged(cbActionOption7, cbDest7);
        }

        private void cbAccpetExten_CheckedChanged(object sender, EventArgs e)
        {
            if (cbAccpetExten.Checked)
            {
                tbDTMFWait.Enabled = true;
                tbDTMFWait.Text = ivr.dtmf_accept_exten_wait_ms.ToString();
            }
            else
            {
                tbDTMFWait.Enabled = false;
            }
        }
    }
}