using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class DialPlanList : Form
    {
        public SIPPBX pbx;
        public PBXMainForm main_form;

        public DialPlanList()
        {
            InitializeComponent();
        }

        public void ShowDialPlanList()
        {

            lvDialPlan.Items.Clear();

            for (int i = 0; i < pbx.sip_dialplan.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(pbx.sip_dialplan[i].planName);
                if(pbx.sip_dialplan[i].CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND)
                    aItem.SubItems.Add("Inbound");
                else
                    aItem.SubItems.Add("Outbound");
                aItem.SubItems.Add(pbx.sip_dialplan[i].CalledID);

                if (pbx.sip_dialplan[i].CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND)
                {
                    switch (pbx.sip_dialplan[i].CallPlan)
                    {
                        case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.AUTO_ATTENDANT:
                            aItem.SubItems.Add("Auto Attendant");
                            break;
                        case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ACD_QUEUE:
                            aItem.SubItems.Add("Hunt Group(ACD)");
                            break;
                        case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION:
                            aItem.SubItems.Add("Dial Extension");
                            break;
                        case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DO_NOT_DISTURB:
                            aItem.SubItems.Add("DO NOT DISTURB");
                            break;
                        case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MONITOR_GROUP:
                            aItem.SubItems.Add("Monitor Group");
                            break;
                        case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.VOICE_MAIL_BOX:
                            aItem.SubItems.Add("Voice Mail Box");
                            break;
                        case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.RING_GROUP:
                            aItem.SubItems.Add("Ring Group");
                            break;
                        case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CONFERENCE_ROOM:
                            aItem.SubItems.Add("Conference Room");
                            break;
                        case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.PLUGIN_ROUTINE:
                            aItem.SubItems.Add("Run Plugin");
                            break;
                        case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CALL_FORWARDING:
                            aItem.SubItems.Add("Call Forward");
                            break;
                        case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MUSIC_SERVER:
                            aItem.SubItems.Add("Music Server");
                            break;
                        case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ECHO_TEST:
                            aItem.SubItems.Add("Echo Test");
                            break;
                        case SIPPBXDialPlan.DIALPLAN_CALL_PLAN.OPENAI_NODE:
                            aItem.SubItems.Add("OpenAI Agent");
                            break;
                    }
                }
                else
                {
                    aItem.SubItems.Add("");
                }

                //aItem.SubItems.Add(pbx.sip_dialplan[i].CallerID);
                lvDialPlan.Items.Add(aItem);
            }

        }

        private void DialPlanList_Load(object sender, EventArgs e)
        {
            lvDialPlan.Columns.Clear();
            lvDialPlan.Columns.Add("Plan Name", 120, HorizontalAlignment.Left);
            lvDialPlan.Columns.Add("Call Direction", 120, HorizontalAlignment.Left);
            lvDialPlan.Columns.Add("Called ID", 120, HorizontalAlignment.Left);
            lvDialPlan.Columns.Add("Templete", 120, HorizontalAlignment.Left);
            //lvDialPlan.Columns.Add("End Time", 120, HorizontalAlignment.Left);

            ShowDialPlanList();
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            /*
                        if (pbx.bFreeVersion)
                        {
                            if (pbx.sip_dialplan.Count >= 3)
                            {
                                MessageBox.Show("Free version only allows 3 dialplans.", "Error");
                                return;
                            }
                        }
            */

            SIPPBXDialPlan dp = new SIPPBXDialPlan();
            DialPlanStep1 step1_dlg = new DialPlanStep1();
            step1_dlg.dplist = this;
            step1_dlg.dp = dp;
            step1_dlg.pbx = pbx;
            if (step1_dlg.ShowDialog() == DialogResult.OK)
            {
                if (SIPPBXCFGDB.AddDialPlanToDB(dp, null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    if (!pbx.sip_dialplan.Contains(dp))
                        pbx.sip_dialplan.Add(dp);
                    ShowDialPlanList();
                }
                else
                {
                    MessageBox.Show("Cannot add the dialplan into DB!", "Error");
                }
            }

        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            if (lvDialPlan.SelectedIndices.Count >= 1)
            {
                DialogResult dialogResult = MessageBox.Show("Are you sure to delete the item?", "Confirmation", MessageBoxButtons.YesNo);
                if (dialogResult == DialogResult.Yes)
                {
                    //do something
                }
                else if (dialogResult == DialogResult.No)
                {
                    //do something else
                    return;
                }

                if (SIPPBXCFGDB.RemoveDialPlanFromDB(pbx.sip_dialplan[lvDialPlan.SelectedIndices[0]], null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    pbx.sip_dialplan.RemoveAt(lvDialPlan.SelectedIndices[0]);
                    lvDialPlan.Items.RemoveAt(lvDialPlan.SelectedIndices[0]);
                }
                else
                {
                    MessageBox.Show("Cannot remove the dialplan from DB!", "Error");
                }
            }
            else
            {
                MessageBox.Show("Please select an dial plan first!", "Error");
            }
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            SIPPBXDialPlan dp;
            if (lvDialPlan.SelectedIndices.Count >= 1)
            {
                dp = pbx.sip_dialplan[lvDialPlan.SelectedIndices[0]];
                DialPlanStep1 step1_dlg = new DialPlanStep1();
                step1_dlg.dplist = this;
                step1_dlg.dp = dp;
                step1_dlg.pbx = pbx;
                if (step1_dlg.ShowDialog() == DialogResult.OK)
                {
                    if (SIPPBXCFGDB.UpdateDialPlanInDB(dp, null, pbx, null, pbx.db_set, PBXMainForm.log))
                    {
                        if (!pbx.sip_dialplan.Contains(dp))
                            pbx.sip_dialplan.Add(dp);
                    }
                    else
                    {
                        MessageBox.Show("Cannot update the dialplan in DB!", "Error");
                    }
                    ShowDialPlanList();
                }
            }
            else
            {
                MessageBox.Show("Please select an dial plan first!", "Error");
            }
        }

        private void btnMoveUp_Click(object sender, EventArgs e)
        {
            if (lvDialPlan.SelectedIndices.Count >= 1)
            {
                int nSelPos = lvDialPlan.SelectedIndices[0];
                if(nSelPos == 0)
                    //already the first item
                    return;

                PBXOptCmdProcess.AddSrvCmd_MoveUpDialplan(pbx.sip_dialplan[nSelPos], pbx.db_set, PBXMainForm.log);

                SIPPBXDialPlan dp = pbx.sip_dialplan[nSelPos];
                pbx.sip_dialplan[nSelPos] = pbx.sip_dialplan[nSelPos - 1];
                pbx.sip_dialplan[nSelPos - 1] = dp;

                ShowDialPlanList();

                lvDialPlan.SelectedIndices.Add(nSelPos - 1);


            }
            else
            {
                MessageBox.Show("Please select an dial plan first!", "Error");
            }

        }

        private void btnMoveDown_Click(object sender, EventArgs e)
        {
            if (lvDialPlan.SelectedIndices.Count >= 1)
            {
                int nSelPos = lvDialPlan.SelectedIndices[0];
                if (nSelPos == pbx.sip_dialplan.Count - 1)
                    //already the bottom item
                    return;

                PBXOptCmdProcess.AddSrvCmd_MoveDownDialplan(pbx.sip_dialplan[nSelPos], pbx.db_set, PBXMainForm.log);

                SIPPBXDialPlan dp = pbx.sip_dialplan[nSelPos];
                pbx.sip_dialplan[nSelPos] = pbx.sip_dialplan[nSelPos + 1];
                pbx.sip_dialplan[nSelPos + 1] = dp;

                ShowDialPlanList();

                lvDialPlan.SelectedIndices.Add(nSelPos + 1);
            }
            else
            {
                MessageBox.Show("Please select an dial plan first!", "Error");
            }

        }
    }
}