using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class LoadBalanceConfig : Form
    {
        public SIPPBX pbx;

        public LoadBalanceConfig()
        {
            InitializeComponent();
        }

        private void ShowDestList()
        {
            lbDests.Items.Clear();
            for (int i = 0; i < pbx.lb_addrs.Count; i++)
            {
                lbDests.Items.Add(pbx.lb_addrs[i].DestAddr);
            }
        }

        private void LoadBalanceConfig_Load(object sender, EventArgs e)
        {
            if (pbx.lb_on)
            {
                cbLoadBalance.Checked = true;
                lbDests.Enabled = true;
                ShowDestList();
                btnAdd.Enabled = true;
                btnEdit.Enabled = true;
                btnDelete.Enabled = true;
            }
            else
            {
                cbLoadBalance.Checked = false;
                lbDests.Enabled = false;
                btnAdd.Enabled = false;
                btnEdit.Enabled = false;
                btnDelete.Enabled = false;
            }

        }

        private void cbLoadBalance_CheckedChanged(object sender, EventArgs e)
        {
            if (cbLoadBalance.Checked)
            {
                lbDests.Enabled = true;
                ShowDestList();
                btnAdd.Enabled = true;
                btnEdit.Enabled = true;
                btnDelete.Enabled = true;
            }
            else
            {
                lbDests.Enabled = false;
                lbDests.Items.Clear();
                btnAdd.Enabled = false;
                btnEdit.Enabled = false;
                btnDelete.Enabled = false;
            }
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            RingDestEdit dlg = new RingDestEdit();
            SIPPBXDest dest = new SIPPBXDest();
            dlg.dest = dest;
            dlg.ringTimeout = false;
            dlg.pbx = pbx;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                lbDests.Items.Add(dest.DestAddr);
                pbx.lb_addrs.Add(dest);
            }
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            int nSel = lbDests.SelectedIndex;
            if (nSel >= 0)
            {
                RingDestEdit dlg = new RingDestEdit();
                dlg.dest = pbx.lb_addrs[nSel];
                dlg.ringTimeout = false;
                dlg.pbx = pbx;
                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    ShowDestList();
                }
            }
            else
            {
                MessageBox.Show("Please select an item first", "Error");
            }
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            int nSel = lbDests.SelectedIndex;
            if (nSel >= 0)
            {
                pbx.lb_addrs.RemoveAt(nSel);
                ShowDestList();
            }
            else
            {
                MessageBox.Show("Please select an item first", "Error");
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            if (cbLoadBalance.Checked)
            {
                pbx.lb_on = true;
            }
            else
            {
                pbx.lb_addrs.Clear();
                pbx.lb_on = false;
            }

            DialogResult = DialogResult.OK;

            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }


    }
}