using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class MonitorGroupList : Form
    {
        public SIPPBX pbx;
        public PBXMainForm main_form;

        public MonitorGroupList()
        {
            InitializeComponent();
        }

        private void MonitorGroupList_Load(object sender, EventArgs e)
        {
            lvMonitorGroups.Columns.Clear();
            lvMonitorGroups.Columns.Add("Name", 120, HorizontalAlignment.Left);
            lvMonitorGroups.Columns.Add("Number", 120, HorizontalAlignment.Left);

            ShowMonitorGroups();
        }

        private void ShowMonitorGroups()
        {
            lvMonitorGroups.Items.Clear();

            for (int i = 0; i < pbx.sip_monitorgroups.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(pbx.sip_monitorgroups[i].mgName);
                aItem.SubItems.Add(pbx.sip_monitorgroups[i].mgNumber);
                lvMonitorGroups.Items.Add(aItem);
            }

        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            SIPPBXMonitorGroup mg = new SIPPBXMonitorGroup();
            mg.mgExtenPrompt = pbx.please_enter_extension_number_dir;
            mg.mgPasswordPrompt = pbx.please_enter_password_dir;

            MonitorGroupEdit dlg = new MonitorGroupEdit();
            dlg.mg = mg;
            dlg.pbx = pbx;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                if (SIPPBXCFGDB.AddMonitorGroupToDB(mg, null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    pbx.sip_monitorgroups.Add(mg);
                    ShowMonitorGroups();
                }
                else
                {
                    MessageBox.Show("Cannot add monitor group into DB!", "Error");
                }
            }
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            if (lvMonitorGroups.SelectedIndices.Count > 0)
            {
                SIPPBXMonitorGroup mg = pbx.sip_monitorgroups[lvMonitorGroups.SelectedIndices[0]];
                MonitorGroupEdit dlg = new MonitorGroupEdit();
                dlg.mg = mg;
                dlg.pbx = pbx;
                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    if (SIPPBXCFGDB.UpdateMonitorGroupInDB(mg, null, pbx, null, pbx.db_set, PBXMainForm.log))
                    {
                    }
                    else
                    {
                        MessageBox.Show("Cannot update the monitor group in DB!", "Error");
                    }
                    ShowMonitorGroups();
                }
            }
            else
            {
                MessageBox.Show("Please select one item first.", "Error");
            }
        }

        private void btnDelete_Click(object sender, EventArgs e)
        {
            if (lvMonitorGroups.SelectedIndices.Count > 0)
            {
                DialogResult dialogResult = MessageBox.Show("Are you sure to delete the item?", "Confirmation", MessageBoxButtons.YesNo);
                if (dialogResult == DialogResult.Yes)
                {
                    //do something
                }
                else if (dialogResult == DialogResult.No)
                {
                    //do something else
                    return;
                }

                if (SIPPBXCFGDB.RemoveMonitorGroupFromDB(pbx.sip_monitorgroups[lvMonitorGroups.SelectedIndices[0]], null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    pbx.sip_monitorgroups.RemoveAt(lvMonitorGroups.SelectedIndices[0]);
                    ShowMonitorGroups();
                }
                else
                {
                    MessageBox.Show("Cannot remove monitor group from DB!", "Error");
                }
            }
            else
            {
                MessageBox.Show("Please select one item first.", "Error");
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}