﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class OpenAIAgentEdit : Form
    {
        public int agent_index;
        public SIPPBX pbx;
        public OpenAIAgentList parent_form;

        public OpenAIAgentEdit()
        {
            InitializeComponent();
            agent_index = -1;
        }

        private void OpenAIAgentEdit_Load(object sender, EventArgs e)
        {
            SIPPBXOpenAINode agent = null;

            if (agent_index != -1)
            {
                agent = pbx.openai_nodes[agent_index];

                tbAgentName.Text = agent.NodeName;
                tbAgentAPIKey.Text = agent.APIKey;
                rtbSessionUpdate.Text = agent.DefDesc;

                tbAgentName.Enabled = false;
            }


        }

        private void AddBtn_Click(object sender, EventArgs e)
        {
            SIPPBXOpenAINode agent;

            if (agent_index == -1)
            {
                if (pbx.getOpenAIAgentByName(tbAgentName.Text) != null)
                {
                    MessageBox.Show("Same name agent already exists");
                    return;
                }

                agent = new SIPPBXOpenAINode();
                agent.NodeName = tbAgentName.Text;
                agent.APIKey = tbAgentAPIKey.Text;
                agent.DefDesc = rtbSessionUpdate.Text;

                if (!SIPPBXCFGDB.AddOpenAINodeToDB(agent, null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    MessageBox.Show("Cannot add the openai agent into DB!", "Error");
                    return;
                }

                pbx.openai_nodes.Add(agent);
            }
            else
            {
                agent = pbx.openai_nodes[agent_index];
                agent.NodeName = tbAgentName.Text;
                agent.APIKey = tbAgentAPIKey.Text;
                agent.DefDesc = rtbSessionUpdate.Text;

                if (!SIPPBXCFGDB.UpdateOpenAINodeInDB(agent, null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    MessageBox.Show("Cannot update the openai agent in DB!", "Error");
                    return;
                }
            }

            Close();

            parent_form.ShowOpenAIAgents();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}
