﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class PagingGroupEdit : Form
    {
        public SIPPBX pbx;
        public SIPPBXPagingGroup pg;

        public PagingGroupEdit()
        {
            InitializeComponent();
            pbx = null;
            pg = null;
        }

        private void btnAddDest_Click(object sender, EventArgs e)
        {
            SIPPBXDest dest = new SIPPBXDest();
            RingDestEdit dlg = new RingDestEdit();
            dlg.isPagingExten = true;
            dlg.dest = dest;
            dlg.pbx = pbx;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                pg.destList.Add(dest);
                RefreshDestList();
            }
        }

        private void PagingGroupEdit_Load(object sender, EventArgs e)
        {
            tbName.Text = pg.gpName;
            tbNumber.Text = pg.did;
            if (pg.gpName.Length > 0)
            {
                tbName.Enabled = false;
            }

            RefreshDestList();
        }

        public void RefreshDestList()
        {
            lbDests.Items.Clear();
            for (int i = 0; i < pg.destList.Count; i++)
            {
                lbDests.Items.Add(pg.destList[i].DestAddr);
            }
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            int nSel = lbDests.SelectedIndex;
            if (nSel >= 0)
            {
                RingDestEdit dlg = new RingDestEdit();
                dlg.isPagingExten = true;
                dlg.dest = pg.destList[nSel];
                dlg.pbx = pbx;
                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    RefreshDestList();
                }
            }
            else
            {
                MessageBox.Show("Please select one item first.", "Error");
            }

        }

        private void btnRemoveDest_Click(object sender, EventArgs e)
        {
            int nSel = lbDests.SelectedIndex;
            if (nSel >= 0)
            {
                pg.destList.RemoveAt(nSel);
                RefreshDestList();
            }
            else
            {
                MessageBox.Show("Please select one item to delete.", "Error");
            }

        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            pg.gpName = tbName.Text;
            pg.did = tbNumber.Text;

            DialogResult = DialogResult.OK;
            Close();

        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

    }
}
