using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;
using System.IO;
using GTAPIASM; 

namespace SIPPBXGUI
{
    public partial class RegLicForm : Form
    {
        public PBXMainForm parent_form;
        public SIPPBX pbx;

        public RegLicForm()
        {
            InitializeComponent();
            pbx = null;
        }

        private void RegLicForm_Load(object sender, EventArgs e)
        {
            if(parent_form.SelfBrand.Length > 0)
                linkLabel1.Visible = false;

            cbPBXEdition.Items.Add("Free Edition(8 simultaneous calls)");
            cbPBXEdition.Items.Add("Professional Edition");

            //cbNIC.Visible = false;
            //labelMAC.Visible = false;

            //cbUSBKey.Visible = false;
            //cbUSBDriver.Visible = false;

            DriveInfo[] allDrives = DriveInfo.GetDrives();

            foreach (DriveInfo dirInfo in allDrives)
            {
                cbUSBDriver.Items.Add(dirInfo.Name);
            }


            if (pbx.bFreeVersion)
            {
                cbPBXEdition.SelectedIndex = 0;
                textChans.Enabled = false;
                textChans.Text = "8";
                textLicKey.Enabled = false;
                textLicKey.Text = "";

                if (pbx.LicOwner.Length > 0)
                {
                    if (parent_form.SelfBrand.Length > 0)
                        labelLicTo.Text = "Licensed to " + parent_form.SelfBrand;
                    else
                        labelLicTo.Text = "Licensed to " + pbx.LicOwner;
                }
                else
                {
                    labelLicTo.Text = "Not licensed software";
                }

                cbNIC.Enabled = false;
                cbNIC.Text = pbx.LicMAC;

                cbUSBKey.Enabled = false;
                cbUSBKey.Checked = false;

                cbUSBDriver.Enabled = false;
                cbUSBDriver.Text = pbx.USBKeyDriver;
            }
            else
            {
                cbPBXEdition.SelectedIndex = 1;
                textChans.Enabled = true;
                textChans.Text = pbx.ChanNum.ToString();
                textLicKey.Enabled = true;
                textLicKey.Text = pbx.PBXLicKey;
                if(pbx.LicOwner.Length>0)
                    labelLicTo.Text = "Licensed to " + pbx.LicOwner;
                else
                    labelLicTo.Text = "Not licensed software";
                cbNIC.Enabled = true;
                cbNIC.Text = pbx.LicMAC;

                cbUSBKey.Enabled = true;
                cbUSBKey.Checked = pbx.USBKeyDriver.Length > 0;

                if (cbUSBKey.Checked)
                {
                    cbNIC.Enabled = false;
                    cbUSBDriver.Enabled = true;
                    cbUSBDriver.Text = pbx.USBKeyDriver;
                }
                else
                {
                    cbNIC.Enabled = true;
                    cbUSBDriver.Enabled = false;
                    cbUSBDriver.Text = pbx.USBKeyDriver;
                }
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            pbx.bFreeVersion = cbPBXEdition.SelectedIndex == 0;
            pbx.ChanNum = Convert.ToInt32(textChans.Text);
            pbx.PBXLicKey = textLicKey.Text;
            DialogResult = DialogResult.OK;

            if (cbUSBKey.Checked)
            {
                if (cbUSBDriver.Text.Length > 0)
                {
                    pbx.USBKeyDriver = cbUSBDriver.Text;
                }
                else
                {
                    pbx.USBKeyDriver = "";
                }
            }
            else
            {
                pbx.USBKeyDriver = "";
            }

            if (cbNIC.Enabled && cbNIC.Text.Length > 0)
            {
                pbx.LicMAC = cbNIC.Text;
            }
            else
            {
                pbx.LicMAC = "";
            }

            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void linkLabel1_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            try
            {
                System.Diagnostics.Process.Start("http://www.pcbest.net/prices.php");
                linkLabel1.LinkVisited = true;
            }
            catch (Exception)
            {
            }
        }

        private void cbPBXEdition_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cbPBXEdition.SelectedIndex == 0)
            {
                textChans.Enabled = false;
                textChans.Text = "8";
                textLicKey.Enabled = false;
                textLicKey.Text = "";
            }
            else
            {
                textChans.Enabled = true;
                textChans.Text = "8";
                textLicKey.Enabled = true;
                textLicKey.Text = "";

                cbUSBKey.Enabled = true;
                cbUSBKey.Checked = pbx.USBKeyDriver.Length > 0;

                if (cbUSBKey.Checked)
                {
                    cbNIC.Enabled = false;
                    cbUSBDriver.Enabled = true;
                    cbUSBDriver.Text = pbx.USBKeyDriver;
                }
                else
                {
                    cbNIC.Enabled = true;
                    cbUSBDriver.Enabled = false;
                    cbUSBDriver.Text = pbx.USBKeyDriver;
                }
            }
        }

        private void cbUSBKey_CheckedChanged(object sender, EventArgs e)
        {
            if (cbUSBKey.Checked)
            {
                cbUSBDriver.Enabled = true;
                cbNIC.Enabled = false;
            }
            else
            {
                cbUSBDriver.Enabled = false;
                cbNIC.Enabled = true;
            }
        }
    }
}