using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class RingGroupEdit : Form
    {
        public SIPPBX pbx;
        public SIPPBXRingGroup rg;
        public VoiceMailBox vmb;

        public RingGroupEdit()
        {
            InitializeComponent();
            rg = null;
            pbx = null;
        }

        private void RingGroupEdit_Load(object sender, EventArgs e)
        {
            tbName.Text = rg.gpName;
            if (rg.gpName.Length > 0)
            {
                tbName.Enabled = false;
            }

            if (rg.ringType == 0)
            {
                rbRingAll.Checked = true;
                rbRingOrder.Checked = false;
            }
            else if (rg.ringType == 1)
            {
                rbRingAll.Checked = false;
                rbRingOrder.Checked = true;
            }

            if (rg.playMOH)
            {
                cbPlayMOH.Checked = true;
                tbMOHDir.Enabled = true;
                btnBrowse.Enabled = true;
                if (rg.mohDir.Length > 0)
                    tbMOHDir.Text = rg.mohDir;
                else
                    tbMOHDir.Text = pbx.moh_dir;
            }
            else
            {
                cbPlayMOH.Checked = false;
                tbMOHDir.Enabled = false;
                btnBrowse.Enabled = false;
            }

            cbAnswerCallFirst.Checked = rg.bAnswerCallFirst;

            vmb = rg.vmb;
            if (vmb != null)
            {
                cbVMB.Checked = true;
                btnVMBSet.Enabled = true;
            }
            else
            {
                cbVMB.Checked = false;
                btnVMBSet.Enabled = false;
            }

            RefreshDestList();
        }

        public void RefreshDestList()
        {
            lbDests.Items.Clear();
            for (int i = 0; i < rg.destList.Count; i++)
            {
                lbDests.Items.Add(rg.destList[i].DestAddr);
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            rg.gpName = tbName.Text;
            if(rbRingAll.Checked)
                rg.ringType = 0;
            else
                rg.ringType = 1;
            rg.playMOH = cbPlayMOH.Checked;
            if (rg.playMOH)
                rg.mohDir = tbMOHDir.Text;
            else
                rg.mohDir = "";

            if (cbVMB.Checked)
                rg.vmb = vmb;
            else
                rg.vmb = null;

            rg.bAnswerCallFirst = cbAnswerCallFirst.Checked;

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

 
        private void btnRemoveDest_Click(object sender, EventArgs e)
        {
            int nSel = lbDests.SelectedIndex;
            if (nSel >= 0)
            {
                rg.destList.RemoveAt(nSel);
                RefreshDestList();
            }
            else
            {
                MessageBox.Show("Please select one item to delete.", "Error");
            }
        }

        private void btnAddDest_Click(object sender, EventArgs e)
        {
            SIPPBXDest dest = new SIPPBXDest();
            RingDestEdit dlg = new RingDestEdit();
            dlg.dest = dest;
            dlg.pbx = pbx;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                rg.destList.Add(dest);
                RefreshDestList();
            }
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            int nSel = lbDests.SelectedIndex;
            if (nSel >= 0)
            {
                RingDestEdit dlg = new RingDestEdit();
                dlg.dest = rg.destList[nSel];
                dlg.pbx = pbx;
                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    RefreshDestList();
                }
            }
            else
            {
                MessageBox.Show("Please select one item first.", "Error");
            }
        }

        private void cbPlayMOH_CheckedChanged(object sender, EventArgs e)
        {
            if (cbPlayMOH.Checked)
            {
                tbMOHDir.Enabled = true;
                btnBrowse.Enabled = true;
                if (rg.mohDir.Length > 0)
                    tbMOHDir.Text = rg.mohDir;
                else
                    tbMOHDir.Text = pbx.moh_dir;
            }
            else
            {
                tbMOHDir.Enabled = false;
                btnBrowse.Enabled = false;
            }
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            FolderBrowser myBrowser = new FolderBrowser();
            myBrowser.Title = "Choose a music folder";
            myBrowser.Flags = BrowseFlags.BIF_NEWDIALOGSTYLE |
                              BrowseFlags.BIF_STATUSTEXT |
                              BrowseFlags.BIF_EDITBOX; ;
            DialogResult res = myBrowser.ShowDialog();
            if (res == DialogResult.OK)
            {
                tbMOHDir.Text = myBrowser.DirectoryPath;
            }
        }

        private void cbVMB_CheckedChanged(object sender, EventArgs e)
        {
            if (cbVMB.Checked)
            {
                btnVMBSet.Enabled = true;
                if (vmb == null)
                    vmb = new VoiceMailBox();
            }
            else
            {
                btnVMBSet.Enabled = false;
                vmb = null;
            }
        }

        private void btnVMBSet_Click(object sender, EventArgs e)
        {
            if (vmb == null)
                vmb = new VoiceMailBox();

            VoiceMailBoxEdit dlg = new VoiceMailBoxEdit();
            dlg.vmb = vmb;
            dlg.pbx = pbx;
            dlg.ShowDialog();
        }


    }
}