using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class RingGroupList : Form
    {
        public SIPPBX pbx;
        public PBXMainForm main_form;

        public RingGroupList()
        {
            InitializeComponent();
        }

        private void btnAdd_Click(object sender, EventArgs e)
        {
            SIPPBXRingGroup rg = new SIPPBXRingGroup();
            rg.bUseGroupName = false;

            RingGroupEdit dlg = new RingGroupEdit();
            dlg.rg = rg;
            dlg.pbx = pbx;
            if (dlg.ShowDialog() == DialogResult.OK)
            {
                if (SIPPBXCFGDB.AddRingGroupToDB(rg, null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    pbx.sip_ringgroups.Add(rg);
                    ShowRingGroupList();
                }
                else
                {
                    MessageBox.Show("Cannot add the ring group into DB!", "Error");
                }
            }
        }

        private void RingGroupList_Load(object sender, EventArgs e)
        {
            lvRingGroups.Columns.Clear();
            lvRingGroups.Columns.Add("Name", 120, HorizontalAlignment.Left);
            lvRingGroups.Columns.Add("Ring Type", 120, HorizontalAlignment.Left);
            lvRingGroups.Columns.Add("Destinations", 240, HorizontalAlignment.Left);

            cbUseGroupName.Checked = pbx.use_gpname_as_dispname;

            ShowRingGroupList();
        }

        public void ShowRingGroupList()
        {
            lvRingGroups.Items.Clear();
            for (int i = 0; i < pbx.sip_ringgroups.Count; i++)
            {
                ListViewItem aItem = new ListViewItem(pbx.sip_ringgroups[i].gpName);
                if(pbx.sip_ringgroups[i].ringType == 0)
                    aItem.SubItems.Add("All");
                else
                    aItem.SubItems.Add("By Order");
                
                string sDests = "";
                for(int j=0; j<pbx.sip_ringgroups[i].destList.Count; j++)
                    sDests += pbx.sip_ringgroups[i].destList[j].DestAddr + ";";
                aItem.SubItems.Add(sDests);
                lvRingGroups.Items.Add(aItem);
            }
        }

        private void btnEdit_Click(object sender, EventArgs e)
        {
            SIPPBXRingGroup rg;
            if (lvRingGroups.SelectedIndices.Count >= 1)
            {
                rg = pbx.sip_ringgroups[lvRingGroups.SelectedIndices[0]];
                RingGroupEdit dlg = new RingGroupEdit();
                dlg.pbx = pbx;
                dlg.rg = rg;
                if (dlg.ShowDialog() == DialogResult.OK)
                {
                    if (SIPPBXCFGDB.UpdateRingGroupInDB(rg, null, pbx, null, pbx.db_set, PBXMainForm.log))
                    {
                    }
                    else
                    {
                        MessageBox.Show("Cannot update the ring group into DB!", "Error");
                    }
                }

                ShowRingGroupList();
            }
            else
            {
                MessageBox.Show("Please select an item first!", "Error");
            }
        }

        private void btnDel_Click(object sender, EventArgs e)
        {
            if (lvRingGroups.SelectedIndices.Count >= 1)
            {
                DialogResult dialogResult = MessageBox.Show("Are you sure to delete the item?", "Confirmation", MessageBoxButtons.YesNo);
                if (dialogResult == DialogResult.Yes)
                {
                    //do something
                }
                else if (dialogResult == DialogResult.No)
                {
                    //do something else
                    return;
                }

                if (SIPPBXCFGDB.RemoveRingGroupFromDB(pbx.sip_ringgroups[lvRingGroups.SelectedIndices[0]], null, pbx, null, pbx.db_set, PBXMainForm.log))
                {
                    pbx.sip_ringgroups.RemoveAt(lvRingGroups.SelectedIndices[0]);
                    lvRingGroups.Items.RemoveAt(lvRingGroups.SelectedIndices[0]);
                }
                else
                {
                    MessageBox.Show("Cannot remove the ring group from DB!", "Error");
                }
            }
            else
            {
                MessageBox.Show("Please select an item first!", "Error");
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void cbUseGroupName_CheckedChanged(object sender, EventArgs e)
        {
            pbx.use_gpname_as_dispname = cbUseGroupName.Checked;
            SIPPBXCFGDB.UpdateSysUseGroupNameAsDisplayNameToDB(null, pbx, null, pbx.db_set, PBXMainForm.log);
        }

    }
}