using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;
using System.Data.SqlClient;
using System.IO;

namespace SIPPBXGUI
{
    public partial class SearchACDCalls : Form
    {
        public SIPPBX pbx;
        public DBServerSetting db_set;

        public SearchACDCalls()
        {
            InitializeComponent();
            db_set = new DBServerSetting();
        }

        private void SearchACDCalls_Load(object sender, EventArgs e)
        {
            DateTime dt1 = DateTime.Now.AddDays(-5);
            dtPicker1.Value = new DateTime(dt1.Year, dt1.Month, dt1.Day, 0, 0, 0);
            dtPicker1.Checked = false;

            DateTime dt2 = DateTime.Now;
            dtPicker2.Value = new DateTime(dt2.Year, dt2.Month, dt2.Day, 23, 59, 59);
            dtPicker2.Checked = false;

            db_set.CopyFrom(pbx.db_set);
        }

        private void btnSearch_Click(object sender, EventArgs e)
        {
            SearchData(tbACDName.Text.Trim(), dtPicker1.Value, dtPicker2.Value);
        }

        public void SearchData(string acdName, DateTime dt1, DateTime dt2)
        {
            string commandStr = "SELECT Caller, Callee, StartTime, EndTime, RecordFile, ACD_Name, Transferred FROM cdr_acd WHERE ";

            bool cnd = false;

            if (dtPicker1.Checked)
            {
                if (cnd) commandStr += "AND ";
                commandStr += "StartTime >= '" + PBXMainForm.GetSQLDateTime(dt1) + "' ";
                cnd = true;
            }
            if (dtPicker2.Checked)
            {
                if (cnd) commandStr += "AND ";
                commandStr += "StartTime <= '" + PBXMainForm.GetSQLDateTime(dt2) + "' ";
                cnd = true;
            }

            if (acdName.Length > 0)
            {
                if (cnd) commandStr += "AND ";
                commandStr += "ACD_Name LIKE '%" + acdName + "%' ";
                cnd = true;
            }

            if (!cnd)
            {
                commandStr = commandStr.Substring(0, commandStr.Length - 6); //remove WHERE
            }

            try
            {

                if (db_set.ConnectDB())
                {
                    // you can make it grid readonly.
                    dataGridView1.ReadOnly = true;

                    // finally bind the data to the grid
                    dataGridView1.DataSource = PBXMainForm.GetSearchDataBinder(db_set, commandStr);

                    dataGridView1.Columns[2].DefaultCellStyle.Format = "yyyy-MM-dd hh:mm:ss";
                    dataGridView1.Columns[3].DefaultCellStyle.Format = "yyyy-MM-dd hh:mm:ss";

                    // Resize the DataGridView columns to fit the newly loaded content.
                    //dataGridView1.AutoResizeColumns(DataGridViewAutoSizeColumnsMode.AllCellsExceptHeader);

                    db_set.DisconnectDB();
                }
                else
                {
                    MessageBox.Show("Cannot connect to database!");
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.ToString());
            }
        }

        private void dataGridView1_CellContentDoubleClick(object sender, DataGridViewCellEventArgs e)
        {
            string fn = "";

            //if (DataViewType == 0) return;

            if (e.ColumnIndex == 4)
            {
                fn = dataGridView1.Rows[e.RowIndex].Cells[e.ColumnIndex].Value.ToString();
            }
            else
            {
                fn = dataGridView1.Rows[e.RowIndex].Cells[4].Value.ToString();
            }

            if (fn.Length == 0)
                return;

            fn = pbx.handleAudioFileName(fn);

            System.Diagnostics.Process Proc = new System.Diagnostics.Process();
            Proc.StartInfo.FileName = fn;
            try
            {
                Proc.Start();
            }
            catch (Exception ep)
            {
                MessageBox.Show("Error when playing file:(" + fn + ")\r\n" + ep.ToString());
            }
        }




    }
}