using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using SIPPBXv3;

namespace SIPPBXGUI
{
    public partial class VoiceMailBoxEdit : Form
    {
        public SIPPBX pbx;
        public VoiceMailBox vmb;

        public VoiceMailBoxEdit()
        {
            InitializeComponent();
        }

        private void VoiceMailBoxEdit_Load(object sender, EventArgs e)
        {
            if (vmb.vmbPrompt.Length > 0)
                tbVoicePrompt.Text = vmb.vmbPrompt;
            else
                tbVoicePrompt.Text = pbx.please_leave_your_message_after_beep_dir;

            if (vmb.vmbExten != null && vmb.vmbEmailAddr.Length == 0)
            {
                tbEmailAddr.Text = vmb.vmbExten.Email;
                //tbEmailAddr.Enabled = false;
            }
            else
            {
                tbEmailAddr.Text = vmb.vmbEmailAddr;
            }

            tbMaxLength.Text = vmb.maxLengthInSecond.ToString();
            tbPassword.Text = vmb.vmbPassword;
        }

        private void btnBrowse_Click(object sender, EventArgs e)
        {
            OpenFileDialog openFileDialog1 = new OpenFileDialog();

            openFileDialog1.InitialDirectory = Application.StartupPath + "\\audio\\";
            openFileDialog1.Filter = Constants.SoundFileFilter;
            openFileDialog1.FilterIndex = 1;
            openFileDialog1.RestoreDirectory = true;

            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                tbVoicePrompt.Text = openFileDialog1.FileName;
            }
        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            vmb.vmbPrompt = tbVoicePrompt.Text;
            //if (vmb.vmbExten == null)
            //{
                vmb.vmbEmailAddr = tbEmailAddr.Text;
            //}

            vmb.maxLengthInSecond = Convert.ToInt32(tbMaxLength.Text);

            vmb.vmbPassword = tbPassword.Text;

            DialogResult = DialogResult.OK;

            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            Close();
            DialogResult = DialogResult.Cancel;
        }

        private void textBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (!char.IsControl(e.KeyChar) && !char.IsDigit(e.KeyChar) /*&& (e.KeyChar != '.')*/)
            {
                e.Handled = true;
            }

            // only allow one decimal point
            /*
            if ((e.KeyChar == '.') && ((sender as TextBox).Text.IndexOf('.') > -1))
            {
                e.Handled = true;
            }*/
        }
    }
}