/*////////////////////////////////////////////////////////////////////////////////////
//
//Copyright (c) 2007-2020 by PC Best Networks, Inc.   All rights reserved
//
*/////////////////////////////////////////////////////////////////////////////////////

using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpACDAgentLog : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXChan _chan;
        public bool _login;
        public GTOpAudioPlayEx _audio_code;
        public GTOpAudioPlayEx _audio_password;
        public GTOpAudioPlayEx _audio_acd_name;
        public GTOpAudioPlay _audio_result;
        int _error_count;
        public SIPPBXAgent _agent;
        public bool _is_for_acd;

        public GTOpACDAgentLog(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, bool login)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _login = login;
            _audio_code = null;
            _audio_password = null;
            _audio_result = null;
            _error_count = 0;
            _agent = null;
            _is_for_acd = false;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpACDAgentLog::start()########################====>>");

            List<string> audio_files= new List<string>();
            audio_files.Add(_pbx.acd_agent_prompt1);
            _chan.DTMFBuf = "";
            _audio_code = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "#", 15000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
            _audio_code.perform();
        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _audio_code)
            {
                string agent_code = _audio_code.getDTMFStr();
                agent_code = agent_code.TrimEnd('#');
                _env.LOG_Trace(4, "Agent code: " + agent_code);
                bool bFound = false;
                for (int i = 0; i < _pbx.sip_agents.Count; i++)
                {
                    if (_pbx.sip_agents[i].Code == agent_code)
                    {
                        _agent = _pbx.sip_agents[i];
                        bFound = true;
                        break;
                    }
                }
                if (bFound)
                {
                    _error_count = 0;
                    List<string> audio_files = new List<string>();
                    audio_files.Add(_pbx.acd_agent_prompt2);
                    _chan.DTMFBuf = "";
                    _audio_password = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "#", 15000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
                    _audio_password.perform();
                }
                else
                {
                    _error_count++;
                    if (_error_count >= 3)
                    {
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: Agent Login - error count reached 3 times.");
                    }
                    else
                    {
                        List<string> audio_files = new List<string>();
                        audio_files.Add(_pbx.acd_agent_prompt1);
                        _chan.DTMFBuf = "";
                        _audio_code = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "#", 15000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
                        _audio_code.perform();
                    }
                }
            }
            else if (opAsync == _audio_password)
            {
                if (_agent == null) //should never be the case
                    return;

                if (_audio_password.getDTMFStr().TrimEnd('#') == _agent.Password)
                {
                    _error_count = 0;
                    if(_login)
                    {
                        List<string> audio_files = new List<string>();
                        audio_files.Add(_pbx.acd_agent_prompt7);
                        _chan.DTMFBuf = "";
                        _audio_acd_name = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "#", 15000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
                        _audio_acd_name.perform();
                    }
                    else
                    {
                        List<string> audio_files = new List<string>();
                        audio_files.Add(_pbx.acd_agent_prompt8);
                        _chan.DTMFBuf = "";
                        _audio_acd_name = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "#", 15000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
                        _audio_acd_name.perform();

                    }
                }
                else
                {
                    _error_count++;
                    if (_error_count >= 3)
                    {
                        if (_login)
                        {
                            List<string> audio_files = new List<string>();
                            audio_files.Add(_pbx.acd_agent_prompt4);
                            _audio_result = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
                            _audio_result.perform();
                        }
                        else
                        {
                            List<string> audio_files = new List<string>();
                            audio_files.Add(_pbx.acd_agent_prompt6);
                            _audio_result = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
                            _audio_result.perform();
                        }
                    }
                    else
                    {
                        List<string> audio_files = new List<string>();
                        audio_files.Add(_pbx.acd_agent_prompt2);
                        _chan.DTMFBuf = "";
                        _audio_password = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "#", 15000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
                        _audio_password.perform();
                    }
                }
            }
            else if (opAsync == _audio_acd_name)
            {
                if (_audio_acd_name.getDTMFStr().TrimEnd('#') == "" && !_is_for_acd)
                {
                    if (_login)
                    {
                        bool login_result = _pbx.AgentLogin(_agent, _chan.link_exten, _env, "", "", "", null);

                        List<string> audio_files = new List<string>();
                        if (login_result)
                        {
                            for (int i = 0; i < _pbx.sip_agents.Count; i++)
                            {
                                if (_pbx.sip_agents[i] != _agent)
                                {
                                    if (_pbx.sip_agents[i].AtExten == _chan.link_exten)
                                    {
                                        //Don't allow multuple agents to sign in at one extension
                                        _pbx.AgentLogout(_pbx.sip_agents[i], _chan.link_exten, _env, "", "", "", null);
                                    }
                                }
                            }
                            audio_files.Add(_pbx.acd_agent_prompt3);
                        }
                        else
                            audio_files.Add(_pbx.acd_agent_prompt4);
                        _audio_result = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
                        _audio_result.perform();
                    }
                    else
                    {
                        bool logout_result = _pbx.AgentLogout(_agent, _chan.link_exten, _env, "", "", "", null);

                        List<string> audio_files = new List<string>();
                        if(logout_result)
                            audio_files.Add(_pbx.acd_agent_prompt5);
                        else
                            audio_files.Add(_pbx.acd_agent_prompt6);
                        _audio_result = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
                        _audio_result.perform();
                    }
                }
                else
                {
                    _is_for_acd = true;
                    SIPPBXACDHuntGroup _acd = _pbx.getACDByDigit(_audio_acd_name.getDTMFStr().TrimEnd('#'));
                    if (_acd != null)
                    {
                        if (_login)
                        {
                            bool login_result = _pbx.AgentLogin(_agent, _chan.link_exten, _env, "", "", "", _acd);

                            List<string> audio_files = new List<string>();
                            if (login_result)
                                audio_files.Add(_pbx.acd_agent_prompt3);
                            else
                                audio_files.Add(_pbx.acd_agent_prompt4);
                            _audio_result = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
                            _audio_result.perform();
                        }
                        else
                        {
                            bool logout_result = _pbx.AgentLogout(_agent, _chan.link_exten, _env, "", "", "", _acd);

                            List<string> audio_files = new List<string>();
                            if (logout_result)
                                audio_files.Add(_pbx.acd_agent_prompt5);
                            else
                                audio_files.Add(_pbx.acd_agent_prompt6);
                            _audio_result = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
                            _audio_result.perform();
                        }
                    }
                    else
                    {
                        _error_count++;
                        if (_error_count >= 3)
                        {
                            if (_login)
                            {
                                List<string> audio_files = new List<string>();
                                audio_files.Add(_pbx.acd_agent_prompt4);
                                _audio_result = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
                                _audio_result.perform();
                            }
                            else
                            {
                                List<string> audio_files = new List<string>();
                                audio_files.Add(_pbx.acd_agent_prompt6);
                                _audio_result = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
                                _audio_result.perform();
                            }
                        }
                        else
                        {
                            if (_login)
                            {
                                List<string> audio_files = new List<string>();
                                audio_files.Add(_pbx.acd_agent_prompt7);
                                _chan.DTMFBuf = "";
                                _audio_acd_name = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "#", 15000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
                                _audio_acd_name.perform();
                            }
                            else
                            {
                                List<string> audio_files = new List<string>();
                                audio_files.Add(_pbx.acd_agent_prompt8);
                                _chan.DTMFBuf = "";
                                _audio_acd_name = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "#", 15000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
                                _audio_acd_name.perform();
                            }

                        }
                    }

                }
            }
            else if (opAsync == _audio_result)
            {
                //_env.DisconnectCall(_chan.index, 0, "", "PBX: Agent Login - error count reached 3 times.");
                _env.DisconnectCall(_chan.index, 0, "", "");
            }
        }

    }
}
