/*////////////////////////////////////////////////////////////////////////////////////
//
//Copyright (c) 2007-2020 by PC Best Networks, Inc.   All rights reserved
//
*/////////////////////////////////////////////////////////////////////////////////////
using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpACDSelect : GTOpAsync
    {
        public SIPPBXACDHuntGroup _hg;
        public bool _front;
        public int _linear_idx;
        public List<SIPPBXExten> _exp_list;
        public int timeout_act;

        public int queue_pos_cnt; //in seconds, count how many seconds have gone since last time prompt the position

        public GTOpACDSelect(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, string dtmfStr, SIPPBXACDHuntGroup hg, bool bFront, int linear_start, List<SIPPBXExten> exp_lst)
            :base(ac, env, pbx_chan, dtmfStr)
        {
            _hg = hg;
            _front = bFront;
            _linear_idx = linear_start;
            if (exp_lst == null)
                _exp_list = new List<SIPPBXExten>();
            else
                _exp_list = exp_lst;

            _env.LOG_Trace(4, "GTOpACDSelect::GTOpACDSelect " + _linear_idx.ToString());

            timeout_act = 0;
            queue_pos_cnt = 10;
        }

        public SIPPBXExten getExtensionByName(string extn_name)
        {
            return getEnv().pbx.getExtensionByName(extn_name);
        }

        public int availableExtension()
        {
            int cnt = 0;
            SIPPBXExten extn = null;
            SIPPBXAgent agent = null;

            if (_hg.agentType == 0) //extensions
            {
                for (int i = 0; i < _hg.agents.Count; i++)
                {
                    extn = getExtensionByName(_hg.agents[i]);
                    if (extn != null)
                    {
                        if (extn.IsRegistered() || extn.IsVirtualExten())
                        {
                            cnt++;
                        }
                    }
                }
            }
            else if (_hg.agentType == 1)//static agents
            {
                for (int i = 0; i < _hg.agents.Count; i++)
                {
                    agent = _env.pbx.getAgentByCode(_hg.agents[i]);
                    if (agent != null)
                    {
                        if (agent.AtExten != null)
                        {
                            if (agent.AtExten.IsRegistered() || agent.AtExten.IsVirtualExten())
                            {
                                cnt++;
                            }
                        }
                    }
                }
            }
            else if (_hg.agentType == 2)//dynamic agents
            {
                for (int i = 0; i < _env.pbx.sip_agents.Count; i++)
                {
                    agent = _env.pbx.sip_agents[i];
                    if (agent != null)
                    {
                        if (agent.AtExten != null && agent.LoggedInACD.Contains(_hg.hgName))
                        {
                            if (agent.AtExten.IsRegistered() || agent.AtExten.IsVirtualExten())
                            {
                                cnt++;
                            }
                        }
                    }
                }
            }

            return cnt;
        }

        public bool isExtenAbleToAnwerACDCalls(SIPPBXExten extn)
        {
            if (extn.ACDCallMethod == 1) //1 = once registered
            {
                TimeSpan tsp = DateTime.Now - extn.IdleStartTime;

                if (extn.IsVirtualExten())
                    _env.LOG_Trace(4, "isExtenAbleToAnwerACDCalls:" + extn.UserName + " is virtual.");
                else
                {
                    if(extn.IsRegistered())
                        _env.LOG_Trace(4, "isExtenAbleToAnwerACDCalls: Exten:" + extn.UserName + " is registered.");
                    else
                        _env.LOG_Trace(4, "isExtenAbleToAnwerACDCalls: Exten:" + extn.UserName + " is not registered.");
                }

                if(extn.InCalling == 0)
                    _env.LOG_Trace(4, "isExtenAbleToAnwerACDCalls: Exten:" + extn.UserName + " is idle. " + tsp.TotalSeconds.ToString() + " " + extn.RestSeconds.ToString());
                else
                    _env.LOG_Trace(4, "isExtenAbleToAnwerACDCalls: Exten:" + extn.UserName + " is in call. " + tsp.TotalSeconds.ToString() + " " + extn.RestSeconds.ToString());

                if (extn.IsVirtualExten() && (extn.InCalling == 0 || extn.bMultipleCalls) && tsp.TotalSeconds >= extn.RestSeconds)
                {
                    return true;
                }
                else if (extn.IsRegistered() && (extn.InCalling == 0 || extn.bMultipleCalls) && tsp.TotalSeconds >= extn.RestSeconds)
                {
                    return true;
                }
            }
            else if (extn.ACDCallMethod == 2) //2 = once connected with *9000
            {
                if (extn.InCalling == 30)
                {
                    GTAPIASM.GTAPIChan achan = null;
                    //find the channel
                    for (int i = 0; i < _env.GetChannelCount(); i++)
                    {
                        achan = _env.GetChannel(i);
                        if (GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, achan.caller_num) == extn.UserName &&
                            GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, achan.callee_num) == getEnv().pbx.acd_number)
                        {
                            if (_env.pbx.chan_list[i].link_chan == null)
                                return true;
                            else
                                return false;
                        }
                    }
                }
            }

            return false;
        }

        public SIPPBXExten selectAgent()
        {
            SIPPBXAgent agent = null;

            List<string> agents = new List<string>();

            if (_hg.agentType == 2) //agent dynamic sign in to ACD group
            {
                for (int i = 0; i < _env.pbx.sip_agents.Count; i++)
                {
                    agents.Add(_env.pbx.sip_agents[i].Code);
                }
            }
            else
            {
                for (int i = 0; i < _hg.agents.Count; i++)
                {
                    agents.Add(_hg.agents[i]);
                }
            }

            if (_hg.hgType == 0) //linear
            {
                for (int i = 0; i < agents.Count; i++)
                {
                    int idx = (_linear_idx + i) % agents.Count;
                    agent = _env.pbx.getAgentByCode(agents[idx]);
                    if (agent != null)
                    {
                        if (agent.AtExten != null && !agent.Paused)
                        {
                            if ((_hg.agentType == 2 && agent.LoggedInACD.Contains(_hg.hgName)) || _hg.agentType == 1)
                            {
                                if (isExtenAbleToAnwerACDCalls(agent.AtExten))
                                {
                                    _linear_idx = (idx + 1) % agents.Count;
                                    _env.LOG_Trace(4, "GTOpACDSelect::selectAgent _linear_idx set to " + _linear_idx.ToString());
                                    return agent.AtExten;
                                }
                            }
                        }
                    }
                }
            }
            else if (_hg.hgType == 1 && agents.Count > 0) //circle
            {
                int iBegin = _hg.circularCursor;
                _env.LOG_Trace(4, "GTOpACDSelect::selectAgent circle 1 iBegin:" + iBegin.ToString() + " circularCursor:" + _hg.circularCursor.ToString() + " AgentCount:" + agents.Count.ToString());

                if (iBegin >= 0 && iBegin < agents.Count)
                    agent = _env.pbx.getAgentByCode(agents[iBegin]);
                else
                    agent = null;

                if (agent != null)
                {
                    _env.LOG_Trace(4, "GTOpACDSelect::selectAgent circle 2 iBegin:" + iBegin.ToString() + " circularCursor:" + _hg.circularCursor.ToString() + " AgentCount:" + agents.Count.ToString() + " Agent:" + agent.Code);
                    if (agent.AtExten != null && !agent.Paused)
                    {
                        if ((_hg.agentType == 2 && agent.LoggedInACD.Contains(_hg.hgName)) || _hg.agentType == 1)
                        {
                            if (isExtenAbleToAnwerACDCalls(agent.AtExten))
                            {
                                //trying to reach this number
                                _hg.circularCursor++;
                                _hg.circularCursor %= agents.Count;
                                _env.LOG_Trace(4, "GTOpACDSelect::selectAgent circle 3 iBegin:" + iBegin.ToString() + " circularCursor:" + _hg.circularCursor.ToString() + " AgentCount:" + agents.Count.ToString() + " Agent:" + agent.Code);
                                return agent.AtExten;
                            }
                        } 
                    }
                }

                iBegin++;
                iBegin %= agents.Count;
                _env.LOG_Trace(4, "GTOpACDSelect::selectAgent circle 4 iBegin:" + iBegin.ToString() + " circularCursor:" + _hg.circularCursor.ToString() + " AgentCount:" + agents.Count.ToString());

                while (iBegin != _hg.circularCursor)
                {
                    _env.LOG_Trace(4, "GTOpACDSelect::selectAgent circle 5 iBegin:" + iBegin.ToString() + " circularCursor:" + _hg.circularCursor.ToString() + " AgentCount:" + agents.Count.ToString());
                    agent = _env.pbx.getAgentByCode(agents[iBegin]);
                    if (agent != null)
                    {
                        _env.LOG_Trace(4, "GTOpACDSelect::selectAgent circle 6 iBegin:" + iBegin.ToString() + " circularCursor:" + _hg.circularCursor.ToString() + " AgentCount:" + agents.Count.ToString() + " Agent:" + agent.Code);
                        if (agent.AtExten != null && !agent.Paused)
                        {
                            if ((_hg.agentType == 2 && agent.LoggedInACD.Contains(_hg.hgName)) || _hg.agentType == 1)
                            {
                                _env.LOG_Trace(4, "GTOpACDSelect::selectAgent circle 7 iBegin:" + iBegin.ToString() + " circularCursor:" + _hg.circularCursor.ToString() + " AgentCount:" + agents.Count.ToString() + " Agent:" + agent.Code);
                                if (isExtenAbleToAnwerACDCalls(agent.AtExten))
                                {
                                    //trying to reach this number
                                    _hg.circularCursor = iBegin + 1;
                                    _hg.circularCursor %= agents.Count;
                                    _env.LOG_Trace(4, "GTOpACDSelect::selectAgent circle 8 iBegin:" + iBegin.ToString() + " circularCursor:" + _hg.circularCursor.ToString() + " AgentCount:" + agents.Count.ToString() + " Agent:" + agent.Code);
                                    return agent.AtExten;
                                }
                            }
                        }
                    }
                    iBegin++;
                    iBegin %= agents.Count;
                    _env.LOG_Trace(4, "GTOpACDSelect::selectAgent circle 9 iBegin:" + iBegin.ToString() + " circularCursor:" + _hg.circularCursor.ToString() + " AgentCount:" + agents.Count.ToString());
                }
            }
            else if (_hg.hgType == 2) //most idle
            {
                SIPPBXExten extn1 = null;
                for (int i = 0; i < agents.Count; i++)
                {
                    agent = _env.pbx.getAgentByCode(agents[i]);
                    if (agent != null)
                    {
                        if (agent.AtExten != null && !agent.Paused)
                        {
                            if (_exp_list.Contains(agent.AtExten))
                                continue;

                            if ((_hg.agentType == 2 && agent.LoggedInACD.Contains(_hg.hgName)) || _hg.agentType == 1)
                            {
                                if (isExtenAbleToAnwerACDCalls(agent.AtExten))
                                {
                                    if (extn1 == null)
                                    {
                                        extn1 = agent.AtExten;
                                    }
                                    else
                                    {
                                        if (agent.AtExten.IdleStartTime < extn1.IdleStartTime)
                                        {
                                            extn1 = agent.AtExten;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }

                if (extn1 != null)
                    _exp_list.Add(extn1);
                else
                {
                    //should we reset the exception list. yes we do.
                    _exp_list.Clear();
                }

                return extn1;
            }
            else if (_hg.hgType == 3) //most skill
            {
                SIPPBXExten extn1 = null;
                short skill1 = 0;
               
                for (int i = 0; i < agents.Count; i++)
                {
                    agent = _env.pbx.getAgentByCode(agents[i]);
                    if (agent != null)
                    {
                        if (agent.AtExten != null && !agent.Paused)
                        {
                            if (_exp_list.Contains(agent.AtExten))
                                continue;

                            if (isExtenAbleToAnwerACDCalls(agent.AtExten))
                            {
                                if (extn1 == null)
                                {
                                    extn1 = agent.AtExten;
                                    skill1 = agent.SkillLevel;
                                }
                                else
                                {
                                    if (agent.SkillLevel > skill1)
                                    {
                                        extn1 = agent.AtExten;
                                        skill1 = agent.SkillLevel;
                                    }
                                }
                            }
                        }
                    }
                }

                if (extn1 != null)
                    _exp_list.Add(extn1);
                else
                {
                    //should we reset the exception list. yes we do.
                    _exp_list.Clear();
                }

                return extn1;
            }

            return null;
        }

        public SIPPBXExten selectExtension()
        {
            SIPPBXExten extn = null;

            if (_hg.hgType == 0) //linear
            {
                for (int i = 0; i < _hg.agents.Count; i++)
                {
                    int idx = (_linear_idx + i) % _hg.agents.Count;
                    extn = getExtensionByName(_hg.agents[idx]);
                    if (extn != null)
                    {
                        _env.LOG_Trace(4, "GTOpACDSelect::selectExtension linear " + extn.UserName);
                        if (isExtenAbleToAnwerACDCalls(extn))
                        {
                            _env.LOG_Trace(4, "GTOpACDSelect::selectExtension linear " + extn.UserName + " is selected");
                            //trying to reach this number
                            _linear_idx = (idx+1)% _hg.agents.Count;
                            _env.LOG_Trace(4, "GTOpACDSelect::selectExtension _linear_idx set to " + _linear_idx.ToString());
                            return extn;                            
                        }
                    }
                }
            }
            else if (_hg.hgType == 1 && _hg.agents.Count > 0) //circle
            {
                int iBegin = _hg.circularCursor;
                extn = getExtensionByName(_hg.agents[iBegin]);
                if (extn != null)
                {
                    _env.LOG_Trace(4, "GTOpACDSelect::selectExtension circle " + extn.UserName);
                    if (isExtenAbleToAnwerACDCalls(extn))
                    {
                        _env.LOG_Trace(4, "GTOpACDSelect::selectExtension circle " + extn.UserName + " is selected");
                        //trying to reach this number
                        _hg.circularCursor++;
                        _hg.circularCursor %= _hg.agents.Count;
                        return extn;
                    }
                }

                iBegin++;
                iBegin %= _hg.agents.Count;

                while (iBegin != _hg.circularCursor)
                {
                    extn = getExtensionByName(_hg.agents[iBegin]);
                    if (extn != null)
                    {
                        _env.LOG_Trace(4, "GTOpACDSelect::selectExtension circle " + extn.UserName);
                        if (isExtenAbleToAnwerACDCalls(extn))
                        {
                            _env.LOG_Trace(4, "GTOpACDSelect::selectExtension circle " + extn.UserName + " is selected");
                            //trying to reach this number
                            _hg.circularCursor = iBegin + 1;
                            _hg.circularCursor %= _hg.agents.Count;
                            return extn;
                        }
                    }
                    iBegin++;
                    iBegin %= _hg.agents.Count;
                }
            }
            else if (_hg.hgType == 2) //most idle
            {
                SIPPBXExten extn1 = null;
                for (int i = 0; i < _hg.agents.Count; i++)
                {
                    extn = getExtensionByName(_hg.agents[i]);
                    if (extn != null)
                    {
                        if (_exp_list.Contains(extn))
                            continue;

                        if (isExtenAbleToAnwerACDCalls(extn))
                        {
                            if (extn1 == null)
                            {
                                extn1 = extn;
                            }
                            else
                            {
                                if (extn.IdleStartTime < extn1.IdleStartTime)
                                {
                                    extn1 = extn;
                                }
                            }
                        }
                    }
                }

                if (extn1 != null)
                    _exp_list.Add(extn1);
                else
                {
                    //should we reset the exception list. yes we do.
                    _exp_list.Clear();
                }

                return extn1;
            }

            return null;
        }

        public bool transferCall(string callee, string caller, SIPPBXExten extn, SIPAccount acct)
        {
            SIPPBXChan chan2 = _env.pbx.SeizeChannelForOutbound(_env);
            //GTAPIASM.GTAPIChan api_chan = null;

            if (chan2 == null)
            {
                //not enough outbound channel available
                LogoutText(1, "GTOpACDSelect::transferCall SeizeChannelForOutbound return null. No enough outbound channel for calling!");
                return false;
            }

            GTOpACD acdComp = (GTOpACD)_async_compund;

            chan2.ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, _env.pbx, extn);
            chan2.link_exten = extn;
            if (extn != null)
                if (extn.RingTimeoutSec >= 0) //as for -1, it is always forwarding. won't make call out so this state is not updated if set to 10.
                    _env.pbx.SetExtenCallingState(extn, _env, 10);
            acdComp._op_call_transfer = new GTOpACDCallTransfer(_async_compund, _env, _pbxChan, _dtmf, chan2, callee, caller, (extn != null) ? extn.RingTimeoutSec : 0, _hg, acct);
            acdComp._op_call_transfer.perform();
            return true;
        }


        public bool DistributeCallToExten(SIPPBXExten extn)
        {
            if (extn.ACDCallMethod == 1) //1 = once registered
            {
                GTAPIASM.GTAPIChan api_chan = _env.GetChannel(getPBXChan().index);
 
                string caller_num;
                if(_hg.bUseGroupName)
                    caller_num = SIPPBXWinUtil.BuildCallerID(api_chan, _hg.hgName);
                else
                    caller_num = SIPPBXWinUtil.BuildCallerID(api_chan, "");

                string caller_username = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num);
                string called_num = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num);

                if (extn.IsVirtualExten())
                {
                    if (extn.InCalling != 0 && !extn.bMultipleCalls)
                        return false;

                    //calling to a virtual extension
                    if (extn.VirtualExtenDestAddr.Contains(".") || extn.VirtualExtenDestAddr.Contains("@"))
                    {
                        //sip address
                        string sipDestAddr = extn.VirtualExtenDestAddr.Replace("*", called_num);

                        if (sipDestAddr.Contains("sip:"))
                        {
                            return transferCall(sipDestAddr, caller_num, extn, null);
                        }
                        else
                        {
                            return transferCall("<sip:" + sipDestAddr + ">", caller_num, extn, null);
                        }
                    }
                    else
                    {
                        //to see if it matchs any outbound rules

                        SIPPBXVirExtenTransferWrap wrap = _env.pbx.transferCallToVirtualExtension(_env, extn, getPBXChan(), caller_num, called_num);

                        if(wrap != null)
                        {
                            return transferCall(wrap.callee, wrap.caller, wrap.extn, wrap.acct);
                        }
                        /*
                        SIPPBXDialPlan dp1 = _env.pbx.getDialPlanByCalledNum(_env, extn.VirtualExtenDestAddr, "", GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num), GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, caller_num), _env.pbx.getExtensionBySIPAddr(caller_num), 1);
                        if (dp1 != null)
                        {
                            SIPAccount sip_acct = _env.pbx.getDialPlanSIPAccount(dp1);
                            if (sip_acct != null)
                            {
                                //outbound, should take out predix digit, then use another channel to dialout
                                string destaddr = dp1.OutboundPrepend + extn.VirtualExtenDestAddr.Substring(dp1.OutboundPreStrip.Length);
                                if (extn.bAcceptOtherID && called_num.Length > 0)
                                    destaddr = called_num;
                                destaddr += "@" + sip_acct.DomainServer;
                                destaddr = "<sip:" + destaddr + ">";

                                string fromaddr = sip_acct.UserName;
                                if (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1)
                                {
                                    SIPPBXExten ext0 = _env.pbx.getExtensionBySIPAddr(caller_num);
                                    if (ext0 != null)
                                    {
                                        if (ext0.AlternativePhoneNumber.Length > 0)
                                        {
                                            fromaddr = ext0.AlternativePhoneNumber;
                                        }
                                        else if (sip_acct.DIDList.Count > 0)
                                        {
                                            fromaddr = sip_acct.DIDList[0];

                                            if (sip_acct.OutboundAppendExtenID)
                                                fromaddr += ext0.UserName;
                                        }
                                    }
                                    else
                                    {
                                        fromaddr = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num);
                                        if (fromaddr == "unknown")
                                            fromaddr = sip_acct.UserName;
                                    }
                                }

                                if (fromaddr == "")
                                {
                                    if (caller_username.Length > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                        fromaddr = caller_username;
                                    else if (sip_acct.DIDList.Count > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                        fromaddr = sip_acct.DIDList[0];
                                    else if (sip_acct.UserName.Length > 0)
                                        fromaddr = sip_acct.UserName;
                                    else
                                        fromaddr = "unknown";
                                }

                                if (sip_acct.UseLocalIPInFrom)
                                {
                                    if (_env.pbx.sip_set.sipAddr.Length > 0)
                                        fromaddr += "@" + _env.pbx.sip_set.sipAddr;
                                    else
                                        fromaddr += "@" + _env.GetMappedPublicSIPIPAddress();
                                }
                                else
                                    fromaddr += "@" + sip_acct.DomainServer;
                                fromaddr = SIPPBXWinUtil.GetCallerDisplayName(api_chan) + "<sip:" + fromaddr + ">";

                                return transferCall(destaddr, fromaddr, extn, sip_acct);
                            }
                        }*/
                    }
                }
                else
                {
                    //regular extension
                    if (extn.IsRegistered() && (extn.InCalling == 0 || extn.bMultipleCalls))
                    {
                        string sCallee = SIPPBXWinUtil.BuildCalleeID(api_chan, extn, getPBXChan());

                        return transferCall(sCallee, caller_num, extn, null);
                    }
                }
            }
            else if (extn.ACDCallMethod == 2) //2 = once connected with *9000
            {
                if (extn.InCalling == 30)
                {
                    GTAPIASM.GTAPIChan achan = null;
                    //find the channel
                    for (int i = 0; i < _env.GetChannelCount(); i++)
                    {
                        achan = _env.GetChannel(i);
                        if (GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, achan.caller_num) == extn.UserName &&
                            GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, achan.callee_num) == getEnv().pbx.acd_number)
                        {
                            if (_env.pbx.chan_list[i].link_chan == null)
                            {
                                //should define another op for this case
                                GTOpACD acdComp = (GTOpACD)_async_compund;
                                acdComp._op_call_connect = new GTOpCallConnect(_async_compund, _env, _pbxChan, _env.pbx.chan_list[i], _hg);
                                acdComp._op_call_connect.perform();
                                return true;
                            }
                        }
                    }
                }
            }

            return false;

        }

        public void LogHGCallsOut(int ch)
        {
        loop_again:
            for (int j = 0; j < _hg.calls.Count; j++)
            {
                GTOpAsync op = _hg.calls[j].op;
                if (op != null)
                {
                    if (op.getPBXChan() != null)
                    {
                        SIPPBXChan temp_chan = op.getPBXChan();

                        LogoutText(4, "GTOpACDSelect --> Call[" + j.ToString() + "] is on channel " + temp_chan.index.ToString());

                        if (ch == temp_chan.index)
                        {
                            LogoutText(1, "GTOpACDSelect --> channel " + temp_chan.index.ToString() + " repeated. remove this one from the list.");
                            _hg.calls.RemoveAt(j);
                            goto loop_again;
                        }
                        else
                        {
                            GTAPIASM.GTAPIChan api_chan = _env.GetChannel(temp_chan.index);
                            if (!api_chan.originate)
                            {
                                if (!_env.IsChanConnected(temp_chan.index))
                                {
                                    LogoutText(1, "GTOpACDSelect --> channel " + temp_chan.index.ToString() + " is not in connected status! It should NOT be in the HuntGroup List anymore.");
                                    _hg.calls.RemoveAt(j);
                                    goto loop_again;
                                }
                            }
                            else
                            {
                                //For outbound call, it is possibly from auto-dialer tasks
                                //changed logic 2012/04/18
                                //just do the same check as inbound
                                //LogoutText(1, "GTOpACDSelect --> channel " + temp_chan.index.ToString() + " originated the call. It cannot be in HuntGroup List!");
                                if (!_env.IsChanConnected(temp_chan.index))
                                {
                                    LogoutText(1, "GTOpACDSelect --> channel " + temp_chan.index.ToString() + " is not in connected status! It should NOT be in the HuntGroup List anymore.");
                                    _hg.calls.RemoveAt(j);
                                    goto loop_again;
                                }
                            }
                        }
                    }
                    else
                    {
                        LogoutText(1, "GTOpACDSelect --> GTOpAsync.getPBXChan() is null. " + j.ToString());
                        LogoutText(1, "GTOpACDSelect --> Remove call " + j.ToString() + " from list.");
                        _hg.calls.RemoveAt(j);
                        goto loop_again;
                    }
                }
                else
                {
                    LogoutText(1, "GTOpACDSelect --> GTOpAsync is null. " + j.ToString());
                    LogoutText(1, "GTOpACDSelect --> Remove call " + j.ToString() + " from list.");
                    _hg.calls.RemoveAt(j);
                    goto loop_again;
                }
            }
        }

        public override void beginOp()
        {
            base.beginOp();

            LogoutText(4, "Start perform asyncronized step - GTOpACDSelect!");

            //GTAPIASM.GTAPIChan api_chan = _env.GetChannel(getPBXChan().index);

            if (!_env.IsChanConnected(getPBXChan().index))
            {
                LogoutText(1, "GTOpACDSelect::beginOp channel " + getPBXChan().index.ToString() + " is not in connected status!");
                fireDone(ResultCode.OP_RESULT_ERROR, 0);
                return;
            }

            //LogoutText(4, "Start perform asyncronized step - GTOpACDSelect - 2");

            LogHGCallsOut(getPBXChan().index);

            //LogoutText(4, "Start perform asyncronized step - GTOpACDSelect - 3");

            if (_front)
            {
                //if the bFront is true, it is also the call coming back to ACD
                _hg.calls.Insert(0, _async_compund);
                //LogoutText(4, "Start perform asyncronized step - GTOpACDSelect - 4");
            }
            else
            {
                _hg.calls.Add(_async_compund);
                getPBXChan().in_queue_time = DateTime.Now;
                //LogoutText(4, "Start perform asyncronized step - GTOpACDSelect - 5");
                getPBXChan().out_queue_time = getPBXChan().in_queue_time;
            }

            LogHGCallsOut(-1);

            //LogoutText(4, "Start perform asyncronized step - GTOpACDSelect - 6");

            getPBXChan().acd_queue = _hg;

            //LogoutText(4, "Start perform asyncronized step - GTOpACDSelect - 7");


            if (IsWaitingTooLongOrNoAvailableExten())
            {
                //LogoutText(4, "Start perform asyncronized step - GTOpACDSelect - 8");
                return;
            }
            else
            {
                LogoutText(4, "GTOpACDSelect: start timer(2s) on channel " + getPBXChan().index.ToString());

                _env.StartTimer(getPBXChan().index, 2000);

                if ((_hg.vmb != null && _hg.vmbDTMF.Length > 0) ||
                    (_hg.dpDTMF.Length > 0 && _hg.dpName.Length > 0))
                {
                    getPBXChan().DTMFBuf = "";
                    _env.Send_EnableDTMF(getPBXChan().index, 0, "", 0);
                    //LogoutText(4, "Start perform asyncronized step - GTOpACDSelect - 9");
                }

                //LogoutText(4, "Start perform asyncronized step - GTOpACDSelect - 10");
            }
        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);

            if (ch != getPBXChan().index)
                return;

            _env.StopTimer(getPBXChan().index);

            _hg.calls.Remove(_async_compund);
            getPBXChan().out_queue_time = DateTime.Now;
            //getEnv().m_pMainForm.RefreshListView();

            fireDone(ResultCode.OP_RESULT_ERROR, 0);
        }

        public override void On_RecvAudioPlayDone(int ch, int doneReason, string dtmfBuffer)
        {
            base.On_RecvAudioPlayDone(ch, doneReason, dtmfBuffer);

            if (ch != getPBXChan().index)
                return;

            if (timeout_act == 1)
            {
                getPBXChan().async_op_compound = new GTOpVMB(getEnv().pbx, getEnv(), getPBXChan(), _hg.vmb);
                getPBXChan().async_op_compound.start();
            }
            else if (timeout_act == 3)
            {
                SIPPBXDialPlan dp = getEnv().pbx.getDialPlanByPlanName(_hg.dpName);
                getPBXChan().dp = dp;
                getEnv().DoDialPlan(getPBXChan().index, getPBXChan(), null, null);
            }

        }

        public void DoTimeoutAction()
        {
            //want to leave a message
            LogoutText(4, "GTOpACDSelect::DoTimeoutAction");

            getEnv().StopTimer(getPBXChan().index);
            _hg.calls.Remove(_async_compund);
            getPBXChan().out_queue_time = DateTime.Now;

            if (_hg.waitTimeoutTo.Length == 0)
            {
                if (_hg.vmb != null)
                {
                    LogoutText(4, "GTOpACDSelect::DoTimeoutAction 1");

                    if (_hg.playMOH)
                    {
                        getEnv().Send_StopMusicOnHold(getPBXChan().index);
                        timeout_act = 1;
                    }
                    else
                    {
                        //getEnv().m_pMainForm.RefreshListView();

                        getPBXChan().async_op_compound = new GTOpVMB(getEnv().pbx, getEnv(), getPBXChan(), _hg.vmb);
                        getPBXChan().async_op_compound.start();
                    }
                }
                else
                {
                    LogoutText(4, "GTOpACDSelect::DoTimeoutAction 2");

                    //getEnv().m_pMainForm.RefreshListView();

                    LogoutText(1, "Voice Mail Box not defined for ACD group. Disconnect call.");

                    getEnv().DisconnectCall(getPBXChan().index, 0, "", "PBX: ACDSelect - Voice Mail Box not defined for ACD group.");
                }
            }
            else
            {
                //want to go another dialplan
                SIPPBXDialPlan dp = getEnv().pbx.getDialPlanByPlanName(_hg.dpName);

                if (dp != null)
                {
                    LogoutText(4, "GTOpACDSelect::DoTimeoutAction 3, go another dialplan");

                    if (_hg.playMOH)
                    {
                        getEnv().Send_StopMusicOnHold(getPBXChan().index);
                        timeout_act = 3;
                    }
                    else
                    {
                        //getEnv().m_pMainForm.RefreshListView();

                        getPBXChan().dp = dp;
                        getEnv().DoDialPlan(getPBXChan().index, getPBXChan(), null, null);
                    }
                }
                else
                {
                    LogoutText(4, "GTOpACDSelect::DoTimeoutAction 4");

                    //getEnv().m_pMainForm.RefreshListView();

                    LogoutText(1, "Dialplan not found for ACD group. Disconnect call.");
                    getEnv().DisconnectCall(getPBXChan().index, 0, "", "PBX: ACDSelect - Dialplan not found for ACD group.");
                }
            }
        }

        public bool IsWaitingTooLongOrNoAvailableExten()
        {
            if (availableExtension() == 0)
            {
                LogoutText(1, "IsWaitingTooLongOrNoAvailableExten: no available Extension");
                DoTimeoutAction();
                return true;
            }

            if (_hg.waitTimeout > 0)
            {
                TimeSpan tsp = DateTime.Now - getPBXChan().in_queue_time;
                if (tsp.TotalSeconds > _hg.waitTimeout)
                {
                    LogoutText(1, "IsWaitingTooLongOrNoAvailableExten: timeout");
                    DoTimeoutAction();
                    return true;
                }
            }

            LogoutText(4, "IsWaitingTooLongOrNoAvailableExten: return false");

            return false;
        }

        public override void On_Timer(int ch)
        {
            base.On_Timer(ch);

            if (ch != getPBXChan().index)
                return;

            SIPPBXExten extn = null;

            //LogoutText(4, "GTOpACDSelect.On_Timer channel " + ch.ToString());

            if (_hg.calls.Count > 0)
            {
                if (!_hg.calls.Contains(_async_compund))
                {
                    getPBXChan().out_queue_time = DateTime.Now;

                    fireDone(ResultCode.OP_RESULT_ERROR, 0);
                    LogoutText(1, "GTOpACDSelect.On_Timer channel " + ch.ToString() + "is not in call list anymore.");
                    return;
                }

                //if(_hg.calls[_hg.calls.Count-1] == _async_compund)
                if (_hg.calls[0] == _async_compund)
                {
                    //just refresh the view on the right by using top element timer
                    if (_hg.agentType == 0)
                        extn = selectExtension();
                    else
                        extn = selectAgent();

                    if (extn != null)
                    {
                        if (DistributeCallToExten(extn))
                        {
                            _hg.calls.Remove(_async_compund);
                            getPBXChan().out_queue_time = DateTime.Now;
                            getPBXChan().acd_to_extn = extn;

                            //getEnv().m_pMainForm.RefreshListView();
                            return;
                        }
                        else
                            LogoutText(4, "GTOpACDSelect.On_Timer DistributeCallToExten failed. Chan:" + ch.ToString());
                    }
                    else
                    {
                        LogoutText(4, "GTOpACDSelect.On_Timer select extn is null on channel " + ch.ToString());
                    }

                    //getEnv().m_pMainForm.RefreshListView();
                }
                else
                {
                    LogoutText(4, "GTOpACDSelect.On_Timer channel " + ch.ToString() + " is not on the top of list.");
                }
            }
            else
            {
                LogoutText(1, "GTOpACDSelect.On_Timer call list has no calls. channel " + ch.ToString() + " is not in list any more. Reset it to ACD list now.");
                getPBXChan().out_queue_time = DateTime.Now;

                fireDone(ResultCode.OP_RESULT_ERROR, 0);
                return;
            }

            if (IsWaitingTooLongOrNoAvailableExten())
                return;

            queue_pos_cnt -= 2;

            LogoutText(4, "GTOpACDSelect.On_Timer queue_pos_cnt " + queue_pos_cnt.ToString());

            if (_hg.promptQueuePosition && queue_pos_cnt <= 0 && _hg.calls.Count > 0)
            {
                queue_pos_cnt = 60;
                GTOpACD acdComp = (GTOpACD)_async_compund;
                acdComp.op = acdComp._op_moh;
                acdComp._op_moh.abort();
            }
            else
                _env.StartTimer(getPBXChan().index, 2000);
        }

        public void resumeFromPromptQueuePostion()
        {
            _env.LOG_Trace(4, "GTOpACDSelect::resumeFromPromptQueuePostion ");
            _env.StartTimer(getPBXChan().index, 2000);
            _async_compund.op = this;
        }

        public override void On_RecvDTMFKeyUp(int ch, byte keyValue, uint ticks)
        {
            base.On_RecvDTMFKeyUp(ch, keyValue, ticks);

            if (ch != getPBXChan().index)
                return;

            if ((_hg.vmb == null || _hg.vmbDTMF.Length == 0) && (_hg.dpDTMF.Length == 0 || _hg.dpName.Length == 0))
                return;

            if (_hg.calls.Count > 0)
            {
                if (!_hg.calls.Contains(_async_compund))
                {
                    getPBXChan().out_queue_time = DateTime.Now;

                    fireDone(ResultCode.OP_RESULT_ERROR, 0);
                    return;
                }
            }

            getPBXChan().DTMFBuf += Convert.ToChar(keyValue);

            if (_hg.vmbDTMF.Length> 0 && getPBXChan().DTMFBuf.Contains(_hg.vmbDTMF))
            {
                //want to leave a message
                if (_hg.vmb != null)
                {
                    if (_hg.playMOH)
                        getEnv().Send_StopMusicOnHold(getPBXChan().index);

                    getEnv().StopTimer(getPBXChan().index);
                    _hg.calls.Remove(_async_compund);
                    getPBXChan().out_queue_time = DateTime.Now;

                    getPBXChan().async_op_compound = new GTOpVMB(getEnv().pbx, getEnv(), getPBXChan(), _hg.vmb);
                    getPBXChan().async_op_compound.start();
                }
            }
            else if (_hg.dpDTMF.Length > 0 && getPBXChan().DTMFBuf.Contains(_hg.dpDTMF))
            {
                //want to go another dialplan
                SIPPBXDialPlan dp = getEnv().pbx.getDialPlanByPlanName(_hg.dpName);

                if (dp != null)
                {
                    if (_hg.playMOH)
                        getEnv().Send_StopMusicOnHold(getPBXChan().index);

                    getEnv().StopTimer(getPBXChan().index);
                    _hg.calls.Remove(_async_compund);
                    getPBXChan().out_queue_time = DateTime.Now;

                    getPBXChan().dp = dp;
                    getEnv().DoDialPlan(getPBXChan().index, getPBXChan(), null, null);
                }
            }
        }
    }
}
