using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpCallConnect : GTOpAsync 
    {
        public SIPPBXChan trans_chan;
        public SIPPBXACDHuntGroup hunt_group;

        public int transfering_chan_index;
        public SIPPBXChan transfering_wait_chan;
        public bool transfering_chan_got_idle_evt;
        public string transfering_addr;
        public string transfering_replaces_callid;
        public SIPPBXChan transfering_replaces_chan;

        //public SIPPBXExten trans_org_extn;
        //public SIPPBXExten trans_to_extn;

        public GTOpCallConnect(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, SIPPBXChan pbx_chan1, SIPPBXACDHuntGroup hg)
            : base(ac, env, pbx_chan, "")
        {
            trans_chan = pbx_chan1;
            transfering_chan_index = -1;
            transfering_wait_chan = null;
            transfering_chan_got_idle_evt = false;
            transfering_addr = "";
            transfering_replaces_callid = "";
            transfering_replaces_chan = null;

            //trans_org_extn = null;
            //trans_to_extn = null;

            hunt_group = hg;
        }

        public override void beginOp()
        {
            base.beginOp();
            LogoutText(4, "Start perform asyncronized step - GTOpCallConnect!");

            getPBXChan().link_chan = trans_chan;
            trans_chan.link_chan = getPBXChan();

            getPBXChan().link_dtmf = "";
            trans_chan.link_dtmf = "";

            if (hunt_group != null)
            {
                if (hunt_group.playMOH)
                    _env.Send_StopMusicOnHold(_pbxChan.index);
                else
                    getEnv().Send_StopAudioEx(_pbxChan.index, 1, "");
            }
            else
                getEnv().Send_StopAudioEx(_pbxChan.index, 1, "");

            bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
            bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

            if (b1 || b2)
            {
                //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
            }
            else
            {
                if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay)
                    getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                else
                    getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
            }

            //start DTMF detection for call parking
            if (getPBXChan().link_exten != null)
            {
                getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
            }
            if (trans_chan.link_exten != null)
            {
                getEnv().Send_EnableDTMF(trans_chan.index, 0, "", 0);
            }
        }

        public override void abort()
        {
            base.abort();

            if (!_bAborting && !isDone() && getPerformCount() > 0)
            {
                _bAborting = true;
                getEnv().LOG_Trace(4, "Aborting transfer in GTOpACDCallConnect::abort");
                getEnv().DisconnectCall(_pbxChan.index, 0, "", "PBX: Aborting transfer in GTOpACDCallConnect");
            }
            else if (!_bAborting && getPerformCount() == 0)
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                return;
            }
        }

        public override void On_RecvConnected(int ch)
        {
            base.On_RecvConnected(ch);

            if (transfering_chan_index >= 0 && ch == transfering_chan_index)
            {
                //transfering is done
                _pbxChan = transfering_wait_chan;
                trans_chan = getEnv().pbx.chan_list[transfering_chan_index];

                getPBXChan().link_chan = trans_chan;
                trans_chan.link_chan = getPBXChan();

                bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                if (b1 || b2)
                {
                    //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                }
                else
                {
                    if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay)
                        getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                    else
                        getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                }

                getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");

                //start DTMF detection for call parking
                if (getPBXChan().link_exten != null)
                {
                    getPBXChan().link_dtmf = "";
                    getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
                }
                if (trans_chan.link_exten != null)
                {
                    trans_chan.link_dtmf = "";
                    getEnv().Send_EnableDTMF(trans_chan.index, 0, "", 0);
                }

                transfering_chan_index = -1;
                transfering_wait_chan = null;
                transfering_chan_got_idle_evt = false;
                transfering_addr = "";
                transfering_replaces_callid = "";
                transfering_replaces_chan = null;

                //trans_org_extn = null;
                //trans_to_extn = null;
            }
        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);
            
            string logInfo;

            if (transfering_chan_index >= 0 && ch == transfering_chan_index)
            {
                if (transfering_replaces_callid.Length > 0 &&
                    transfering_replaces_chan != null)
                {

                    //if (_env.GetChannel(transfering_replaces_chan.index).ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.CONNECTED)
                    if (_env.IsChanConnected(transfering_replaces_chan.index))
                    {
                        _pbxChan = transfering_wait_chan;
                        trans_chan = transfering_replaces_chan;

                        getPBXChan().link_chan = trans_chan;
                        trans_chan.link_chan = getPBXChan();

                        bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                        bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                        if (b1 || b2)
                        {
                            //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                        }
                        else
                        {
                            if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay)
                                getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                            else
                                getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                        }

                        getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");

                        //start DTMF detection for call parking
                        if (getPBXChan().link_exten != null)
                        {
                            getPBXChan().link_dtmf = "";
                            getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
                        }
                        if (trans_chan.link_exten != null)
                        {
                            trans_chan.link_dtmf = "";
                            getEnv().Send_EnableDTMF(trans_chan.index, 0, "", 0);
                        }

                        transfering_chan_index = -1;
                        transfering_wait_chan = null;
                        transfering_chan_got_idle_evt = false;
                        transfering_addr = "";
                        transfering_replaces_callid = "";
                        transfering_replaces_chan = null;

                        //trans_org_extn = null;
                        //trans_to_extn = null;

                        return;
                    }


                    trans_chan = transfering_replaces_chan;
                    transfering_chan_index = trans_chan.index;
                    transfering_wait_chan = _pbxChan;
                    transfering_chan_got_idle_evt = true;
                    transfering_replaces_callid = "";
                    transfering_replaces_chan = null;

                    if(_env.pbx.sip_set.doRTPRelay)
                        _env.Send_RTPDuplexConnect(_pbxChan.index, trans_chan.index);
                    else
                        _env.Send_DuplexConnect(_pbxChan.index, trans_chan.index);

                    return;
                }


                SIPPBXExten extn = getEnv().pbx.getExtensionBySIPAddr(transfering_addr);
                if (extn == null)
                {
					logInfo = "GTOpCallConnect => Transfering to address " + transfering_addr + " is not an extension of local PBX! Call Transfering Failed!";
                    LogoutText(3, logInfo);
                    getEnv().DisconnectCall(transfering_wait_chan.index, 0, "", "PBX: " + logInfo);
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                    transfering_chan_index = -1;
                    transfering_wait_chan = null;
                    transfering_chan_got_idle_evt = false;
                    transfering_addr = "";
                    transfering_replaces_callid = "";
                    transfering_replaces_chan = null;

                    //trans_org_extn = null;
                    //trans_to_extn = null;
                    return;
                }

                VoiceMailBox vmb = extn.vmb;

                if (!transfering_chan_got_idle_evt)
                {
                    GTAPIASM.GTAPIChan api_chan = getEnv().GetChannel(transfering_wait_chan.index);

                    transfering_chan_got_idle_evt = true;

                    if (transfering_wait_chan.async_op_compound == null)
                    {
                        //2020-09-30 just in case it is the main channel which has GTOpConnect got transferred(Hang up)
                        getEnv().Send_StopAudioEx(transfering_wait_chan.index, 1, "");
                        transfering_wait_chan.async_op_compound = new GTOpDialExten(getEnv().pbx, getEnv(), transfering_wait_chan, null, extn);
                        transfering_wait_chan.async_op_compound.start();
                        return;
                    }


                    //2013/06/20, better choose another free channel rather than transfering_chan_index,
                    //because transfering_chan_index is last call's channel, and its call_connected is changed after calling
                    //pbx's MakeExtensionCall
                    SIPPBXChan ch_tmp = _env.pbx.SeizeChannelForOutbound(_env, transfering_chan_index);

                    if (ch_tmp != null)
                    {
                        transfering_chan_index = ch_tmp.index;
                        ch_tmp.ResetAll(transfering_wait_chan.unique_call_id, transfering_wait_chan.call_dir, getEnv().pbx, extn);
                        ch_tmp.link_exten = extn;

                        ch_tmp.link_chan = transfering_wait_chan;
                        transfering_wait_chan.link_chan = ch_tmp;
                    }
                    else
                    {
                        logInfo = "GTOpCallConnect => Transfering to address " + transfering_addr + " Failed because there is no free channel to call out!";
                        LogoutText(3, logInfo);
                        getEnv().DisconnectCall(transfering_wait_chan.index, 0, "", "PBX: " + logInfo);
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                        transfering_chan_index = -1;
                        transfering_wait_chan = null;
                        transfering_chan_got_idle_evt = false;
                        transfering_addr = "";
                        transfering_replaces_callid = "";
                        transfering_replaces_chan = null;

                        //trans_org_extn = null;
                        //trans_to_extn = null;
                        return;
                    }

                    string sCaller;
                    string sCallee;

                    sCaller = SIPPBXWinUtil.BuildCallerID(api_chan, "");

                    if (extn.IsRegistered() && ch_tmp != null)
                    {
                        sCallee = SIPPBXWinUtil.BuildCalleeID(api_chan, extn, getEnv().pbx.chan_list[transfering_wait_chan.index]);

                        //changed according to settings
                        SIPPBXWinUtil.SetChanAudioCodec(extn, _env, _env.pbx, _env.pbx.chan_list[transfering_chan_index], transfering_wait_chan);

                        if(_env.pbx.sip_set.doRTPRelay)
                            getEnv().Send_RTPDuplexConnect(transfering_wait_chan.index, transfering_chan_index);
                        else
                            getEnv().Send_DuplexConnect(transfering_wait_chan.index, transfering_chan_index);

                        getEnv().pbx.SetExtenCallingState(extn, getEnv(), 10);
                        getEnv().pbx.MakeExtensionCall(getEnv(), transfering_chan_index, sCallee, sCaller, extn);
                    }
                    else
                    {
                        if (vmb != null)
                        {
                            transfering_wait_chan.async_op_compound = new GTOpVMB(getEnv().pbx, getEnv(), transfering_wait_chan, vmb);
                            transfering_wait_chan.async_op_compound.start();
                        }
                        else
                        {
                            getEnv().DisconnectCall(transfering_wait_chan.index, 0, "", "PBX: VMB is null in On_RecvIdle of CallConnect");
                            fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                        }

                        transfering_chan_index = -1;
                        transfering_wait_chan = null;
                        transfering_chan_got_idle_evt = false;
                        transfering_addr = "";
                        transfering_replaces_callid = "";
                        transfering_replaces_chan = null;

                        //trans_org_extn = null;
                        //trans_to_extn = null;
                    }
                }
                else
                {
                    //transfering failed
                    //should check if the extension has voice mail box
                    //if it does, asking leave message.
                    if (vmb != null)
                    {
                        transfering_wait_chan.async_op_compound = new GTOpVMB(getEnv().pbx, getEnv(), transfering_wait_chan, vmb);
                        transfering_wait_chan.async_op_compound.start();
                    }
                    else
                    {
                        getEnv().DisconnectCall(transfering_wait_chan.index, 0, "", "PBX: VMB is null in On_RecvIdle of CallConnect 1");
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                    }

                    transfering_chan_index = -1;
                    transfering_wait_chan = null;
                    transfering_chan_got_idle_evt = false;
                    transfering_addr = "";
                    transfering_replaces_callid = "";
                    transfering_replaces_chan = null;

                    //trans_org_extn = null;
                    //trans_to_extn = null;
                }
                return;
            }

            if (ch == trans_chan.index)
            {
                SIPPBXParkingSlot ps = getEnv().pbx.IsPBXChanInParkingSlot(getPBXChan());
                if (ps != null)
                {
                    //in the parking slot
                    /*
                    if (ps.playMOH)
                        getEnv().Send_StartMusicOnHold(getPBXChan().index, ps.mohDir, getEnv().pbx.pbx_sys_set.bRandomPlayMOH?1:0, 0);
                     */
                    getPBXChan().async_op_compound = new GTOpCallPark(_env.pbx, _env, _pbxChan, ps);
                    getPBXChan().async_op_compound.start();
                }
                else
                {
                    if (getEnv().IsChanConnected(getPBXChan().index))
                    {
                        getEnv().DisconnectCall(getPBXChan().index, 0, "", "PBX: park slot is null in On_RecvIdle of CallConnect");
                    }
                    else
                    {
                        //getPBXChan().link_chan = null;
                        //trans_chan.link_chan = null;
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                    }
                }
            }
            else if (ch == getPBXChan().index)
            {
                SIPPBXParkingSlot ps = getEnv().pbx.IsPBXChanInParkingSlot(trans_chan);

                if (ps != null)
                {
                    //in the parking slot
                    /*
                    if (ps.playMOH)
                        getEnv().Send_StartMusicOnHold(trans_chan.index, ps.mohDir, getEnv().pbx.pbx_sys_set.bRandomPlayMOH?1:0, 0);
                     */
                    trans_chan.async_op_compound = new GTOpCallPark(_env.pbx, _env, trans_chan, ps);
                    trans_chan.async_op_compound.start();
                }
                else
                {
                    if (getEnv().IsChanConnected(trans_chan.index))
                    {
                        getEnv().DisconnectCall(trans_chan.index, 0, "", "PBX: park slot is null in On_RecvIdle of CallConnect 1");
                    }
                    else
                    {
                        //getPBXChan().link_chan = null;
                        //trans_chan.link_chan = null;
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                    }
                }
            }
        }

        public override void On_RecvDialing(int ch, string sCaller, string sCallee)
        {
            base.On_RecvDialing(ch, sCaller, sCallee);

            if (transfering_chan_index >= 0 && ch == transfering_chan_index)
            {
                getEnv().pbx.chan_list[ch].link_chan = transfering_wait_chan;
                //cannot use callee to get extension because callee may be the original callee number
                //getEnv().pbx.chan_list[ch].link_exten = getEnv().pbx.getExtensionBySIPAddr(sCallee);
                getEnv().pbx.chan_list[ch].async_op_compound = new GTOpAsyncCompound(); //a null compound, doing nothing in connected event
                transfering_wait_chan.link_chan = getEnv().pbx.chan_list[ch];
            }
        }

        public override void On_RecvDTMFKeyUp(int ch, byte keyValue, uint ticks)
        {
            base.On_RecvDTMFKeyUp(ch, keyValue, ticks);

            if (ch == trans_chan.index && trans_chan.link_exten != null)
            {
                trans_chan.link_dtmf += Convert.ToChar(keyValue);
                SIPPBXParkingSlot ps = getEnv().pbx.getParkingSlot(trans_chan.link_dtmf);
                if (ps != null)
                {
                    ps.pbxChan = getPBXChan();

                    //record parking slot in IVR keys:
                    string sCallPark = "CallPark:" + trans_chan.link_exten.UserName + "->" + ps.psDTMF + ";";
                    getPBXChan().ivrKeys += sCallPark;
                    trans_chan.ivrKeys += sCallPark;

                    getEnv().DisconnectCall(trans_chan.index, 0, "", "PBX: Call parked in CallConnect");
                    getPBXChan().link_chan = null;
                    trans_chan.link_chan = null;
                    //fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                    return;
                }

                if (getEnv().pbx.isTrunkHookFlashCode(trans_chan.link_dtmf))
                {
                    getEnv().Send_PlayDTMFStr(_pbxChan.index, "X");
                    trans_chan.link_dtmf = "";
                    return;
                }

                if (trans_chan.link_dtmf.EndsWith(getEnv().pbx.blindtrans_code) ||
                    trans_chan.link_dtmf.EndsWith(getEnv().pbx.consulttrans_code) ||
                    trans_chan.link_dtmf.EndsWith(getEnv().pbx.trunk_blindtrans_code) ||
                    trans_chan.link_dtmf.EndsWith(getEnv().pbx.trunk_consulttrans_code))
                {
                    _env.Send_DuplexDisconnect(getPBXChan().index, trans_chan.index);
                }

                SIPPBXExten extn = getEnv().pbx.isBlindTransfer(trans_chan.link_dtmf);
                if (extn != null)
                {
                    trans_chan.async_op_compound = null;
                    getPBXChan().async_op_compound = new GTOpCallTransBlind(_env.pbx, _env, _pbxChan, trans_chan, extn);
                    getPBXChan().async_op_compound.start();
                    return;
                }

                extn = getEnv().pbx.isConsultTransfer(trans_chan.link_dtmf);
                if (extn != null)
                {
                    trans_chan.async_op_compound = null;
                    getPBXChan().async_op_compound = new GTOpCallTransConsult(_env.pbx, _env, _pbxChan, trans_chan, extn);
                    getPBXChan().async_op_compound.start();
                    return;
                }

                string sTrunkNum = getEnv().pbx.isTrunkBlindTransferCode(trans_chan.link_dtmf);
                if (sTrunkNum.Length > 0)
                {
                    GTAPIASM.GTAPIChan apiChan = getEnv().GetChannel(_pbxChan.index);

                    string sRefID;
                    if (apiChan.originate)
                        sRefID = apiChan.callee_num;
                    else
                        sRefID = apiChan.caller_num;

                    string domainName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, sRefID);
                    string portName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(3, sRefID);

/* see the case that it is using "fxo" in FROM for AudioCode FXO/FXS gateway
  [2010-03-31 04:19:19] 192.168.1.181:5060 -> 0.0.0.0:5060 
680 Bytes Data:
[NOTIFY sip:GTAPISIPUA-CH0@192.168.1.198:5060 SIP/2.0
Via: SIP/2.0/UDP 192.168.1.181;branch=z9hG4bKac878944335
Max-Forwards: 70
From: "4443535" <sip:4000@fxo>;tag=1c843096086
To: <sip:4@192.168.1.198;user=phone>;tag=165056622163410893 
 */
                    if (!apiChan.originate && !SIPPBXWinUtil.IsValidIPAddress(domainName))
                    {
                        domainName = _pbxChan.sFromIP;
                        if (_pbxChan.nFromPort != 5060 && _pbxChan.nFromPort != 0)
                            portName = _pbxChan.nFromPort.ToString();
                        else
                            portName = "";
                    }

                    if (portName.Length > 0)
                        sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ":" + portName + ">";
                    else
                        sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ">";
                    getEnv().Send_Transfer(_pbxChan.index, sTrunkNum);

                    trans_chan.link_dtmf = "";
                    return;
                }

                sTrunkNum = getEnv().pbx.isTrunkConsultTransferCode(trans_chan.link_dtmf);
                if (sTrunkNum.Length > 0)
                {
                    GTOpCallTransConsultTrunk transConsultTrunk = new GTOpCallTransConsultTrunk(_env.pbx, _env, _pbxChan, trans_chan, sTrunkNum);
                    _pbxChan.async_op_compound = transConsultTrunk;
                    _pbxChan.async_op_compound.start();
                    trans_chan.link_dtmf = "";
                    trans_chan.async_op_compound = null;
                    return;
                }

                SIPPBXDialPlanWrap wrap = getEnv().pbx.isDialplanTransfer(getEnv(), trans_chan, trans_chan.link_exten.UserName, trans_chan.link_exten);
                if (wrap != null)
                {
                    LogoutText(4, "GTOpCallConnect 1: Transfer call to dialplan " + wrap.dp.planName);

                    if (wrap.trans_type == 2 && wrap.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        getPBXChan().async_op_compound = new GTOpCallTransConsultDP(_env.pbx, _env, _pbxChan, trans_chan, wrap.dp, wrap.called_id);
                        getPBXChan().async_op_compound.start();
                        return;
                    }

                    _env.Send_DuplexDisconnect(_pbxChan.index, trans_chan.index);

                    _env.DisconnectCall(trans_chan.index, 0, "", "PBX: DialplanTransfer in CallConnect");

                    _pbxChan.dp = wrap.dp;
                    if (wrap.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        GTOpOutbound outbound = new GTOpOutbound(_env.pbx, _env, _pbxChan, wrap.dp);
                        outbound._check_caller_extn = false;
                        outbound._called_id = wrap.called_id;
                        _pbxChan.async_op_compound = outbound;
                        _pbxChan.async_op_compound.start();
                    }
                    else
                    {
                        _env.DoDialPlan(_pbxChan.index, _pbxChan, null, null);
                    }

                    return;
                }

            }
            else if (ch == getPBXChan().index && getPBXChan().link_exten != null)
            {
                getPBXChan().link_dtmf += Convert.ToChar(keyValue);
                SIPPBXParkingSlot ps = getEnv().pbx.getParkingSlot(getPBXChan().link_dtmf);
                if (ps != null)
                {
                    ps.pbxChan = trans_chan;

                    //record parking slot in IVR keys:
                    string sCallPark = "CallPark:" + getPBXChan().link_exten.UserName + "->" + ps.psDTMF + ";";
                    getPBXChan().ivrKeys += sCallPark;
                    trans_chan.ivrKeys += sCallPark;

                    getEnv().DisconnectCall(getPBXChan().index, 0, "", "PBX: call parked in CallConnect");
                    getPBXChan().link_chan = null;
                    trans_chan.link_chan = null;
                    //fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                    return;
                }

                if (getEnv().pbx.isTrunkHookFlashCode(_pbxChan.link_dtmf))
                {
                    getEnv().Send_PlayDTMFStr(trans_chan.index, "X");
                    _pbxChan.link_dtmf = "";
                    return;
                }

                if (getPBXChan().link_dtmf.EndsWith(getEnv().pbx.blindtrans_code) ||
                    getPBXChan().link_dtmf.EndsWith(getEnv().pbx.consulttrans_code) ||
                    getPBXChan().link_dtmf.EndsWith(getEnv().pbx.trunk_blindtrans_code) ||
                    getPBXChan().link_dtmf.EndsWith(getEnv().pbx.trunk_consulttrans_code))
                {
                    _env.Send_DuplexDisconnect(getPBXChan().index, trans_chan.index);
                }

                SIPPBXExten extn = getEnv().pbx.isBlindTransfer(getPBXChan().link_dtmf);
                if (extn != null)
                {
                    getPBXChan().async_op_compound = null;
                    trans_chan.async_op_compound = new GTOpCallTransBlind(_env.pbx, _env, trans_chan, _pbxChan, extn);
                    trans_chan.async_op_compound.start();
                    return;
                }

                extn = getEnv().pbx.isConsultTransfer(getPBXChan().link_dtmf);
                if (extn != null)
                {
                    getPBXChan().async_op_compound = null;
                    trans_chan.async_op_compound = new GTOpCallTransConsult(_env.pbx, _env, trans_chan, _pbxChan, extn);
                    trans_chan.async_op_compound.start();
                    return;
                }

                string sTrunkNum = getEnv().pbx.isTrunkBlindTransferCode(getPBXChan().link_dtmf);
                if (sTrunkNum.Length > 0)
                {
                    GTAPIASM.GTAPIChan apiChan = getEnv().GetChannel(trans_chan.index);

                    string sRefID;
                    if (apiChan.originate)
                        sRefID = apiChan.callee_num;
                    else
                        sRefID = apiChan.caller_num;

                    string domainName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, sRefID);
                    string portName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(3, sRefID);

                    if (!apiChan.originate && !SIPPBXWinUtil.IsValidIPAddress(domainName))
                    {
                        domainName = trans_chan.sFromIP;
                        if (trans_chan.nFromPort != 5060 && trans_chan.nFromPort != 0)
                            portName = trans_chan.nFromPort.ToString();
                        else
                            portName = "";
                    }

                    if (portName.Length > 0)
                        sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ":" + portName + ">";
                    else
                        sTrunkNum = "<sip:" + sTrunkNum + "@" + domainName + ">";


                    getEnv().Send_Transfer(trans_chan.index, sTrunkNum);

                    getPBXChan().link_dtmf = "";
                    return;
                }

                sTrunkNum = getEnv().pbx.isTrunkConsultTransferCode(getPBXChan().link_dtmf);
                if (sTrunkNum.Length > 0)
                {
                    GTOpCallTransConsultTrunk transConsultTrunk = new GTOpCallTransConsultTrunk(_env.pbx, _env, trans_chan, _pbxChan, sTrunkNum);
                    trans_chan.async_op_compound = transConsultTrunk;
                    trans_chan.async_op_compound.start();
                    getPBXChan().link_dtmf = "";
                    getPBXChan().async_op_compound = null;
                    return;
                }

                SIPPBXDialPlanWrap wrap = getEnv().pbx.isDialplanTransfer(getEnv(), _pbxChan, _pbxChan.link_exten.UserName, _pbxChan.link_exten);
                if (wrap != null)
                {
                    LogoutText(4, "GTOpCallConnect 1: Transfer call to dialplan " + wrap.dp.planName);

                    if (wrap.trans_type == 2 && wrap.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        getPBXChan().async_op_compound = null;
                        trans_chan.async_op_compound = new GTOpCallTransConsultDP(_env.pbx, _env, trans_chan, _pbxChan, wrap.dp, wrap.called_id);
                        trans_chan.async_op_compound.start();
                        return;
                    }

                    _env.Send_DuplexDisconnect(_pbxChan.index, trans_chan.index);

                    _env.DisconnectCall(_pbxChan.index, 0, "", "PBX: DialplanTransfer in CallConnect");

                    trans_chan.dp = wrap.dp;
                    if (wrap.dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND)
                    {
                        GTOpOutbound outbound = new GTOpOutbound(_env.pbx, _env, trans_chan, wrap.dp);
                        outbound._check_caller_extn = false;
                        outbound._called_id = wrap.called_id;
                        trans_chan.async_op_compound = outbound;
                        trans_chan.async_op_compound.start();
                    }
                    else
                    {
                        _env.DoDialPlan(trans_chan.index, trans_chan, null, null);
                    }

                    getPBXChan().async_op_compound = null;
                    return;
                }
            }
        }

        public override void On_RecvHolding(int ch, int hold_on)
        {
            base.On_RecvHolding(ch, hold_on);

            GTAPIASM.GTAPIChan APIChan = _env.GetChannel(getPBXChan().index);
            GTAPIASM.GTAPIChan APIChanTrans = _env.GetChannel(trans_chan.index);

            if (ch == trans_chan.index && hold_on == 1 && APIChanTrans.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.BE_HOLDED)
            {
                _env.Send_Hold(getPBXChan().index);
            }
            else if (ch == trans_chan.index && hold_on == 0 && APIChan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.HOLDING)
            {
                _env.Send_Hold(getPBXChan().index);
            }
            else if (ch == getPBXChan().index && hold_on == 1 && APIChan.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.BE_HOLDED)
            {
                _env.Send_Hold(trans_chan.index);
            }
            else if (ch == getPBXChan().index && hold_on == 0 && APIChanTrans.ch_status == GTAPIASM.GTAPI_CHANNEL_STATE.HOLDING)
            {
                _env.Send_Hold(trans_chan.index);
            }

            /*
            if (ch == trans_chan.index)
            {
                if (hold_on == 1)
                {
                    _env.Send_DuplexDisconnect(getPBXChan().index, ch);
                    _env.Send_StartMusicOnHold(getPBXChan().index, _env.pbx.moh_dir, getEnv().pbx.pbx_sys_set.bRandomPlayMOH ? 1 : 0, 0);
                }
                else
                {
                    _env.Send_StopMusicOnHold(getPBXChan().index);

                    bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                    bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                    if (b1 || b2)
                    {
                        //There is already code for duplexconnect in record function.
                        //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    }
                    else
                    {
                        if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay)
                            getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                        else
                            getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    }

                }
            }
            else if (ch == getPBXChan().index)
            {
                if (hold_on == 1)
                {
                    _env.Send_DuplexDisconnect(getPBXChan().index, ch);
                    _env.Send_StartMusicOnHold(trans_chan.index, _env.pbx.moh_dir, getEnv().pbx.pbx_sys_set.bRandomPlayMOH ? 1 : 0, 0);
                }
                else
                {
                    _env.Send_StopMusicOnHold(trans_chan.index);
                    bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                    bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                    if (b1 || b2)
                    {
                        //There is already code for duplexconnect in record function.
                        //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    }
                    else
                    {
                        if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay)
                            getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                        else
                            getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                    }

                }
            }*/
        }

        public override void On_RecvTransfering(int ch, string sAddr, string sReplaceCallID, string sReplaceFromTag, string sReplaceToTag)
        {
            base.On_RecvTransfering(ch, sAddr, sReplaceCallID, sReplaceFromTag, sReplaceToTag);

            if (ch == getPBXChan().index && getPBXChan().link_exten != null)
            {
                _env.LOG_Trace(4, "GTOpCallConnect::On_RecvTransfering : " + ch.ToString() + " " + sAddr + " " + sReplaceCallID);

                //trans_to_extn = getEnv().pbx.getExtensionBySIPAddr(sAddr);

                //if (trans_to_extn != null)
                {
                    //trans_org_extn = trans_chan.link_exten;
                    transfering_chan_index = ch;
                    transfering_wait_chan = trans_chan;
                    transfering_chan_got_idle_evt = false;
                    transfering_addr = sAddr;
                    transfering_replaces_callid = sReplaceCallID;
                    transfering_replaces_chan = null;

                    if (transfering_replaces_callid.Length > 0)
                    {
                        //attended transfer
                        //there must be already another leg for replacing
                        //do duplexdisconnect first for this call
                        _env.Send_DuplexDisconnect(trans_chan.index, ch);

                        for (int i = 0; i < _env.GetChannelCount(); i++)
                        {
                            GTAPIASM.GTAPIChan api_chan = _env.GetChannel(i);
                            string sCallID = _env.GetChanCallID(i);
                            if (sCallID.Length == 0)
                                continue;

                            _env.LOG_Trace(4, "Channel-" + i.ToString() + " CallID: " + sCallID);

                            string sCallID1;
                            int at_idx = sCallID.IndexOf('@');
                            if (at_idx >= 0)
                            {
                                sCallID1 = sCallID.Substring(0, at_idx);
                            }
                            else
                            {
                                sCallID1 = sCallID;
                            }
                            _env.LOG_Trace(4, "Channel-" + i.ToString() + " CallID1: " + sCallID1);

                            if (api_chan.ch_status != GTAPIASM.GTAPI_CHANNEL_STATE.IDLE && sReplaceCallID.IndexOf(sCallID1) == 0)
                            {
                                transfering_replaces_chan = _env.pbx.chan_list[i].link_chan;

                                if (transfering_replaces_chan != null)
                                {
                                    _env.Send_DuplexDisconnect(i, transfering_replaces_chan.index);

                                    if (_env.IsChanConnected(transfering_replaces_chan.index))
                                    {
                                        /*
                                        trans_chan.transferred = true;
                                        transfering_wait_chan.transferred = true;
                                        transfering_replaces_chan.transferred = true;

                                        _pbxChan = transfering_wait_chan;
                                        trans_chan = transfering_replaces_chan;
                                        */

                                        //trans_chan.link_exten = getEnv().pbx.getExtensionBySIPAddr(transfering_addr);
                                        /* //In the following case, refer to address is <<sip:GTAPISIPUA-CH1@192.168.1.30:5060?...>, and actually it is calling into an extension. PBX already associated this channel into extension number. SO DO NOT SET
[2011-06-27 11:37:12] 192.168.1.20:5200 -> 192.168.1.30:5060 
750 Bytes Data:
[REFER sip:GTAPISIPUA-CH4@192.168.1.30:5060 SIP/2.0
From: <sip:9492005085@192.168.1.20>;tag=b0a77e8-0-1450-50022-2cf8c-5110fb25-2cf8c
To: <sip:9494598476@199.117.79.180:5060>;tag=1871619718198955447
Call-ID: vg4352l1309199786l12698855l4528lrx
CSeq: 1 REFER
Via: SIP/2.0/UDP 192.168.1.20:5200;branch=z9hG4bK-2cfba-afb716f-72cd93a4
Refer-To: <sip:GTAPISIPUA-CH1@192.168.1.30:5060?Replaces=b0b9c98-0-1450-50022-2cf96-1b05e9d4-2cf96Bto-tagD2735011501694121724Bfrom-tagDb0a7978-0-1450-50022-2cf96-2695c03a-2cf96>
Referred-By: <sip:9492005085@192.168.1.20>
Max-Forwards: 70
Supported: replaces
Contact: <sip:9492005085@192.168.1.20>
Allow: INVITE, CANCEL, ACK, BYE, OPTIONS, INFO, REFER, NOTIFY
Allow-Events: refer
Content-Length: 0
]
                                         */

                                        /*
                                        getPBXChan().link_chan = trans_chan;
                                        trans_chan.link_chan = getPBXChan();

                                        bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                                        bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                                        if (b1 || b2)
                                        {
                                            //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                                        }
                                        else
                                        {
                                            if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay)
                                                getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                                            else
                                                getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                                        }

                                        //if one of the channel is in hold status
                                        //pbx is playing moh now on it
                                        //in this case, we have to stop music.
                                        getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
                                        getEnv().Send_StopAudioEx(trans_chan.index, 1, "");


                                        //start DTMF detection for call parking
                                        if (getPBXChan().link_exten != null)
                                        {
                                            getPBXChan().link_dtmf = "";
                                            getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
                                        }
                                        if (trans_chan.link_exten != null)
                                        {
                                            trans_chan.link_dtmf = "";
                                            getEnv().Send_EnableDTMF(trans_chan.index, 0, "", 0);
                                        }
                                        */

                                        //trans_org_extn = null;
                                        //trans_to_extn = null;

                                        //here trans_chan == transfering_wait_chan 
                                        //getEnv().Send_StopAudioEx(transfering_wait_chan.index, 1, "");
                                        //GTOpCallBridge's member GTOpCallConnect.beginOp will call Send_StopAudioEx on trans_chan

                                        trans_chan.async_op_compound = new GTOpCallBridge(_env.pbx, getEnv(), trans_chan, transfering_replaces_chan);
                                        trans_chan.async_op_compound.start();

                                        getPBXChan().async_op_compound = null;
                                        getPBXChan().link_chan = null;

                                        trans_chan.link_chan = transfering_replaces_chan;
                                        transfering_replaces_chan.link_chan = trans_chan;

                                        transfering_chan_index = -1;
                                        transfering_wait_chan = null;
                                        transfering_chan_got_idle_evt = false;
                                        transfering_addr = "";
                                        transfering_replaces_callid = "";
                                        transfering_replaces_chan = null;

                                    }
                                    else
                                    {
                                        //in the case the transfering_replaces_chan is still in ringing..

                                        //here trans_chan == transfering_wait_chan 
                                        //getEnv().Send_StopAudioEx(transfering_wait_chan.index, 1, "");
                                        //GTOpCallBridge's member GTOpCallConnect.beginOp will call Send_StopAudioEx on trans_chan

                                        trans_chan.async_op_compound = new GTOpCallBridge(_env.pbx, getEnv(), trans_chan, transfering_replaces_chan);
                                        trans_chan.async_op_compound.start();

                                        getPBXChan().async_op_compound = null;
                                        getPBXChan().link_chan = null;

                                        trans_chan.link_chan = transfering_replaces_chan;
                                        transfering_replaces_chan.link_chan = trans_chan;
                                    }
                                }

                                _env.pbx.chan_list[i].link_chan = null;
                                _env.pbx.chan_list[i].async_op_compound = null;

                                _env.DisconnectCall(i, 0, "", "PBX: call transfering in CallConnect");
                                break;
                            }
                        }
                    }

                    getEnv().DisconnectCall(ch, 0, "", "PBX: call transfering in CallConnect");
                }

            }
            else if (ch == trans_chan.index /*&& trans_chan.link_exten != null*/)
            {
                _env.LOG_Trace(4, "GTOpCallConnect::On_RecvTransfering : " + ch.ToString() + " " + sAddr + " " + sReplaceCallID);

                //trans_to_extn = getEnv().pbx.getExtensionBySIPAddr(sAddr);

                //if (trans_to_extn != null)
                {
                    //trans_org_extn = trans_chan.link_exten;
                    transfering_chan_index = ch;
                    transfering_wait_chan = getPBXChan();
                    transfering_chan_got_idle_evt = false;
                    transfering_addr = sAddr;
                    transfering_replaces_callid = sReplaceCallID;
                    transfering_replaces_chan = null;

                    if (transfering_replaces_callid.Length > 0)
                    {
                        //attended transfer
                        //there must be already another leg for replacing
                        //do duplexdisconnect first for this call
                        _env.Send_DuplexDisconnect(getPBXChan().index, ch);

                        for (int i = 0; i < _env.GetChannelCount(); i++)
                        {
                            GTAPIASM.GTAPIChan api_chan = _env.GetChannel(i);
                            string sCallID = _env.GetChanCallID(i);
                            if (sCallID.Length == 0)
                                continue;

                            _env.LOG_Trace(4, "Channel-" + i.ToString() + " CallID: " + sCallID);

                            string sCallID1;
                            int at_idx = sCallID.IndexOf('@');
                            if(at_idx >= 0)
                            {
                                sCallID1 = sCallID.Substring(0, at_idx);
                            }
                            else
                            {
                                sCallID1 = sCallID;
                            }
                            _env.LOG_Trace(4, "Channel-" + i.ToString() + " CallID1: " + sCallID1);

                            if (api_chan.ch_status != GTAPIASM.GTAPI_CHANNEL_STATE.IDLE &&  sReplaceCallID.IndexOf(sCallID1) == 0)
                            {
                                transfering_replaces_chan = _env.pbx.chan_list[i].link_chan;

                                if (transfering_replaces_chan != null)
                                {
                                    _env.Send_DuplexDisconnect(i, transfering_replaces_chan.index);

                                    if (_env.IsChanConnected(transfering_replaces_chan.index))
                                    {
                                        trans_chan.transferred = true;
                                        transfering_wait_chan.transferred = true;
                                        transfering_replaces_chan.transferred = true;

                                        _pbxChan = transfering_wait_chan;
                                        trans_chan = transfering_replaces_chan;

                                        //trans_chan.link_exten = getEnv().pbx.getExtensionBySIPAddr(transfering_addr);
                                        /* //In the following case, refer to address is <<sip:GTAPISIPUA-CH1@192.168.1.30:5060?...>, and actually it is calling into an extension. PBX already associated this channel into extension number. SO DO NOT SET
[2011-06-27 11:37:12] 192.168.1.20:5200 -> 192.168.1.30:5060 
750 Bytes Data:
[REFER sip:GTAPISIPUA-CH4@192.168.1.30:5060 SIP/2.0
From: <sip:9492005085@192.168.1.20>;tag=b0a77e8-0-1450-50022-2cf8c-5110fb25-2cf8c
To: <sip:9494598476@199.117.79.180:5060>;tag=1871619718198955447
Call-ID: vg4352l1309199786l12698855l4528lrx
CSeq: 1 REFER
Via: SIP/2.0/UDP 192.168.1.20:5200;branch=z9hG4bK-2cfba-afb716f-72cd93a4
Refer-To: <sip:GTAPISIPUA-CH1@192.168.1.30:5060?Replaces=b0b9c98-0-1450-50022-2cf96-1b05e9d4-2cf96Bto-tagD2735011501694121724Bfrom-tagDb0a7978-0-1450-50022-2cf96-2695c03a-2cf96>
Referred-By: <sip:9492005085@192.168.1.20>
Max-Forwards: 70
Supported: replaces
Contact: <sip:9492005085@192.168.1.20>
Allow: INVITE, CANCEL, ACK, BYE, OPTIONS, INFO, REFER, NOTIFY
Allow-Events: refer
Content-Length: 0
]
                                         */
                                        getPBXChan().link_chan = trans_chan;
                                        trans_chan.link_chan = getPBXChan();

                                        bool b1 = getPBXChan().Record(getEnv(), trans_chan, "");
                                        bool b2 = trans_chan.Record(getEnv(), getPBXChan(), "");

                                        if (b1 || b2)
                                        {
                                            //getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                                        }
                                        else
                                        {
                                            if (getEnv().GetChanAudioCodec(getPBXChan().index) == getEnv().GetChanAudioCodec(trans_chan.index) && _env.pbx.sip_set.doRTPRelay)
                                                getEnv().Send_RTPDuplexConnect(getPBXChan().index, trans_chan.index);
                                            else
                                                getEnv().Send_DuplexConnect(getPBXChan().index, trans_chan.index);
                                        }

                                        //if one of the channel is in hold status
                                        //pbx is playing moh now on it
                                        //in this case, we have to stop music.
                                        getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
                                        getEnv().Send_StopAudioEx(trans_chan.index, 1, "");


                                        //start DTMF detection for call parking
                                        if (getPBXChan().link_exten != null)
                                        {
                                            getPBXChan().link_dtmf = "";
                                            getEnv().Send_EnableDTMF(getPBXChan().index, 0, "", 0);
                                        }
                                        if (trans_chan.link_exten != null)
                                        {
                                            trans_chan.link_dtmf = "";
                                            getEnv().Send_EnableDTMF(trans_chan.index, 0, "", 0);
                                        }

                                        transfering_chan_index = -1;
                                        transfering_wait_chan = null;
                                        transfering_chan_got_idle_evt = false;
                                        transfering_addr = "";
                                        transfering_replaces_callid = "";
                                        transfering_replaces_chan = null;

                                        //trans_org_extn = null;
                                        //trans_to_extn = null;

                                    }
                                    else
                                    {
                                        //in the case the transfering_replaces_chan is still in ringing.. 
                                        //getEnv().Send_StopAudioEx(getPBXChan().index, 1, "");
                                        //GTOpCallBridge's member GTOpCallConnect.beginOp will call Send_StopAudioEx on getPBXChan()

                                        getPBXChan().async_op_compound = new GTOpCallBridge(_env.pbx, getEnv(), getPBXChan(), transfering_replaces_chan);
                                        getPBXChan().async_op_compound.start();

                                        getPBXChan().link_chan = transfering_replaces_chan;
                                        transfering_replaces_chan.link_chan = getPBXChan();
                                    }
                                }

                                _env.pbx.chan_list[i].link_chan = null;
                                _env.pbx.chan_list[i].async_op_compound = null;

                                _env.DisconnectCall(i, 0, "", "PBX: call transfering in CallConnect");
                                break;
                            }
                        }
                    }

                    getEnv().DisconnectCall(ch, 0, "", "PBX: call transfering in CallConnect");
                }
            }
            //only deal with inbound call transfering right now

/*
            else if (ch == getPBXChan().index && getPBXChan().link_exten != null)
            {
                transfering_chan_index = ch;
                transfering_wait_chan = trans_chan;
                transfering_chan_got_idle_evt = false;
                transfering_addr = sAddr;
                getPBXChan().link_exten = null;
                getEnv().Send_HungUp(ch);
            }
 */
        }

    }

    public class GTOpAnswerCall : GTOpAsync
    {
        public GTOpAnswerCall(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan)
            : base(ac, env, pbx_chan, "")
        {
        }

        public override void beginOp()
        {
            base.beginOp();
            LogoutText(4, "Start perform asyncronized step - GTOpAnswerCall!");
            SIPPBXWinUtil.SetChanAudioCodec(_pbxChan.link_exten, _env, _env.pbx, _pbxChan, null);
            getEnv().Send_Answer(getPBXChan().index);
        }

        public override void On_RecvConnected(int ch)
        {
            base.On_RecvConnected(ch);

            if(ch == getPBXChan().index)
                fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);

            if (ch == getPBXChan().index)
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, 0);
        }
    }
}
