using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
/*
    public class GTOpCallHangup : GTOpAsync
    {
        public GTOpCallHangup(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, string dtmfStr)
            : base(ac, env, pbx_chan, dtmfStr)
        {
        }

        public override void beginOp()
        {
            base.beginOp();
            LogoutText(4, "Start perform asyncronized step - GTOpCallHangup!");
            getEnv().Send_HangUp(getPBXChan().index, 0, "");
        }

        public override void abort()
        {
            base.abort();

            if (!_bAborting && !isDone() && getPerformCount() > 0)
            {
                _bAborting = true;
                getEnv().LOG_Trace(4, "Aborting transfer in GTOpCallHangup::abort");
                getEnv().Send_HangUp(getPBXChan().index, 0, "");
            }
            else if (!_bAborting && getPerformCount() == 0)
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                return;
            }
        }

        public override void On_RecvIdle(int ch)
        {
            base.On_RecvIdle(ch);

            if (ch == getPBXChan().index)
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
            }
        }

    }
*/

    class GTOpCallTransBlind : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXChan _chan;
        public SIPPBXChan _trans_chan;
        public SIPPBXExten _to_exten;
        public GTOpCallTransfer _op_call_transfer;

        public GTOpCallTransBlind(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXChan transChan, SIPPBXExten extn)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _trans_chan = transChan;
            _to_exten = extn;
            _op_call_transfer = null;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpCallTransBlind::start()########################====>>");

            //disconnect duplex connect between original two channels
            //_env.Send_DuplexDisconnect(_chan.index, _trans_chan.index);
            //DO NOT USE above line to disconnect rtp because the following line 
            //will disconnect call and rtp.
            //also, if above line is enabled.
            //SDK will generate a On_RecvError(ch, GT_ERR_CHANNEL_INVALID)
            //which makes the original channel to fail and disconnect call.
            //IT TOOK me about ##########3 hours######### to find out why.

            //disconnect the old extension first.
            _env.DisconnectCall(_trans_chan.index, 0, "", "PBX: disconnect the old extension first in start() of OpCallTransBlind");

            //music on hold on original channel
            //_env.Send_StartMusicOnHold(_chan.index, _pbx.moh_dir, _pbx.pbx_sys_set.bRandomPlayMOH ? 1 : 0, 0);

            GTAPIASM.GTAPIChan api_chan = _env.GetChannel(_chan.index);
            SIPPBXExten extn = _to_exten;

            string caller_num = SIPPBXWinUtil.BuildCallerID(api_chan, "");
            string caller_username = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num);
            string called_num = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num); 

            if (extn != null)
            {
                if (extn.IsVirtualExten())
                {
                    //calling to a virtual extension
                    if (extn.VirtualExtenDestAddr.Contains(".") || extn.VirtualExtenDestAddr.Contains("@"))
                    {
                        //sip address
                        string sipDestAddr = extn.VirtualExtenDestAddr.Replace("*", called_num);

                        if (sipDestAddr.Contains("sip:"))
                        {
                            if (!transferCall(sipDestAddr, caller_num, extn, null))
                            {
                                //no enough idle channel for outbound
                                toVMB(extn);
                            }
                        }
                        else
                        {
                            if (!transferCall("<sip:" + sipDestAddr + ">", caller_num, extn, null))
                            {
                                //no enough idle channel for outbound
                                toVMB(extn);
                            }
                        }
                    }
                    else
                    {
                        //to see if it matchs any outbound rules
                        SIPPBXVirExtenTransferWrap wrap = _env.pbx.transferCallToVirtualExtension(_env, extn, _chan, caller_num, called_num);

                        if (wrap != null)
                        {
                            if(!transferCall(wrap.callee, wrap.caller, wrap.extn, wrap.acct))
                            {
                                toVMB(extn);
                            }
                        }
                        else
                        {
                            //cannot find right SIP account for outbound
                            toVMB(extn);
                        }

                        /*
                        SIPPBXDialPlan dp1 = _pbx.getDialPlanByCalledNum(_env, extn.VirtualExtenDestAddr, "", GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num), GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, caller_num), _pbx.getExtensionBySIPAddr(caller_num), 1);
                        if (dp1 != null)
                        {
                            SIPAccount sip_acct = _pbx.getDialPlanSIPAccount(dp1);
                            if (sip_acct != null)
                            {
                                //outbound, should take out predix digit, then use another channel to dialout
                                string destaddr = dp1.OutboundPrepend + extn.VirtualExtenDestAddr.Substring(dp1.OutboundPreStrip.Length);
                                if (extn.bAcceptOtherID && called_num.Length > 0)
                                    destaddr = called_num;
                                destaddr += "@" + sip_acct.DomainServer;
                                destaddr = "<sip:" + destaddr + ">";

                                string fromaddr = sip_acct.UserName;
                                if (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1)
                                {
                                    SIPPBXExten ext0 = _pbx.getExtensionBySIPAddr(caller_num);
                                    if (ext0 != null)
                                    {
                                        if (ext0.AlternativePhoneNumber.Length > 0)
                                        {
                                            fromaddr = ext0.AlternativePhoneNumber;
                                        }
                                        else if (sip_acct.DIDList.Count > 0)
                                        {
                                            fromaddr = sip_acct.DIDList[0];
                                            if (sip_acct.OutboundAppendExtenID)
                                            {
                                                fromaddr += ext0.UserName;
                                            }
                                        }
                                    }
                                    else
                                    {
                                        fromaddr = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num);
                                        if (fromaddr == "unknown")
                                            fromaddr = sip_acct.UserName;
                                    }
                                }

                                if (fromaddr == "")
                                {
                                    if (caller_username.Length > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                        fromaddr = caller_username;
                                    else if (sip_acct.DIDList.Count > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                        fromaddr = sip_acct.DIDList[0];
                                    else if (sip_acct.UserName.Length > 0)
                                        fromaddr = sip_acct.UserName;
                                    else
                                        fromaddr = "unknown";
                                }

                                if (sip_acct.UseLocalIPInFrom)
                                {
                                    if (_pbx.sip_set.sipAddr.Length > 0)
                                        fromaddr += "@" + _pbx.sip_set.sipAddr;
                                    else
                                        fromaddr += "@" + _env.GetMappedPublicSIPIPAddress();
                                }
                                else
                                    fromaddr += "@" + sip_acct.DomainServer;
                                fromaddr = SIPPBXWinUtil.GetCallerDisplayName(api_chan) + "<sip:" + fromaddr + ">";

                                if (!transferCall(destaddr, fromaddr, extn, sip_acct))
                                {
                                    //no enough idle channel for outbound
                                    toVMB(extn);
                                }
                            }
                            else
                            {
                                //cannot find right SIP account for outbound
                                toVMB(extn);
                            }
                        }
                        else
                        {
                            //no matched outbound dialplan
                            toVMB(extn);
                        }*/
                    }
                }
                else
                {
                    //regular extension
                    if (extn.IsRegistered() && (extn.InCalling == 0 || extn.bMultipleCalls))
                    {
                        string sCallee = SIPPBXWinUtil.BuildCalleeID(api_chan, extn, _chan);

                        if (!transferCall(sCallee, caller_num, extn, null))
                        {
                            //no enough idle channel for outbound
                            toVMB(extn);
                        }
                    }
                    else
                    {
                        //not registered yet(offline)
                        toVMB(extn);
                    }
                }
            }

        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _op_call_transfer)
            {
                if (_env.IsChanConnected(_chan.index))
                {
                    if (_pbx.IsPBXChanInParkingSlot(_chan) == null)
                    {
                        if (!_op_call_transfer.trans_succeed)
                        {
                            if (_to_exten != null)
                            {
                                if (_op_call_transfer.getHwCode() == 1 && _op_call_transfer.isAborting())
                                {
                                    //ring timeout or no answer
                                    toVMB(_to_exten);
                                }
                                else
                                {
                                    //busy, or other cases unreachable
                                    toVMB(_to_exten);
                                }
                            }
                            else
                            {
                                //shouldn't reach here
                            }
                        }
                        else
                        {
                            _env.DisconnectCall(_chan.index, 0, "", "PBX: call succeed in done() of OpCallTransBlind");
                        }
                    }
                }
                else
                {
                    if (!_op_call_transfer.trans_succeed)
                    {
                        if (_to_exten != null)
                        {
                            if (_op_call_transfer.getHwCode() == 1 && _op_call_transfer.isAborting())
                            {
                                //ring timeout or no answer
                                toVMB(_to_exten);
                            }
                            else
                            {
                                //busy, or other cases unreachable
                                toVMB(_to_exten);
                            }
                        }
                        else
                        {
                            //shouldn't reach here
                        }
                    }
                    else
                    {
                        _env.DisconnectCall(_chan.index, _op_call_transfer.disc_code, _op_call_transfer.disc_desc, "PBX: call succeed in done() of OpCallTransBlind 1");
                    }
                }
            }
        }


        public bool transferCall(string callee, string caller, SIPPBXExten extn, SIPAccount acct)
        {
            SIPPBXChan chan2 = _pbx.SeizeChannelForOutbound(_env);
            //GTAPIASM.GTAPIChan api_chan = null;

            if (chan2 == null)
            {
                _env.LogoutText("GTOpCallTransBlind::transferCall SeizeChannelForOutbound return null. No enough outbound channel for calling!");
                return false;
            }

            _chan.transferred = true;
            chan2.transferred = true;

            chan2.ResetAll(_chan.unique_call_id, _chan.call_dir, _pbx, extn);
            chan2.link_exten = extn;
            if (extn != null)
                if (extn.RingTimeoutSec >= 0) //as for -1, it is always forwarding. won't make call out so this state is not updated if set to 10.
                    _pbx.SetExtenCallingState(extn, _env, 10); //offered
            _op_call_transfer = new GTOpCallTransfer(this, _env, _chan, _chan.DTMFBuf, chan2, callee, caller, (extn != null) ? extn.RingTimeoutSec : 0, acct);
            _op_call_transfer.perform();

            return true;
        }

        public void toVMB(SIPPBXExten extn)
        {
            if (_env.IsChanConnected(_chan.index))
            {
                SIPPBXWinUtil.DoCallForwardingForExtension(_pbx, _env, _chan, extn);
            }
        }

    }

    class GTOpCallTransConsult : GTOpAsyncCompound
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXChan _chan;
        public SIPPBXChan _trans_chan;
        public SIPPBXChan _chan2;
        public SIPPBXExten _to_exten;
        public GTOpCallTransfer _op_call_transfer;
        public GTOpCallConnect _op_call_connect;
        public GTOpAudioPlay _audio_trans_failed;
        public GTOpAudioPlay _audio_orig_caller_failed;
        public int _call_stage;

        public GTOpCallTransConsult(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXChan transChan, SIPPBXExten extn)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _trans_chan = transChan;
            _to_exten = extn;
            _op_call_transfer = null;
            _op_call_connect = null;
            _audio_trans_failed = null;
            _audio_orig_caller_failed = null;
            _call_stage = 0;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpCallTransConsult::start()########################====>>");

            //disconnect duplex connect between original two channels
            if(_trans_chan != null)
                _env.Send_DuplexDisconnect(_chan.index, _trans_chan.index);

            //music on hold on original channel
            _env.Send_StartMusicOnHold(_chan.index, _pbx.moh_dir, _pbx.pbx_sys_set.bRandomPlayMOH ? 1 : 0, 0);

            GTAPIASM.GTAPIChan api_chan = _env.GetChannel(_chan.index);
            SIPPBXExten extn = _to_exten;

            string caller_num = SIPPBXWinUtil.BuildCallerID(api_chan, "");
            string caller_username = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num);
            string called_num = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num); 

            if (extn != null)
            {
                if (extn.IsVirtualExten())
                {
                    //calling to a virtual extension
                    if (extn.VirtualExtenDestAddr.Contains(".") || extn.VirtualExtenDestAddr.Contains("@"))
                    {
                        //sip address
                        string sipDestAddr = extn.VirtualExtenDestAddr.Replace("*", called_num);

                        if (sipDestAddr.Contains("sip:"))
                        {
                            if (!transferCall(sipDestAddr, caller_num, extn, null))
                            {
                                //no enough idle channel for outbound
                                transFailed(_chan);
                            }
                        }
                        else
                        {
                            if (!transferCall("<sip:" + sipDestAddr + ">", caller_num, extn, null))
                            {
                                //no enough idle channel for outbound
                                transFailed(_chan);
                            }
                        }
                    }
                    else
                    {
                        //to see if it matchs any outbound rules

                        SIPPBXVirExtenTransferWrap wrap = _env.pbx.transferCallToVirtualExtension(_env, extn, _chan, caller_num, called_num);

                        if (wrap != null)
                        {
                            if (!transferCall(wrap.callee, wrap.caller, wrap.extn, wrap.acct))
                            {
                                transFailed(_chan);
                            }
                        }
                        else
                        {
                            //cannot find right SIP account for outbound
                            transFailed(_chan);
                        }

                        /*
                        SIPPBXDialPlan dp1 = _pbx.getDialPlanByCalledNum(_env, extn.VirtualExtenDestAddr, "", GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num), GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, caller_num), _pbx.getExtensionBySIPAddr(caller_num), 1);
                        if (dp1 != null)
                        {
                            SIPAccount sip_acct = _pbx.getDialPlanSIPAccount(dp1);
                            if (sip_acct != null)
                            {
                                //outbound, should take out predix digit, then use another channel to dialout
                                string destaddr = dp1.OutboundPrepend + extn.VirtualExtenDestAddr.Substring(dp1.OutboundPreStrip.Length);
                                if (extn.bAcceptOtherID && called_num.Length > 0)
                                    destaddr = called_num;
                                destaddr += "@" + sip_acct.DomainServer;
                                destaddr = "<sip:" + destaddr + ">";

                                string fromaddr = sip_acct.UserName;
                                if (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1)
                                {
                                    SIPPBXExten ext0 = _pbx.getExtensionBySIPAddr(caller_num);
                                    if (ext0 != null)
                                    {
                                        if (ext0.AlternativePhoneNumber.Length > 0)
                                        {
                                            fromaddr = ext0.AlternativePhoneNumber;
                                        }
                                        else if (sip_acct.DIDList.Count > 0)
                                        {
                                            fromaddr = sip_acct.DIDList[0];
                                            if (sip_acct.OutboundAppendExtenID)
                                            {
                                                fromaddr += ext0.UserName;
                                            }
                                        }
                                    }
                                    else
                                    {
                                        fromaddr = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num);
                                        if (fromaddr == "unknown")
                                            fromaddr = sip_acct.UserName;
                                    }
                                }

                                if (fromaddr == "")
                                {
                                    if (caller_username.Length > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                        fromaddr = caller_username;
                                    else if (sip_acct.DIDList.Count > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                        fromaddr = sip_acct.DIDList[0];
                                    else if (sip_acct.UserName.Length > 0)
                                        fromaddr = sip_acct.UserName;
                                    else
                                        fromaddr = "unknown";
                                }

                                if (sip_acct.UseLocalIPInFrom)
                                {
                                    if (_pbx.sip_set.sipAddr.Length > 0)
                                        fromaddr += "@" + _pbx.sip_set.sipAddr;
                                    else
                                        fromaddr += "@" + _env.GetMappedPublicSIPIPAddress();
                                }
                                else
                                    fromaddr += "@" + sip_acct.DomainServer;
                                fromaddr = SIPPBXWinUtil.GetCallerDisplayName(api_chan) +  "<sip:" + fromaddr + ">";

                                if (!transferCall(destaddr, fromaddr, extn, sip_acct))
                                {
                                    //no enough idle channel for outbound
                                    transFailed(_chan);
                                }
                            }
                            else
                            {
                                //cannot find right SIP account for outbound
                                transFailed(_chan);
                            }

                        }
                        else
                        {
                            //no matched outbound dialplan
                            transFailed(_chan);
                        }*/
                    }
                }
                else
                {
                    //regular extension
                    if (extn.IsRegistered() && (extn.InCalling == 0 || extn.bMultipleCalls))
                    {
                        string sCallee = SIPPBXWinUtil.BuildCalleeID(api_chan, extn, _chan);

                        if (!transferCall(sCallee, caller_num, extn, null))
                        {
                            //no enough idle channel for outbound
                            transFailed(_chan);
                        }
                    }
                    else
                    {
                        //not registered yet(offline)
                        transFailed(_chan);
                    }
                }
            }

        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _op_call_transfer)
            {
                if (_env.IsChanConnected(_trans_chan.index))
                {
                    if (!_op_call_transfer.trans_succeed)
                    {
                        transFailed(_op_call_transfer.monitor_chan);
                    }
                    else
                    {
                        //the dest exten doesn't want to talk
                        if (_op_call_transfer.monitor_chan != null)
                        {
                            //_env.Send_StopAudio(_chan.index);
                            _env.Send_StopAudioEx(_chan.index, 1, "");
                            _op_call_connect = new GTOpCallConnect(this, _env, _chan, _trans_chan, null);
                            //_trans_chan.link_exten = _chan2.link_exten;
                            _op_call_connect.perform();
                        }
                        else
                        {
                            //original caller has already disconnected
                            _call_stage = 1;
                            originalCallerDisconnected(_trans_chan);
                        }
                    }
                }
                else
                {
                    if (!_op_call_transfer.trans_succeed)
                    {
                        GTAPIASM.GTAPIChan api_chan2 = _env.GetChannel(_chan2.index);
                        if (api_chan2.ch_status != GTAPIASM.GTAPI_CHANNEL_STATE.IDLE)
                        {
                            //_env.Send_StopAudio(_chan.index);
                            _env.Send_StopAudioEx(_chan.index, 1, "");
                            _op_call_connect = new GTOpCallConnect(this, _env, _chan, _chan2, null);
                            _op_call_connect.perform();
                        }
                        else
                        {
                            if (_op_call_transfer.monitor_chan != null)
                                toVMB(_to_exten);
                        }
                    }
                    else
                    {
                        //the dest extension did want to talk
                        if (_op_call_transfer.monitor_chan != null)
                        {
                            //Should I transfer original channel's ACD info to chan2?
                            if (_chan.acd_queue != null)
                            {
                                _chan.call_reached_agent = true;
                                _chan2.call_reached_agent = true;
                                _chan2.acd_queue = _chan.acd_queue;
                                _chan2.acd_cdr_saved = false;
                                _chan2.in_queue_time = _chan.in_queue_time;
                                _chan2.out_queue_time = _chan.out_queue_time;
                                _chan2.acd_to_extn = _chan.acd_to_extn;
                            }

                            //_env.Send_StopAudio(_chan.index);
                            _env.Send_StopAudioEx(_chan.index, 1, "");
                            _op_call_connect = new GTOpCallConnect(this, _env, _chan, _chan2, null);
                            _op_call_connect.perform();
                        }
                        else
                        {
                            //original caller has already disconnected
                            _call_stage = 2;
                            originalCallerDisconnected(_chan2);
                        }
                    }
                }
            }
            else if (opAsync == _audio_orig_caller_failed)
            {
                if (_call_stage == 1 && _trans_chan != null)
                {
                    if (_env.IsChanConnected(_trans_chan.index))
                    {
                        _env.DisconnectCall(_trans_chan.index, 0, "", "PBX: original caller failed in done() of OpCallTransConsult");
                    }
                }
                else if (_call_stage == 2 && _chan2 != null)
                {
                    if (_env.IsChanConnected(_chan2.index))
                    {
                        _env.DisconnectCall(_chan2.index, 0, "", "PBX: original caller failed in done() of OpCallTransConsult 1");
                    }
                }          
            }
            else if (opAsync == _audio_trans_failed)
            {
                if (_audio_trans_failed.monitor_chan != null)
                {
                    if (_env.IsChanConnected(_trans_chan.index))
                    {
                        //_env.Send_StopAudio(_chan.index);
                        _env.Send_StopAudioEx(_chan.index, 1, "");
                        _op_call_connect = new GTOpCallConnect(this, _env, _chan, _trans_chan, null);
                        //_trans_chan.link_exten = _chan2.link_exten;
                        _op_call_connect.perform();
                    }
                    else
                        toVMB(_to_exten);
                }
                else
                {
                    //original caller already disconnected
                    if (_env.IsChanConnected(_trans_chan.index))
                    {
                        _call_stage = 1;
                        originalCallerDisconnected(_trans_chan);
                    }
                    else
                    {
                        //all disconnected
                    }
                }
            }
        }


        public bool transferCall(string callee, string caller, SIPPBXExten extn, SIPAccount acct)
        {
            _chan2 = _pbx.SeizeChannelForOutbound(_env);
            //GTAPIASM.GTAPIChan api_chan = null;

            if (_chan2 == null)
            {
                _env.LogoutText("GTOpCallTransConsult::transferCall SeizeChannelForOutbound return null. No enough outbound channel for calling!");
                return false;
            }

            _chan.transferred = true;
            _chan2.transferred = true;

            _chan2.ResetAll(_chan.unique_call_id, _chan.call_dir, _pbx, extn);
            _chan2.link_exten = extn;
            if (extn != null)
                if (extn.RingTimeoutSec >= 0) //as for -1, it is always forwarding. won't make call out so this state is not updated if set to 10.
                    _pbx.SetExtenCallingState(extn, _env, 10); //offered
            _op_call_transfer = new GTOpCallTransfer(this, _env, _trans_chan, _trans_chan.DTMFBuf, _chan2, callee, caller, (extn != null) ? extn.RingTimeoutSec : 0, acct);
            _op_call_transfer.disc_trans_chan = false;
            _op_call_transfer.monitor_chan = _chan;
            _op_call_transfer.perform();

            return true;
        }

        public void originalCallerDisconnected(SIPPBXChan achan)
        {
            List<string> audio_files = new List<string>();
            audio_files.Add(_pbx.pbx_dir + "\\audio\\" + "Original-caller-has-already-disconnected.wav");
            _audio_orig_caller_failed = new GTOpAudioPlay(this, _env, achan, achan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
            _audio_orig_caller_failed.perform();
        }

        public void transFailed(SIPPBXChan monitor_chan)
        {
            List<string> audio_files = new List<string>();
            audio_files.Add(_pbx.pbx_dir + "\\audio\\" + "Call-transfer-failed.wav");
            _audio_trans_failed = new GTOpAudioPlay(this, _env, _trans_chan, _trans_chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
            _audio_trans_failed.monitor_chan = monitor_chan;
            _audio_trans_failed.perform();
        }

        public void toVMB(SIPPBXExten extn)
        {
            //_env.Send_StopAudio(_chan.index);
            _env.Send_StopAudioEx(_chan.index, 1, "");

            if (_env.IsChanConnected(_chan.index))
            {
                SIPPBXWinUtil.DoCallForwardingForExtension(_pbx, _env, _chan, extn);
            }
        }

    }

    class GTOpCallTransConsultDP : GTOpAsyncCompound
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXChan _chan;
        public SIPPBXChan _trans_chan;
        public SIPPBXChan _chan2;
        public SIPPBXDialPlan _dp;
        public string _dst_number;
        public GTOpCallTransfer _op_call_transfer;
        public GTOpCallConnect _op_call_connect;
        public GTOpAudioPlay _audio_trans_failed;
        public GTOpAudioPlay _audio_orig_caller_failed;
        public int _call_stage;

        public CallLimit _cl;

        public GTOpCallTransConsultDP(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXChan transChan, SIPPBXDialPlan dp, string dst_number)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _trans_chan = transChan;
            _dp = dp;
            _dst_number = dst_number;
            _op_call_transfer = null;
            _op_call_connect = null;
            _audio_trans_failed = null;
            _audio_orig_caller_failed = null;
            _call_stage = 0;

            _cl = null;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpCallTransConsultDP::start()########################====>>");

            //disconnect duplex connect between original two channels
            _env.Send_DuplexDisconnect(_chan.index, _trans_chan.index);

            //music on hold on original channel
            _env.Send_StartMusicOnHold(_chan.index, _pbx.moh_dir, _pbx.pbx_sys_set.bRandomPlayMOH ? 1 : 0, 0);

            GTAPIASM.GTAPIChan api_chan = _env.GetChannel(_chan.index);

            string caller_num = SIPPBXWinUtil.BuildCallerID(api_chan, "");
            string caller_username = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num);
            //string called_num = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num);
            SIPPBXDialPlan dp1 = _dp;

            SIPAccount sip_acct = _pbx.getDialPlanSIPAccount(dp1);
            if (sip_acct != null)
            {
                //outbound, should take out predix digit, then use another channel to dialout
                string destaddr = dp1.OutboundPrepend + _dst_number.Substring(dp1.OutboundPreStrip.Length);
                destaddr += "@" + sip_acct.DomainServer;
                destaddr = "<sip:" + destaddr + ">";

                string fromaddr = sip_acct.UserName;
                if (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1)
                {
                    SIPPBXExten ext0 = _pbx.getExtensionBySIPAddr(caller_num);
                    if (ext0 != null)
                    {
                        if (ext0.AlternativePhoneNumber.Length > 0)
                        {
                            fromaddr = ext0.AlternativePhoneNumber;
                        }
                        else if (sip_acct.DIDList.Count > 0)
                        {
                            fromaddr = sip_acct.DIDList[0];
                            if (sip_acct.OutboundAppendExtenID)
                            {
                                fromaddr += ext0.UserName;
                            }
                        }
                    }
                    else
                    {
                        fromaddr = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, caller_num);
                        if (fromaddr == "unknown")
                            fromaddr = sip_acct.UserName;
                    }
                }

                if (fromaddr == "")
                {
                    if (caller_username.Length > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                        fromaddr = caller_username;
                    else if (sip_acct.DIDList.Count > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                        fromaddr = sip_acct.DIDList[0];
                    else if (sip_acct.UserName.Length > 0)
                        fromaddr = sip_acct.UserName;
                    else
                        fromaddr = "unknown";
                }

                if (sip_acct.UseLocalIPInFrom)
                {
                    if (_pbx.sip_set.sipAddr.Length > 0)
                        fromaddr += "@" + _pbx.sip_set.sipAddr;
                    else
                        fromaddr += "@" + _env.GetMappedPublicSIPIPAddress();
                }
                else
                    fromaddr += "@" + sip_acct.DomainServer;
                fromaddr = SIPPBXWinUtil.GetCallerDisplayName(api_chan) + "<sip:" + fromaddr + ">";
                
                
				//check call limit and call block
				_cl = _pbx.getCallLimit(_dp, GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, fromaddr), GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, destaddr), _chan);
				if (_cl != null)
				{
					if (_cl.Seconds <= 0)
					{
						_env.LOG_Trace(4, "GTOpCallTransConsultDP: Call is rejected because there is no enough minute left!");
						_env.LogoutText("GTOpCallTransConsultDP: Call is rejected bbecause there is no enough minute left!");
						transFailed(_chan);
						return;
					}
				}


				if (!_pbx.passCallBlackList(_env, _dp, GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, fromaddr), GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, destaddr)))
				{
					_env.LOG_Trace(4, "GTOpCallTransConsultDP: Call is rejected because it is in blacklist!");
					_env.LogoutText("GTOpCallTransConsultDP: Call is rejected bbecause it is in blacklist!");
					transFailed(_chan);
					return;
				}
                                    

                if (!transferCall(destaddr, fromaddr, null, sip_acct))
                {
                    //no enough idle channel for outbound
                    transFailed(_chan);
                }
            }

        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _op_call_transfer)
            {
                if (_env.IsChanConnected(_trans_chan.index))
                {
                    if (!_op_call_transfer.trans_succeed)
                    {
                        transFailed(_op_call_transfer.monitor_chan);
                    }
                    else
                    {
                        //the dest exten doesn't want to talk
                        if (_op_call_transfer.monitor_chan != null)
                        {
                            //_env.Send_StopAudio(_chan.index);
                            _env.Send_StopAudioEx(_chan.index, 1, "");
                            _op_call_connect = new GTOpCallConnect(this, _env, _chan, _trans_chan, null);
                            //_trans_chan.link_exten = _chan2.link_exten;
                            _op_call_connect.perform();
                        }
                        else
                        {
                            //original caller has already disconnected
                            _call_stage = 1;
                            originalCallerDisconnected(_trans_chan);
                        }
                    }
                }
                else
                {
                    if (!_op_call_transfer.trans_succeed)
                    {
                        GTAPIASM.GTAPIChan api_chan2 = _env.GetChannel(_chan2.index);
                        if (api_chan2.ch_status != GTAPIASM.GTAPI_CHANNEL_STATE.IDLE)
                        {
                            //_env.Send_StopAudio(_chan.index);
                            _env.Send_StopAudioEx(_chan.index, 1, "");
                            _op_call_connect = new GTOpCallConnect(this, _env, _chan, _chan2, null);
                            _op_call_connect.perform();
                        }
                        else
                        {
                            if (_op_call_transfer.monitor_chan != null)
                                toVMB(null);
                        }
                    }
                    else
                    {
                        //the dest extension did want to talk
                        if (_op_call_transfer.monitor_chan != null)
                        {
                            //_env.Send_StopAudio(_chan.index);
                            _env.Send_StopAudioEx(_chan.index, 1, "");
                            _op_call_connect = new GTOpCallConnect(this, _env, _chan, _chan2, null);
                            _op_call_connect.perform();
                        }
                        else
                        {
                            //original caller has already disconnected
                            _call_stage = 2;
                            originalCallerDisconnected(_chan2);
                        }
                    }
                }
            }
            else if (opAsync == _audio_orig_caller_failed)
            {
                if (_call_stage == 1 && _trans_chan != null)
                {
                    if (_env.IsChanConnected(_trans_chan.index))
                    {
                        _env.DisconnectCall(_trans_chan.index, 0, "", "PBX: original caller failed in done() of OpCallTransConsultDP");
                    }
                }
                else if (_call_stage == 2 && _chan2 != null)
                {
                    if (_env.IsChanConnected(_chan2.index))
                    {
                        _env.DisconnectCall(_chan2.index, 0, "", "PBX: original caller failed in done() of OpCallTransConsultDP 1");
                    }
                }
            }
            else if (opAsync == _audio_trans_failed)
            {
                if (_audio_trans_failed.monitor_chan != null)
                {
                    if (_env.IsChanConnected(_trans_chan.index))
                    {
                        //_env.Send_StopAudio(_chan.index);
                        _env.Send_StopAudioEx(_chan.index, 1, "");
                        _op_call_connect = new GTOpCallConnect(this, _env, _chan, _trans_chan, null);
                        //_trans_chan.link_exten = _chan2.link_exten;
                        _op_call_connect.perform();
                    }
                    else
                        toVMB(null);
                }
                else
                {
                    //original caller already disconnected
                    if (_env.IsChanConnected(_trans_chan.index))
                    {
                        _call_stage = 1;
                        originalCallerDisconnected(_trans_chan);
                    }
                    else
                    {
                        //all disconnected
                    }
                }
            }
            else if(opAsync == _op_call_connect)
            {
				if(_cl != null)
				{
					GTAPIASM.GTAPIChan api_chan = _env.GetChannel(_trans_chan.index);
                    TimeSpan tsp = DateTime.Now - api_chan.call_start_time;
                    _pbx.countCallLimit(_env, _cl, tsp);
				}			
			}
        }


        public bool transferCall(string callee, string caller, SIPPBXExten extn, SIPAccount acct)
        {
            _chan2 = _pbx.SeizeChannelForOutbound(_env);
            //GTAPIASM.GTAPIChan api_chan = null;

            if (_chan2 == null)
            {
                _env.LogoutText("GTOpCallTransConsultDP::transferCall SeizeChannelForOutbound return null. No enough outbound channel for calling!");
                return false;
            }

            _chan.transferred = true;
            _chan2.transferred = true;

            _chan2.ResetAll(_chan.unique_call_id, _chan.call_dir, _pbx, extn);
            _chan2.link_exten = extn;
            if (extn != null)
                if (extn.RingTimeoutSec >= 0) //as for -1, it is always forwarding. won't make call out so this state is not updated if set to 10.
                    _pbx.SetExtenCallingState(extn, _env, 10); //offered
            _op_call_transfer = new GTOpCallTransfer(this, _env, _trans_chan, _trans_chan.DTMFBuf, _chan2, callee, caller, (extn != null) ? extn.RingTimeoutSec : 0, acct);
            _op_call_transfer.disc_trans_chan = false;
            _op_call_transfer.monitor_chan = _chan;
            _op_call_transfer._cl = _cl;
            _op_call_transfer.perform();

            return true;
        }

        public void originalCallerDisconnected(SIPPBXChan achan)
        {
            List<string> audio_files = new List<string>();
            audio_files.Add(_pbx.pbx_dir + "\\audio\\" + "Original-caller-has-already-disconnected.wav");
            _audio_orig_caller_failed = new GTOpAudioPlay(this, _env, achan, achan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
            _audio_orig_caller_failed.perform();
        }

        public void transFailed(SIPPBXChan monitor_chan)
        {
            List<string> audio_files = new List<string>();
            audio_files.Add(_pbx.pbx_dir + "\\audio\\" + "Call-transfer-failed.wav");
            _audio_trans_failed = new GTOpAudioPlay(this, _env, _trans_chan, _trans_chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
            _audio_trans_failed.monitor_chan = monitor_chan;
            _audio_trans_failed.perform();
        }

        public void toVMB(SIPPBXExten extn)
        {
            //_env.Send_StopAudio(_chan.index);
            _env.Send_StopAudioEx(_chan.index, 1, "");

            if (_env.IsChanConnected(_chan.index))
            {
                if (extn != null)
                    SIPPBXWinUtil.DoCallForwardingForExtension(_pbx, _env, _chan, extn);
                else
                {
                    //_chan.async_op_compound = new GTOpVMB(_pbx, _env, _chan, );
                    //_chan.async_op_compound.start();
                }
            }
        }

    }

///////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////////////////////////////////
    public class GTOpCallTransConsultTrunkCallRelease : GTOpAsync
    {
        public SIPPBXChan _chan2;
        public bool pbxChanIdle;
        public bool pbxChan2Idle;

        public GTOpCallTransConsultTrunkCallRelease(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, string dtmfStr, SIPPBXChan chan2)
            : base(ac, env, pbx_chan, dtmfStr)
        {
            _chan2 = chan2;
            pbxChanIdle = false;
            pbxChan2Idle = false;
        }

        public override void beginOp()
        {
            base.beginOp();
            LogoutText(4, "Start perform asyncronized step - GTOpCallTransConsultTrunkCallRelease!");
            _env.StartTimer(_pbxChan.index, 6000);
            _env.StartTimer(_chan2.index, 6000);
        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);

            if (ch == _pbxChan.index && !pbxChanIdle)
            {
                pbxChanIdle = true;
                _env.StopTimer(ch);
                if (!pbxChan2Idle)
                {
                    _chan2.async_op_compound = _async_compund;
                }
                else
                {
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                }
            }
            else if (ch == _chan2.index && !pbxChan2Idle)
            {
                pbxChan2Idle = true;
                _env.StopTimer(ch);
                if (!pbxChanIdle)
                {
                    _pbxChan.async_op_compound = _async_compund;
                }
                else
                {
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                }
            }
        }

        public override void On_Timer(int ch)
        {
            base.On_Timer(ch);

            if (ch == _pbxChan.index && !pbxChanIdle)
            {
                _env.DisconnectCall(ch, 0, "", "PBX: On_Timer of OpCallTransTrunkCallRelease");
            }
            else if (ch == _chan2.index && !pbxChan2Idle)
            {
                _env.DisconnectCall(ch, 0, "", "PBX: On_Timer of OpCallTransTrunkCallRelease 1");
            }
        }
    }

    public class GTOpCallTransConsultTrunkCallHold : GTOpAsync
    {
        public SIPPBXChan _chan2;
        public bool pbxChanHolded;
        public bool pbxChan2Holded;

        public GTOpCallTransConsultTrunkCallHold(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, string dtmfStr, SIPPBXChan chan2)
            : base(ac, env, pbx_chan, dtmfStr)
        {
            _chan2 = chan2;
            pbxChanHolded = false;
            pbxChan2Holded = true;
        }

        public override void beginOp()
        {
            base.beginOp();
            LogoutText(4, "Start perform asyncronized step - GTOpCallTransConsultTrunkCallHold!");
            getEnv().Send_Hold(_pbxChan.index);
            //getEnv().Send_Hold(_chan2.index);
        }

        public override void abort()
        {
            base.abort();

            if (!_bAborting && !isDone() && getPerformCount() > 0)
            {
                _bAborting = true;
                getEnv().LOG_Trace(4, "Aborting transfer in GTOpCallTransConsultTrunkCallHold::abort");
                if(pbxChanHolded)
                    getEnv().Send_Hold(_pbxChan.index);
                if (pbxChan2Holded)
                    getEnv().Send_Hold(_chan2.index);
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                return;
            }
            else if (!_bAborting && getPerformCount() == 0)
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                return;
            }
        }

        public override void On_RecvHolding(int ch, int hold_on)
        {
            base.On_RecvHolding(ch, hold_on);

            if (ch == _pbxChan.index)
            {
                if (hold_on == 1)
                {
                    pbxChanHolded = true;

                    if (pbxChanHolded && pbxChan2Holded)
                    {
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                        return;
                    }
                }
                else
                {
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, 0);
                    return;
                }
            }
/*
            if (ch == _chan2.index)
            {
                if (hold_on == 1)
                {
                    pbxChan2Holded = true;
                    if (pbxChanHolded && pbxChan2Holded)
                    {
                        fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                        return;
                    }
                }
                else
                {
                }
            }
 */
        }

    }


    class GTOpCallTransConsultTrunk : GTOpAsyncCompound
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXChan _chan;
        public SIPPBXChan _trans_chan;
        public SIPPBXChan _chan2;
        public string _trunk_num;
        public GTOpCallTransfer _op_call_transfer;
        public GTOpCallConnect _op_call_connect;
        public GTOpAudioPlay _audio_trans_failed;
        public GTOpAudioPlay _audio_orig_caller_failed;
        public GTOpCallTransConsultTrunkCallHold _op_call_hold;
        public GTOpCallTransConsultTrunkCallRelease _op_call_release;
        public int _call_stage;

        public GTOpCallTransConsultTrunk(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXChan transChan, string trunkNum)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _trans_chan = transChan;
            _trunk_num = trunkNum;
            _op_call_transfer = null;
            _op_call_connect = null;
            _audio_trans_failed = null;
            _audio_orig_caller_failed = null;
            _call_stage = 0;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpCallTransConsultTrunk::start()########################====>>");

            //disconnect duplex connect between original two channels
            _env.Send_DuplexDisconnect(_chan.index, _trans_chan.index);

            //music on hold on original channel
            _env.Send_StartMusicOnHold(_chan.index, _pbx.moh_dir, _pbx.pbx_sys_set.bRandomPlayMOH ? 1 : 0, 0);

            GTAPIASM.GTAPIChan api_chan = _env.GetChannel(_chan.index);

            string refCallId;

            if (api_chan.originate)
                refCallId = api_chan.callee_num;
            else
                refCallId = api_chan.caller_num;

            string domainName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, refCallId);
            string portName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(3, refCallId);

            if (!api_chan.originate && !SIPPBXWinUtil.IsValidIPAddress(domainName))
            {
                domainName = _chan.sFromIP;
                if (_chan.nFromPort != 5060 && _chan.nFromPort != 0)
                    portName = _chan.nFromPort.ToString();
                else
                    portName = "";
            }

            string sTrunkNum = "";
            if (portName.Length > 0 && portName != "5060")
                sTrunkNum = "<sip:" + _trunk_num + "@" + domainName + ":" + portName + ">";
            else
                sTrunkNum = "<sip:" + _trunk_num + "@" + domainName + ">";

            _trunk_num = sTrunkNum;

            string fromID;
            
            if (api_chan.originate)
                fromID = api_chan.callee_num;
            else
                fromID = api_chan.caller_num;

            SIPAccount acct = _pbx.getSIPAccountByDomain(domainName);
            if (acct != null)
            {
                if (acct.UseLocalIPInFrom)
                {
                    fromID = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(0, fromID) + "<sip:" + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, fromID) + "@" + _env.GetMappedPublicSIPIPAddress();
                    if (_env.GetMappedPublicSIPIPPort() != 5060)
                    {
                        fromID += ":";
                        fromID += _env.GetMappedPublicSIPIPPort().ToString();
                    }
                    fromID += ">";
                }
            }


            if (!transferCall(sTrunkNum, fromID, null, acct))
            {
                //no enough idle channel for outbound
                transFailed(_chan);
            }

        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _op_call_transfer)
            {
                if (_env.IsChanConnected(_trans_chan.index))
                {
                    if (!_op_call_transfer.trans_succeed)
                    {
                        transFailed(_op_call_transfer.monitor_chan);
                    }
                    else
                    {
                        //the dest exten doesn't want to talk
                        if (_op_call_transfer.monitor_chan != null)
                        {
                            //_env.Send_StopAudio(_chan.index);
                            _env.Send_StopAudioEx(_chan.index, 1, "");
                            _op_call_connect = new GTOpCallConnect(this, _env, _chan, _trans_chan, null);
                            //_trans_chan.link_exten = _chan2.link_exten;
                            _op_call_connect.perform();
                        }
                        else
                        {
                            //original caller has already disconnected
                            _call_stage = 1;
                            originalCallerDisconnected(_trans_chan);
                        }
                    }
                }
                else
                {
                    if (!_op_call_transfer.trans_succeed)
                    {
                        GTAPIASM.GTAPIChan api_chan2 = _env.GetChannel(_chan2.index);
                        if (api_chan2.ch_status != GTAPIASM.GTAPI_CHANNEL_STATE.IDLE)
                        {
                            //successfully transfered
                            //_env.Send_StopAudio(_chan.index);
                            _env.Send_StopAudioEx(_chan.index, 1, "");
                            _op_call_hold = new GTOpCallTransConsultTrunkCallHold(this, _env, _chan, "", _chan2);
                            _op_call_hold.perform();
                        }
                        else
                        {
                            if (_op_call_transfer.monitor_chan != null)
                                _env.DisconnectCall(_op_call_transfer.monitor_chan.index, 0, "", "PBX: disconnect monitor channel in done() of OpCallTransConsultTrunk");
                        }
                    }
                    else
                    {
                        //the dest extension did want to talk
                        if (_op_call_transfer.monitor_chan != null)
                        {
                            //_env.Send_StopAudio(_chan.index);
                            _env.Send_StopAudioEx(_chan.index, 1, "");
                            _op_call_hold = new GTOpCallTransConsultTrunkCallHold(this, _env, _chan, "", _chan2);
                            _op_call_hold.perform();
                        }
                        else
                        {
                            //original caller has already disconnected
                            _call_stage = 2;
                            originalCallerDisconnected(_chan2);
                        }
                    }
                }
            }
            else if (opAsync == _audio_orig_caller_failed)
            {
                if (_call_stage == 1 && _trans_chan != null)
                {
                    if (_env.IsChanConnected(_trans_chan.index))
                    {
                        _env.DisconnectCall(_trans_chan.index, 0, "", "PBX: original caller failed in done() of OpCallTransConsultTrunk");
                    }
                }
                else if (_call_stage == 2 && _chan2 != null)
                {
                    if (_env.IsChanConnected(_chan2.index))
                    {
                        _env.DisconnectCall(_chan2.index, 0, "", "PBX: original caller failed in done() of OpCallTransConsultTrunk 1");
                    }
                }
            }
            else if (opAsync == _audio_trans_failed)
            {
                if (_audio_trans_failed.monitor_chan != null)
                {
                    if (_env.IsChanConnected(_trans_chan.index))
                    {
                        //_env.Send_StopAudio(_chan.index);
                        _env.Send_StopAudioEx(_chan.index, 1, "");
                        _op_call_connect = new GTOpCallConnect(this, _env, _chan, _trans_chan, null);
                        //_trans_chan.link_exten = _chan2.link_exten;
                        _op_call_connect.perform();
                    }
                    else
                    {
                        //call dropped. Disconnect caller
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: call dropped. Disconnect caller in done() of OpCallTransConsultTrunk");
                    }
                }
                else
                {
                    //original caller already disconnected
                    if (_env.IsChanConnected(_trans_chan.index))
                    {
                        _call_stage = 1;
                        originalCallerDisconnected(_trans_chan);
                    }
                    else
                    {
                        //all disconnected
                    }
                }
            }
            else if (opAsync == _op_call_hold)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    _env.Send_TransferEx(_chan.index, _trunk_num, _chan2.index);
                    _op_call_release = new GTOpCallTransConsultTrunkCallRelease(this, _env, _chan, "", _chan2);
                    _op_call_release.perform();
                }
                else
                {
                    _env.DisconnectCall(_chan.index, 0, "", "PBX: call hold failed. Disconnect 1 in done() of OpCallTransConsultTrunk");
                    _env.DisconnectCall(_chan2.index, 0, "", "PBX: call hold failed. Disconnect 2 in done() of OpCallTransConsultTrunk");
                }
            }
            else if (opAsync == _op_call_release)
            {

            }

        }


        public bool transferCall(string callee, string caller, SIPPBXExten extn, SIPAccount acct)
        {
            _chan2 = _pbx.SeizeChannelForOutbound(_env);
            //GTAPIASM.GTAPIChan api_chan = null;

            if (_chan2 == null)
            {
                _env.LogoutText("GTOpCallTransConsultTrunk::transferCall SeizeChannelForOutbound return null. No enough outbound channel for calling!");
                return false;
            }

            _chan.transferred = true;
            _chan2.transferred = true;

            _chan2.ResetAll(_chan.unique_call_id, _chan.call_dir, _pbx, extn);
            _chan2.link_exten = extn;
            if (extn != null)
                if (extn.RingTimeoutSec >= 0) //as for -1, it is always forwarding. won't make call out so this state is not updated if set to 10.
                    _pbx.SetExtenCallingState(extn, _env, 10); //offered
            _op_call_transfer = new GTOpCallTransfer(this, _env, _trans_chan, _trans_chan.DTMFBuf, _chan2, callee, caller, (extn != null) ? extn.RingTimeoutSec : 0, acct);
            _op_call_transfer.disc_trans_chan = false;
            _op_call_transfer.monitor_chan = _chan;
            _op_call_transfer.perform();

            return true;
        }

        public void originalCallerDisconnected(SIPPBXChan achan)
        {
            List<string> audio_files = new List<string>();
            audio_files.Add(_pbx.pbx_dir + "\\audio\\" + "Original-caller-has-already-disconnected.wav");
            _audio_orig_caller_failed = new GTOpAudioPlay(this, _env, achan, achan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
            _audio_orig_caller_failed.perform();
        }

        public void transFailed(SIPPBXChan monitor_chan)
        {
            List<string> audio_files = new List<string>();
            audio_files.Add(_pbx.pbx_dir + "\\audio\\" + "Call-transfer-failed.wav");
            _audio_trans_failed = new GTOpAudioPlay(this, _env, _trans_chan, _trans_chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
            _audio_trans_failed.monitor_chan = monitor_chan;
            _audio_trans_failed.perform();
        }

    }




}


