using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    public class GTOpDTMFDetect : GTOpAsync 
    {
        public List<string> dtmf_options_list;
        public int max_digits;
        public string term_str;
        public int time_out;
        public int timeout1; //when multiple choices matched in DTMF, this timeout is used to wait for next digit. in milliseconds.

        public GTOpDTMFDetect(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, string dtmfStr, List<string> d_o, int maxDigits, string termStr, int timeOut)
            :base(ac, env, pbx_chan, dtmfStr)
        {
            dtmf_options_list = d_o;
            max_digits = maxDigits;
            term_str = termStr;
            time_out = timeOut;
            timeout1 = 0;
        }

        public override void beginOp()
        {
            base.beginOp();
            LogoutText(4, "Start perform asyncronized step - GTOpDTMFDetect!");
            getEnv().Send_EnableDTMF(getPBXChan().index, max_digits, term_str, time_out);
        }

        public override void abort()
        {
            base.abort();
            if (!_bAborting && !isDone() && getPerformCount() > 0)
            {
                _bAborting = true;
                getEnv().LOG_Trace(4, "Aborting DTMF detect in GTOpDTMFDetect");
                getEnv().Send_DisableDTMF(getPBXChan().index);
            }
            
            fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
        }

        public override void On_RecvDTMFDone(int ch, int doneReason, string dtmfBuf)
        {
            base.On_RecvDTMFDone(ch, doneReason, dtmfBuf);

            if (ch != getPBXChan().index)
                return;

            switch (doneReason)
            {
                case 0: //DTMF_DONE_TIMEOUT
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_TIMEOUT, 0);
                    break;
                case 1: //DTMF_DONE_MAX_DIGITS
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 1);
                    break;
                case 2: //DTMF_DONE_DIGIT_DETECTED
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 2);
                    break;
            }
        }

        public override void On_RecvDTMFKeyUp(int ch, byte keyValue, uint ticks)
        {
            base.On_RecvDTMFKeyUp(ch, keyValue, ticks);

            if (ch != getPBXChan().index)
                return;

            getEnv().StopTimer(getPBXChan().index);

            //_dtmf += Convert.ToChar(keyValue);
            char keyChar = Convert.ToChar(keyValue);

            if (term_str.Length > 0)
            {
                if (term_str.IndexOf(keyChar) >= 0)
                {
                    //here we don't append key which is in term string
                }
                else
                    _dtmf += keyChar;
            }
            else
                _dtmf += keyChar;

            int num_of_match = 0;
            int num_of_equal = 0;

            for (int i = 0; i < dtmf_options_list.Count; i++)
            {
                if (dtmf_options_list[i].IndexOf(_dtmf) == 0)
                    num_of_match++;

                if (dtmf_options_list[i] == _dtmf)
                    num_of_equal++;
            }

            if (num_of_equal > 0)
            {
                if (num_of_match == 1)
                {
                    getEnv().LOG_Trace(4, "Aborting DTMF detect in GTOpDTMFDetect");
                    getEnv().Send_DisableDTMF(getPBXChan().index);
                    fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
                }
                else if (num_of_match > 1)
                {
                    getEnv().LOG_Trace(4, "Starting timer in GTOpDTMFDetect");
                    if(timeout1 > 0)
                        getEnv().StartTimer(getPBXChan().index, (uint)timeout1);
                }
            }

        }

        public override void On_RecvError(int ch, int errCode)
        {
            base.On_RecvError(ch, errCode);

            if (ch != getPBXChan().index)
                return;

            fireDone(GTOpAsync.ResultCode.OP_RESULT_ERROR, errCode);
        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);

            if (ch != getPBXChan().index)
                return;

            fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
        }

        public override void On_Timer(int ch)
        {
            base.On_Timer(ch);

            if (ch != getPBXChan().index)
                return;

            getEnv().LOG_Trace(4, "Stop DTMF detect in On_Timer");
            getEnv().Send_DisableDTMF(getPBXChan().index);
            fireDone(GTOpAsync.ResultCode.OP_RESULT_SUCCESS, 0);
        }

    }
}
