using System;
using System.Collections.Generic;
using System.Text;

namespace SIPPBXv3
{
    class GTOpPagingGroup : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXPagingGroup _pg;
        public SIPPBXChan _chan;
        public string _moh_dir;
        public GTOpPagingGroupDial op_paginggroup_dial;
        //public GTOpCallConnect op_call_connect;
        //public GTOpAnswerCall op_answercall;

        public GTOpPagingGroup(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXPagingGroup pg, string moh_dir)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _pg = pg;
            _moh_dir = moh_dir;
            op_paginggroup_dial = null;
            //op_call_connect = null;
            //op_answercall = null;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpPagingGroup::start()########################====>>");

            if (_pg.conf_handle == IntPtr.Zero)
            {
                _pg.conf_handle = _env.CreateConf();
            }


            op_paginggroup_dial = new GTOpPagingGroupDial(this, _env, _chan, _chan.DTMFBuf, _pg, 30);
            op_paginggroup_dial.perform();
        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == op_paginggroup_dial)
            {
                //nothing to do as all calls have been disconnected.
                //maybe need to unset conference handle to make sure all channels are cleared out from conference handle
                
            }
        }


    }


    public class GTOpPagingGroupDial : GTOpAsync
    {
        public List<SIPPBXChan> trans_chans;
        public int ring_seconds;
        //public bool trans_succeed;
        public SIPPBXPagingGroup paging_group;

        public GTOpPagingGroupDial(GTOpAsyncCompound ac, GTSIPPBXEnv env, SIPPBXChan pbx_chan, string dtmfStr, SIPPBXPagingGroup pg, int ringSeconds)
            : base(ac, env, pbx_chan, dtmfStr)
        {
            ring_seconds = ringSeconds;
            //trans_succeed = false;
            paging_group = pg;
            trans_chans = new List<SIPPBXChan>();
        }

        public override void beginOp()
        {
            base.beginOp();
            LogoutText(4, "Start perform asyncronized step - GTOpPagingGroupDial!");

            GTAPIASM.GTAPIChan chan = getEnv().GetChannel(getPBXChan().index);

            _env.SetChanInConf(paging_group.conf_handle, getPBXChan().index, 1);

            string sCaller;
            if (paging_group.bUseGroupName)
                sCaller = SIPPBXWinUtil.BuildCallerID(chan, paging_group.gpName);
            else
                sCaller = SIPPBXWinUtil.BuildCallerID(chan, "");

            SIPPBXDest dest = null;

            //if (paging_group.ringType == 0) //ring all always for paging group
            {
                for (int j = 0; j < paging_group.destList.Count; j++)
                {
                    dest = paging_group.destList[j];
                    int idx = -1;
                    for (int i = Convert.ToInt32(getEnv().GetChannelCount()) - 1; i >= 0; i--)
                    {
                        if (getEnv().GetChannel(i).Reserve())
                        {
                            idx = i;
                            break;
                        }
                    }

                    if (idx >= 0)
                    {
                        if (dest.DestType == 0) //always extension for paging group
                        {
                            SIPPBXExten extn = getEnv().pbx.getExtensionByName(dest.DestAddr);
                            if (extn != null)
                            {
                                getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, extn);
                                DialExtension(idx, extn, sCaller, dest, chan);
                            }
                            else
                            {
                                getEnv().LOG_Trace(1, "Cannot call to extension " + dest.DestAddr);
                                getEnv().GetChannel(idx).Free();
                            }
                        }
                        /*
                        else if (dest.DestType == 1) //outbound call
                        {
                            getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, null);
                            DialOutboundCall(idx, dest.DestAddr, sCaller, dest);
                        }
                        else if (dest.DestType == 2) //sip address
                        {
                            getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, null);
                            getEnv().pbx.MakeSIPAddrCall(getEnv(), idx, dest.DestAddr, sCaller);
                            getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                            getEnv().pbx.chan_list[idx].link_dest = dest;
                            trans_chans.Add(getEnv().pbx.chan_list[idx]);
                        }
                        else if (dest.DestType == 3) //ACD agent
                        {
                            SIPPBXAgent agent = getEnv().pbx.getAgentByCode(dest.DestAddr);
                            if (agent != null)
                            {
                                if (agent.AtExten != null)
                                {
                                    getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, agent.AtExten);
                                    DialExtension(idx, agent.AtExten, sCaller, dest, chan);
                                }
                                else
                                {
                                    getEnv().LOG_Trace(1, "Agent " + dest.DestAddr + " is not logged in yet! Cannot forward ringgroup call to it.");
                                    getEnv().GetChannel(idx).Free();
                                }
                            }
                            else
                            {
                                //no need to reset, because this channel is going to be free
                                getEnv().LOG_Trace(1, "Cannot call to agent " + dest.DestAddr);
                                getEnv().GetChannel(idx).Free();
                            }
                        }
                        else
                        {
                            getEnv().GetChannel(idx).Free();
                        }*/
                    }
                }
            }
            /*
            else //dial by order
            {
                ring_group.uiCurrentPos = 0;
            rg_retry:
                if (ring_group.uiCurrentPos < ring_group.destList.Count)
                {
                    dest = ring_group.destList[ring_group.uiCurrentPos++];

                    int idx = -1;
                    for (int i = Convert.ToInt32(getEnv().GetChannelCount()) - 1; i >= 0; i--)
                    {
                        if (getEnv().GetChannel(i).Reserve())
                        {
                            idx = i;
                            break;
                        }
                    }

                    if (idx >= 0)
                    {
                        if (dest.DestType == 0) //extension
                        {
                            SIPPBXExten extn = getEnv().pbx.getExtensionByName(dest.DestAddr);
                            if (extn != null)
                            {
                                getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, extn);
                                if (!DialExtension(idx, extn, sCaller, dest, chan))
                                    goto rg_retry;
                            }
                            else
                            {
                                getEnv().LOG_Trace(1, "Cannot call to extension " + dest.DestAddr);
                                getEnv().GetChannel(idx).Free();
                                goto rg_retry;
                            }
                        }
                        else if (dest.DestType == 1) //outbound call
                        {
                            getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, null);
                            if (!DialOutboundCall(idx, dest.DestAddr, sCaller, dest))
                                goto rg_retry;
                        }
                        else if (dest.DestType == 2) //sip address
                        {
                            getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, null);
                            getEnv().pbx.MakeSIPAddrCall(getEnv(), idx, dest.DestAddr, sCaller);
                            getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                            getEnv().pbx.chan_list[idx].link_dest = dest;
                            trans_chans.Add(getEnv().pbx.chan_list[idx]);
                        }
                        else if (dest.DestType == 3) //ACD agent
                        {
                            SIPPBXAgent agent = getEnv().pbx.getAgentByCode(dest.DestAddr);
                            if (agent != null)
                            {
                                if (agent.AtExten != null)
                                {
                                    getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, agent.AtExten);
                                    if (!DialExtension(idx, agent.AtExten, sCaller, dest, chan))
                                        goto rg_retry;
                                }
                                else
                                {
                                    getEnv().LOG_Trace(1, "Agent " + dest.DestAddr + " is not logged in yet! Cannot forward ringgroup call to it.");
                                    getEnv().GetChannel(idx).Free();
                                    goto rg_retry;
                                }
                            }
                            else
                            {
                                //no need to reset the channel because it is going to be free
                                getEnv().LOG_Trace(1, "Cannot call to agent " + dest.DestAddr);
                                getEnv().GetChannel(idx).Free();
                                goto rg_retry;
                            }
                        }
                        else
                        {
                            getEnv().GetChannel(idx).Free();
                            goto rg_retry;
                        }
                    }
                }
            }*/

            if (trans_chans.Count > 0)
            {
            }
            else
            {
                fireDone(ResultCode.OP_RESULT_ERROR, -1);
            }
        }

        public override void abort()
        {
            base.abort();

            if (!_bAborting && !isDone() && getPerformCount() > 0)
            {
                _bAborting = true;
                getEnv().LOG_Trace(4, "Aborting transfer in GTOpPagingGroupDial::abort");
                for (int i = 0; i < trans_chans.Count; i++)
                {
                    getEnv().DisconnectCall(trans_chans[i].index, 0, "", "PBX: aborting in paging group dial of GTOpPagingGroupDial");
                }
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                return;
            }
            else if (!_bAborting && getPerformCount() == 0)
            {
                fireDone(GTOpAsync.ResultCode.OP_RESULT_ABORTED, 0);
                return;
            }
        }

        public bool DialExtension(int idx, SIPPBXExten extn, string sCaller, SIPPBXDest dest, GTAPIASM.GTAPIChan api_chan)
        {
            string called_num = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num);

            if (extn.IsVirtualExten())
            {
                //calling to a virtual extension
                if (extn.VirtualExtenDestAddr.Contains(".") || extn.VirtualExtenDestAddr.Contains("@"))
                {
                    //sip address
                    string sipDestAddr = extn.VirtualExtenDestAddr.Replace("*", called_num);

                    if (sipDestAddr.Contains("sip:"))
                    {
                        //getEnv().SetChanCallExtraSIPHeader(idx, "Alert-Info: <http://www.notused.com>;info=alert-autoanswer;delay=0\r\nCall-Info: answer-after=0");
                        getEnv().pbx.MakeSIPAddrCall(getEnv(), idx, sipDestAddr, sCaller);
                        getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                        getEnv().pbx.chan_list[idx].link_exten = extn;
                        getEnv().pbx.chan_list[idx].link_dtmf = "";
                        getEnv().pbx.chan_list[idx].link_dest = dest;
                        trans_chans.Add(getEnv().pbx.chan_list[idx]);
                        return true;
                    }
                    else
                    {
                        //getEnv().SetChanCallExtraSIPHeader(idx, "Alert-Info: <http://www.notused.com>;info=alert-autoanswer;delay=0\r\nCall-Info: answer-after=0");
                        getEnv().pbx.MakeSIPAddrCall(getEnv(), idx, "<sip:" + sipDestAddr + ">", sCaller);
                        getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                        getEnv().pbx.chan_list[idx].link_exten = extn;
                        getEnv().pbx.chan_list[idx].link_dtmf = "";
                        getEnv().pbx.chan_list[idx].link_dest = dest;
                        trans_chans.Add(getEnv().pbx.chan_list[idx]);
                        return true;
                    }
                }
                else
                {
                    //to see if it matchs any outbound rules
                    SIPPBXDialPlan dp1 = getEnv().pbx.getDialPlanByCalledNum(_env, extn.VirtualExtenDestAddr, "", GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, sCaller), GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, sCaller), getEnv().pbx.getExtensionBySIPAddr(sCaller), 1);
                    if (dp1 != null)
                    {
                        SIPAccount sip_acct = getEnv().pbx.getDialPlanSIPAccount(dp1);
                        if (sip_acct != null)
                        {
                            //outbound, should take out predix digit, then use another channel to dialout
                            string destaddr = dp1.OutboundPrepend + extn.VirtualExtenDestAddr.Substring(dp1.OutboundPreStrip.Length);
                            if (extn.bAcceptOtherID && called_num.Length > 0)
                                destaddr = called_num;
                            destaddr += "@" + sip_acct.DomainServer;
                            destaddr = "<sip:" + destaddr + ">";

                            string fromaddr = sip_acct.UserName;
                            if (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1)
                            {
                                SIPPBXExten ext0 = getEnv().pbx.getExtensionBySIPAddr(sCaller);
                                if (ext0 != null)
                                {
                                    if (ext0.AlternativePhoneNumber.Length > 0)
                                    {
                                        fromaddr = ext0.AlternativePhoneNumber;
                                    }
                                    else if (sip_acct.DIDList.Count > 0)
                                    {
                                        fromaddr = sip_acct.DIDList[0];
                                        if (sip_acct.OutboundAppendExtenID)
                                        {
                                            fromaddr += ext0.UserName;
                                        }
                                    }
                                }
                                else
                                {
                                    fromaddr = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, sCaller);
                                    if (fromaddr == "unknown")
                                        fromaddr = sip_acct.UserName;
                                }
                            }

                            string caller_username = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, sCaller);

                            if (fromaddr == "")
                            {
                                if (caller_username.Length > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                    fromaddr = caller_username;
                                else if (sip_acct.DIDList.Count > 0 && (sip_acct.OutboundAcceptOtherID || sip_acct.SIPTrunk == 1))
                                    fromaddr = sip_acct.DIDList[0];
                                else if (sip_acct.UserName.Length > 0)
                                    fromaddr = sip_acct.UserName;
                                else
                                    fromaddr = "unknown";
                            }

                            if (sip_acct.UseLocalIPInFrom)
                            {
                                if (_env.pbx.sip_set.sipAddr.Length > 0)
                                    fromaddr += "@" + _env.pbx.sip_set.sipAddr;
                                else
                                    fromaddr += "@" + _env.GetMappedPublicSIPIPAddress();
                            }
                            else
                                fromaddr += "@" + sip_acct.DomainServer;
                            fromaddr = SIPPBXWinUtil.GetCallerDisplayName(api_chan) + "<sip:" + fromaddr + ">";

                            if (getEnv().pbx.sip_set.bForwardPAssertedIdentity)
                            {
                                string sPAssertedIdentity = getEnv().GetPAssertedIdentity(getPBXChan().index);
                                if (sPAssertedIdentity.Length > 0)
                                    getEnv().SetPAssertedIdentity(idx, sPAssertedIdentity);
                            }

                            //getEnv().SetChanCallExtraSIPHeader(idx, "Alert-Info: <http://www.notused.com>;info=alert-autoanswer;delay=0\r\nCall-Info: answer-after=0");

                            getEnv().pbx.MakeOutboundCall(getEnv(), idx, destaddr, fromaddr, sip_acct);

                            getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                            getEnv().pbx.chan_list[idx].link_exten = extn;
                            getEnv().pbx.chan_list[idx].link_dtmf = "";
                            getEnv().pbx.chan_list[idx].link_dest = dest;

                            trans_chans.Add(getEnv().pbx.chan_list[idx]);
                            return true;
                        }
                        else
                        {
                            getEnv().GetChannel(idx).Free();
                            return false;
                        }
                    }
                    else
                    {
                        getEnv().GetChannel(idx).Free();
                        return false;
                    }
                }
            }
            else
            {
                //regular extension
                if (extn.IsRegistered())
                {
                    string sCallee = SIPPBXWinUtil.BuildCalleeID(api_chan, extn, getEnv().pbx.chan_list[idx]);
                    //getEnv().SetChanCallExtraSIPHeader(idx, "Alert-Info: <http://www.notused.com>;info=alert-autoanswer;delay=0\r\nCall-Info: answer-after=0");
                    getEnv().pbx.MakeExtensionCall(getEnv(), idx, sCallee, sCaller, extn);
                    getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                    getEnv().pbx.chan_list[idx].link_exten = extn;
                    getEnv().pbx.chan_list[idx].link_dtmf = "";
                    getEnv().pbx.chan_list[idx].link_dest = dest;
                    trans_chans.Add(getEnv().pbx.chan_list[idx]);
                    return true;
                }
                else
                {
                    getEnv().GetChannel(idx).Free();
                    return false;
                }
            }
        }

        public override void On_RecvConnected(int ch)
        {
            base.On_RecvConnected(ch);

            bool found = false;
            for (int i = 0; i < trans_chans.Count; i++)
            {
                if (ch == trans_chans[i].index)
                {
                    found = true;
                    break;
                }
            }

            if (!found) return;

            getEnv().StopTimer(ch);

            getEnv().SetChanInConf(paging_group.conf_handle, ch, 2); //2 == listening(monitoring) only
        }

        public override void On_RecvIdle(int ch, int code, string desc)
        {
            base.On_RecvIdle(ch, code, desc);

            if (ch == getPBXChan().index) //caller hung up
            {
                getEnv().SetChanInConf(paging_group.conf_handle, getPBXChan().index, 0);
                for (int i = 0; i < trans_chans.Count; i++)
                {
                    getEnv().DisconnectCall(trans_chans[i].index, 0, "", "PBX: caller hung up the call in paginggroup dial of OpPagingGroupDial");
                    getEnv().SetChanInConf(paging_group.conf_handle, trans_chans[i].index, 0);
                }
                trans_chans.Clear();
                fireDone(ResultCode.OP_RESULT_SUCCESS, 0);
                return;
            }

            bool found = false;

            for (int i = 0; i < trans_chans.Count; i++)
            {
                if (ch == trans_chans[i].index)
                {
                    found = true;
                    break;
                }
            }

            if (!found) return;

            getEnv().StopTimer(ch);

            //GTAPIASM.GTAPIChan chan = getEnv().GetChannel(getPBXChan().index);

            //if (paging_group.ringType == 0) //ring all
            {
                for (int i = 0; i < trans_chans.Count; i++)
                {
                    if (trans_chans[i].index == ch)
                    {
                        getEnv().SetChanInConf(paging_group.conf_handle, trans_chans[i].index, 0);
                        trans_chans.RemoveAt(i);
                        break;
                    }
                }

                if (trans_chans.Count == 0)
                {
                    getEnv().SetChanInConf(paging_group.conf_handle, getPBXChan().index, 0);
                    fireDone(ResultCode.OP_RESULT_SUCCESS, 0);
                }
            }

        }

        public override void On_RecvError(int ch, int errCode)
        {
            base.On_RecvError(ch, errCode);

            On_RecvIdle(ch, errCode, "");
        }

        public override void On_RecvRinging(int ch)
        {
            base.On_RecvRinging(ch);

            bool found = false;

            for (int i = 0; i < trans_chans.Count; i++)
            {
                if (ch == trans_chans[i].index)
                {
                    found = true;
                    break;
                }
            }

            if (!found) return;

            SIPPBXDest dest = getEnv().pbx.chan_list[ch].link_dest;
            getEnv().StartTimer(ch, Convert.ToUInt32(dest.RingTimeout * 1000));
        }

        public override void On_Timer(int ch)
        {
            base.On_Timer(ch);


            bool found = false;

            for (int i = 0; i < trans_chans.Count; i++)
            {
                if (ch == trans_chans[i].index)
                {
                    found = true;
                    break;
                }
            }

            if (!found) return;

            GTAPIASM.GTAPIChan chan = getEnv().GetChannel(getPBXChan().index);

            string sCaller;
            if (paging_group.bUseGroupName)
                sCaller = SIPPBXWinUtil.BuildCallerID(chan, paging_group.gpName);
            else
                sCaller = SIPPBXWinUtil.BuildCallerID(chan, "");

            getEnv().DisconnectCall(ch, 0, "", "PBX: ringing timeout in paginggroup dial of OpPagingGroupDial");

            for (int i = 0; i < trans_chans.Count; i++)
            {
                if (trans_chans[i].index == ch)
                {
                    trans_chans.RemoveAt(i);
                    getEnv().SetChanInConf(paging_group.conf_handle, trans_chans[i].index, 0); 
                    break;
                }
            }

            //if (paging_group.ringType == 0) //ring all
            {
                if (trans_chans.Count == 0)
                {
                    //all calls are rejected
                    getEnv().SetChanInConf(paging_group.conf_handle, getPBXChan().index, 0);
                    fireDone(ResultCode.OP_RESULT_ERROR, 0);
                }
            }
            /*
            else //ring by order
            {
                trans_chans.Clear();

            rg_retry:
                if (ring_group.uiCurrentPos < ring_group.destList.Count)
                {
                    SIPPBXDest dest = ring_group.destList[ring_group.uiCurrentPos++];

                    int idx = -1;
                    for (int i = Convert.ToInt32(getEnv().GetChannelCount()) - 1; i >= 0; i--)
                    {
                        if (getEnv().GetChannel(i).Reserve())
                        {
                            idx = i;
                            break;
                        }
                    }

                    if (idx >= 0)
                    {
                        if (dest.DestType == 0) //extension
                        {
                            SIPPBXExten extn = getEnv().pbx.getExtensionByName(dest.DestAddr);
                            if (extn != null)
                            {
                                getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, extn);
                                if (!DialExtension(idx, extn, sCaller, dest, chan))
                                    goto rg_retry;
                            }
                            else
                            {
                                getEnv().LOG_Trace(1, "Cannot call to extension " + dest.DestAddr);
                                getEnv().GetChannel(idx).Free();
                                goto rg_retry;
                            }
                        }
                        else if (dest.DestType == 1) //outbound call
                        {
                            getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, null);
                            if (!DialOutboundCall(idx, dest.DestAddr, sCaller, dest))
                                goto rg_retry;
                        }
                        else if (dest.DestType == 2) //sip address
                        {
                            getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, null);
                            getEnv().pbx.MakeSIPAddrCall(getEnv(), idx, dest.DestAddr, sCaller);
                            getEnv().pbx.chan_list[idx].link_chan = getPBXChan();
                            getEnv().pbx.chan_list[idx].link_dest = dest;
                            trans_chans.Add(getEnv().pbx.chan_list[idx]);
                        }
                        else if (dest.DestType == 3) //ACD agent
                        {
                            SIPPBXAgent agent = getEnv().pbx.getAgentByCode(dest.DestAddr);
                            if (agent != null)
                            {
                                if (agent.AtExten != null)
                                {
                                    getEnv().pbx.chan_list[idx].ResetAll(getPBXChan().unique_call_id, getPBXChan().call_dir, getEnv().pbx, agent.AtExten);
                                    if (!DialExtension(idx, agent.AtExten, sCaller, dest, chan))
                                        goto rg_retry;
                                }
                                else
                                {
                                    getEnv().LOG_Trace(1, "Agent " + dest.DestAddr + " is not logged in yet! Cannot forward ringgroup call to it.");
                                    getEnv().GetChannel(idx).Free();
                                    goto rg_retry;
                                }
                            }
                            else
                            {
                                getEnv().LOG_Trace(1, "Cannot call to agent " + dest.DestAddr);
                                getEnv().GetChannel(idx).Free();
                                goto rg_retry;
                            }
                        }
                        else
                        {
                            getEnv().GetChannel(idx).Free();
                            goto rg_retry;
                        }
                    }
                    else
                    {
                        fireDone(ResultCode.OP_RESULT_ERROR, -1);
                    }
                }
                else
                {
                    fireDone(ResultCode.OP_RESULT_ERROR, 0);
                }

                if (trans_chans.Count == 0)
                {
                    fireDone(ResultCode.OP_RESULT_ERROR, 0);
                }
            }*/
        }
    }
}
