using System;
using System.Collections.Generic;
using System.Text;
using System.Net;
using System.Net.Mail;
using System.Net.Mime;
using System.Threading;
using System.ComponentModel;
using System.IO;

namespace SIPPBXv3
{
    class GTOpVMBAccess : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXChan _chan;
        public GTOpCallWait _call_wait;
        public GTOpAudioPlayEx _audio_password;
        public GTOpAudioPlayEx _audio_extensions;
        public GTOpAudioPlay _audio_error;	
        public SIPPBXExten _extn;
        public int _error_cnt;

        public GTOpVMBAccess(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXExten extn)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _extn = extn;
            _error_cnt = 0;
            _audio_password = null;
            _audio_extensions = null;
            _call_wait = null;
			_audio_error = null;
        }
        
        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpVMBAccess::start()########################====>>");

            if (_extn == null)
                StartExtenAudio(true);
            else
                StartPasswordAudio(true);
        }

        public void StartPasswordAudio(bool playVMBWelcome)
        {
            if (_extn.vmb == null)
            {
                StartExtenAudio(true);
                return;
            }

            List<string> a_list = new List<string>();

            a_list.Add(_pbx.pbx_dir + "\\audio\\" + "blank1.wav");

            if (playVMBWelcome)
                a_list.Add(_pbx.pbx_dir + "\\audio\\" + "Welcome-to-access-your-Voice-Mail-Box.wav");

            a_list.Add(_pbx.please_enter_password_dir);

            List<string> d_list = new List<string>();
            d_list.Add(_extn.vmb.vmbPassword);

            _chan.DTMFBuf = "";
            _audio_password = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, a_list, d_list, _extn.Password.Length, "#", 15000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
            _audio_password.perform();
        }

        public void StartExtenAudio(bool playVMBWelcome)
        {
            List<string> a_list = new List<string>();

            a_list.Add(_pbx.pbx_dir + "\\audio\\" + "blank1.wav");

            if (playVMBWelcome)
                a_list.Add(_pbx.pbx_dir + "\\audio\\" + "Welcome-to-access-your-Voice-Mail-Box.wav");
            a_list.Add(_pbx.please_enter_extension_number_dir);

            List<string> d_list = new List<string>();
            int max_digits = 0;

            for (int i = 0; i < _pbx.sip_exten.Count; i++)
            {
                d_list.Add(_pbx.sip_exten[i].UserName);
                if (_pbx.sip_exten[i].UserName.Length > max_digits)
                    max_digits = _pbx.sip_exten[i].UserName.Length;
            }

            _chan.DTMFBuf = "";
            _audio_extensions = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, a_list, d_list, max_digits, "#", 15000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
            _audio_extensions.perform();
        }
		
		public void StartErrorAudio()
		{
            List<string> a_list = new List<string>();
            a_list.Add(_pbx.pbx_dir + "\\audio\\" + "too-many-errors.wav");

            List<string> d_list = new List<string>();

            _chan.DTMFBuf = "";
            _audio_error = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, a_list, d_list, 0, "", 0);
            _audio_error.perform();		
		}	

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _audio_extensions)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    string extn_username = _audio_extensions.getDTMFStr();
                    extn_username = extn_username.Trim();
                    extn_username = extn_username.TrimEnd('#');
                    if(extn_username.Length > 0)
                        _extn = _pbx.getExtensionByName(extn_username);

                    if (_extn != null)
                    {
                        if (_extn.vmb != null)
                        {
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 0);
                            _call_wait.perform();
                        }
                        else
                        {
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 1);
                            _call_wait.perform();
                        }
                    }
                    else
                    {
                        if (++_error_cnt >= 3)
                        {
							_call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 2);
							_call_wait.perform();
                        }
                        else
                        {
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 1);
                            _call_wait.perform();
                        }
                    }
                }
                else
                {
                    if (++_error_cnt >= 3)
                    {
                        _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 2);
                        _call_wait.perform();
                    }
                    else
                    {
                        _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 1);
                        _call_wait.perform();
                    }
                }
            }
            else if (opAsync == _audio_password)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    _error_cnt = 0;
                    _chan.async_op_compound = new GTOpPlayVMB(_pbx, _env, _chan, _extn);
                    _chan.async_op_compound.start();
                }
                else
                {
                    if (++_error_cnt >= 3)
                    {
                        _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 2);
                        _call_wait.perform();
                    }
                    else
                    {
                        _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 0);
                        _call_wait.perform();
                    }
                }
            }
            else if (opAsync == _call_wait)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    if (_call_wait._Tag == 0)
                    {
                        StartPasswordAudio(false);
                    }
                    else if (_call_wait._Tag == 1)
                    {
                        StartExtenAudio(false);
                    }
                    else if (_call_wait._Tag == 2)
                    {
                        StartErrorAudio();
                    }					
                }
                else
                {
                    //call already disconnected
                }
            }
			else if(opAsync == _audio_error)
			{
				if(_env.IsChanConnected(_chan.index))
                    _env.DisconnectCall(_chan.index, 0, "", "PBX: error in OpVMBAccess");				
			}

        }

    }

    public class GTOpPlayVMB : GTOpAsyncCompound 
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXChan _chan;
        public SIPPBXExten _extn;
        public int _error_cnt;
        public GTOpAudioPlayEx _audio_main_menu;
        public List<SIPPBXExtenVoiceMail> _vms_new;
        public List<SIPPBXExtenVoiceMail> _vms_old;
        public GTOpAudioPlayEx _audio_vm;
        public GTOpAudioPlay _audio_error;
        public GTOpAudioPlay _audio_op2;
        public GTOpAudioPlay _audio_op7;
        public GTOpCallWait _call_wait;	
        public bool _b_new;
        public int _idx;

        public GTOpPlayVMB(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXExten extn)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _extn = extn;
            _error_cnt = 0;
			_call_wait = null;
            _audio_main_menu = null;
			_audio_error = null;
			_audio_op2 = null;
            _audio_op7 = null;
            _vms_new = new List<SIPPBXExtenVoiceMail>();
            _vms_old = new List<SIPPBXExtenVoiceMail>();

            _audio_vm = null;
            _b_new = true;
            _idx = 0;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpPlayVMB::start()########################====>>");

            List<SIPPBXExtenVoiceMail> _vms = SIPPBXDBUtil.GetExtensionVoiceMailFromDB(_pbx, _env, _extn, _env.pbxMain.dbPBXSet, _env.pbxMain.GetPBXLog());
            for (int i = _vms.Count - 1; i >= 0; i--)
            {
                if (_vms[i].VMStatus == 1)
                    _vms_new.Add(_vms[i]);
                else
                    _vms_old.Add(_vms[i]);
            }

            StartMainMenuAudio();
        }

        public void StartPlayVoiceMail(SIPPBXExtenVoiceMail vm, bool bNew)
        {
            string audio0 = _pbx.pbx_dir + "\\audio\\" + "blank1.wav";
            string audio1 = _pbx.pbx_dir + "\\audio\\" + "press-1-to-play-this-message-again.wav";
            string audio2;
            if(bNew)
                audio2 = _pbx.pbx_dir + "\\audio\\" + "press-2-to-save-this-message.wav";
            else
                audio2 = _pbx.pbx_dir + "\\audio\\" + "press-2-to-play-next-message.wav";
            string audio3 = _pbx.pbx_dir + "\\audio\\" + "press-7-to-discard-this-message.wav";

            List<string> a_list = new List<string>();
            SIPPBXWinUtil.AddShortDateTimeToVoiceList(_pbx, a_list, vm.tBegin);
            a_list.Add(vm.VMFile);
            a_list.Add(audio0);
            a_list.Add(audio1);
            a_list.Add(audio2);
            a_list.Add(audio3);

            List<string> d_list = new List<string>();
            d_list.Add("1");
            d_list.Add("2");
            d_list.Add("7");

            _chan.DTMFBuf = "";
            _audio_vm = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, a_list, d_list, 1, "", (vm.nDurSec + 24) * 1000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
            _audio_vm.perform();

            if (_b_new)
            {
                vm.VMStatus = 0;
                //DB operate here
                if (!SIPPBXDBUtil.UpdateVoiceMailIntoDB(_pbx, _env, _env.pbxMain.dbPBXSet, vm, _env.pbxMain.GetPBXLog()))
                    _env.pbxMain.dbPBXSet.ResetConnection();

                if (_extn != null)
                {
                    if (_extn.vmb != null)
                    {
                        SIPPBXDBUtil.UpdateExtenVoiceMailFromDB(_pbx, _env, _extn, _env.pbxMain.dbPBXSet, _env.pbxMain.GetPBXLog());
                    }
                }
            }

        }

        public void StartMainMenuAudio()
        {
            string youhave_audio = _pbx.pbx_dir + "\\audio\\" + "You-have.wav";
            string new_msgs = _pbx.pbx_dir + "\\audio\\" + "New-messages.wav";
            string old_msgs = _pbx.pbx_dir + "\\audio\\" + "Old-messages.wav";

            string for_new = _pbx.pbx_dir + "\\audio\\" + "press-1-for-new-messages.wav";
            string for_old = _pbx.pbx_dir + "\\audio\\" + "press-2-for-old-messages.wav";
            string for_prompt = _pbx.pbx_dir + "\\audio\\" + "press-9-to-manage-your-mailbox-greeting.wav";

            int newCnt = _vms_new.Count;
            int oldCnt = _vms_old.Count;

            List<string> a_list = new List<string>();
            a_list.Add(youhave_audio);
            SIPPBXWinUtil.AddNumberToVoiceList(_pbx, a_list, newCnt);
            a_list.Add(new_msgs);

            SIPPBXWinUtil.AddNumberToVoiceList(_pbx, a_list, oldCnt);
            a_list.Add(old_msgs);

            a_list.Add(for_new);
            a_list.Add(for_old);
            a_list.Add(for_prompt);
            
            List<string> d_list = new List<string>();
            d_list.Add("1");
            d_list.Add("2");
            d_list.Add("9");

            _chan.DTMFBuf = "";
            _audio_main_menu = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, a_list, d_list, 1, "", 18000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
            _audio_main_menu.perform();
        }
		
		public void StartErrorAudio()
		{
            List<string> a_list = new List<string>();
            a_list.Add(_pbx.pbx_dir + "\\audio\\" + "too-many-errors.wav");

            List<string> d_list = new List<string>();

            _chan.DTMFBuf = "";
            _audio_error = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, a_list, d_list, 0, "", 0);
            _audio_error.perform();		
		}
		
		public void StartVMOpt7Audio()
		{
            List<string> a_list = new List<string>();
            a_list.Add(_pbx.pbx_dir + "\\audio\\" + "message-has-been-discarded.wav");

            List<string> d_list = new List<string>();

            _chan.DTMFBuf = "";
            _audio_op7 = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, a_list, d_list, 0, "", 0);
            _audio_op7.perform();
		}
		
		public void StartVMOpt2Audio()
		{
            List<string> a_list = new List<string>();
			a_list.Add(_pbx.pbx_dir + "\\audio\\" + "message-has-been-saved.wav");

            List<string> d_list = new List<string>();

            _chan.DTMFBuf = "";
            _audio_op2 = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, a_list, d_list, 0, "", 0);
            _audio_op2.perform();		
		}

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _audio_main_menu)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    if (_audio_main_menu.getDTMFStr() == "1")
                    {
                        _b_new = true;
                        _idx = 0;
						_error_cnt = 0;

                        if (_vms_new.Count > 0)
						{
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 2);
                            _call_wait.perform();
                        }
                        else
                        {
                            //you have no new messages
							if (++_error_cnt >= 3)
							{
								_call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 1);
								_call_wait.perform();
							}
							else
							{
								_call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 0);
								_call_wait.perform();
							}
                        }
                    }
                    else if (_audio_main_menu.getDTMFStr() == "2")
                    {
                        _b_new = false;
                        _idx = 0;
						_error_cnt = 0;
						
                        if (_vms_old.Count > 0)
						{
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 2);
                            _call_wait.perform();
						}
                        else
                        {
                            //you have no old messages
							if (++_error_cnt >= 3)
							{
								_call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 1);
								_call_wait.perform();
							}
							else
							{
								_call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 0);
								_call_wait.perform();
							}
                        }
                    }
                    else if (_audio_main_menu.getDTMFStr() == "9")
                    {
                        //for changing mail box greeting.
                        _chan.async_op_compound = new GTOpVMBChgGreeting(_pbx, _env, _chan, _extn);
                        _chan.async_op_compound.start();
                        return;  
                    }
                }
                else
                {
                    if (_env.IsChanConnected(_chan.index))
                    {
                        if (++_error_cnt >= 3)
                        {
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 1);
                            _call_wait.perform();
                        }
                        else
                        {
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 0);
                            _call_wait.perform();
                        }
                    }
                }
            }
			else if (opAsync == _audio_vm)
			{
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    if (_audio_vm.getDTMFStr() == "1")
                    {
						//play message again
						_error_cnt = 0;
                        _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 2);
                        _call_wait.perform();
					}
                    else if (_audio_vm.getDTMFStr() == "2")
					{
						_error_cnt = 0;
						if(_b_new)
						{
                            _vms_old.Add(_vms_new[_idx]);
							_vms_new.Remove(_vms_new[_idx]);
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 4);
                            _call_wait.perform();
						}
						else
						{
							_idx++;
							if(_idx >= _vms_old.Count)
							{
								//you have reached the end of messages.
								_call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 0);
								_call_wait.perform();								
							}
							else
							{
                                _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 2);
                                _call_wait.perform();
							}
						}
					}
                    else if (_audio_vm.getDTMFStr() == "7")
					{
						_error_cnt = 0;
						if(_b_new)
						{
							//DB operate here
                            SIPPBXDBUtil.DeleteVoiceMailFromDB(_pbx, _env, _env.pbxMain.dbPBXSet, _vms_new[_idx], _env.pbxMain.GetPBXLog());
                            _vms_new.Remove(_vms_new[_idx]);
						}
						else
						{
                            //DB operate here
                            SIPPBXDBUtil.DeleteVoiceMailFromDB(_pbx, _env, _env.pbxMain.dbPBXSet, _vms_old[_idx], _env.pbxMain.GetPBXLog());
                            _vms_old.Remove(_vms_old[_idx]);
						}

                        _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 3);
                        _call_wait.perform();
					}
				}
				else
				{
                    if (_env.IsChanConnected(_chan.index))
                    {
                        _error_cnt++;
                        if (_error_cnt >= 3)
                        {
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 1);
                            _call_wait.perform();
                        }
                        else
                        {
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 2);
                            _call_wait.perform();
                        }
                    }
				}
			}
            else if (opAsync == _call_wait)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    if (_call_wait._Tag == 0)
                    {
                        StartMainMenuAudio();
                    }
					else if (_call_wait._Tag == 1)
                    {
						StartErrorAudio();
                    }
                    else if (_call_wait._Tag == 2)
                    {
                        if (_b_new)
                            StartPlayVoiceMail(_vms_new[_idx], _b_new);
                        else
                            StartPlayVoiceMail(_vms_old[_idx], _b_new);
                    }
                    else if (_call_wait._Tag == 3)
                    {
                        StartVMOpt7Audio();
                    }
                    else if (_call_wait._Tag == 4)
                    {
                        StartVMOpt2Audio();
                    }
                }
                else
                {
                    //call already disconnected
                }
            }
			else if(opAsync == _audio_error)
			{
				if(_env.IsChanConnected(_chan.index))
                    _env.DisconnectCall(_chan.index, 0, "", "PBX: error in OpVMBAccess 1");		
			}
			else if(opAsync == _audio_op2 && _b_new)
			{
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
					_idx = 0;

					if (_vms_new.Count > 0)
					{
                        _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 2);
                        _call_wait.perform();
					}
					else
					{
						_call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 0);
						_call_wait.perform();
					}
                }
                else
                {
                    if (_env.IsChanConnected(_chan.index))
                    {
                        _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 0);
                        _call_wait.perform();
                    }
                }			
			}
            else if(opAsync == _audio_op7)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    if (_b_new)
                    {
                        if (_idx >= _vms_new.Count)
                        {
                            //reached the end of list
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 0);
                            _call_wait.perform();
                        }
                        else
                        {
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 2);
                            _call_wait.perform();
                        }
                    }
                    else
                    {
                        if (_idx >= _vms_old.Count)
                        {
                            //reached the end of list
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 0);
                            _call_wait.perform();
                        }
                        else
                        {
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 2);
                            _call_wait.perform();
                        }
                    }
                }
                else
                {
                    if (_env.IsChanConnected(_chan.index))
                    {
                        //you have no new messages
                        if (++_error_cnt >= 3)
                        {
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 1);
                            _call_wait.perform();
                        }
                        else
                        {
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 0);
                            _call_wait.perform();
                        }
                    }
                }
            }

        }


    }

    public class GTOpVMBChgGreeting : GTOpAsyncCompound
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public SIPPBXChan _chan;
        public SIPPBXExten _extn;

        public int _error_cnt;
        public GTOpAudioPlay _audio_record_prompt;

        public GTOpAudioRecord _audio_record;
        public string _audio_fn;
        public string _audio_fn1;
        public DateTime _record_start_time;

        public GTOpAudioPlayEx _audio_topmenu;
        public GTOpAudioPlayEx _audio_menu;
        public GTOpCallWait _call_wait;
        public GTOpAudioPlay _audio_play_greeting;
        public GTOpAudioPlay _audio_play_cur_greeting;

        public GTOpAudioPlay _audio_saved_done;
        public GTOpAudioPlay _audio_db_error;
        public GTOpAudioPlay _audio_error;

        public GTOpVMBChgGreeting(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, SIPPBXExten extn)
            : base()
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _extn = extn;
            _error_cnt = 0;

            _audio_record_prompt = null;
            _audio_topmenu = null;
            _audio_record = null;
            _audio_fn = "";
            _audio_fn1 = "";
            _record_start_time = DateTime.Now;

            _audio_menu = null;
            _call_wait = null;
            _audio_play_greeting = null;
            _audio_play_cur_greeting = null;
            _audio_saved_done = null;
            _audio_db_error = null;

            _audio_error = null;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpVMBChgGreeting::start()########################====>>");

            StartTopMenu();
        }

        public void StartTopMenu()
        {
            string audio0 = _pbx.pbx_dir + "\\audio\\" + "blank1.wav";
            string audio1 = _pbx.pbx_dir + "\\audio\\" + "press-1-to-play-your-current-mailbox-greeting.wav";
            string audio2 = _pbx.pbx_dir + "\\audio\\" + "press-9-to-change-your-mailbox-greeting.wav";

            List<string> a_list = new List<string>();

            a_list.Add(audio0);
            a_list.Add(audio1);
            a_list.Add(audio2);

            List<string> d_list = new List<string>();
            d_list.Add("1");
            d_list.Add("9");

            _chan.DTMFBuf = "";
            _audio_topmenu = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, a_list, d_list, 1, "", 15 * 1000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
            _audio_topmenu.perform();
        }

        public void StartErrorAudio()
        {
            List<string> a_list = new List<string>();
            a_list.Add(_pbx.pbx_dir + "\\audio\\" + "too-many-errors.wav");

            List<string> d_list = new List<string>();

            _chan.DTMFBuf = "";
            _audio_error = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, a_list, d_list, 0, "", 0);
            _audio_error.perform();
        }

        public void StartRecordPrompt()
        {
            List<string> audio_files = new List<string>();
            audio_files.Add(_pbx.pbx_dir + "\\audio\\" + "Please-record-your-greeting-after-beep.wav");
            audio_files.Add(_pbx.pbx_dir + "\\audio\\" + "press-any-key-when-you-are-done.wav");
            audio_files.Add(_pbx.pbx_dir + "\\audio\\" + "ShortBeep.wav");

            _audio_record_prompt = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
            _audio_record_prompt.perform();
        }

        public void StartRecordGreeting()
        {
            _record_start_time = DateTime.Now;
            _audio_fn = _pbx.pbx_dir + "\\temp\\" + SIPPBXWinUtil.GetFNDateTime(_record_start_time) + "-" + _chan.index.ToString() + ".wav";

            if (_extn != null)
            {
                _pbx.CreateDir(_pbx.record_dir + _extn.UserName + "\\");
                _pbx.CreateDir(_pbx.record_dir + _extn.UserName + "\\" + SIPPBXWinUtil.GetDirDateTime(_record_start_time) + "\\");
                _audio_fn1 = _pbx.record_dir + _extn.UserName + "\\" + SIPPBXWinUtil.GetDirDateTime(_record_start_time) + "\\" + SIPPBXWinUtil.GetFNDateTime(_record_start_time) + "-" + _chan.index.ToString() + ".wav";
            }
            else
            {
                _pbx.CreateDir(_pbx.record_dir + SIPPBXWinUtil.GetDirDateTime(_record_start_time) + "\\");
                _audio_fn1 = _pbx.record_dir + SIPPBXWinUtil.GetDirDateTime(_record_start_time) + "\\" + SIPPBXWinUtil.GetFNDateTime(_record_start_time) + "-" + _chan.index.ToString() + ".wav";
            }
            _audio_record = new GTOpAudioRecord(this, _env, _chan, _audio_fn, 1, "", 180 * 1000);
            _audio_record.perform();
        }

        public void StartPlayMenu()
        {
            string audio0 = _pbx.pbx_dir + "\\audio\\" + "blank1.wav";
            string audio1 = _pbx.pbx_dir + "\\audio\\" + "press-1-to-play-the-greeting.wav";
            string audio2 = _pbx.pbx_dir + "\\audio\\" + "press-2-to-save-and-use-the-greeting.wav";
            string audio3 = _pbx.pbx_dir + "\\audio\\" + "press-7-to-record-your-greeting-again.wav";

            List<string> a_list = new List<string>();

            a_list.Add(audio0);
            a_list.Add(audio1);
            a_list.Add(audio2);
            a_list.Add(audio3);

            List<string> d_list = new List<string>();
            d_list.Add("1");
            d_list.Add("2");
            d_list.Add("7");

            _chan.DTMFBuf = "";
            _audio_menu = new GTOpAudioPlayEx(this, _env, _chan, _chan.DTMFBuf, a_list, d_list, 1, "", 15 * 1000, _pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey);
            _audio_menu.perform();
        }

        void PlayCurrentGreeting()
        {
            if(_extn == null)
            {
                StartTopMenu();
                return;
            }

            if(_extn.vmb == null)
            {
                StartTopMenu();
                return;
            }

            List<string> audio_files = new List<string>();

            if (_extn.vmb.vmbPrompt.Length > 0)
                audio_files.Add(_extn.vmb.vmbPrompt);
            else
                audio_files.Add(_pbx.please_leave_your_message_after_beep_dir);

            _audio_play_cur_greeting = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
            _audio_play_cur_greeting.perform();
        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _audio_play_cur_greeting)
            {
                StartTopMenu();
            }
            else if (opAsync == _audio_topmenu)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    if (_audio_topmenu.getDTMFStr() == "1")
                    {
                        PlayCurrentGreeting();
                    }
                    else if (_audio_topmenu.getDTMFStr() == "9")
                    {
                        StartRecordPrompt();
                    }
                    else
                    {
                        if (++_error_cnt >= 3)
                        {
                            StartErrorAudio();
                        }
                        else
                        {
                            StartTopMenu();
                        }

                    }
                }
                else
                {
                    if (_env.IsChanConnected(_chan.index))
                    {
                        if (++_error_cnt >= 3)
                        {
                            StartErrorAudio();
                        }
                        else
                        {
                            StartTopMenu();
                        }
                    }
                }
            }
            else if (opAsync == _audio_record_prompt)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    StartRecordGreeting();
                }
            }
            else if (opAsync == _audio_record)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    StartPlayMenu();
                }
                else
                {
                    if (_env.IsChanConnected(_chan.index))
                    {
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: recording failed in GTOpVMBChgGreeting");
                    }
                }
            }
            else if (opAsync == _audio_menu)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    if (_audio_menu.getDTMFStr() == "1")
                    {
                        List<string> audio_files = new List<string>();
                        audio_files.Add(_audio_fn);

                        _audio_play_greeting = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
                        _audio_play_greeting.perform();
                    }
                    else if (_audio_menu.getDTMFStr() == "2")
                    {
                        //need to save voicemail info into DB
                        string org_fn = _extn.vmb.vmbPrompt;
                        File.Move(_audio_fn, _audio_fn1);
                        _extn.vmb.vmbPrompt = _audio_fn1;
                        if (SIPPBXCFGDB.UpdateExtensionVMBInDB(_extn, _env.pbxMain, _pbx, _env, _env.pbxMain.dbPBXSet, _env.pbxMain.GetPBXLog()))
                        {
                            List<string> audio_files = new List<string>();
                            audio_files.Add(_pbx.pbx_dir + "\\audio\\" + "greeting-saved-successfully.wav");

                            if (org_fn != _pbx.please_leave_your_message_after_beep_dir && org_fn.Length > 0)
                            {
                                //delete the old customized greeting on disk
                                File.Decrypt(org_fn);
                            }

                            _audio_saved_done = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
                            _audio_saved_done.perform();
                        }
                        else
                        {
                            _extn.vmb.vmbPrompt = org_fn;

                            File.Delete(_audio_fn1); //DB error, can't recover, delete the file it is using for recording.

                            List<string> audio_files = new List<string>();
                            audio_files.Add(_pbx.pbx_dir + "\\audio\\" + "database-error-system-error-please-try-again-later.wav");

                            _audio_db_error = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audio_files, new List<string>(), 0, "", 0);
                            _audio_db_error.perform();
                        }
                    }
                    else if (_audio_menu.getDTMFStr() == "7")
                    {
                        File.Delete(_audio_fn);
                        StartRecordPrompt();
                    }
                }
                else
                {
                    if (_env.IsChanConnected(_chan.index))
                    {
                        if (++_error_cnt >= 3)
                        {
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 1);
                            _call_wait.perform();
                        }
                        else
                        {
                            _call_wait = new GTOpCallWait(this, _env, _chan, "", 200, 0);
                            _call_wait.perform();
                        }
                    }
                }
            }
            else if (opAsync == _audio_play_greeting)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    StartPlayMenu();
                }
                else
                {
                    if (_env.IsChanConnected(_chan.index))
                    {
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: recording failed in GTOpVMBChgGreeting 1");
                    }
                }
            }
            else if (opAsync == _audio_saved_done)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    _env.DisconnectCall(_chan.index, 0, "Greeting saved successfully");
                }
            }
            else if (opAsync == _audio_db_error)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    _env.DisconnectCall(_chan.index, 0, "Save greeting failed because of db error");
                }
            }
            else if (opAsync == _call_wait)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    if (_call_wait._Tag == 0)
                    {
                        StartPlayMenu();
                    }
                    else if (_call_wait._Tag == 1)
                    {
                        StartErrorAudio();
                    }

                }
                else
                {
                    //call already disconnected
                }
            }
            else if (opAsync == _audio_error)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    _env.DisconnectCall(_chan.index, 0, "Too many errors in greeting change");
                }
            }
        }
    }

/*
    public class GTOpVMBChgPwd : GTOpAsyncCompound
    {
        public GTSIPPBXEnv _env;
        public SIPPBX _pbx;
        public VoiceMailBox _vmb;
        public SIPPBXChan _chan;
        public GTOpAudioPlay _audio_play;
        public GTOpAudioRecord _audio_record;
        public string _audio_fn;
        public string _audio_fn1;

        public DateTime _record_start_time;

        public GTOpVMBChgPwd(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbxChan, VoiceMailBox vmb)
        {
            _pbx = pbx;
            _env = env;
            _chan = pbxChan;
            _vmb = vmb;
            _audio_play = null;
            _audio_record = null;
            _audio_fn = "";
            _audio_fn1 = "";
            mailSent = false;
            _record_start_time = DateTime.Now;
        }

        public override void start()
        {
            base.start();

            _env.LOG_Trace(4, "GTOpVMBChgPwd::start()########################====>>");

            List<string> audios = new List<string>();
            audios.Add(_pbx.please_record_your_greeting_dir);

            _audio_play = new GTOpAudioPlay(this, _env, _chan, _chan.DTMFBuf, audios, null, 0, "", 0);
            _audio_play.perform();
        }

        private static void SendCompletedCallback(object sender, AsyncCompletedEventArgs e)
        {
            // Get the unique identifier for this asynchronous operation.
            GTOpVMB _op_vmb = (GTOpVMB)e.UserState;
            string m_to = "";

            try
            {
                if (_op_vmb._vmb.vmbEmailAddr.Length > 0)
                {
                    m_to = _op_vmb._vmb.vmbEmailAddr;
                }
                else if (_op_vmb._vmb.vmbExten != null)
                {
                    m_to = _op_vmb._vmb.vmbExten.Email;
                }

                if (e.Cancelled)
                {
                    //Console.WriteLine("[{0}] Send canceled.", token);
                    _op_vmb._env.LogoutText("Voice mail sent to " + m_to + " is cancelled!");
                    _op_vmb._env.LOG_Trace(1, "Voice mail sent to " + m_to + " is cancelled!");
                }
                if (e.Error != null)
                {
                    //Console.WriteLine("[{0}] {1}", token, e.Error.ToString());
                    _op_vmb._env.LogoutText("Voice mail sent to " + m_to + " got error:" + e.Error.ToString());
                    _op_vmb._env.LOG_Trace(1, "Voice mail sent to " + m_to + " got error:" + e.Error.ToString());
                }
                else
                {
                    //Console.WriteLine("Message sent.");
                    _op_vmb._env.LogoutText("Voice mail sent to " + m_to + " succeeded!");
                    _op_vmb._env.LOG_Trace(4, "Voice mail sent to " + m_to + " succeeded!");
                }

                _op_vmb.mailSent = true;

                File.Delete(_op_vmb._audio_fn);

            }
            catch (Exception)
            {

            }
        }

        public override void done(GTOpAsync opAsync, GTOpAsync.ResultCode result, int hwStatus)
        {
            base.done(opAsync, result, hwStatus);

            if (opAsync == _audio_play)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    _record_start_time = DateTime.Now;
                    _audio_fn = _pbx.pbx_dir + "\\temp\\" + SIPPBXWinUtil.GetFNDateTime(_record_start_time) + "-" + _chan.index.ToString() + ".wav";

                    if (_vmb.vmbExten != null)
                    {
                        _pbx.CreateDir(_pbx.vmb_dir + _vmb.vmbExten.UserName + "\\");
                        _pbx.CreateDir(_pbx.vmb_dir + _vmb.vmbExten.UserName + "\\" + SIPPBXWinUtil.GetDirDateTime(_record_start_time) + "\\");
                        _audio_fn1 = _pbx.vmb_dir + _vmb.vmbExten.UserName + "\\" + SIPPBXWinUtil.GetDirDateTime(_record_start_time) + "\\greeting-" + SIPPBXWinUtil.GetFNDateTime(_record_start_time) + "-" + _chan.index.ToString() + ".wav";
                    }
                    else
                    {
                        _pbx.CreateDir(_pbx.vmb_dir + SIPPBXWinUtil.GetDirDateTime(_record_start_time) + "\\");
                        _audio_fn1 = _pbx.vmb_dir + SIPPBXWinUtil.GetDirDateTime(_record_start_time) + "\\greeting-" + SIPPBXWinUtil.GetFNDateTime(_record_start_time) + "-" + _chan.index.ToString() + ".wav";
                    }
                    _audio_record = new GTOpAudioRecord(this, _env, _chan, _audio_fn, 0, "", 60 * 1000);
                    _audio_record.perform();
                }
                else
                {
                    _env.DisconnectCall(_chan.index, 0, "", "PBX: audio play failed in GTOpVMBChgPwd");
                }
            }
            else if (opAsync == _audio_record)
            {
                if (result == GTOpAsync.ResultCode.OP_RESULT_SUCCESS)
                {
                    GTAPIASM.GTAPIChan api_chan = _env.GetChannel(_chan.index);

                    if (_env.IsChanConnected(_chan.index))
                    {
                        //disconnect the call first if it is still connected
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: recording done in GTOpVMBChgPwd");
                    }


                    //need to save voicemail info into DB
                    File.Copy(_audio_fn, _audio_fn1);

                    DBServerSetting db_set = _pbx.GetDBServerSet();
                    if (db_set != null)
                    {
                        if (db_set.ConnectDB())
                        {
                            SIPPBXExtenVoiceMail vm = new SIPPBXExtenVoiceMail();
                            vm.UserName = (_vmb.vmbExten != null) ? _vmb.vmbExten.UserName : "";
                            vm.ToEmail = m_to;
                            vm.Caller = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.caller_num);
                            vm.Callee = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.callee_num);
                            vm.tBegin = _record_start_time;
                            TimeSpan tsp = DateTime.Now - _record_start_time;
                            vm.nDurSec = Convert.ToInt32(tsp.TotalSeconds);
                            vm.VMFile = _audio_fn1;
                            vm.VMStatus = 1; //new msg
                            vm.CallID = _chan.unique_call_id;

                            if (SIPPBXDBUtil.SaveVoiceMailIntoDB(_pbx, _env, db_set.myConn, vm, _env.pbxMain.GetPBXLog()))
                            {
                                if (_vmb.vmbExten != null)
                                    SIPPBXDBUtil.UpdateExtenVoiceMailFromDB(_pbx, _env, _vmb.vmbExten, db_set.myConn, _env.pbxMain.GetPBXLog());
                            }
                            db_set.DisconnectDB();
                        }
                    }

                    if (m_to.Length == 0)
                    {
                        _env.LogoutText("Cannot send voice mail to null email address!");
                        _env.LOG_Trace(1, "Cannot send voice mail to null email address!");
                        return;
                    }

                    if (_pbx.email_set.emailAddr.Length > 0 && _pbx.email_set.emailServer.Length > 0)
                    {
                        try
                        {
                            MailMessage myMail = new MailMessage(_pbx.email_set.emailAddr, m_to);
                            myMail.Subject = "Voice Mail Received from " + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(0, api_chan.caller_num) + " " + GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, api_chan.caller_num);

                            myMail.Body = "You got a voice mail. Caller " + api_chan.caller_num + " Callee " + api_chan.callee_num + " Time " + DateTime.Now.ToString();

                            Attachment data = new Attachment(_audio_fn, MediaTypeNames.Application.Octet);

                            myMail.Attachments.Add(data); //add the attachment

                            SmtpClient smtp_client = new SmtpClient(_pbx.email_set.emailServer, _pbx.email_set.emailPort);

                            smtp_client.UseDefaultCredentials = false;
                            smtp_client.Credentials = new NetworkCredential(_pbx.email_set.emailAddr, _pbx.email_set.emailPassword);
                            smtp_client.EnableSsl = _pbx.email_set.emailSSL;

                            // Set the method that is called back when the send operation ends.
                            smtp_client.SendCompleted += new SendCompletedEventHandler(SendCompletedCallback);

                            //string userState = "test message1";
                            smtp_client.SendAsync(myMail, this);
                        }
                        catch (Exception ex)
                        {
                            _env.LogoutText(ex.Message);
                            _env.LOG_Trace(1, ex.Message);
                            _env.LOG_Trace(1, ex.ToString());
                        }
                    }
                    else
                    {
                        _env.LogoutText("No email server settings to send out voice email notification!");
                    }
                }
                else
                {
                    if (_env.IsChanConnected(_chan.index))
                    {
                        _env.DisconnectCall(_chan.index, 0, "", "PBX: recording failed in OpVMB");
                    }
                }
            }
        }
    }
*/
}
