/*////////////////////////////////////////////////////////////////////////////////////
//
//Copyright (c) 2007-2020 by PC Best Networks, Inc.   All rights reserved
//
*/////////////////////////////////////////////////////////////////////////////////////

//#define PBXV3_DEBUG

using System;
using System.Collections.Generic;
using System.Text;
using System.Data.SqlClient;
using System.Threading;
using System.IO;
using System.Windows.Forms;
using Microsoft.Win32;
using System.Data;
using System.Data.Common;
using System.Data.SqlTypes;
using System.Data.SQLite;

namespace SIPPBXv3
{
    public class SIPPBXCFGDB
    {
        public const string EXTN_BLOCK_INCOMING_CALLERID_ATTR = "1001";
        public const string EXTN_PING_CODE_ATTR = "1002";

        public static bool RefreshAllCfgFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SIPPBXLog log)
        {
            DBServerSetting db_set = pbx.GetDBServerSet();

            try
            {
                if (db_set != null)
                {
                    if (db_set.ConnectDB())
                    //if(pbxMain.dbPBXSet.IsDBConnected())
                    {

                        RefreshSysCfgFromDB(pbxMain, pbx, env, db_set, log);

                        //RefreshSysCfg(pbxMain, pbx, env, db_set.myConn);
                        RefreshSIPAccountConfig(pbxMain, pbx, env, db_set, log);
                        RefreshSecurityConfig(pbxMain, pbx, env, db_set, log);

                        RefreshExtensionsConfig(pbxMain, pbx, env, db_set, log);

                        RefreshDialplansConfig(pbxMain, pbx, env, db_set, log);
                        RefreshACDConfig(pbxMain, pbx, env, db_set, log);
                        RefreshParkingSlotConfig(pbxMain, pbx, env, db_set, log);
                        RefreshRingGroupConfig(pbxMain, pbx, env, db_set, log);
                        RefreshPagingGroupConfig(pbxMain, pbx, env, db_set, log);

                        //RefreshLoadBalanceConfig(pbxMain, pbx, env, db_set.myConn, log);

                        RefreshMonitorGroupConfig(pbxMain, pbx, env, db_set, log);
                        RefreshAgentsConfig(pbxMain, pbx, env, db_set, log);
                        RefreshIVRsConfig(pbxMain, pbx, env, db_set, log);
                        RefreshAutoDialerTasks(pbxMain, pbx, env, db_set, log);
                        RefreshPickupGroupConfig(pbxMain, pbx, env, db_set, log);
                        RefreshConferRoomsConfig(pbxMain, pbx, env, db_set, log);

                        RefreshCallLimitConfig(pbxMain, pbx, env, db_set, log);
                        RefreshBlackListConfig(pbxMain, pbx, env, db_set, log);
                        RefreshCallBackConfig(pbxMain, pbx, env, db_set, log);
                        RefreshOpenAINodesConfig(pbxMain, pbx, env, db_set, log);

                        db_set.DisconnectDB();
                        return true;
                    }
                }
            }
            catch (Exception e)
            {
                if(log != null)
                    log.LogoutText(e.ToString());

                //reset DB connection
                /*
                if (pbxMain.dbPBXSet != null)
                {
                    try
                    {
                        pbxMain.dbPBXSet.DisconnectDB();
                    }
                    catch (Exception)
                    {
                    }

                    pbxMain.dbPBXSet.ConnectDB();
                }*/
            }

            return false;
        }

        //pbxMain and env are null for GUI app
        public static bool LoadAllCfgFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, SIPPBXLog log)
        {
            DBServerSetting db_set = pbx.GetDBServerSet();

#if PBXV3_DEBUG   
            SIPPBXMain.LogMessageToFile("LoadAllCfgFromDB 1");
#endif

            try
            {
#if PBXV3_DEBUG
                SIPPBXMain.LogMessageToFile("LoadAllCfgFromDB 2");
#endif

                if (db_set != null)
                {
#if PBXV3_DEBUG
                    SIPPBXMain.LogMessageToFile("LoadAllCfgFromDB 3");
#endif

                    if (db_set.ConnectDB())
                    {
#if PBXV3_DEBUG
                        SIPPBXMain.LogMessageToFile("LoadAllCfgFromDB 4");
#endif
                        //CheckAttrDef(pbxMain, pbx, env, db_set.myConn, log);

                        LoadSysCfgFromDB(pbxMain, pbx, env, db_set, log);

                        //if (pbxMain != null && env != null)
                        {
                            //server application. 
                            //need to check the DB.
                            double curVersion = 3.81;
                            double dbVersion = 3.81;
                            try
                            {
                                if (pbx.PBXVersion.Length > 0)
                                    curVersion = Convert.ToDouble(pbx.PBXVersion);

                                dbVersion = Convert.ToDouble(GetSysPBXVersionSettingsFromDB(pbxMain, pbx, env, db_set, log));
                            }
                            catch (Exception ex)
                            {
                                SIPPBXMain.LogMessageToFile("GetSysPBXVersionSettingsFromDB returns " + GetSysPBXVersionSettingsFromDB(pbxMain, pbx, env, db_set, log));
                                SIPPBXMain.LogMessageToFile(ex.ToString());
                            }

                            //I don't know why, in some system it is 329 like
                            //if (curVersion > 100) curVersion /= 100.00;
                            //if (dbVersion > 100) dbVersion /= 100.00;

                            if (curVersion < dbVersion)
                            {
                                log.LogoutText("PBX version is older than DB version! You must used a newer PBX before! Please remove the DB, or create a new DB for this PBX application. " + curVersion.ToString() + " " + dbVersion.ToString());
                                return false;
                            }

                            log.LogoutText("DBVersion:" + dbVersion.ToString() + " AppVersion:" + curVersion.ToString());
                            if (curVersion > dbVersion)
                            {
                                log.LogoutText("AppVersion is greater than DBVersio!");
                                if (dbVersion < 3.08)
                                {
                                    if (curVersion > 3.07)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo308, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo308(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.09)
                                {
                                    if (curVersion > 3.08)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo309, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo309(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.11)
                                {
                                    if (curVersion > 3.10)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo311, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo311(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.20)
                                {
                                    if (curVersion > 3.19)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo320, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo320(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.22)
                                {
                                    if (curVersion > 3.21)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo322, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo322(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.29)
                                {
                                    if (curVersion > 3.28)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo329, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo329(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.31)
                                {
                                    if (curVersion > 3.30)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo331, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo331(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.44)
                                {
                                    if (curVersion > 3.45)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo346, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo346(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.48)
                                {
                                    if (curVersion > 3.47)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo348, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo348(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.50)
                                {
                                    if (curVersion > 3.49)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo350, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo350(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.51)
                                {
                                    if (curVersion > 3.50)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo351, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo351(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.52)
                                {
                                    if (curVersion > 3.51)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo352, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo352(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.53)
                                {
                                    if (curVersion > 3.52)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo353, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo353(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.54)
                                {
                                    if (curVersion > 3.53)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo354, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo354(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.57)
                                {
                                    if (curVersion > 3.56)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo357, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo357(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.58)
                                {
                                    if (curVersion > 3.57)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo358, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo358(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.59)
                                {
                                    if (curVersion > 3.58)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo359, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo359(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.60)
                                {
                                    if (curVersion > 3.59)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo360, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo360(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.61)
                                {
                                    if (curVersion > 3.60)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo361, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo361(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.62)
                                {
                                    if (curVersion > 3.61)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo362, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo362(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.63)
                                {
                                    if (curVersion > 3.62)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo363, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo363(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.64)
                                {
                                    if (curVersion > 3.63)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo364, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo364(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.65)
                                {
                                    if (curVersion > 3.64)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo365, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo365(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.66)
                                {
                                    if (curVersion > 3.65)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo366, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo366(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.67)
                                {
                                    if (curVersion > 3.66)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo367, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo367(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.68)
                                {
                                    if (curVersion > 3.67)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo368, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo368(pbxMain, pbx, env, db_set, log);
                                    }
                                }
                                
                                UpgradeDBTo368_1(pbxMain, pbx, env, db_set, log);

                                if (dbVersion < 3.71)
                                {
                                    if (curVersion > 3.70)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo371, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo371(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                if (dbVersion < 3.80)
                                {
                                    if (curVersion > 3.71)
                                    {
                                        log.LogoutText("Calling UpgradeDBTo380, Upgrade DB from " + dbVersion.ToString() + " to " + curVersion.ToString());
                                        UpgradeDBTo380(pbxMain, pbx, env, db_set, log);
                                    }
                                }

                                SavePBXVersionToDB(curVersion.ToString(), env, db_set, log);
                            }
                            else if (curVersion == dbVersion)
                            {
                                if (curVersion >= 3.68)
                                {
                                    UpgradeDBTo368_1(pbxMain, pbx, env, db_set, log);
                                }
                            }
                        }

                        LoadSIPAccountConfigFromDB(pbxMain, pbx, env, db_set, log);
                        LoadSecurityFromDB(pbxMain, pbx, env, db_set, log);
                        LoadExtensionsConfigFromDB(pbxMain, pbx, env, db_set, log);

                        LoadDialplansConfigFromDB(pbxMain, pbx, env, db_set, log);
                        LoadACDConfigFromDB(pbxMain, pbx, env, db_set, log);
                        LoadParkingSlotConfigFromDB(pbxMain, pbx, env, db_set, log);
                        LoadRingGroupConfigFromDB(pbxMain, pbx, env, db_set, log);
                        LoadPagingGroupConfigFromDB(pbxMain, pbx, env, db_set, log);

                        LoadLoadBalanceConfigFromDB(pbxMain, pbx, env, db_set, log);

                        LoadMonitorGroupConfigFromDB(pbxMain, pbx, env, db_set, log);
                        LoadAgentsConfigFromDB(pbxMain, pbx, env, db_set, log);
                        LoadIVRsConfigFromDB(pbxMain, pbx, env, db_set, log);
                        LoadAutoDialerTasksFromDB(pbxMain, pbx, env, db_set, log);
                        LoadPickupGroupConfigFromDB(pbxMain, pbx, env, db_set, log);
                        LoadConferRoomsConfigFromDB(pbxMain, pbx, env, db_set, log);

                        LoadAutoDialerTasksFromDB(pbxMain, pbx, env, db_set, log);

                        LoadCallLimitConfigFromDB(pbxMain, pbx, env, db_set, log);
                        LoadBlackListConfigFromDB(pbxMain, pbx, env, db_set, log);
                        LoadCallBackConfigFromDB(pbxMain, pbx, env, db_set, log);
                        LoadOpenAINodesFromDB(pbxMain, pbx, env, db_set, log);

                        db_set.DisconnectDB();
                        return true;
                    }
                    else
                    {
                        SIPPBXMain.LogMessageToFile("cannot connect to DB!");
                    }
                }
            }
            catch (Exception ex)
            {
                if (log != null)
                    log.LogoutText(ex.ToString());
                SIPPBXMain.LogMessageToFile(ex.ToString());
            }

            return false;
        }

        public static string SysCFGGetValue(string cfgName, DBServerSetting db_set, SIPPBXLog log)
        {
            string cfgValue = "";

            try
            {
                string sqlstr = "SELECT * FROM cfg_sys WHERE CfgName = '" + cfgName + "'";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, null);

                try
                {
                    while (myReader.Read())
                    {
                        cfgValue = myReader.GetString(1);
                        break;
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return cfgValue;
        }

        public static void SysCFGSetValue(string cfgName, string cfgValue, DBServerSetting db_set, SIPPBXLog log, bool bMod)
        {
            try
            {
                string sqlstr = "SELECT * FROM cfg_sys WHERE CfgName = '" + cfgName + "'";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, null);

                if (myReader.HasRows)
                {
                    myReader.Close();
                    sqlstr = "UPDATE cfg_sys SET CfgValue = '" + cfgValue + "', ModTag = " + (bMod ? "1" : "0") + " WHERE CfgName = '" + cfgName + "'";
                    db_set.ExcuteNonQuerySQL(sqlstr, null);
                }
                else
                {
                    myReader.Close();
                    sqlstr = "INSERT INTO cfg_sys VALUES('" + cfgName + "','" + cfgValue + "', 1)";
                    db_set.ExcuteNonQuerySQL(sqlstr, null);
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void SavePBXVersionToDB(string ver, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            //PBXVersion
            SysCFGSetValue("PBXVersion", ver, db_set, log, false);
        }

        public static void SaveSysCfgToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            SysCFGSetValue("ChanNum", pbx.ChanNum.ToString(), db_set, log, false);
            SysCFGSetValue("PBXLicKey", pbx.PBXLicKey, db_set, log, false);
            //SysCFGSetValue("UseUSBKey", pbx.bUseUSBKey ? "1" : "0", db_set, log, false);
            SysCFGSetValue("USBKeyDriver", pbx.USBKeyDriver, db_set, log, false);
            SysCFGSetValue("LicMAC", pbx.LicMAC, db_set, log, false);
            SysCFGSetValue("MohDir", pbx.moh_dir, db_set, log, false);
            SysCFGSetValue("LogDir", pbx.log_dir, db_set, log, false);
            SysCFGSetValue("LogLevel", pbx.log_level.ToString(), db_set, log, false);
            SysCFGSetValue("ReportDir", pbx.report_dir, db_set, log, false);
            SysCFGSetValue("RecordDir", pbx.record_dir, db_set, log, false);
            SysCFGSetValue("VMBDir", pbx.vmb_dir, db_set, log, false);

            SysCFGSetValue("OutboundPercent", pbx.pbx_sys_set.OutPercent.ToString(), db_set, log, false);
            SysCFGSetValue("ExtenCanInbound", pbx.pbx_sys_set.bExtenCanInbound ? "1" : "0", db_set, log, false);
            SysCFGSetValue("MaxProxyUserRegSec", pbx.pbx_sys_set.MaxProxyUserRegSec.ToString(), db_set, log, false);

            SysCFGSetValue("PreferOutlineCodec", pbx.pbx_sys_set.PreferOutlineCodec, db_set, log, false);
            SysCFGSetValue("PreferExtensionCodec", pbx.pbx_sys_set.PreferExtensionCodec, db_set, log, false);

            SysCFGSetValue("RestartTime", pbx.pbx_sys_set.sRestartTime, db_set, log, false);

            SysCFGSetValue("PlayMOHRandomly", pbx.pbx_sys_set.bRandomPlayMOH ? "1" : "0", db_set, log, false);
            SysCFGSetValue("PlayRingbackTone", pbx.pbx_sys_set.bPlayRingbackTone ? "1" : "0", db_set, log, false);
            SysCFGSetValue("NoAudioDisconnect", pbx.pbx_sys_set.bNoAudioDisconnect ? "1" : "0", db_set, log, false);

            SysCFGSetValue("UseOpenAI", pbx.pbx_sys_set.useOpenAI==1? "1" : "0", db_set, log, false);
            //SysCFGSetValue("APIKey", pbx.pbx_sys_set.apiKey, db_set, log, false);

            SysCFGSetValue("StopPlayingForFirstDTMFkey", pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey ? "1" : "0", db_set, log, false);

            SysCFGSetValue("NoAudioDisconnectDur", pbx.pbx_sys_set.NoAudioDisconnectDur.ToString(), db_set, log, false);

            SysCFGSetValue("MaxCallDuration", pbx.pbx_sys_set.MaxCallDuration.ToString(), db_set, log, false);

            //special numbers
            SysCFGSetValue("PickupShortCode", pbx.pickup_shortcode, db_set, log, false);
            SysCFGSetValue("ACDNumber", pbx.acd_number, db_set, log, false);
            SysCFGSetValue("AgentLoginNumber", pbx.agent_login_number, db_set, log, false);
            SysCFGSetValue("AgentLogoutNumber", pbx.agent_logout_number, db_set, log, false);
            SysCFGSetValue("VoiceMailBoxNumber", pbx.vmb_code, db_set, log, false);

            SysCFGSetValue("BlindTransCode", pbx.blindtrans_code, db_set, log, false);
            SysCFGSetValue("ConsultTransCode", pbx.consulttrans_code, db_set, log, false);

            SysCFGSetValue("TrunkBlindTransCode", pbx.trunk_blindtrans_code, db_set, log, false);
            SysCFGSetValue("TrunkConsultTransCode", pbx.trunk_consulttrans_code, db_set, log, false);
            SysCFGSetValue("TrunkHookFlashCode", pbx.trunk_hook_flash_code, db_set, log, false);
            SysCFGSetValue("MagicCancelCode", pbx.magic_cancel_code, db_set, log, false);

            //cdr_option
            SysCFGSetValue("PBXCDR", pbx.cdr_option.pbx_cdr.ToString(), db_set, log, false);
            SysCFGSetValue("ACDCDR", pbx.cdr_option.acd_cdr.ToString(), db_set, log, false);
            SysCFGSetValue("ExtenCDR", pbx.cdr_option.exten_cdr.ToString(), db_set, log, false);
            SysCFGSetValue("AgentCDR", pbx.cdr_option.agent_cdr.ToString(), db_set, log, false);

            SysCFGSetValue("NoAudioDuration", pbx.no_audio_dur.ToString(), db_set, log, false);
            SysCFGSetValue("UseGroupNameAsDisplayName", pbx.use_gpname_as_dispname ? "1" : "0", db_set, log, false);
            SysCFGSetValue("GetRemoteContactFromRing", pbx.get_remote_contact_from_ring ? "1" : "0", db_set, log, false);

            SysCFGSetValue("AudioFormat", pbx.AudioFormat.ToString(), db_set, log, false);
            SysCFGSetValue("AudioEncode", pbx.AudioEncode.ToString(), db_set, log, false);

            //email settings
            SysCFGSetValue("Email.SMTPServer", pbx.email_set.emailServer, db_set, log, false);
            SysCFGSetValue("Email.SMTPPort", pbx.email_set.emailPort.ToString(), db_set, log, false);
            SysCFGSetValue("Email.EmailAddr", pbx.email_set.emailAddr, db_set, log, false);
            SysCFGSetValue("Email.Password", pbx.email_set.emailPassword, db_set, log, false);
            SysCFGSetValue("Email.SSL", pbx.email_set.emailSSL ? "1" : "0", db_set, log, false);

            //sip net
            SysCFGSetValue("SIPNetwork.SIPAddr", pbx.sip_set.sipAddr, db_set, log, false);
            SysCFGSetValue("SIPNetwork.SIPProtocol", pbx.sip_set.sipProtocol.ToString(), db_set, log, false);
            SysCFGSetValue("SIPNetwork.SRTPType", pbx.sip_set.srtpType.ToString(), db_set, log, false);
            SysCFGSetValue("SIPNetwork.SIPPort", pbx.sip_set.sipPort.ToString(), db_set, log, false);
            SysCFGSetValue("SIPNetwork.RTPPort", pbx.sip_set.rtpPort.ToString(), db_set, log, false);
            SysCFGSetValue("SIPNetwork.RTPPortSpace", pbx.sip_set.rtpPortSpace.ToString(), db_set, log, false);
            SysCFGSetValue("SIPNetwork.AudioCodecs", pbx.sip_set.auCodecs, db_set, log, false);
            SysCFGSetValue("SIPNetwork.VideoCodecs", pbx.sip_set.videoCodecs, db_set, log, false);
            SysCFGSetValue("SIPNetwork.StunServer", pbx.sip_set.sStunServer, db_set, log, false);
            SysCFGSetValue("SIPNetwork.DTMFMethod", pbx.sip_set.dtmfMethod.ToString(), db_set, log, false);
            SysCFGSetValue("SIPNetwork.PublicIP", pbx.sip_set.sPublicIPAddr, db_set, log, false);
            SysCFGSetValue("SIPNetwork.ManagerPort", pbx.sip_set.managerPort.ToString(), db_set, log, false);
            SysCFGSetValue("SIPNetwork.DynMapRTP", pbx.sip_set.dynMapRTP.ToString(), db_set, log, false);
            SysCFGSetValue("SIPNetwork.DoRTPRelay", pbx.sip_set.doRTPRelay ? "1" : "0", db_set, log, false);
            SysCFGSetValue("SIPNetwork.UseDNSSRV", pbx.sip_set.useDNSSRV ? "1" : "0", db_set, log, false);
            SysCFGSetValue("SIPNetwork.DoExtenProxy", pbx.sip_set.doExtenProxy ? "1" : "0", db_set, log, false);
            SysCFGSetValue("SIPNetwork.ForwardPAssertedIdentity", pbx.sip_set.bForwardPAssertedIdentity ? "1" : "0", db_set, log, false);


            SysCFGSetValue("SIPNetwork.UserAgentName", pbx.sip_set.sUAName, db_set, log, false);

            //call limit list and black list
            SysCFGSetValue("PBX.EnableCallLimit", pbx.calllimit_enabled ? "1" : "0", db_set, log, false);
            SysCFGSetValue("PBX.EnableBlackList", pbx.callblock_enabled ? "1" : "0", db_set, log, false);
            SysCFGSetValue("PBX.EnableCallBack", pbx.callback_enabled ? "1" : "0", db_set, log, false);
            SysCFGSetValue("PBX.RecordAllCalls", pbx.RecordAllCalls ? "1" : "0", db_set, log, false);


            //proxy site
            SysCFGSetValue("SIPProxySite.DomainList", pbx.sip_proxy_sites[0].domainList, db_set, log, false);
            SysCFGSetValue("SIPProxySite.MapSIPAddr", pbx.sip_proxy_sites[0].mapSIPAddr ? "1" : "0", db_set, log, false);

            SysCFGSetValue("SIPProxySite.OptionPingExtension", pbx.sip_proxy_sites[0].optionPingExten ? "1" : "0", db_set, log, false);

            SavePBXVersionToDB(pbx.PBXVersion, env, db_set, log);
        }

        public static string GetSysPBXVersionSettingsFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            string sVersion = SysCFGGetValue("PBXVersion", db_set, log);
            if (sVersion == "")
            {
                sVersion = pbx.PBXVersion;
            }
            return sVersion;
        }

        public static void SavePBXLicOwner(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            SysCFGSetValue("PBXLicOwner", pbx.LicOwner, db_set, log, false);
            SysCFGSetValue("PBXFreeVersion", pbx.bFreeVersion?"1":"0", db_set, log, false);
        }

        public static void GetPBXLicOwner(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.LicOwner = SysCFGGetValue("PBXLicOwner", db_set, log);
            pbx.bFreeVersion = SysCFGGetValue("PBXFreeVersion", db_set, log) == "1";
        }

        public static void UpdateSysUseGroupNameAsDisplayNameToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            SysCFGSetValue("UseGroupNameAsDisplayName", pbx.use_gpname_as_dispname ? "1" : "0", db_set, log, true);
        }

        public static void UpdateGetRemoteContactFromRingToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            SysCFGSetValue("GetRemoteContactFromRing", pbx.get_remote_contact_from_ring ? "1" : "0", db_set, log, true);
        }

        public static void UpdateSysRegLicKeyToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            SysCFGSetValue("ChanNum", pbx.ChanNum.ToString(), db_set, log, true);
            SysCFGSetValue("PBXLicKey", pbx.PBXLicKey, db_set, log, true);
            //SysCFGSetValue("UseUSBKey", pbx.bUseUSBKey?"1":"0", db_set, log, true);
            SysCFGSetValue("USBKeyDriver", pbx.USBKeyDriver, db_set, log, true);
            SysCFGSetValue("LicMAC", pbx.LicMAC, db_set, log, true);
        }

        public static void UpdateSysCDROptionToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            SysCFGSetValue("PBXCDR", pbx.cdr_option.pbx_cdr.ToString(), db_set, log, true);
            SysCFGSetValue("ACDCDR", pbx.cdr_option.acd_cdr.ToString(), db_set, log, true);
            SysCFGSetValue("ExtenCDR", pbx.cdr_option.exten_cdr.ToString(), db_set, log, true);
            SysCFGSetValue("AgentCDR", pbx.cdr_option.agent_cdr.ToString(), db_set, log, true);
        }

        public static void UpdateSysSpecialNumberToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            SysCFGSetValue("PickupShortCode", pbx.pickup_shortcode, db_set, log, true);
            SysCFGSetValue("ACDNumber", pbx.acd_number, db_set, log, true);
            SysCFGSetValue("AgentLoginNumber", pbx.agent_login_number, db_set, log, true);
            SysCFGSetValue("AgentLogoutNumber", pbx.agent_logout_number, db_set, log, true);
            SysCFGSetValue("VoiceMailBoxNumber", pbx.vmb_code, db_set, log, true);

            //******changed below bMod parameters from false to true
            //******I think it should follow above footprint
            SysCFGSetValue("BlindTransCode", pbx.blindtrans_code, db_set, log, true);
            SysCFGSetValue("ConsultTransCode", pbx.consulttrans_code, db_set, log, true);

            SysCFGSetValue("TrunkBlindTransCode", pbx.trunk_blindtrans_code, db_set, log, true);
            SysCFGSetValue("TrunkConsultTransCode", pbx.trunk_consulttrans_code, db_set, log, true);
            SysCFGSetValue("TrunkHookFlashCode", pbx.trunk_hook_flash_code, db_set, log, true);
            SysCFGSetValue("MagicCancelCode", pbx.magic_cancel_code, db_set, log, true);

        }

        public static void UpdateSysOptionsToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            SysCFGSetValue("PreferOutlineCodec", pbx.pbx_sys_set.PreferOutlineCodec, db_set, log, true);
            SysCFGSetValue("PreferExtensionCodec", pbx.pbx_sys_set.PreferExtensionCodec, db_set, log, true);

            SysCFGSetValue("OutboundPercent", pbx.pbx_sys_set.OutPercent.ToString(), db_set, log, true);

            SysCFGSetValue("ExtenCanInbound", pbx.pbx_sys_set.bExtenCanInbound ? "1" : "0", db_set, log, true);
            SysCFGSetValue("MaxProxyUserRegSec", pbx.pbx_sys_set.MaxProxyUserRegSec.ToString(), db_set, log, true);

            SysCFGSetValue("RestartTime", pbx.pbx_sys_set.sRestartTime, db_set, log, true);

            SysCFGSetValue("PlayMOHRandomly", pbx.pbx_sys_set.bRandomPlayMOH ? "1" : "0", db_set, log, true);
            SysCFGSetValue("PlayRingbackTone", pbx.pbx_sys_set.bPlayRingbackTone ? "1" : "0", db_set, log, true);
            SysCFGSetValue("NoAudioDisconnect", pbx.pbx_sys_set.bNoAudioDisconnect ? "1" : "0", db_set, log, true);

            SysCFGSetValue("UseOpenAI", pbx.pbx_sys_set.useOpenAI == 1 ? "1" : "0", db_set, log, true);
            //SysCFGSetValue("APIKey", pbx.pbx_sys_set.apiKey, db_set, log, true);

            SysCFGSetValue("StopPlayingForFirstDTMFkey", pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey ? "1" : "0", db_set, log, true);

            SysCFGSetValue("NoAudioDisconnectDur", pbx.pbx_sys_set.NoAudioDisconnectDur.ToString(), db_set, log, true);

            SysCFGSetValue("MaxCallDuration", pbx.pbx_sys_set.MaxCallDuration.ToString(), db_set, log, true);


            SysCFGSetValue("AudioFormat", pbx.AudioFormat.ToString(), db_set, log, true);
            SysCFGSetValue("AudioEncode", pbx.AudioEncode.ToString(), db_set, log, true);

            SysCFGSetValue("PBX.RecordAllCalls", pbx.RecordAllCalls ? "1" : "0", db_set, log, true);

            UpdateGetRemoteContactFromRingToDB(pbxMain, pbx, env, db_set, log);
        }

        public static void UpdateSysServerFoldersToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            SIPPBXCFGDB.SysCFGSetValue("MohDir", pbx.moh_dir, db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("LogDir", pbx.log_dir, db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("LogLevel", pbx.log_level.ToString(), db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("ReportDir", pbx.report_dir, db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("RecordDir", pbx.record_dir, db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("VMBDir", pbx.vmb_dir, db_set, log, true);
        }

        public static void GetSysProxySiteSettingsFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.sip_proxy_sites[0].domainList = SysCFGGetValue("SIPProxySite.DomainList", db_set, log);
            pbx.sip_proxy_sites[0].mapSIPAddr = SysCFGGetValue("SIPProxySite.MapSIPAddr", db_set, log) == "1";
            pbx.sip_proxy_sites[0].optionPingExten = SysCFGGetValue("SIPProxySite.OptionPingExtension", db_set, log) == "1";
        }

        public static void UpdateSysProxySiteToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            SIPPBXCFGDB.SysCFGSetValue("SIPProxySite.DomainList", pbx.sip_proxy_sites[0].domainList, db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPProxySite.MapSIPAddr", pbx.sip_proxy_sites[0].mapSIPAddr ? "1" : "0", db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPProxySite.OptionPingExtension", pbx.sip_proxy_sites[0].optionPingExten ? "1" : "0", db_set, log, true);
        }

        public static void UpdateCallLimitAndBlackListToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            //call limit list and black list
            SysCFGSetValue("PBX.EnableCallLimit", pbx.calllimit_enabled ? "1" : "0", db_set, log, true);
            SysCFGSetValue("PBX.EnableBlackList", pbx.callblock_enabled ? "1" : "0", db_set, log, true);
            SysCFGSetValue("PBX.EnableCallBack", pbx.callback_enabled ? "1" : "0", db_set, log, true);
        }

        public static void UpdateSysNetworkSettingsToDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.SIPAddr", pbx.sip_set.sipAddr, db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.SIPProtocol", pbx.sip_set.sipProtocol.ToString(), db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.SRTPType", pbx.sip_set.srtpType.ToString(), db_set, log, true);          
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.SIPPort", pbx.sip_set.sipPort.ToString(), db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.RTPPort", pbx.sip_set.rtpPort.ToString(), db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.RTPPortSpace", pbx.sip_set.rtpPortSpace.ToString(), db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.StunServer", pbx.sip_set.sStunServer, db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.DTMFMethod", pbx.sip_set.dtmfMethod.ToString(), db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.PublicIP", pbx.sip_set.sPublicIPAddr, db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.ManagerPort", pbx.sip_set.managerPort.ToString(), db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.DynMapRTP", pbx.sip_set.dynMapRTP.ToString(), db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.DoRTPRelay", pbx.sip_set.doRTPRelay ? "1" : "0", db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.UseDNSSRV", pbx.sip_set.useDNSSRV ? "1" : "0", db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.DoExtenProxy", pbx.sip_set.doExtenProxy ? "1" : "0", db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.ForwardPAssertedIdentity", pbx.sip_set.bForwardPAssertedIdentity ? "1" : "0", db_set, log, true);

            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.UserAgentName", pbx.sip_set.sUAName, db_set, log, true);

            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.AudioCodecs", pbx.sip_set.auCodecs, db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("SIPNetwork.VideoCodecs", pbx.sip_set.videoCodecs, db_set, log, true);

            SIPPBXCFGDB.SysCFGSetValue("Email.SMTPServer", pbx.email_set.emailServer, db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("Email.SMTPPort", pbx.email_set.emailPort.ToString(), db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("Email.EmailAddr", pbx.email_set.emailAddr, db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("Email.Password", pbx.email_set.emailPassword, db_set, log, true);
            SIPPBXCFGDB.SysCFGSetValue("Email.SSL", pbx.email_set.emailSSL ? "1" : "0", db_set, log, true);
        }

        public static void RefreshSysCfgFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "SELECT * FROM cfg_sys WHERE ModTag = 1";

                Queue<PBXOptCmd> tempQueue = new Queue<PBXOptCmd>();

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        PBXOptCmd cmd = new PBXOptCmd();
                        cmd.CmdName = myReader.GetString(0);
                        cmd.CmdArgs = myReader.GetString(1);
                        tempQueue.Enqueue(cmd);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                while (tempQueue.Count > 0)
                {
                    PBXOptCmd cmd = tempQueue.Dequeue();

                    if (cmd.CmdName == "ChanNum")
                    {
                        //pbx.ChanNum = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "OutboundPercent")
                    {
                        pbx.pbx_sys_set.OutPercent = Convert.ToInt32(cmd.CmdArgs);
                        if (pbx.pbx_sys_set.OutPercent > 100)
                            pbx.pbx_sys_set.OutPercent = 100;
                        else if (pbx.pbx_sys_set.OutPercent < 0)
                            pbx.pbx_sys_set.OutPercent = 0;
                    }
                    else if (cmd.CmdName == "ExtenCanInbound")
                    {
                        if (Convert.ToInt32(cmd.CmdArgs) == 1)
                            pbx.pbx_sys_set.bExtenCanInbound = true;
                        else
                            pbx.pbx_sys_set.bExtenCanInbound = false;
                    }
                    else if (cmd.CmdName == "MaxProxyUserRegSec")
                    {
                        pbx.pbx_sys_set.MaxProxyUserRegSec = Convert.ToInt32(cmd.CmdArgs);
                        if (pbx.pbx_sys_set.MaxProxyUserRegSec < 60)
                            pbx.pbx_sys_set.MaxProxyUserRegSec = 60;
                        else if (pbx.pbx_sys_set.MaxProxyUserRegSec > 3600)
                            pbx.pbx_sys_set.MaxProxyUserRegSec = 3600;
                    }
                    else if (cmd.CmdName == "PreferOutlineCodec")
                    {
                        pbx.pbx_sys_set.PreferOutlineCodec = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "PreferExtensionCodec")
                    {
                        pbx.pbx_sys_set.PreferExtensionCodec = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "RestartTime")
                    {
                        pbx.pbx_sys_set.sRestartTime = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "PlayMOHRandomly")
                    {
                        pbx.pbx_sys_set.bRandomPlayMOH = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "PlayRingbackTone")
                    {
                        pbx.pbx_sys_set.bPlayRingbackTone = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "UseOpenAI")
                    {
                        pbx.pbx_sys_set.useOpenAI = Convert.ToInt32(cmd.CmdArgs);
                    }
                    /*else if (cmd.CmdName == "APIKey")
                    {
                        pbx.pbx_sys_set.apiKey = cmd.CmdArgs;
                    }*/
                    else if (cmd.CmdName == "NoAudioDisconnect")
                    {
                        pbx.pbx_sys_set.bNoAudioDisconnect = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "StopPlayingForFirstDTMFkey")
                    {
                        pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "NoAudioDisconnectDur")
                    {
                        pbx.pbx_sys_set.NoAudioDisconnectDur = Convert.ToInt32(cmd.CmdArgs);
                        if (pbx.pbx_sys_set.NoAudioDisconnectDur < 10)
                            pbx.pbx_sys_set.NoAudioDisconnectDur = 10;
                    }
                    else if (cmd.CmdName == "MaxCallDuration")
                    {
                        pbx.pbx_sys_set.MaxCallDuration = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "PBXLicKey")
                    {
                        pbx.PBXLicKey = cmd.CmdArgs;
                    }
                    /*else if (cmd.CmdName == "UseUSBKey")
                    {
                        pbx.bUseUSBKey = cmd.CmdArgs == "1";
                    }*/
                    else if (cmd.CmdName == "USBKeyDriver")
                    {
                        pbx.USBKeyDriver = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "LicMAC")
                    {
                        pbx.LicMAC = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "MohDir")
                    {
                        pbx.moh_dir = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "LogDir")
                    {
                        // pbx.log_dir = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "LogLevel")
                    {
                        //pbx.log_level = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "ReportDir")
                    {
                        pbx.report_dir = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "RecordDir")
                    {
                        pbx.record_dir = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "VMBDir")
                    {
                        pbx.vmb_dir = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "PickupShortCode")
                    {
                        pbx.pickup_shortcode = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "ACDNumber")
                    {
                        pbx.acd_number = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "AgentLoginNumber")
                    {
                        pbx.agent_login_number = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "AgentLogoutNumber")
                    {
                        pbx.agent_logout_number = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "VoiceMailBoxNumber")
                    {
                        pbx.vmb_code = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "BlindTransCode")
                    {
                        pbx.blindtrans_code = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "ConsultTransCode")
                    {
                        pbx.consulttrans_code = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "TrunkBlindTransCode")
                    {
                        pbx.trunk_blindtrans_code = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "TrunkConsultTransCode")
                    {
                        pbx.trunk_consulttrans_code = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "TrunkHookFlashCode")
                    {
                        pbx.trunk_hook_flash_code = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "MagicCancelCode")
                    {
                        pbx.magic_cancel_code = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "PBXCDR")
                    {
                        pbx.cdr_option.pbx_cdr = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "ACDCDR")
                    {
                        pbx.cdr_option.acd_cdr = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "ExtenCDR")
                    {
                        pbx.cdr_option.exten_cdr = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "AgentCDR")
                    {
                        pbx.cdr_option.agent_cdr = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "NoAudioDuration")
                    {
                        pbx.no_audio_dur = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "AudioFormat")
                    {
                        pbx.AudioFormat = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "AudioEncode")
                    {
                        pbx.AudioEncode = Convert.ToInt32(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "UseGroupNameAsDisplayName")
                    {
                        pbx.use_gpname_as_dispname = Convert.ToInt32(cmd.CmdArgs) == 1;

                        if (pbx.sip_ringgroups.Count > 0)
                        {
                            for (int i = 0; i < pbx.sip_ringgroups.Count; i++)
                            {
                                pbx.sip_ringgroups[i].bUseGroupName = pbx.use_gpname_as_dispname;
                            }
                        }
                        if (pbx.sip_huntgroups.Count > 0)
                        {
                            for (int i = 0; i < pbx.sip_huntgroups.Count; i++)
                            {
                                pbx.sip_huntgroups[i].bUseGroupName = pbx.use_gpname_as_dispname;
                            }
                        }
                    }
                    else if (cmd.CmdName == "GetRemoteContactFromRing")
                    {
                        pbx.get_remote_contact_from_ring = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    //original email part.
                    else if (cmd.CmdName == "Email.SMTPServer")
                    {
                        pbx.email_set.emailServer = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "Email.SMTPPort")
                    {
                        pbx.email_set.emailPort = Convert.ToUInt16(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "Email.EmailAddr")
                    {
                        pbx.email_set.emailAddr = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "Email.Password")
                    {
                        pbx.email_set.emailPassword = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "Email.SSL")
                    {
                        pbx.email_set.emailSSL = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    //sip network
                    else if (cmd.CmdName == "SIPNetwork.SIPAddr")
                    {
                        //pbx.sip_set.sipAddr = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "SIPNetwork.SIPProtocol")
                    {
                        //pbx.sip_set.sipProtocol = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "SIPNetwork.SRTPType")
                    {
                        //pbx.sip_set.srtpType = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "SIPNetwork.SIPPort")
                    {
                        //pbx.sip_set.sipPort = Convert.ToUInt16(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "SIPNetwork.RTPPort")
                    {
                        //pbx.sip_set.rtpPort = Convert.ToUInt16(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "SIPNetwork.RTPPortSpace")
                    {
                        //pbx.sip_set.rtpPortSpace = Convert.ToUInt16(cmd.CmdArgs);
                    }
                    else if (cmd.CmdName == "SIPNetwork.AudioCodecs")
                    {
                        //pbx.sip_set.auCodecs = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "SIPNetwork.VideoCodecs")
                    {
                        //pbx.sip_set.videoCodecs = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "SIPNetwork.StunServer")
                    {
                        //pbx.sip_set.sStunServer = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "SIPNetwork.DTMFMethod")
                    {
                        /*
                        pbx.sip_set.dtmfMethod = Convert.ToInt32(cmd.CmdArgs);
                        if (pbx.sip_set.dtmfMethod < 0 || pbx.sip_set.dtmfMethod > 3)
                            pbx.sip_set.dtmfMethod = 3;
                         */
                    }
                    else if (cmd.CmdName == "SIPNetwork.DoRTPRelay")
                    {
                        pbx.sip_set.doRTPRelay = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "SIPNetwork.UseDNSSRV")
                    {
                        pbx.sip_set.useDNSSRV = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "SIPNetwork.DoExtenProxy")
                    {
                        pbx.sip_set.doExtenProxy = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "SIPNetwork.ForwardPAssertedIdentity")
                    {
                        pbx.sip_set.bForwardPAssertedIdentity = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "SIPNetwork.UserAgentName")
                    {
                        pbx.sip_set.sUAName = cmd.CmdArgs;
                    }
                    //proxy sites
                    else if (cmd.CmdName == "SIPProxySite.DomainList")
                    {
                        //pbx.sip_proxy_sites[0].domainList = cmd.CmdArgs;
                    }
                    else if (cmd.CmdName == "SIPProxySite.MapSIPAddr")
                    {
                        //pbx.sip_proxy_sites[0].mapSIPAddr = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "SIPProxySite.OptionPingExtension")
                    {
                        //pbx.sip_proxy_sites[0].optionPingExten = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "PBX.EnableCallLimit")
                    {
                        pbx.calllimit_enabled = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "PBX.EnableBlackList")
                    {
                        pbx.callblock_enabled = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "PBX.EnableCallBack")
                    {
                        pbx.callback_enabled = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                    else if (cmd.CmdName == "PBX.RecordAllCalls")
                    {
                        pbx.RecordAllCalls = Convert.ToInt32(cmd.CmdArgs) == 1;
                    }
                }

                if (pbx.PBXLicKey.Length > 0)
                {
                    pbx.bFreeVersion = false;
                }
                else
                {
                    pbx.bFreeVersion = true;
                }

                db_set.ExcuteNonQuerySQL("UPDATE cfg_sys SET ModTag = 0", env);
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void CheckAttrDef(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            bool fnd = false;
            try
            {
                string sqlstr = "SELECT * FROM cfg_attrdef WHERE AttrType = " + EXTN_BLOCK_INCOMING_CALLERID_ATTR;
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);
                try
                {
                    if (myReader.Read())
                    {
                        int attrType = myReader.GetInt32(0);
                        string attrName = myReader.GetString(1);
                        string attrDesc = myReader.GetString(2);
                        fnd = true;
                    }
                    else
                    {
                        fnd = false;
                    }
                }
                catch (Exception ex)
                {
                    if (log != null)
                        log.LogoutText(ex.ToString());

                    SIPPBXMain.LogMessageToFile(ex.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (!fnd)
                {
                    db_set.ExcuteNonQuerySQL("INSERT INTO cfg_attrdef(AttrType, AttrName, AttrDesc) VALUES(" + EXTN_BLOCK_INCOMING_CALLERID_ATTR + ", 'Extension block incoming caller id', 'for cfg_extensions')", env);
                }
            }
            catch (Exception ex1)
            {
                log.LogoutText(ex1.ToString());
                //env.LOG_Trace(1, ex1.ToString());
            }
            finally { }

        }

        public static void LoadSysCfgFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
#if PBXV3_DEBUG
            SIPPBXMain.LogMessageToFile("LoadSysCfgFromDB 1");
#endif

            try
            {
                string sqlstr = "SELECT * FROM cfg_sys";

                Queue<PBXOptCmd> tempQueue = new Queue<PBXOptCmd>();

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

#if PBXV3_DEBUG
                SIPPBXMain.LogMessageToFile("LoadSysCfgFromDB 2");
#endif

                try
                {
                    while (myReader.Read())
                    {
                        PBXOptCmd cmd = new PBXOptCmd();
                        cmd.CmdName = myReader.GetString(0);
                        cmd.CmdArgs = myReader.GetString(1);
                        tempQueue.Enqueue(cmd);
                    }
                }
                catch (Exception ex)
                {
                    if (log != null)
                        log.LogoutText(ex.ToString());

                    SIPPBXMain.LogMessageToFile(ex.ToString());
                }
                finally
                {
                    myReader.Close();
                }

#if PBXV3_DEBUG
                SIPPBXMain.LogMessageToFile("LoadSysCfgFromDB 3");
                SIPPBXMain.LogMessageToFile("tempQueue.Count = " + tempQueue.Count.ToString());
#endif

                while (tempQueue.Count > 0)
                {
                    PBXOptCmd cmd = tempQueue.Dequeue();

                    try
                    {

                        if (cmd.CmdName == "ChanNum")
                        {
                            pbx.ChanNum = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "OutboundPercent")
                        {
                            pbx.pbx_sys_set.OutPercent = Convert.ToInt32(cmd.CmdArgs);
                            if (pbx.pbx_sys_set.OutPercent > 100)
                                pbx.pbx_sys_set.OutPercent = 100;
                            else if (pbx.pbx_sys_set.OutPercent < 0)
                                pbx.pbx_sys_set.OutPercent = 0;
                        }
                        else if (cmd.CmdName == "ExtenCanInbound")
                        {
                            if (Convert.ToInt32(cmd.CmdArgs) == 1)
                                pbx.pbx_sys_set.bExtenCanInbound = true;
                            else
                                pbx.pbx_sys_set.bExtenCanInbound = false;
                        }
                        else if (cmd.CmdName == "MaxProxyUserRegSec")
                        {
                            pbx.pbx_sys_set.MaxProxyUserRegSec = Convert.ToInt32(cmd.CmdArgs);
                            if (pbx.pbx_sys_set.MaxProxyUserRegSec < 60)
                                pbx.pbx_sys_set.MaxProxyUserRegSec = 60;
                            else if (pbx.pbx_sys_set.MaxProxyUserRegSec > 3600)
                                pbx.pbx_sys_set.MaxProxyUserRegSec = 3600;
                        }
                        else if (cmd.CmdName == "PreferOutlineCodec")
                        {
                            pbx.pbx_sys_set.PreferOutlineCodec = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "PreferExtensionCodec")
                        {
                            pbx.pbx_sys_set.PreferExtensionCodec = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "RestartTime")
                        {
                            pbx.pbx_sys_set.sRestartTime = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "PlayMOHRandomly")
                        {
                            pbx.pbx_sys_set.bRandomPlayMOH = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "PlayRingbackTone")
                        {
                            pbx.pbx_sys_set.bPlayRingbackTone = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "NoAudioDisconnect")
                        {
                            pbx.pbx_sys_set.bNoAudioDisconnect = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "UseOpenAI")
                        {
                            pbx.pbx_sys_set.useOpenAI = Convert.ToInt32(cmd.CmdArgs);
                        }
                        /*else if (cmd.CmdName == "APIKey")
                        {
                            pbx.pbx_sys_set.apiKey = cmd.CmdArgs;
                        }*/
                        else if (cmd.CmdName == "StopPlayingForFirstDTMFkey")
                        {
                            pbx.pbx_sys_set.bStopPlayingForFirstDTMFkey = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "NoAudioDisconnectDur")
                        {
                            pbx.pbx_sys_set.NoAudioDisconnectDur = Convert.ToInt32(cmd.CmdArgs);
                            if (pbx.pbx_sys_set.NoAudioDisconnectDur < 10)
                                pbx.pbx_sys_set.NoAudioDisconnectDur = 10;
                        }
                        else if (cmd.CmdName == "MaxCallDuration")
                        {
                            pbx.pbx_sys_set.MaxCallDuration = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "PBXLicKey")
                        {
                            pbx.PBXLicKey = cmd.CmdArgs;
                        }
                        /*else if (cmd.CmdName == "UseUSBKey")
                        {
                            pbx.bUseUSBKey = cmd.CmdArgs == "1";
                        }*/
                        else if (cmd.CmdName == "USBKeyDriver")
                        {
                            pbx.USBKeyDriver = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "LicMAC")
                        {
                            pbx.LicMAC = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "MohDir")
                        {
                            pbx.moh_dir = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "LogDir")
                        {
                            pbx.log_dir = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "LogLevel")
                        {
                            pbx.log_level = Convert.ToInt32(cmd.CmdArgs);
#if PBXV3_DEBUG
                            SIPPBXMain.LogMessageToFile("pbx.log_level = " + pbx.log_level.ToString());
#endif
                        }
                        else if (cmd.CmdName == "ReportDir")
                        {
                            pbx.report_dir = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "RecordDir")
                        {
                            pbx.record_dir = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "VMBDir")
                        {
                            pbx.vmb_dir = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "PickupShortCode")
                        {
                            pbx.pickup_shortcode = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "ACDNumber")
                        {
                            pbx.acd_number = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "AgentLoginNumber")
                        {
                            pbx.agent_login_number = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "AgentLogoutNumber")
                        {
                            pbx.agent_logout_number = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "VoiceMailBoxNumber")
                        {
                            pbx.vmb_code = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "BlindTransCode")
                        {
                            pbx.blindtrans_code = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "ConsultTransCode")
                        {
                            pbx.consulttrans_code = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "TrunkBlindTransCode")
                        {
                            pbx.trunk_blindtrans_code = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "TrunkConsultTransCode")
                        {
                            pbx.trunk_consulttrans_code = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "TrunkHookFlashCode")
                        {
                            pbx.trunk_hook_flash_code = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "MagicCancelCode")
                        {
                            pbx.magic_cancel_code = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "PBXCDR")
                        {
                            pbx.cdr_option.pbx_cdr = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "ACDCDR")
                        {
                            pbx.cdr_option.acd_cdr = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "ExtenCDR")
                        {
                            pbx.cdr_option.exten_cdr = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "AgentCDR")
                        {
                            pbx.cdr_option.agent_cdr = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "NoAudioDuration")
                        {
                            pbx.no_audio_dur = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "AudioFormat")
                        {
                            pbx.AudioFormat = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "AudioEncode")
                        {
                            pbx.AudioEncode = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "UseGroupNameAsDisplayName")
                        {
                            pbx.use_gpname_as_dispname = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "GetRemoteContactFromRing")
                        {
                            pbx.get_remote_contact_from_ring = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        //original email part.
                        else if (cmd.CmdName == "Email.SMTPServer")
                        {
                            pbx.email_set.emailServer = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "Email.SMTPPort")
                        {
                            pbx.email_set.emailPort = Convert.ToUInt16(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "Email.EmailAddr")
                        {
                            pbx.email_set.emailAddr = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "Email.Password")
                        {
                            pbx.email_set.emailPassword = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "Email.SSL")
                        {
                            pbx.email_set.emailSSL = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        //sip network
                        else if (cmd.CmdName == "SIPNetwork.SIPAddr")
                        {
                            pbx.sip_set.sipAddr = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "SIPNetwork.SIPProtocol")
                        {
                            pbx.sip_set.sipProtocol = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "SIPNetwork.SRTPType")
                        {
                            pbx.sip_set.srtpType = Convert.ToInt32(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "SIPNetwork.SIPPort")
                        {
                            pbx.sip_set.sipPort = Convert.ToUInt16(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "SIPNetwork.RTPPort")
                        {
                            pbx.sip_set.rtpPort = Convert.ToUInt16(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "SIPNetwork.RTPPortSpace")
                        {
                            pbx.sip_set.rtpPortSpace = Convert.ToUInt16(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "SIPNetwork.AudioCodecs")
                        {
                            pbx.sip_set.auCodecs = cmd.CmdArgs.Trim();
                        }
                        else if (cmd.CmdName == "SIPNetwork.VideoCodecs")
                        {
                            pbx.sip_set.videoCodecs = cmd.CmdArgs.Trim();
                        }
                        else if (cmd.CmdName == "SIPNetwork.StunServer")
                        {
                            pbx.sip_set.sStunServer = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "SIPNetwork.DTMFMethod")
                        {
                            pbx.sip_set.dtmfMethod = Convert.ToInt32(cmd.CmdArgs);
                            if (pbx.sip_set.dtmfMethod < 0 || pbx.sip_set.dtmfMethod > 3)
                                pbx.sip_set.dtmfMethod = 3;
                        }
                        else if (cmd.CmdName == "SIPNetwork.PublicIP")
                        {
                            pbx.sip_set.sPublicIPAddr = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "SIPNetwork.ManagerPort")
                        {
                            pbx.sip_set.managerPort = Convert.ToUInt16(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "SIPNetwork.DynMapRTP")
                        {
                            pbx.sip_set.dynMapRTP = Convert.ToUInt16(cmd.CmdArgs);
                        }
                        else if (cmd.CmdName == "SIPNetwork.DoRTPRelay")
                        {
                            pbx.sip_set.doRTPRelay = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "SIPNetwork.UseDNSSRV")
                        {
                            pbx.sip_set.useDNSSRV = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "SIPNetwork.DoExtenProxy")
                        {
                            pbx.sip_set.doExtenProxy = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "SIPNetwork.ForwardPAssertedIdentity")
                        {
                            pbx.sip_set.bForwardPAssertedIdentity = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "SIPNetwork.UserAgentName")
                        {
                            pbx.sip_set.sUAName = cmd.CmdArgs;
                        }
                        //proxy sites
                        else if (cmd.CmdName == "SIPProxySite.DomainList")
                        {
                            pbx.sip_proxy_sites[0].domainList = cmd.CmdArgs;
                        }
                        else if (cmd.CmdName == "SIPProxySite.MapSIPAddr")
                        {
                            pbx.sip_proxy_sites[0].mapSIPAddr = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "SIPProxySite.OptionPingExtension")
                        {
                            pbx.sip_proxy_sites[0].optionPingExten = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "PBX.EnableCallLimit")
                        {
                            pbx.calllimit_enabled = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "PBX.EnableBlackList")
                        {
                            pbx.callblock_enabled = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "PBX.EnableCallBack")
                        {
                            pbx.callback_enabled = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                        else if (cmd.CmdName == "PBX.RecordAllCalls")
                        {
                            pbx.RecordAllCalls = Convert.ToInt32(cmd.CmdArgs) == 1;
                        }
                    }
                    catch (Exception ex)
                    {
                        if (log != null)
                            log.LogoutText(ex.ToString());
                        SIPPBXMain.LogMessageToFile(ex.ToString());
                    }
                }

                if (pbx.PBXLicKey.Length > 0)
                {
                    pbx.bFreeVersion = false;
                }
                else
                {
                    pbx.bFreeVersion = true;
                }

                db_set.ExcuteNonQuerySQL("UPDATE cfg_sys SET ModTag = 0", env);
            }
            catch (Exception ex)
            {
                if (log != null)
                    log.LogoutText(ex.ToString());
                SIPPBXMain.LogMessageToFile(ex.ToString());
            }
        }

        public static void RefreshSIPAccountConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            bool newRow = false;
            bool bChanged = false;

            try
            {

                string sqlstr = "SELECT ID, DisplayName, UserName, DomainServer, ProxyServer, AuthName, Password, ExpireSec, RegWithProxyServer, DIDS, Disabled, ModTag, AcceptOtherID, UseLocalIPInFrom, MappedExten, AppendExtenID, SIPProtocol, SIPTrunk, UseSRTP FROM cfg_sipaccounts WHERE ModTag != 0";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        bChanged = true; //so it will re-init status_sipaccount table.

                        newRow = false;

                        SIPAccount acct = pbx.getSIPAccountByID(myReader.GetInt32(0));

                        if (myReader.GetInt16(11) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (acct != null)
                            {
                                env.SIPAccount_Remove(acct.accHandle);
                                pbx.sip_acct.Remove(acct);
                            }

                            bChanged = true;

                            continue;
                        }

                        if (acct == null)
                        {
                            acct = new SIPAccount();
                            acct.AccID = myReader.GetInt32(0);
                            pbx.sip_acct.Add(acct);
                            newRow = true;

                            bChanged = true;
                        }

                        acct.AccID = myReader.GetInt32(0);
                        acct.DisplayName = myReader.GetString(1);
                        acct.UserName = myReader.GetString(2);

                        if (pbxMain.SelfBrand.Contains("iFoneline"))
                        {
                            acct.DomainServer = "sip.ifoneline.com";
                            acct.ProxyServer = "sip.ifoneline.com";
                        }
                        else if (pbxMain.SelfBrand.Contains("ENACCS"))
                        {
                            acct.DomainServer = "sip.enaccs.com";
                            acct.ProxyServer = "sip.enaccs.com";
                        }
                        else
                        {
                            acct.DomainServer = myReader.GetString(3);
                            acct.ProxyServer = myReader.GetString(4);
                        }

                        acct.AuthName = myReader.GetString(5);
                        acct.Password = myReader.GetString(6);
                        acct.ExpireSec = myReader.GetInt32(7);
                        acct.RegWithProxyServer = (myReader.GetByte(8) == 1) ? true : false;

                        acct.DIDList.Clear();
                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = myReader.GetString(9).Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        if (members.Length > 0)
                        {
                            for (int i = 0; i < members.Length; i++)
                            {
                                acct.DIDList.Add(members[i]);
                            }
                        }

                        acct.Disabled = (myReader.GetByte(10) == 1) ? true : false;
                        acct.OutboundAcceptOtherID = myReader.GetByte(12) == 1;
                        acct.UseLocalIPInFrom = myReader.GetByte(13) == 1;
                        try
                        {
                            acct.MappedExten = myReader.GetString(14);
                        }
                        catch (Exception ex)
                        {
                            acct.MappedExten = "";
                            env.LOG_Trace(1, ex.ToString());
                        }

                        acct.OutboundAppendExtenID = myReader.GetByte(15) == 1;
                        acct.SIPProtocol = myReader.GetByte(16);
                        acct.SIPTrunk = myReader.GetByte(17);
                        acct.UseSRTP = myReader.GetByte(18);

                        if (newRow)
                        {
                            acct.accHandle = env.SIPAccount_Add(acct.DisplayName, acct.UserName, acct.DomainServer, acct.ProxyServer, acct.AuthName, acct.Password, acct.ExpireSec, acct.RegWithProxyServer ? 1 : 0, 0, 0, !acct.Disabled, acct.SIPProtocol | (acct.UseSRTP << 4));
                        }
                        else
                        {
                            env.SIPAccount_Remove(acct.accHandle);
                            acct.accHandle = env.SIPAccount_Add(acct.DisplayName, acct.UserName, acct.DomainServer, acct.ProxyServer, acct.AuthName, acct.Password, acct.ExpireSec, acct.RegWithProxyServer ? 1 : 0, 0, 0, !acct.Disabled, acct.SIPProtocol | (acct.UseSRTP << 4));
                        }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }
 



                db_set.ExcuteNonQuerySQL("DELETE FROM cfg_sipaccounts WHERE ModTag = 2", env);
                db_set.ExcuteNonQuerySQL("UPDATE cfg_sipaccounts SET ModTag = 0 WHERE ModTag = 1", env);

                if (bChanged)
                {
                    SIPPBXDBUtil.InitSIPAccountStatusTable(pbx, env, db_set);
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveSIPAccountFromDB(SIPAccount acct, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_sipaccounts SET ModTag = 2 WHERE ID = " + acct.AccID.ToString();

                db_set.ExcuteNonQuerySQL(sqlstr, env);
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddSIPAccountToDB(SIPAccount acct, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "INSERT INTO cfg_sipaccounts(ID, DisplayName, UserName, DomainServer, ProxyServer, AuthName, Password, ExpireSec, RegWithProxyServer, DIDS, Disabled, ModTag, AcceptOtherID, UseLocalIPInFrom, MappedExten, AppendExtenID, SIPProtocol, SIPTrunk, UseSRTP) VALUES(" + acct.AccID.ToString() + ", ";
                sqlstr += "'" + acct.DisplayName + "', ";
                sqlstr += "'" + acct.UserName + "', ";

                sqlstr += "'" + acct.DomainServer + "', ";
                sqlstr += "'" + acct.ProxyServer + "', ";

                sqlstr += "'" + acct.AuthName + "', ";
                sqlstr += "'" + acct.Password + "', ";

                sqlstr += acct.ExpireSec.ToString() + ", ";
                sqlstr += acct.RegWithProxyServer ? "1, " : "0, ";

                string sDIDs = "";
                for (int i = 0; i < acct.DIDList.Count; i++)
                {
                    sDIDs += acct.DIDList[i];
                    if (i != acct.DIDList.Count - 1)
                        sDIDs += ";";
                }
                sqlstr += "'" + sDIDs + "', ";
                sqlstr += acct.Disabled ? "1, " : "0, ";
                sqlstr += "1, " + (acct.OutboundAcceptOtherID ? "1, " : "0, ");
                sqlstr += acct.UseLocalIPInFrom ? "1, " : "0, ";
                sqlstr += "'" + acct.MappedExten + "', ";
                sqlstr += acct.OutboundAppendExtenID ? "1, " : "0, ";
                sqlstr += acct.SIPProtocol.ToString() + ", ";
                sqlstr += acct.SIPTrunk.ToString() + ", ";
                sqlstr += acct.UseSRTP.ToString() + ")";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
/*
                    string sqlstr = "SELECT * FROM cfg_sipaccounts WHERE ";
                    sqlstr += "UserName='" + acct.UserName + "' AND ";
                    sqlstr += "DomainServer='" + acct.DomainServer + "' AND ";
                    sqlstr += "AuthName='" + acct.AuthName + "' AND ";
                    sqlstr += "Password='" + acct.Password + "'";

                    SqlDataReader myReader = catCMD.ExecuteReader();

                    try
                    {
                        while (myReader.Read())
                        {
                            acct.AccID = myReader.GetInt32(0);
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }
                    finally
                    {
                        myReader.Close();
                    }
*/
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateSIPAccountInDB(SIPAccount acct, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_sipaccounts SET ";

                sqlstr += "DisplayName=" + "'" + acct.DisplayName + "', ";
                sqlstr += "UserName=" + "'" + acct.UserName + "', ";

                sqlstr += "DomainServer=" + "'" + acct.DomainServer + "', ";
                sqlstr += "ProxyServer=" + "'" + acct.ProxyServer + "', ";

                sqlstr += "AuthName=" + "'" + acct.AuthName + "', ";
                sqlstr += "Password=" + "'" + acct.Password + "', ";

                sqlstr += "ExpireSec=" + acct.ExpireSec.ToString() + ", ";
                sqlstr += "RegWithProxyServer=" + (acct.RegWithProxyServer ? "1, " : "0, ");

                string sDIDs = "";
                for (int i = 0; i < acct.DIDList.Count; i++)
                {
                    sDIDs += acct.DIDList[i];
                    if (i != acct.DIDList.Count - 1)
                        sDIDs += ";";
                }
                sqlstr += "DIDS=" + "'" + sDIDs + "', ";
                sqlstr += "Disabled=" + (acct.Disabled ? "1, " : "0, ");
                sqlstr += "AcceptOtherID=" + (acct.OutboundAcceptOtherID ? "1, " : "0, ");
                sqlstr += "AppendExtenID=" + (acct.OutboundAppendExtenID ? "1, " : "0, ");
                sqlstr += "UseLocalIPInFrom=" + (acct.UseLocalIPInFrom ? "1, " : "0, ");
                sqlstr += "MappedExten=" + "'" + acct.MappedExten + "', ";
                sqlstr += "SIPProtocol=" + acct.SIPProtocol.ToString() + ", ";
                sqlstr += "SIPTrunk=" + acct.SIPTrunk.ToString() + ", ";
                sqlstr += "UseSRTP=" + acct.UseSRTP.ToString() + ", ";

                sqlstr += "ModTag=1 ";
                sqlstr += "WHERE ID = " + acct.AccID.ToString();

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadSIPAccountConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.sip_acct.Clear();

            try
            {
                string sqlstr = "DELETE FROM cfg_sipaccounts WHERE ModTag = 2";

                db_set.ExcuteNonQuerySQL(sqlstr, env);

                sqlstr = "SELECT ID, DisplayName, UserName, DomainServer, ProxyServer, AuthName, Password, ExpireSec, RegWithProxyServer, DIDS, Disabled, ModTag, AcceptOtherID, UseLocalIPInFrom, MappedExten, AppendExtenID, SIPProtocol, SIPTrunk, UseSRTP FROM cfg_sipaccounts";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        SIPAccount acct = new SIPAccount();

                        acct.AccID = myReader.GetInt32(0);
                        acct.DisplayName = myReader.GetString(1);
                        acct.UserName = myReader.GetString(2);

                        try
                        {
                            if (pbxMain != null)
                            {
                                if (pbxMain.SelfBrand.Contains("iFoneline"))
                                {
                                    acct.DomainServer = "sip.ifoneline.com";
                                    acct.ProxyServer = "sip.ifoneline.com";
                                }
                                else if (pbxMain.SelfBrand.Contains("ENACCS"))
                                {
                                    acct.DomainServer = "sip.enaccs.com";
                                    acct.ProxyServer = "sip.enaccs.com";
                                }
                                else
                                {
                                    acct.DomainServer = myReader.GetString(3);
                                    acct.ProxyServer = myReader.GetString(4);
                                }
                            }
                            else
                            {
                                acct.DomainServer = myReader.GetString(3);
                                acct.ProxyServer = myReader.GetString(4);
                            }
                        }
                        catch (Exception e)
                        {
                            if (log != null)
                                log.LogoutText(e.ToString());
                        }

                        acct.AuthName = myReader.GetString(5);
                        acct.Password = myReader.GetString(6);
                        acct.ExpireSec = myReader.GetInt32(7);
                        acct.RegWithProxyServer = (myReader.GetByte(8) == 1) ? true : false;

                        acct.DIDList.Clear();
                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = myReader.GetString(9).Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        if (members.Length > 0)
                        {
                            for (int i = 0; i < members.Length; i++)
                            {
                                acct.DIDList.Add(members[i]);
                            }
                        }

                        acct.Disabled = (myReader.GetByte(10) == 1) ? true : false;
                        acct.OutboundAcceptOtherID = myReader.GetByte(12) == 1;
                        acct.UseLocalIPInFrom = myReader.GetByte(13) == 1;
                        try
                        {
                            acct.MappedExten = myReader.GetString(14);
                        }
                        catch (Exception ex)
                        {
                            acct.MappedExten = "";
                            env.LOG_Trace(1, ex.ToString());
                        }
                        acct.OutboundAppendExtenID = myReader.GetByte(15) == 1;
                        acct.SIPProtocol = myReader.GetByte(16);
                        acct.SIPTrunk = myReader.GetByte(17);
                        acct.UseSRTP = myReader.GetByte(18);

                        pbx.sip_acct.Add(acct);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                db_set.ExcuteNonQuerySQL("UPDATE cfg_sipaccounts SET ModTag = 0", env);
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }
        
        //only called from SIPPBXv3 service, not from GUI tool, when a proxy user(extension) just registered
        public static bool SaveExtensionStatusConfigToDB(SIPPBXExten extn, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_extensions SET ";

                sqlstr += "RegSDKTime=" + extn.RegSDKTime.ToString() + ", ";
                sqlstr += "RegisterTime=" + "'" + SIPPBXWinUtil.GetSQLDateTime(extn.RegisterTime) + "', ";
                sqlstr += "RegisterExpire=" + extn.RegisterExpire.ToString() + ", ";
                sqlstr += "ContactAddr=" + "'" + extn.ContactAddr + "', ";
                sqlstr += "MappedContactAddr=" + "'" + extn.MappedContactAddr + "', ";
                sqlstr += "RegFromID=" + "'" + extn.RegFromID + "', ";
                sqlstr += "RegToID=" + "'" + extn.RegToID + "', ";
                sqlstr += "RegSrcIP=" + "'" + extn.RegSrcIP + "', ";
                sqlstr += "RegSrcPort=" + extn.RegSrcPort.ToString() + ", ";
                sqlstr += "UAName=" + "'" + extn.UAName + "', ";
                sqlstr += "NATType=" + extn.NATType.ToString() + ", ";
                sqlstr += "AuthType=" + extn.AuthType.ToString() + ", ";
                sqlstr += "UseSRTP=" + extn.UseSRTP.ToString() + " ";
                //sqlstr += "MaxRegExpSec=" + extn.RegMaxExp.ToString() + " "; This value won't change by REGISTER event. 


                //sqlstr += "MsgWaitingCount=" + extn.MsgWaitingCount.ToString() + ", ";
                //sqlstr += "MsgTotalCount=" + extn.MsgTotalCount.ToString() + ", ";
                //sqlstr += "MsgAccount='" + extn.MsgAccount + "', ";
                //sqlstr += "VoiceMsg=" + "'" + extn.VoiceMsg + "', ";

                //sqlstr += "ModTag=1 ";
                sqlstr += "WHERE UserName = '" + extn.UserName + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    //extn.SaveAttrs(pbxMain, pbx, env, myConn, log);
                    //no need to refresh extension's EXTN_BLOCK_INCOMING_CALLERID_ATTR and EXTN_PING_CODE_ATTR
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;

        }

        public static void RefreshExtensionsConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            bool bChanged = false;
            bool bResetExtn = false;

            try
            {
                string sqlstr = "SELECT UserName, RealName, Password, Email, AltPhoneNumber, RegSDKTime, RegisterTime, RegisterExpire, ContactAddr, RegFromID, RegToID, UAName, NATType, MsgWaitingCount, MsgTotalCount, MsgAccount, VoiceMsg, PriorityLevel, VirtualExtenDestAddr, ACDCallMethod, RingTimeoutSec, CallForwardingPlan, RecordCall, AcceptOtherID, RestSeconds, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, ModTag, AuthType, OnlyAgentLogin, MappedContactAddr, RegSrcIP, RegSrcPort, MultipleCall, VMBPassword, MaxRegExpSec, UseSRTP FROM cfg_extensions WHERE ModTag != 0";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {

                    while (myReader.Read())
                    {
                        bChanged = true; //so it will re-init status_extension table

                        bResetExtn = true;

                        SIPPBXExten extn = pbx.getExtensionByName(myReader.GetString(0));

                        if (myReader.GetInt16(29) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (extn != null)
                            {
                                pbx.sip_exten.Remove(extn);
                            }

                            bChanged = true;

                            continue;
                        }

                        if (extn == null)
                        {
                            extn = new SIPPBXExten();
                            extn.UserName = myReader.GetString(0);
                            pbx.sip_exten.Add(extn);

                            bChanged = true;
                        }

                        extn.RealName = myReader.GetString(1);
                        extn.Password = myReader.GetString(2);

                        try
                        {
                            extn.Email = myReader.GetString(3);
                            extn.AlternativePhoneNumber = myReader.GetString(4);
                        }
                        catch (Exception) { }
                        /*
                        extn.RegSDKTime = Convert.ToUInt64(myReader.GetInt32(5));
                        extn.RegisterTime = myReader.GetDateTime(6);
                        extn.RegisterExpire = Convert.ToUInt32(myReader.GetInt32(7));
                        extn.ContactAddr = myReader.GetString(8);
                        extn.RegFromID = myReader.GetString(9);
                        extn.RegToID = myReader.GetString(10);
                        extn.UAName = myReader.GetString(11);
                        extn.NATType = myReader.GetInt32(12);
                        extn.MsgWaitingCount = myReader.GetInt32(13);
                        extn.MsgTotalCount = myReader.GetInt32(14);
                        extn.MsgAccount = myReader.GetString(15);
                        extn.VoiceMsg = myReader.GetString(16);
                         */
                        try
                        {
                            extn.PriorityLevel = Convert.ToUInt32(myReader.GetInt32(17));
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.VirtualExtenDestAddr = myReader.GetString(18);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.ACDCallMethod = myReader.GetInt32(19);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.RingTimeoutSec = myReader.GetInt32(20);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.CallForwardingPlan = myReader.GetString(21);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.RecordCall = myReader.GetByte(22) == 1 ? true : false;
                        }
                        catch (Exception)
                        {
                        }

                        try
                        {
                            extn.bAcceptOtherID = myReader.GetByte(23) == 1 ? true : false;
                        }
                        catch (Exception)
                        {
                        }

                        try
                        {
                            extn.RestSeconds = myReader.GetInt32(24);
                        }
                        catch (Exception) { }

                        try
                        {

                            if (myReader.GetByte(25) == 1)
                            {
                                extn.vmb = new VoiceMailBox();
                                extn.vmb.vmbExten = extn;
                                extn.vmb.vmbPrompt = myReader.GetString(26);
                                extn.vmb.vmbEmailAddr = myReader.GetString(27);
                                extn.vmb.maxLengthInSecond = myReader.GetInt32(28);
                                extn.vmb.vmbPassword = myReader.GetString(36);
                            }
                            else
                            {
                                extn.vmb = null;
                            }
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.AuthType = myReader.GetInt32(30);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.bOnlyAgentLogin = myReader.GetByte(31) == 1 ? true : false;
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.MappedContactAddr = myReader.GetString(32);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.RegSrcIP = myReader.GetString(33);
                            extn.RegSrcPort = Convert.ToUInt16(myReader.GetInt32(34));
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.bMultipleCalls = myReader.GetByte(35) == 1 ? true : false;
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.RegMaxExp = Convert.ToUInt32(myReader.GetInt32(37));
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.UseSRTP = myReader.GetByte(38) == 1 ? 1 : 0;
                        }
                        catch (Exception) { }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

 
                foreach (SIPPBXExten extn in pbx.sip_exten)
                {
                    extn.ReadAttrs(pbxMain, pbx, env, db_set, log);
                }

                if (bResetExtn)
                {
                    db_set.ExcuteNonQuerySQL("UPDATE cfg_extensions SET ModTag = 0 WHERE ModTag = 1", env);

                    if (pbxMain != null)
                    {
                        pbxMain.ResetExtensions();
                    }
                }

                if (bChanged)
                {
                    db_set.ExcuteNonQuerySQL("DELETE FROM cfg_extensions WHERE ModTag = 2", env);

                    SIPPBXDBUtil.InitExtenStatusTable(pbx, env, db_set);
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveExtensionFromDB(SIPPBXExten extn, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_extensions SET ModTag=2 WHERE UserName = '" + extn.UserName + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    extn.DelAttrs(pbxMain, pbx, env, db_set, log);
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddExtensionToDB(SIPPBXExten extn, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "INSERT INTO cfg_extensions(UserName, RealName, Password, Email, AltPhoneNumber, RegSDKTime, RegisterTime, RegisterExpire, ContactAddr, RegFromID, RegToID, UAName, NATType, MsgWaitingCount, MsgTotalCount, MsgAccount, VoiceMsg, PriorityLevel, VirtualExtenDestAddr, ACDCallMethod, RingTimeoutSec, CallForwardingPlan, RecordCall, AcceptOtherID, RestSeconds, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, VMBPassword, ModTag, AuthType, OnlyAgentLogin, MappedContactAddr, RegSrcIP, RegSrcPort, MultipleCall, MaxRegExpSec, UseSRTP) VALUES('" + extn.UserName + "', ";
                sqlstr += "'" + extn.RealName + "', ";
                sqlstr += "'" + extn.Password + "', ";
                sqlstr += "'" + extn.Email + "', ";
                sqlstr += "'" + extn.AlternativePhoneNumber + "', ";
                sqlstr += extn.RegSDKTime.ToString() + ", ";
                sqlstr += "'" + SIPPBXWinUtil.GetSQLDateTime(extn.RegisterTime) + "', ";
                sqlstr += extn.RegisterExpire.ToString() + ", ";
                sqlstr += "'" + extn.ContactAddr + "', ";
                sqlstr += "'" + extn.RegFromID + "', ";
                sqlstr += "'" + extn.RegToID + "', ";
                sqlstr += "'" + extn.UAName + "', ";
                sqlstr += extn.NATType.ToString() + ", ";
                sqlstr += extn.MsgNewCount.ToString() + ", ";
                sqlstr += extn.MsgOldCount.ToString() + ", ";
                sqlstr += "'" + extn.MsgAccount + "', ";
                sqlstr += "'" + extn.VoiceMsg + "', ";
                sqlstr += extn.PriorityLevel.ToString() + ", ";
                sqlstr += "'" + extn.VirtualExtenDestAddr + "', ";
                sqlstr += extn.ACDCallMethod.ToString() + ", ";
                sqlstr += extn.RingTimeoutSec.ToString() + ", ";
                sqlstr += "'" + extn.CallForwardingPlan + "', ";
                sqlstr += extn.RecordCall ? "1, " : "0, ";
                sqlstr += extn.bAcceptOtherID ? "1, " : "0, ";
                sqlstr += extn.RestSeconds.ToString() + ", ";

                if (extn.vmb != null)
                {
                    sqlstr += "1, ";
                    sqlstr += "'" + extn.vmb.vmbPrompt + "', ";
                    sqlstr += "'" + extn.vmb.vmbEmailAddr + "', ";
                    sqlstr += extn.vmb.maxLengthInSecond.ToString() + ", '";
                    sqlstr += extn.vmb.vmbPassword + "', 1, ";
                }
                else
                {
                    sqlstr += "0, ";
                    sqlstr += "'', ";
                    sqlstr += "'', ";
                    sqlstr += "0, '', 1, ";
                }

                sqlstr += extn.AuthType.ToString() + ", ";
                sqlstr += extn.bOnlyAgentLogin? "1, " : "0, ";
                sqlstr += "'" + extn.MappedContactAddr + "', ";
                sqlstr += "'" + extn.RegSrcIP + "', ";
                sqlstr += extn.RegSrcPort.ToString() + ", ";
                sqlstr += extn.bMultipleCalls? "1, " : "0, ";
                sqlstr += extn.RegMaxExp.ToString() + ", ";
                sqlstr += extn.UseSRTP.ToString() + ")";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    extn.SaveAttrs(pbxMain, pbx, env, db_set, log);
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateExtensionVMBInDB(SIPPBXExten extn, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_extensions SET ";
                if (extn.vmb != null)
                {
                    sqlstr += "VMBOn=" + "1, ";
                    sqlstr += "VMBPrompt=" + "'" + extn.vmb.vmbPrompt + "', ";
                    sqlstr += "VMBEmail=" + "'" + extn.vmb.vmbEmailAddr + "', ";
                    sqlstr += "VMBMaxLength=" + extn.vmb.maxLengthInSecond.ToString() + ", ";
                    sqlstr += "VMBPassword='" + extn.vmb.vmbPassword + "', ";

                }
                else
                {
                    sqlstr += "VMBOn=0, ";
                    sqlstr += "VMBPrompt='', ";
                    sqlstr += "VMBEmail='', ";
                    sqlstr += "VMBMaxLength=0, ";
                    sqlstr += "VMBPassword='', ";
                }

                sqlstr += "ModTag=1 ";

                sqlstr += "WHERE UserName = '" + extn.UserName + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;

        }

        public static bool UpdateExtensionInDB(SIPPBXExten extn, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_extensions SET ";
                sqlstr += "RealName=" + "'" + extn.RealName + "', ";
                sqlstr += "Password=" + "'" + extn.Password + "', ";
                sqlstr += "Email=" + "'" + extn.Email + "', ";
                sqlstr += "AltPhoneNumber=" + "'" + extn.AlternativePhoneNumber + "', ";
                //            sqlstr += "RegSDKTime=" + extn.RegSDKTime.ToString() + ", ";
                //            sqlstr += "RegisterTime=" + "'" + SIPPBXWinUtil.GetSQLDateTime(extn.RegisterTime) + "', ";
                //            sqlstr += "RegisterExpire=" + extn.RegisterExpire.ToString() + ", ";
                //            sqlstr += "ContactAddr=" + "'" + extn.ContactAddr + "', ";
                //            sqlstr += "RegFromID=" + "'" + extn.RegFromID + "', ";
                //            sqlstr += "RegToID=" + "'" + extn.RegToID + "', ";
                //            sqlstr += "UAName=" + "'" + extn.UAName + "', ";
                //            sqlstr += "NATType=" + extn.NATType.ToString() + ", ";
                //            sqlstr += "MsgWaitingCount=" + extn.MsgWaitingCount.ToString() + ", ";
                //            sqlstr += "MsgTotalCount=" + extn.MsgTotalCount.ToString() + ", ";
                //            sqlstr += "MsgAccount='" + extn.MsgAccount + "', ";
                //            sqlstr += "VoiceMsg=" + "'" + extn.VoiceMsg + "', ";
                sqlstr += "PriorityLevel=" + extn.PriorityLevel.ToString() + ", ";
                sqlstr += "VirtualExtenDestAddr=" + "'" + extn.VirtualExtenDestAddr + "', ";
                sqlstr += "ACDCallMethod=" + extn.ACDCallMethod.ToString() + ", ";
                sqlstr += "RingTimeoutSec=" + extn.RingTimeoutSec.ToString() + ", ";
                sqlstr += "CallForwardingPlan=" + "'" + extn.CallForwardingPlan + "', ";
                sqlstr += "RecordCall=" + (extn.RecordCall ? "1, " : "0, ");
                sqlstr += "AcceptOtherID=" + (extn.bAcceptOtherID ? "1, " : "0, ");
                sqlstr += "RestSeconds=" + extn.RestSeconds.ToString() + ", ";

                if (extn.vmb != null)
                {
                    sqlstr += "VMBOn=" + "1, ";
                    sqlstr += "VMBPrompt=" + "'" + extn.vmb.vmbPrompt + "', ";
                    sqlstr += "VMBEmail=" + "'" + extn.vmb.vmbEmailAddr + "', ";
                    sqlstr += "VMBMaxLength=" + extn.vmb.maxLengthInSecond.ToString() + ", ";
                    sqlstr += "VMBPassword='" + extn.vmb.vmbPassword + "', ";

                }
                else
                {
                    sqlstr += "VMBOn=0, ";
                    sqlstr += "VMBPrompt='', ";
                    sqlstr += "VMBEmail='', ";
                    sqlstr += "VMBMaxLength=0, ";
                    sqlstr += "VMBPassword='', ";
                }

                sqlstr += "AuthType=" + extn.AuthType.ToString() + ", ";
                sqlstr += "OnlyAgentLogin=" + (extn.bOnlyAgentLogin?"1":"0") + ", ";
                sqlstr += "MultipleCall=" + (extn.bMultipleCalls? "1" : "0") + ", ";
                sqlstr += "MaxRegExpSec=" + extn.RegMaxExp.ToString() + ", ";
                sqlstr += "UseSRTP=" + extn.UseSRTP.ToString() + ", ";

                sqlstr += "ModTag=1 ";

                sqlstr += "WHERE UserName = '" + extn.UserName + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    extn.SaveAttrs(pbxMain, pbx, env, db_set, log);
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }



        public static void LoadExtensionsConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.sip_exten.Clear();

            try
            {
                db_set.ExcuteNonQuerySQL("DELETE FROM cfg_extensions WHERE ModTag = 2", env);

                string sqlstr = "SELECT UserName, RealName, Password, Email, AltPhoneNumber, RegSDKTime, RegisterTime, RegisterExpire, ContactAddr, RegFromID, RegToID, UAName, NATType, MsgWaitingCount, MsgTotalCount, MsgAccount, VoiceMsg, PriorityLevel, VirtualExtenDestAddr, ACDCallMethod, RingTimeoutSec, CallForwardingPlan, RecordCall, AcceptOtherID, RestSeconds, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, ModTag, AuthType, OnlyAgentLogin, MappedContactAddr, RegSrcIP, RegSrcPort, MultipleCall, VMBPassword, MaxRegExpSec, UseSRTP FROM cfg_extensions";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {

                    while (myReader.Read())
                    {
                        SIPPBXExten extn = new SIPPBXExten();

                        extn.UserName = myReader.GetString(0);
                        extn.RealName = myReader.GetString(1);
                        extn.Password = myReader.GetString(2);
                        try
                        {
                            extn.Email = myReader.GetString(3);
                        }
                        catch(Exception)
                        {
                        }

                        try
                        {
                            extn.AlternativePhoneNumber = myReader.GetString(4);
                        }
                        catch (Exception)
                        {
                        }

                        try
                        {
                            extn.RegSDKTime = Convert.ToUInt32(myReader.GetInt64(5));
                            extn.RegisterTime = myReader.GetDateTime(6);
                            extn.RegisterExpire = Convert.ToUInt32(myReader.GetInt32(7));
                            extn.ContactAddr = myReader.GetString(8);
                            extn.RegFromID = myReader.GetString(9);
                            extn.RegToID = myReader.GetString(10);
                            extn.UAName = myReader.GetString(11);
                            extn.NATType = myReader.GetInt32(12); //UANatType: Network Protocol Type. 0  = UDP, 1 = TCP, 2 = TLS
                            if (extn.NATType < 0)
                                extn.NATType = 0;
                        }
                        catch (Exception)
                        {
                        }

                        try
                        {
                            extn.MsgNewCount = myReader.GetInt32(13);
                            extn.MsgOldCount = myReader.GetInt32(14);
                            extn.MsgAccount = myReader.GetString(15);
                            extn.VoiceMsg = myReader.GetString(16);
                        }
                        catch (Exception)
                        {
                        }

                        try
                        {
                            extn.PriorityLevel = Convert.ToUInt32(myReader.GetInt32(17));
                        }
                        catch (Exception)
                        {
                        }

                        try
                        {
                            extn.VirtualExtenDestAddr = myReader.GetString(18);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.ACDCallMethod = myReader.GetInt32(19);
                            extn.RingTimeoutSec = myReader.GetInt32(20);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.CallForwardingPlan = myReader.GetString(21);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.RecordCall = myReader.GetByte(22) == 1 ? true : false;
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.bAcceptOtherID = myReader.GetByte(23) == 1 ? true : false;
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.RestSeconds = myReader.GetInt32(24);
                        }
                        catch (Exception) { }

                        try
                        {
                            if (myReader.GetByte(25) == 1)
                            {
                                extn.vmb = new VoiceMailBox();
                                extn.vmb.vmbExten = extn;
                                extn.vmb.vmbPrompt = myReader.GetString(26);
                                extn.vmb.vmbEmailAddr = myReader.GetString(27);
                                extn.vmb.maxLengthInSecond = myReader.GetInt32(28);
                                extn.vmb.vmbPassword = myReader.GetString(36);
                            }
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.AuthType = myReader.GetInt32(30);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.bOnlyAgentLogin = myReader.GetByte(31) == 1 ? true : false;
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.MappedContactAddr = myReader.GetString(32);
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.RegSrcIP = myReader.GetString(33);
                            extn.RegSrcPort = Convert.ToUInt16(myReader.GetInt32(34));
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.bMultipleCalls = myReader.GetByte(35) == 1 ? true : false;
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.RegMaxExp = Convert.ToUInt32(myReader.GetInt32(37));
                        }
                        catch (Exception) { }

                        try
                        {
                            extn.UseSRTP = myReader.GetByte(38) == 1 ? 1 : 0;
                        }
                        catch (Exception) { }

                        pbx.sip_exten.Add(extn);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                foreach (SIPPBXExten extn in pbx.sip_exten)
                {
                    extn.ReadAttrs(pbxMain, pbx, env, db_set, log);
                }

                db_set.ExcuteNonQuerySQL("UPDATE cfg_extensions SET ModTag = 0", env);

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshDialplansConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            bool bChanged = false;

            try
            {
                string sqlstr = "SELECT DialPlanName, CallDirection, Caller, Called, CallPlan, DestAddress, OutboundPreStrip, OutboundPrepend, OutboundSIPAcct, OutboundCallerID, ExtenPriorityLevel, TimeLimited, TimeStartHour, TimeStartMinute, TimeEndHour, TimeEndMinute, TimeDay, ExtenMembers, ModTag, DialPlanIndex FROM cfg_dialplans WHERE ModTag != 0 ORDER BY DialPlanIndex ASC";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXDialPlan dp = pbx.getDialPlanByPlanName(myReader.GetString(0));

                        if (myReader.GetInt16(18) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (dp != null)
                            {
                                pbx.sip_dialplan.Remove(dp);
                            }

                            bChanged = true;

                            continue;
                        }

                        if (dp == null)
                        {
                            dp = new SIPPBXDialPlan();
                            dp.planName = myReader.GetString(0);
                            pbx.sip_dialplan.Add(dp);

                            bChanged = true;
                        }

                        if (myReader.GetInt16(1) == 0)
                            dp.CallDirection = SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND;
                        else
                            dp.CallDirection = SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND;

                        dp.CallerID = myReader.GetString(2);
                        dp.CalledID = myReader.GetString(3);
                        if (myReader.GetString(4) == "AUTO_ATTENDANT")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.AUTO_ATTENDANT;
                        }
                        else if (myReader.GetString(4) == "VOICE_MAIL_BOX")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.VOICE_MAIL_BOX;
                        }
                        else if (myReader.GetString(4) == "ACD_QUEUE")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ACD_QUEUE;
                        }
                        else if (myReader.GetString(4) == "DIAL_EXTENSION")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION;
                        }
                        else if (myReader.GetString(4) == "DO_NOT_DISTURB")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DO_NOT_DISTURB;
                        }
                        else if (myReader.GetString(4) == "MONITOR_GROUP")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MONITOR_GROUP;
                        }
                        else if (myReader.GetString(4) == "RING_GROUP")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.RING_GROUP;
                        }
                        else if (myReader.GetString(4) == "CONFERENCE_ROOM")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CONFERENCE_ROOM;
                        }
                        else if (myReader.GetString(4) == "PLUGIN_ROUTINE")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.PLUGIN_ROUTINE;
                        }
                        else if (myReader.GetString(4) == "CALL_FORWARDING")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CALL_FORWARDING;
                        }
                        else if (myReader.GetString(4) == "MUSIC_SERVER")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MUSIC_SERVER;
                        }
                        else if (myReader.GetString(4) == "ECHO_TEST")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ECHO_TEST;
                        }
                        else if (myReader.GetString(4) == "OPENAI_NODE")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.OPENAI_NODE;
                        }

                        dp.DestAddress = myReader.GetString(5);
                        dp.OutboundPreStrip = myReader.GetString(6);
                        dp.OutboundPrepend = myReader.GetString(7);

                        //2016-06-17 decided to use 0xff, 0xff00, and 0xff0000 for alternative sip account
                        int acct = myReader.GetInt32(8);

                        dp.OutboundSIPAcct = acct & 0xff;
                        dp.OutboundSIPAcct1 = (acct & 0xff00) >> 8;
                        dp.OutboundSIPAcct2 = (acct & 0xff0000) >> 16;

                        dp.OutboundCallerID = myReader.GetString(9);
                        dp.ExtenPriorityLevel = Convert.ToUInt32(myReader.GetInt32(10));
                        dp.TimeLimited = myReader.GetByte(11) == 1;
                        dp.TimeStartHour = myReader.GetInt32(12);
                        dp.TimeStartMinute = myReader.GetInt32(13);
                        dp.TimeEndHour = myReader.GetInt32(14);
                        dp.TimeEndMinute = myReader.GetInt32(15);
                        for (int j = 0; j < 7; j++)
                        {
                            int bitFlag = 1 << j;
                            if ((myReader.GetInt32(16) & bitFlag) == bitFlag)
                                dp.TimeDays[j] = 1;
                            else
                                dp.TimeDays[j] = 0;
                        }

                        char[] delimiters = new char[] { ';', ',', ' ' };

                        int mbType = 0;
                        string strExtnList = myReader.GetString(17);
                        if (strExtnList.Contains("agt:"))
                        {
                            mbType = 1;
                            strExtnList = strExtnList.Substring(4);
                        }

                        string[] members = strExtnList.Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        if (members.Length > 0)
                        {
                            dp.MemberList = new PBXMemberList();
                            dp.MemberList.mb_type = mbType;
                            for (int i = 0; i < members.Length; i++)
                            {
                                dp.MemberList.members.Add(members[i]);
                            }
                        }
                        else
                        {
                            dp.MemberList = null;
                        }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (bChanged)
                {
                    db_set.ExcuteNonQuerySQL("DELETE FROM cfg_dialplans WHERE ModTag = 2", env);
                }

                db_set.ExcuteNonQuerySQL("UPDATE cfg_dialplans SET ModTag = 0 WHERE ModTag = 1", env);
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }


        public static bool RemoveDialPlanFromDB(SIPPBXDialPlan dp, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_dialplans SET ModTag=2 WHERE DialPlanName = '" + dp.planName + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddDialPlanToDB(SIPPBXDialPlan dp, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            int maxIndex = 0;
            try
            {
                string sqlstr = "SELECT MAX(DialPlanIndex) FROM cfg_dialplans";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        maxIndex = myReader.GetInt32(0); //When adding the first dialplan, it will have exception. So not logging out below
                    }
                }
                catch (Exception)
                {
                    //if (log != null) log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                maxIndex++;

                sqlstr = "INSERT INTO cfg_dialplans(DialPlanName, CallDirection, Caller, Called, CallPlan, DestAddress, OutboundPreStrip, OutboundPrepend, OutboundSIPAcct, OutboundCallerID, ExtenPriorityLevel, TimeLimited, TimeStartHour, TimeStartMinute, TimeEndHour, TimeEndMinute, TimeDay, ExtenMembers, ModTag, DialPlanIndex) VALUES('" + dp.planName + "', ";

                sqlstr += (dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND) ? "0, " : "1, ";
                sqlstr += "'" + dp.CallerID + "', ";
                sqlstr += "'" + dp.CalledID + "', ";

                if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.AUTO_ATTENDANT)
                {
                    sqlstr += "'AUTO_ATTENDANT', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ACD_QUEUE)
                {
                    sqlstr += "'ACD_QUEUE', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.VOICE_MAIL_BOX)
                {
                    sqlstr += "'VOICE_MAIL_BOX', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION)
                {
                    sqlstr += "'DIAL_EXTENSION', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DO_NOT_DISTURB)
                {
                    sqlstr += "'DO_NOT_DISTURB', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MONITOR_GROUP)
                {
                    sqlstr += "'MONITOR_GROUP', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.RING_GROUP)
                {
                    sqlstr += "'RING_GROUP', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CONFERENCE_ROOM)
                {
                    sqlstr += "'CONFERENCE_ROOM', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.PLUGIN_ROUTINE)
                {
                    sqlstr += "'PLUGIN_ROUTINE', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CALL_FORWARDING)
                {
                    sqlstr += "'CALL_FORWARDING', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MUSIC_SERVER)
                {
                    sqlstr += "'MUSIC_SERVER', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ECHO_TEST)
                {
                    sqlstr += "'ECHO_TEST', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.OPENAI_NODE)
                {
                    sqlstr += "'OPENAI_NODE', ";
                }
                else
                {
                    sqlstr += "'', ";
                }

                sqlstr += "'" + dp.DestAddress + "', ";
                sqlstr += "'" + dp.OutboundPreStrip + "', ";
                sqlstr += "'" + dp.OutboundPrepend + "', ";

                //2016-06-16 Used multiple sip accounts for a dialplan
                int acct = dp.OutboundSIPAcct | (dp.OutboundSIPAcct1 << 8) | (dp.OutboundSIPAcct2 << 16);
                sqlstr += "'" + acct.ToString() + "', ";

                sqlstr += "'" + dp.OutboundCallerID  + "', ";
                sqlstr += dp.ExtenPriorityLevel.ToString() + ", ";
                sqlstr += dp.TimeLimited ? "1, " : "0, ";
                sqlstr += dp.TimeStartHour.ToString() + ", ";
                sqlstr += dp.TimeStartMinute.ToString() + ", ";
                sqlstr += dp.TimeEndHour.ToString() + ", ";
                sqlstr += dp.TimeEndMinute.ToString() + ", ";

                int bitValue = 0;
                for (int j = 0; j < 7; j++)
                {
                    int bitFlag = 1 << j;
                    if (dp.TimeDays[j] == 1)
                        bitValue |= bitFlag;
                }
                sqlstr += bitValue.ToString() + ", ";


                string memlist = "";
                if (dp.MemberList != null)
                {
                    for (int i = 0; i < dp.MemberList.members.Count; i++)
                    {
                        memlist += dp.MemberList.members[i];
                        if (i != dp.MemberList.members.Count - 1)
                            memlist += ";";
                    }

                    if (dp.MemberList.mb_type == 1) //agent
                    {
                        memlist = "agt:" + memlist;
                    }
                }
                sqlstr += "'" + memlist + "', ";
                sqlstr += " 1, " + maxIndex.ToString() + ")";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool ExchangeDialPlanInDB(SIPPBXDialPlan dp, SIPPBXDialPlan dp1, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            int idx1 = 0;
            int idx2 = 0;
            int cnt = 0;
            try
            {
                string sqlstr = "SELECT DialPlanName, DialPlanIndex FROM cfg_dialplans WHERE DialPlanName = '" + dp.planName + "' OR DialPlanName = '" + dp1.planName + "'";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        cnt++;
                        if (myReader.GetString(0) == dp.planName)
                        {
                            idx1 = myReader.GetInt32(1);
                        }
                        else if (myReader.GetString(0) == dp1.planName)
                        {
                            idx2 = myReader.GetInt32(1);
                        }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (cnt == 2)
                {
                    sqlstr = "UPDATE cfg_dialplans SET DialPlanIndex = " + idx1.ToString() + " WHERE DialPlanName = '" + dp1.planName + "'";
                    db_set.ExcuteNonQuerySQL(sqlstr, env);

                    sqlstr = "UPDATE cfg_dialplans SET DialPlanIndex = " + idx2.ToString() + " WHERE DialPlanName = '" + dp.planName + "'";
                    db_set.ExcuteNonQuerySQL(sqlstr, env);
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }


            return true;
        }

        public static bool UpdateDialPlanInDB(SIPPBXDialPlan dp, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log/*, string dpName*/)
        {
            string sqlstr = "";
            try
            {
                sqlstr = "UPDATE cfg_dialplans SET ";

                //if (dpName.Length > 0) sqlstr += "DialPlanName=" + "'" + dp.planName + "', ";

                sqlstr += "CallDirection=" + ((dp.CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND) ? "0, " : "1, ");
                sqlstr += "Caller=" + "'" + dp.CallerID + "', ";
                sqlstr += "Called=" + "'" + dp.CalledID + "', ";

                sqlstr += "CallPlan=";
                if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.AUTO_ATTENDANT)
                {
                    sqlstr += "'AUTO_ATTENDANT', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ACD_QUEUE)
                {
                    sqlstr += "'ACD_QUEUE', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.VOICE_MAIL_BOX)
                {
                    sqlstr += "'VOICE_MAIL_BOX', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION)
                {
                    sqlstr += "'DIAL_EXTENSION', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DO_NOT_DISTURB)
                {
                    sqlstr += "'DO_NOT_DISTURB', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MONITOR_GROUP)
                {
                    sqlstr += "'MONITOR_GROUP', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.RING_GROUP)
                {
                    sqlstr += "'RING_GROUP', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CONFERENCE_ROOM)
                {
                    sqlstr += "'CONFERENCE_ROOM', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.PLUGIN_ROUTINE)
                {
                    sqlstr += "'PLUGIN_ROUTINE', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CALL_FORWARDING)
                {
                    sqlstr += "'CALL_FORWARDING', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MUSIC_SERVER)
                {
                    sqlstr += "'MUSIC_SERVER', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ECHO_TEST)
                {
                    sqlstr += "'ECHO_TEST', ";
                }
                else if (dp.CallPlan == SIPPBXDialPlan.DIALPLAN_CALL_PLAN.OPENAI_NODE)
                {
                    sqlstr += "'OPENAI_NODE', ";
                }
                else
                {
                    sqlstr += "'', ";
                }

                sqlstr += "DestAddress=" + "'" + dp.DestAddress + "', ";
                sqlstr += "OutboundPreStrip=" + "'" + dp.OutboundPreStrip + "', ";
                sqlstr += "OutboundPrepend=" + "'" + dp.OutboundPrepend + "', ";

                //2016-06-16 Used multiple sip accounts for a dialplan
                int acct = dp.OutboundSIPAcct | (dp.OutboundSIPAcct1 << 8) | (dp.OutboundSIPAcct2 << 16);
                sqlstr += "OutboundSIPAcct=" + "'" + acct.ToString() + "', ";

                sqlstr += "OutboundCallerID=" + "'" + dp.OutboundCallerID + "', ";
                sqlstr += "ExtenPriorityLevel=" + dp.ExtenPriorityLevel.ToString() + ", ";
                sqlstr += "TimeLimited=" + (dp.TimeLimited ? "1, " : "0, ");
                sqlstr += "TimeStartHour=" + dp.TimeStartHour.ToString() + ", ";
                sqlstr += "TimeStartMinute=" + dp.TimeStartMinute.ToString() + ", ";
                sqlstr += "TimeEndHour=" + dp.TimeEndHour.ToString() + ", ";
                sqlstr += "TimeEndMinute=" + dp.TimeEndMinute.ToString() + ", ";

                int bitValue = 0;
                for (int j = 0; j < 7; j++)
                {
                    int bitFlag = 1 << j;
                    if (dp.TimeDays[j] == 1)
                        bitValue |= bitFlag;
                }
                sqlstr += "TimeDay=" + bitValue.ToString() + ", ";


                string memlist = "";
                if (dp.MemberList != null)
                {
                    for (int i = 0; i < dp.MemberList.members.Count; i++)
                    {
                        memlist += dp.MemberList.members[i];
                        if (i != dp.MemberList.members.Count - 1)
                            memlist += ";";
                    }

                    if (dp.MemberList.mb_type == 1) //agent
                    {
                        memlist = "agt:" + memlist;
                    }
                }
                sqlstr += "ExtenMembers=" + "'" + memlist + "', ";

                sqlstr += "ModTag=1 ";

                //if(dpName.Length > 0)
                //    sqlstr += "WHERE DialPlanName = '" + dpName + "'";
                //else
                    sqlstr += "WHERE DialPlanName = '" + dp.planName + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                {
                    log.LogoutText(sqlstr);
                    log.LogoutText(e.ToString());
                }
            }

            return false;
        }

        public static void LoadDialplansConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.sip_dialplan.Clear();

            try
            {
                db_set.ExcuteNonQuerySQL("DELETE FROM cfg_dialplans WHERE ModTag = 2", env);

                string sqlstr = "SELECT DialPlanName, CallDirection, Caller, Called, CallPlan, DestAddress, OutboundPreStrip, OutboundPrepend, OutboundSIPAcct, OutboundCallerID, ExtenPriorityLevel, TimeLimited, TimeStartHour, TimeStartMinute, TimeEndHour, TimeEndMinute, TimeDay, ExtenMembers, ModTag, DialPlanIndex FROM cfg_dialplans ORDER BY DialPlanIndex ASC";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXDialPlan dp = new SIPPBXDialPlan();

                        dp.planName = myReader.GetString(0);
                        if (myReader.GetInt16(1) == 0)
                            dp.CallDirection = SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND;
                        else
                            dp.CallDirection = SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_OUTBOUND;

                        dp.CallerID = myReader.GetString(2);
                        dp.CalledID = myReader.GetString(3);

                        if (myReader.GetString(4) == "AUTO_ATTENDANT")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.AUTO_ATTENDANT;
                        }
                        else if (myReader.GetString(4) == "VOICE_MAIL_BOX")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.VOICE_MAIL_BOX;
                        }
                        else if (myReader.GetString(4) == "ACD_QUEUE")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ACD_QUEUE;
                        }
                        else if (myReader.GetString(4) == "DIAL_EXTENSION")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DIAL_EXTENSION;
                        }
                        else if (myReader.GetString(4) == "DO_NOT_DISTURB")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.DO_NOT_DISTURB;
                        }
                        else if (myReader.GetString(4) == "MONITOR_GROUP")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MONITOR_GROUP;
                        }
                        else if (myReader.GetString(4) == "RING_GROUP")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.RING_GROUP;
                        }
                        else if (myReader.GetString(4) == "CONFERENCE_ROOM")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CONFERENCE_ROOM;
                        }
                        else if (myReader.GetString(4) == "PLUGIN_ROUTINE")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.PLUGIN_ROUTINE;
                        }
                        else if (myReader.GetString(4) == "CALL_FORWARDING")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.CALL_FORWARDING;
                        }
                        else if (myReader.GetString(4) == "MUSIC_SERVER")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.MUSIC_SERVER;
                        }
                        else if (myReader.GetString(4) == "ECHO_TEST")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.ECHO_TEST;
                        }
                        else if (myReader.GetString(4) == "OPENAI_NODE")
                        {
                            dp.CallPlan = SIPPBXDialPlan.DIALPLAN_CALL_PLAN.OPENAI_NODE;
                        }

                        dp.DestAddress = myReader.GetString(5);
                        dp.OutboundPreStrip = myReader.GetString(6);
                        dp.OutboundPrepend = myReader.GetString(7);

                        int acct = myReader.GetInt32(8);
                        dp.OutboundSIPAcct = acct & 0xff;
                        dp.OutboundSIPAcct1 = (acct & 0xff00) >> 8;
                        dp.OutboundSIPAcct2 = (acct & 0xff0000) >> 16;

                        dp.OutboundCallerID = myReader.GetString(9);
                        dp.ExtenPriorityLevel = Convert.ToUInt32(myReader.GetInt32(10));
                        dp.TimeLimited = myReader.GetByte(11) == 1;
                        dp.TimeStartHour = myReader.GetInt32(12);
                        dp.TimeStartMinute = myReader.GetInt32(13);
                        dp.TimeEndHour = myReader.GetInt32(14);
                        dp.TimeEndMinute = myReader.GetInt32(15);
                        for (int j = 0; j < 7; j++)
                        {
                            int bitFlag = 1 << j;
                            if ((myReader.GetInt32(16) & bitFlag) == bitFlag)
                                dp.TimeDays[j] = 1;
                            else
                                dp.TimeDays[j] = 0;
                        }

                        string strExtnList = myReader.GetString(17);
                        int mbType = 0;
                        if (strExtnList.Contains("agt:"))
                        {
                            mbType = 1;
                            strExtnList = strExtnList.Substring(4);
                        }

                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = strExtnList.Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        if (members.Length > 0)
                        {
                            dp.MemberList = new PBXMemberList();
                            dp.MemberList.mb_type = mbType;
                            for (int i = 0; i < members.Length; i++)
                            {
                                dp.MemberList.members.Add(members[i]);
                            }
                        }

                        pbx.sip_dialplan.Add(dp);

                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                db_set.ExcuteNonQuerySQL("UPDATE cfg_dialplans SET ModTag = 0", env);
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshACDConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            bool bChanged = false;

            try
            {
                string sqlstr = "SELECT Name, Type, PlayMOH, MOHDir, DialplanDTMF, DialplanName, WaitTimeout, WaitTimeoutTo, VMBDTMF, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, AgentType, Agents, ModTag, VMBPassword, MaxNumOfCalls, CallForwardingType, CallForwardingPlan, PromptQueuePosition FROM cfg_huntgroups WHERE ModTag != 0";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        bChanged = true;

                        SIPPBXACDHuntGroup hg = pbx.getACDByName(myReader.GetString(0));

                        if (myReader.GetInt16(15) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (hg != null)
                            {
                                pbx.sip_huntgroups.Remove(hg);
                            }

                            bChanged = true;
                            continue;
                        }

                        if (hg == null)
                        {
                            hg = new SIPPBXACDHuntGroup();
                            hg.hgName = myReader.GetString(0);
                            hg.bUseGroupName = pbx.use_gpname_as_dispname;
                            pbx.sip_huntgroups.Add(hg);
                            bChanged = true;
                        }

                        hg.hgType = myReader.GetInt32(1);
                        hg.playMOH = (myReader.GetByte(2) == 1);
                        hg.mohDir = myReader.GetString(3);
                        hg.dpDTMF = myReader.GetString(4);
                        hg.dpName = myReader.GetString(5);
                        hg.waitTimeout = myReader.GetInt32(6);
                        hg.waitTimeoutTo = myReader.GetString(7);
                        hg.vmbDTMF = myReader.GetString(8);

                        if (myReader.GetByte(9) == 1)
                        {
                            hg.vmb = new VoiceMailBox();
                            hg.vmb.vmbPrompt = myReader.GetString(10);
                            hg.vmb.vmbEmailAddr = myReader.GetString(11);
                            hg.vmb.maxLengthInSecond = myReader.GetInt32(12);
                            hg.vmb.vmbPassword = myReader.GetString(16);
                        }
                        else
                        {
                            hg.vmb = null;
                        }

                        hg.agentType = myReader.GetInt32(13);

                        hg.agents.Clear();
                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = myReader.GetString(14).Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        for (int i = 0; i < members.Length; i++)
                        {
                            hg.agents.Add(members[i]);
                        }

                        hg.maxNumOfCalls = myReader.GetInt32(17);
                        hg.callForwardingType = myReader.GetInt16(18);
                        hg.callForwardingPlan = myReader.GetString(19);
                        hg.promptQueuePosition = myReader.GetInt16(20) == 1;
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (bChanged)
                {
                    db_set.ExcuteNonQuerySQL("DELETE FROM cfg_huntgroups WHERE ModTag = 2", env);
                }

                db_set.ExcuteNonQuerySQL("UPDATE cfg_huntgroups SET ModTag = 0 WHERE ModTag = 1", env);

                if(bChanged)
                    SIPPBXDBUtil.InitACDStatusTable(pbx, env, db_set);
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static bool RemoveACDConfigFromDB(SIPPBXACDHuntGroup hg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_huntgroups SET ModTag=2 WHERE Name = '" + hg.hgName + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddACDConfigToDB(SIPPBXACDHuntGroup hg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "INSERT INTO cfg_huntgroups(Name, Type, PlayMOH, MOHDir, DialplanDTMF, DialplanName, WaitTimeout, WaitTimeoutTo, VMBDTMF, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, VMBPassword, AgentType, Agents, ModTag, MaxNumOfCalls, CallForwardingType, CallForwardingPlan, PromptQueuePosition) VALUES('" + hg.hgName + "', ";
                sqlstr += hg.hgType.ToString() + ", ";
                sqlstr += hg.playMOH ? "1, " : "0, ";
                sqlstr += "'" + hg.mohDir + "', ";
                sqlstr += "'" + hg.dpDTMF + "', ";
                sqlstr += "'" + hg.dpName + "', ";
                sqlstr += hg.waitTimeout.ToString() + ", ";
                sqlstr += "'" + hg.waitTimeoutTo + "', ";
                sqlstr += "'" + hg.vmbDTMF + "', ";

                if (hg.vmb != null)
                {
                    sqlstr += "1, ";
                    sqlstr += "'" + hg.vmb.vmbPrompt + "', ";
                    sqlstr += "'" + hg.vmb.vmbEmailAddr + "', ";
                    sqlstr += hg.vmb.maxLengthInSecond.ToString() + ", ";
                    sqlstr += "'" + hg.vmb.vmbPassword + "', ";
                }
                else
                {
                    sqlstr += "0, ";
                    sqlstr += "'', ";
                    sqlstr += "'', ";
                    sqlstr += "0, '', ";
                }

                sqlstr += hg.agentType.ToString() + ", ";

                string agents = "";
                for (int i = 0; i < hg.agents.Count; i++)
                {
                    agents += hg.agents[i];
                    if (i != hg.agents.Count - 1)
                        agents += ";";
                }

                sqlstr += "'" + agents + "', 1, ";
                sqlstr += hg.maxNumOfCalls.ToString() + ", ";
                sqlstr += hg.callForwardingType.ToString() + ", '";
                sqlstr += hg.callForwardingPlan + "', ";
                sqlstr += hg.promptQueuePosition ? "1" : "0";
                sqlstr += ")";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateACDConfigInDB(SIPPBXACDHuntGroup hg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_huntgroups SET ";

                sqlstr += "Type=" + hg.hgType.ToString() + ", ";
                sqlstr += "PlayMOH=" + (hg.playMOH ? "1, " : "0, ");
                sqlstr += "MOHDir=" + "'" + hg.mohDir + "', ";
                sqlstr += "DialplanDTMF=" + "'" + hg.dpDTMF + "', ";
                sqlstr += "DialplanName=" + "'" + hg.dpName + "', ";
                sqlstr += "WaitTimeout=" + hg.waitTimeout.ToString() + ", ";
                sqlstr += "WaitTimeoutTo=" + "'" + hg.waitTimeoutTo + "', ";
                sqlstr += "VMBDTMF=" + "'" + hg.vmbDTMF + "', ";

                sqlstr += "VMBOn=" + ((hg.vmb != null) ? "1, " : "0, ");
                sqlstr += "VMBPrompt=" + "'" + ((hg.vmb != null) ? hg.vmb.vmbPrompt : "") + "', ";
                sqlstr += "VMBEmail=" + "'" + ((hg.vmb != null) ? hg.vmb.vmbEmailAddr : "") + "', ";
                sqlstr += "VMBMaxLength=" + ((hg.vmb != null) ? hg.vmb.maxLengthInSecond.ToString() : "0") + ", ";
                sqlstr += "VMBPassword='" + ((hg.vmb != null) ? hg.vmb.vmbPassword : "") + "', ";

                sqlstr += "AgentType=" + hg.agentType.ToString() + ", ";

                string agents = "";
                for (int i = 0; i < hg.agents.Count; i++)
                {
                    agents += hg.agents[i];
                    if (i != hg.agents.Count - 1)
                        agents += ";";
                }

                sqlstr += "Agents='" + agents + "', ModTag=1, ";
                sqlstr += "MaxNumOfCalls=" + hg.maxNumOfCalls.ToString() +", ";
                sqlstr += "CallForwardingType=" + hg.callForwardingType.ToString() +", ";
                sqlstr += "CallForwardingPlan='" + hg.callForwardingPlan +"', ";
                sqlstr += "PromptQueuePosition=" + (hg.promptQueuePosition ? "1 " : "0 ");
                sqlstr += "WHERE Name = '" + hg.hgName + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadACDConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.sip_huntgroups.Clear();

            try
            {
                string sqlstr = "DELETE FROM cfg_huntgroups WHERE ModTag = 2";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "SELECT Name, Type, PlayMOH, MOHDir, DialplanDTMF, DialplanName, WaitTimeout, WaitTimeoutTo, VMBDTMF, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, AgentType, Agents, VMBPassword, ModTag, MaxNumOfCalls, CallForwardingType, CallForwardingPlan, PromptQueuePosition FROM cfg_huntgroups";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXACDHuntGroup hg = new SIPPBXACDHuntGroup();
                        hg.bUseGroupName = pbx.use_gpname_as_dispname;

                        hg.hgName = myReader.GetString(0);
                        hg.hgType = myReader.GetInt32(1);
                        hg.playMOH = (myReader.GetByte(2) == 1);
                        hg.mohDir = myReader.GetString(3);
                        hg.dpDTMF = myReader.GetString(4);
                        hg.dpName = myReader.GetString(5);
                        hg.waitTimeout = myReader.GetInt32(6);
                        hg.waitTimeoutTo = myReader.GetString(7);
                        hg.vmbDTMF = myReader.GetString(8);

                        if (myReader.GetByte(9) == 1)
                        {
                            hg.vmb = new VoiceMailBox();
                            hg.vmb.vmbPrompt = myReader.GetString(10);
                            hg.vmb.vmbEmailAddr = myReader.GetString(11);
                            hg.vmb.maxLengthInSecond = myReader.GetInt32(12);
                            hg.vmb.vmbPassword = myReader.GetString(15);
                        }
                        else
                        {
                            hg.vmb = null;
                        }

                        hg.agentType = myReader.GetInt32(13);

                        hg.agents.Clear();
                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = myReader.GetString(14).Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        for (int i = 0; i < members.Length; i++)
                        {
                            hg.agents.Add(members[i]);
                        }

                        hg.maxNumOfCalls = myReader.GetInt32(17);
                        hg.callForwardingType = myReader.GetInt16(18);
                        hg.callForwardingPlan = myReader.GetString(19);
                        hg.promptQueuePosition = myReader.GetInt16(20) == 1;

                        pbx.sip_huntgroups.Add(hg);

                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                db_set.ExcuteNonQuerySQL("UPDATE cfg_huntgroups SET ModTag = 0", env);
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshParkingSlotConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            bool bChanged = false;

            try
            {
                string sqlstr = "SELECT Name, DTMFStr, PlayMOH, MOHDir, DialplanDTMF, DialplanName, WaitTimeout, WaitTimeoutTo, VMBDTMF, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, VMBPassword, ModTag FROM cfg_parkingslots WHERE ModTag != 0";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXParkingSlot ps = pbx.getParkingSlotByName(myReader.GetString(0));

                        if (myReader.GetInt16(14) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (ps != null)
                            {
                                pbx.sip_parkingslots.Remove(ps);
                            }

                            bChanged = true;
                            continue;
                        }

                        if (ps == null)
                        {
                            ps = new SIPPBXParkingSlot();
                            ps.psName = myReader.GetString(0);
                            pbx.sip_parkingslots.Add(ps);

                            bChanged = true;
                        }

                        ps.psDTMF = myReader.GetString(1);
                        ps.playMOH = (myReader.GetByte(2) == 1);
                        ps.mohDir = myReader.GetString(3);
                        ps.dpDTMF = myReader.GetString(4);
                        ps.dpName = myReader.GetString(5);
                        ps.waitTimeout = myReader.GetInt32(6);
                        ps.waitTimeoutTo = myReader.GetString(7);
                        ps.vmbDTMF = myReader.GetString(8);

                        if (myReader.GetByte(9) == 1)
                        {
                            ps.vmb = new VoiceMailBox();
                            ps.vmb.vmbPrompt = myReader.GetString(10);
                            ps.vmb.vmbEmailAddr = myReader.GetString(11);
                            ps.vmb.maxLengthInSecond = myReader.GetInt32(12);
                            ps.vmb.vmbPassword = myReader.GetString(13);
                        }
                        else
                        {
                            ps.vmb = null;
                        }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (bChanged)
                {
                    db_set.ExcuteNonQuerySQL("DELETE FROM cfg_parkingslots WHERE ModTag = 2", env);

                    SIPPBXDBUtil.InitParkingSlotStatusTable(pbx, env, db_set);
                }

                db_set.ExcuteNonQuerySQL("UPDATE cfg_parkingslots SET ModTag = 0 WHERE ModTag = 1", env);

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveParkingSlotFromDB(SIPPBXParkingSlot ps, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_parkingslots SET ModTag=2 WHERE Name = '" + ps.psName + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddParkingSlotToDB(SIPPBXParkingSlot ps, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "INSERT INTO cfg_parkingslots(Name, DTMFStr, PlayMOH, MOHDir, DialplanDTMF, DialplanName, WaitTimeout, WaitTimeoutTo, VMBDTMF, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, VMBPassword, ModTag) VALUES('" + ps.psName + "', ";
                sqlstr += "'" + ps.psDTMF + "', ";
                sqlstr += ps.playMOH ? "1, " : "0, ";
                sqlstr += "'" + ps.mohDir + "', ";
                sqlstr += "'" + ps.dpDTMF + "', ";
                sqlstr += "'" + ps.dpName + "', ";
                sqlstr += ps.waitTimeout.ToString() + ", ";
                sqlstr += "'" + ps.waitTimeoutTo + "', ";
                sqlstr += "'" + ps.vmbDTMF + "', ";
                sqlstr += (ps.vmb != null) ? "1, " : "0, ";

                if (ps.vmb != null)
                {
                    sqlstr += "'" + ps.vmb.vmbPrompt + "', ";
                    sqlstr += "'" + ps.vmb.vmbEmailAddr + "', ";
                    sqlstr += ps.vmb.maxLengthInSecond.ToString() + ", '";
                    sqlstr += ps.vmb.vmbPassword + "', 1)";
                }
                else
                {
                    sqlstr += "'', ";
                    sqlstr += "'', ";
                    sqlstr += "0, '', 1)";
                }

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateParkingSlotInDB(SIPPBXParkingSlot ps, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_parkingslots SET ";

                sqlstr += "DTMFStr=" + "'" + ps.psDTMF + "', ";
                sqlstr += "PlayMOH=" + (ps.playMOH ? "1, " : "0, ");
                sqlstr += "MOHDir=" + "'" + ps.mohDir + "', ";
                sqlstr += "DialplanDTMF=" + "'" + ps.dpDTMF + "', ";
                sqlstr += "DialplanName=" + "'" + ps.dpName + "', ";
                sqlstr += "WaitTimeout=" + ps.waitTimeout.ToString() + ", ";
                sqlstr += "WaitTimeoutTo=" + "'" + ps.waitTimeoutTo + "', ";
                sqlstr += "VMBDTMF=" + "'" + ps.vmbDTMF + "', ";
                sqlstr += "VMBOn=" + ((ps.vmb != null) ? "1, " : "0, ");

                if (ps.vmb != null)
                {
                    sqlstr += "VMBPrompt=" + "'" + ps.vmb.vmbPrompt + "', ";
                    sqlstr += "VMBEmail=" + "'" + ps.vmb.vmbEmailAddr + "', ";
                    sqlstr += "VMBMaxLength=" + ps.vmb.maxLengthInSecond.ToString() + ", ";
                    sqlstr += "VMBPassword='" + ps.vmb.vmbPassword + "', ModTag=1 ";
                }
                else
                {
                    sqlstr += "VMBPrompt='', ";
                    sqlstr += "VMBEmail='', ";
                    sqlstr += "VMBMaxLength=0, VMBPassword='', ModTag=1 ";
                }

                sqlstr += " WHERE Name = '" + ps.psName + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadParkingSlotConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.sip_parkingslots.Clear();

            try
            {
                db_set.ExcuteNonQuerySQL("DELETE FROM cfg_parkingslots WHERE ModTag = 2", env);

                string sqlstr = "SELECT Name, DTMFStr, PlayMOH, MOHDir, DialplanDTMF, DialplanName, WaitTimeout, WaitTimeoutTo, VMBDTMF, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, VMBPassword, ModTag FROM cfg_parkingslots";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXParkingSlot ps = new SIPPBXParkingSlot();

                        ps.psName = myReader.GetString(0);
                        ps.psDTMF = myReader.GetString(1);
                        ps.playMOH = (myReader.GetByte(2) == 1);
                        ps.mohDir = myReader.GetString(3);
                        ps.dpDTMF = myReader.GetString(4);
                        ps.dpName = myReader.GetString(5);
                        ps.waitTimeout = myReader.GetInt32(6);
                        ps.waitTimeoutTo = myReader.GetString(7);
                        ps.vmbDTMF = myReader.GetString(8);

                        if (myReader.GetByte(9) == 1)
                        {
                            ps.vmb = new VoiceMailBox();
                            ps.vmb.vmbPrompt = myReader.GetString(10);
                            ps.vmb.vmbEmailAddr = myReader.GetString(11);
                            ps.vmb.maxLengthInSecond = myReader.GetInt32(12);
                            ps.vmb.vmbPassword = myReader.GetString(13);
                        }
                        else
                        {
                            ps.vmb = null;
                        }

                        pbx.sip_parkingslots.Add(ps);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (db_set.ExcuteNonQuerySQL("UPDATE cfg_parkingslots SET ModTag = 0", env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshRingGroupConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            bool bChanged = false;
            SIPPBXRingGroup rg = null;

            List<SIPPBXRingGroup> tempListRingGroup = new List<SIPPBXRingGroup>();

            try
            {
                string sqlstr = "SELECT Name, Type, PlayMOH, MOHDir, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, VMBPassword, AnswerCallFirst, ModTag FROM cfg_ringgroups WHERE ModTag != 0";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        rg = pbx.getRingGroupByName(myReader.GetString(0));

                        if (myReader.GetInt16(10) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (rg != null)
                                pbx.sip_ringgroups.Remove(rg);

                            bChanged = true;
                            continue;
                        }

                        if (rg == null)
                        {
                            rg = new SIPPBXRingGroup();
                            rg.gpName = myReader.GetString(0);
                            rg.bUseGroupName = pbx.use_gpname_as_dispname;
                            pbx.sip_ringgroups.Add(rg);

                            bChanged = true;
                        }

                        rg.ringType = myReader.GetInt32(1);
                        rg.playMOH = (myReader.GetByte(2) == 1);
                        rg.mohDir = myReader.GetString(3);
                        rg.bAnswerCallFirst = (myReader.GetByte(9) == 1);

                        if (myReader.GetByte(4) == 1)
                        {
                            rg.vmb = new VoiceMailBox();
                            rg.vmb.vmbPrompt = myReader.GetString(5);
                            rg.vmb.vmbEmailAddr = myReader.GetString(6);
                            rg.vmb.maxLengthInSecond = myReader.GetInt32(7);
                            rg.vmb.vmbPassword = myReader.GetString(8);
                        }
                        else
                        {
                            rg.vmb = null;
                        }

                        tempListRingGroup.Add(rg);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (tempListRingGroup.Count > 0)
                {
                    for (int i = 0; i < tempListRingGroup.Count; i++)
                    {
                        rg = tempListRingGroup[i];

                        rg.destList.Clear();

                        sqlstr = "SELECT * FROM cfg_dests WHERE BelongTo = '" + rg.gpName + "'";
                        myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                        try
                        {
                            while (myReader.Read())
                            {
                                SIPPBXDest dest = new SIPPBXDest();

                                dest.DestType = myReader.GetInt32(0);
                                dest.DestAddr = myReader.GetString(1);
                                dest.RingTimeout = myReader.GetInt32(2);

                                rg.destList.Add(dest);
                            }
                        }
                        catch (Exception e)
                        {
                            if (log != null)
                                log.LogoutText(e.ToString());
                        }
                        finally
                        {
                            myReader.Close();
                        }
                    }
                }

                if (bChanged)
                {
                    sqlstr = "DELETE FROM cfg_ringgroups WHERE ModTag = 2";
                    if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    {
                    }
                }

                sqlstr = "UPDATE cfg_ringgroups SET ModTag = 0 WHERE ModTag = 1";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveRingGroupFromDB(SIPPBXRingGroup rg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_ringgroups SET ModTag=2 WHERE Name = '" + rg.gpName + "'";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    sqlstr = "DELETE FROM cfg_dests WHERE BelongTo = '" + rg.gpName + "'";
                    db_set.ExcuteNonQuerySQL(sqlstr, env);
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddRingGroupToDB(SIPPBXRingGroup rg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "INSERT INTO cfg_ringgroups(Name, Type, PlayMOH, MOHDir, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, VMBPassword, AnswerCallFirst, ModTag) VALUES('" + rg.gpName + "', ";

                sqlstr += rg.ringType.ToString() + ", ";
                sqlstr += rg.playMOH ? "1, " : "0, ";
                sqlstr += "'" + rg.mohDir + "', ";
                sqlstr += (rg.vmb != null) ? "1, " : "0, ";

                if (rg.vmb != null)
                {
                    sqlstr += "'" + rg.vmb.vmbPrompt + "', ";
                    sqlstr += "'" + rg.vmb.vmbEmailAddr + "', ";
                    sqlstr += rg.vmb.maxLengthInSecond.ToString() + ", '";
                    sqlstr += rg.vmb.vmbPassword + "', ";
                }
                else
                {
                    sqlstr += "'', ";
                    sqlstr += "'', ";
                    sqlstr += "0, '', ";
                }

                sqlstr += rg.bAnswerCallFirst ? "1, " : "0, ";

                sqlstr += "1)";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    sqlstr = "DELETE FROM cfg_dests WHERE BelongTo = '" + rg.gpName + "'";
                    db_set.ExcuteNonQuerySQL(sqlstr, env);

                    for (int i = 0; i < rg.destList.Count; i++)
                    {
                        sqlstr = "INSERT INTO cfg_dests VALUES(";
                        sqlstr += rg.destList[i].DestType.ToString() + ", ";
                        sqlstr += "'" + rg.destList[i].DestAddr + "', ";
                        sqlstr += rg.destList[i].RingTimeout.ToString() + ", ";
                        sqlstr += "'" + rg.gpName + "')";
                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) != 1)
                        {
                        }
                    }
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateRingGroupInDB(SIPPBXRingGroup rg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_ringgroups SET ";

                sqlstr += "Type=" + rg.ringType.ToString() + ", ";
                sqlstr += "PlayMOH=" + (rg.playMOH ? "1, " : "0, ");
                sqlstr += "MOHDir=" + "'" + rg.mohDir + "', ";
                sqlstr += "VMBOn=" + ((rg.vmb != null) ? "1, " : "0, ");

                if (rg.vmb != null)
                {
                    sqlstr += "VMBPrompt=" + "'" + rg.vmb.vmbPrompt + "', ";
                    sqlstr += "VMBEmail=" + "'" + rg.vmb.vmbEmailAddr + "', ";
                    sqlstr += "VMBMaxLength=" + rg.vmb.maxLengthInSecond.ToString() + ", ";
                    sqlstr += "VMBPassword='" + rg.vmb.vmbPassword + "', ";
                }
                else
                {
                    sqlstr += "VMBPrompt='', ";
                    sqlstr += "VMBEmail='', ";
                    sqlstr += "VMBMaxLength=0, ";
                    sqlstr += "VMBPassword='', ";
                }

                sqlstr += "AnswerCallFirst=" + (rg.bAnswerCallFirst ? "1, " : "0, ");

                sqlstr += " ModTag=1 WHERE Name = '" + rg.gpName + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    sqlstr = "DELETE FROM cfg_dests WHERE BelongTo = '" + rg.gpName + "'";
                    db_set.ExcuteNonQuerySQL(sqlstr, env);

                    for (int i = 0; i < rg.destList.Count; i++)
                    {
                        sqlstr = "INSERT INTO cfg_dests VALUES(";
                        sqlstr += rg.destList[i].DestType.ToString() + ", ";
                        sqlstr += "'" + rg.destList[i].DestAddr + "', ";
                        sqlstr += rg.destList[i].RingTimeout.ToString() + ", ";
                        sqlstr += "'" + rg.gpName + "')";
                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) != 1)
                        {
                        }
                    }

                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadRingGroupConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            SIPPBXRingGroup rg = null;
            List<SIPPBXRingGroup> tempListRingGroup = new List<SIPPBXRingGroup>();

            pbx.sip_ringgroups.Clear();

            try
            {
                db_set.ExcuteNonQuerySQL("DELETE FROM cfg_ringgroups WHERE ModTag = 2", env);

                string sqlstr = "SELECT Name, Type, PlayMOH, MOHDir, VMBOn, VMBPrompt, VMBEmail, VMBMaxLength, VMBPassword, AnswerCallFirst, ModTag FROM cfg_ringgroups";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        rg = new SIPPBXRingGroup();

                        rg.gpName = myReader.GetString(0);
                        rg.bUseGroupName = pbx.use_gpname_as_dispname;

                        rg.ringType = myReader.GetInt32(1);
                        rg.playMOH = (myReader.GetByte(2) == 1);
                        rg.mohDir = myReader.GetString(3);

                        if (myReader.GetByte(4) == 1)
                        {
                            rg.vmb = new VoiceMailBox();
                            rg.vmb.vmbPrompt = myReader.GetString(5);
                            rg.vmb.vmbEmailAddr = myReader.GetString(6);
                            rg.vmb.maxLengthInSecond = myReader.GetInt32(7);
                            rg.vmb.vmbPassword = myReader.GetString(8);
                        }
                        else
                        {
                            rg.vmb = null;
                        }

                        rg.bAnswerCallFirst = (myReader.GetByte(9) == 1);

                        tempListRingGroup.Add(rg);

                        pbx.sip_ringgroups.Add(rg);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (tempListRingGroup.Count > 0)
                {
                    for (int i = 0; i < tempListRingGroup.Count; i++)
                    {
                        rg = tempListRingGroup[i];

                        rg.destList.Clear();

                        sqlstr = "SELECT * FROM cfg_dests WHERE BelongTo = '" + rg.gpName + "'";
                        myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                        try
                        {
                            while (myReader.Read())
                            {
                                SIPPBXDest dest = new SIPPBXDest();

                                dest.DestType = myReader.GetInt32(0);
                                dest.DestAddr = myReader.GetString(1);
                                dest.RingTimeout = myReader.GetInt32(2);

                                rg.destList.Add(dest);
                            }
                        }
                        catch (Exception e)
                        {
                            if (log != null)
                                log.LogoutText(e.ToString());
                        }
                        finally
                        {
                            myReader.Close();
                        }
                    }
                }

                sqlstr = "UPDATE cfg_ringgroups SET ModTag = 0 WHERE ModTag != 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void UpdateLoadBalanceConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "DELETE FROM cfg_dests WHERE BelongTo = 'LoadBalance'";
                db_set.ExcuteNonQuerySQL(sqlstr, env);

                if (pbx.lb_on)
                {
                    for (int i = 0; i < pbx.lb_addrs.Count; i++)
                    {
                        sqlstr = "INSERT INTO cfg_dests VALUES(";
                        sqlstr += pbx.lb_addrs[i].DestType.ToString() + ", ";
                        sqlstr += "' " + pbx.lb_addrs[i].DestAddr + "', ";
                        sqlstr += pbx.lb_addrs[i].RingTimeout.ToString() + ", 'LoadBalance')";
                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                        {
                        }
                    }
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void LoadLoadBalanceConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.lb_addrs.Clear();

            try
            {
                string sqlstr = "SELECT * FROM cfg_dests WHERE BelongTo = 'LoadBalance'";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    if (myReader.HasRows)
                    {
                        pbx.lb_on = true;
                        while (myReader.Read())
                        {
                            SIPPBXDest dest = new SIPPBXDest();

                            dest.DestType = myReader.GetInt32(0);
                            dest.DestAddr = myReader.GetString(1);
                            dest.RingTimeout = myReader.GetInt32(2);

                            pbx.lb_addrs.Add(dest);
                        }
                    }
                    else
                    {
                        pbx.lb_on = false;
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshMonitorGroupConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            bool bChanged = false;

            try
            {
                string sqlstr = "SELECT Name, Number, PasswordPrompt, Password, KeyBargeIn, KeyBargeOut, KeyWhisper, ExtenPrompt, ExtenAll, Extensions, ModTag FROM cfg_monitorgroups WHERE ModTag != 0";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXMonitorGroup mg = pbx.getMonitorGroupByName(myReader.GetString(0));

                        if (myReader.GetInt16(10) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (mg != null)
                            {
                                pbx.sip_monitorgroups.Remove(mg);
                            }

                            bChanged = true;
                            continue;
                        }

                        if (mg == null)
                        {
                            mg = new SIPPBXMonitorGroup();
                            mg.mgName = myReader.GetString(0);
                            pbx.sip_monitorgroups.Add(mg);
                            bChanged = true;
                        }

                        mg.mgNumber = myReader.GetString(1);
                        mg.mgPasswordPrompt = myReader.GetString(2);
                        mg.mgPassword = myReader.GetString(3);
                        mg.mgKeyBargeIn = myReader.GetString(4);
                        mg.mgKeyOut = myReader.GetString(5);
                        mg.mgKeyWhisper = myReader.GetString(6);
                        mg.mgExtenPrompt = myReader.GetString(7);
                        mg.mgAllExtens = (myReader.GetByte(8) == 1);

                        mg.mgExtenList.Clear();
                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = myReader.GetString(9).Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        for (int i = 0; i < members.Length; i++)
                        {
                            mg.mgExtenList.Add(members[i]);
                        }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (bChanged)
                {
                    sqlstr = "DELETE FROM cfg_monitorgroups WHERE ModTag = 2";
                    if (db_set.ExcuteNonQuerySQL(sqlstr, env) >= 1)
                    {
                    }
                }

                sqlstr = "UPDATE cfg_monitorgroups SET ModTag = 0 WHERE ModTag = 1";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) >= 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveMonitorGroupFromDB(SIPPBXMonitorGroup mg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_monitorgroups SET ModTag=2 WHERE Name = '" + mg.mgName + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddMonitorGroupToDB(SIPPBXMonitorGroup mg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "INSERT INTO cfg_monitorgroups(Name, Number, PasswordPrompt, Password, KeyBargeIn, KeyBargeOut, KeyWhisper, ExtenPrompt, ExtenAll, Extensions, ModTag) VALUES('" + mg.mgName + "', ";
                sqlstr += "'" + mg.mgNumber + "', ";
                sqlstr += "'" + mg.mgPasswordPrompt + "', ";
                sqlstr += "'" + mg.mgPassword + "', ";
                sqlstr += "'" + mg.mgKeyBargeIn + "', ";
                sqlstr += "'" + mg.mgKeyOut + "', ";
                sqlstr += "'" + mg.mgKeyWhisper + "', ";
                sqlstr += "'" + mg.mgExtenPrompt + "', ";
                sqlstr += mg.mgAllExtens ? "1, " : "0, ";

                string sExtens = "";
                for (int i = 0; i < mg.mgExtenList.Count; i++)
                {
                    sExtens += mg.mgExtenList[i];
                    if (i != mg.mgExtenList.Count - 1)
                        sExtens += ";";
                }
                sqlstr += "'" + sExtens + "', ";

                sqlstr += "1)";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateMonitorGroupInDB(SIPPBXMonitorGroup mg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_monitorgroups SET ";

                sqlstr += "Number=" + "'" + mg.mgNumber + "', ";
                sqlstr += "PasswordPrompt=" + "'" + mg.mgPasswordPrompt + "', ";
                sqlstr += "Password=" + "'" + mg.mgPassword + "', ";
                sqlstr += "KeyBargeIn=" + "'" + mg.mgKeyBargeIn + "', ";
                sqlstr += "KeyBargeOut=" + "'" + mg.mgKeyOut + "', ";
                sqlstr += "KeyWhisper=" + "'" + mg.mgKeyWhisper + "', ";
                sqlstr += "ExtenPrompt=" + "'" + mg.mgExtenPrompt + "', ";
                sqlstr += "ExtenAll=" + (mg.mgAllExtens ? "1, " : "0, ");

                string sExtens = "";
                for (int i = 0; i < mg.mgExtenList.Count; i++)
                {
                    sExtens += mg.mgExtenList[i];
                    if (i != mg.mgExtenList.Count - 1)
                        sExtens += ";";
                }
                sqlstr += "Extensions='" + sExtens + "', ";

                sqlstr += " ModTag=1 WHERE Name = '" + mg.mgName + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }


        public static void LoadMonitorGroupConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.sip_monitorgroups.Clear();

            try
            {
                string sqlstr = "DELETE FROM cfg_monitorgroups WHERE ModTag = 2";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "SELECT Name, Number, PasswordPrompt, Password, KeyBargeIn, KeyBargeOut, KeyWhisper, ExtenPrompt, ExtenAll, Extensions, ModTag FROM cfg_monitorgroups";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXMonitorGroup mg = new SIPPBXMonitorGroup();

                        mg.mgExtenPrompt = pbx.please_enter_extension_number_dir;
                        mg.mgPasswordPrompt = pbx.please_enter_password_dir;

                        mg.mgName = myReader.GetString(0);
                        mg.mgNumber = myReader.GetString(1);
                        mg.mgPasswordPrompt = myReader.GetString(2);
                        mg.mgPassword = myReader.GetString(3);
                        mg.mgKeyBargeIn = myReader.GetString(4);
                        mg.mgKeyOut = myReader.GetString(5);
                        mg.mgKeyWhisper = myReader.GetString(6);
                        mg.mgExtenPrompt = myReader.GetString(7);
                        mg.mgAllExtens = (myReader.GetByte(8) == 1);

                        mg.mgExtenList.Clear();
                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = myReader.GetString(9).Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        for (int i = 0; i < members.Length; i++)
                        {
                            mg.mgExtenList.Add(members[i]);
                        }

                        pbx.sip_monitorgroups.Add(mg);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                sqlstr = "UPDATE cfg_monitorgroups SET ModTag = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshAgentsConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            bool bChanged = false;

            try
            {
                string sqlstr = "SELECT Name, Code, Password, RecordCall, AtExten, LogInTime, LogOutTime, ModTag, SkillLevel, Paused FROM cfg_agents WHERE ModTag != 0";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                while (myReader.Read())
                {
                    bChanged = true;

                    SIPPBXAgent agent = pbx.getAgentByCode(myReader.GetString(1));

                    if (myReader.GetInt16(7) == 2)
                    {
                        //ModTag == 2, need remove.
                        if (agent != null)
                        {
                            pbx.sip_agents.Remove(agent);
                        }

                        bChanged = true;
                        continue;
                    }

                    if (agent == null)
                    {
                        agent = new SIPPBXAgent();
                        agent.Code = myReader.GetString(1);
                        pbx.sip_agents.Add(agent);
                        bChanged = true;
                    }

                    agent.Name = myReader.GetString(0);
                    agent.Password = myReader.GetString(2);
                    agent.RecordCall = (myReader.GetByte(3) == 1);

                    string extn_username = myReader.GetString(4);
                    if (extn_username.Contains(";"))
                    {
                        char[] delimiters = new char[] { ';', ',', ' ', '|' };
                        string[] members = extn_username.Split(delimiters, StringSplitOptions.None);
                        extn_username = members[0];
                        for (int i = 1; i < members.Length; i++)
                        {
                            if(members[i].Length > 0)
                                agent.LoggedInACD.Add(members[i]);
                        }
                    }

                    if (extn_username != "")
                    {
                        SIPPBXExten extn = pbx.getExtensionByName(extn_username);
                        if (extn != null)
                        {
                            agent.AtExten = extn;
                            extn.Agent = agent;
                        }
                        else
                            agent.AtExten = null;
                    }
                    else
                        agent.AtExten = null;

                    agent.LogInTime = myReader.GetDateTime(5);
                    agent.LogOutTime = myReader.GetDateTime(6);
                    agent.SkillLevel = myReader.GetInt16(8);

                    agent.Paused = (myReader.GetByte(9) == 1);

                }

                myReader.Close();

                if (bChanged)
                {
                    db_set.ExcuteNonQuerySQL("DELETE FROM cfg_agents WHERE ModTag = 2", env);
                    SIPPBXDBUtil.InitAgentStatusTable(pbx, env, db_set);
                }

                db_set.ExcuteNonQuerySQL("UPDATE cfg_agents SET ModTag = 0 WHERE ModTag = 1", env);

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveAgentFromDB(SIPPBXAgent agent, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_agents SET ModTag=2 WHERE Code = '" + agent.Code + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddAgentToDB(SIPPBXAgent agent, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "INSERT INTO cfg_agents(Name, Code, Password, RecordCall, AtExten, LogInTime, LogOutTime, ModTag, SkillLevel, Paused) VALUES('" + agent.Name + "', ";
                sqlstr += "'" + agent.Code + "', ";
                sqlstr += "'" + agent.Password + "', ";
                sqlstr += agent.RecordCall ? "1, " : "0, ";
                sqlstr += "'', '', '', 1, " + agent.SkillLevel.ToString() + ", 0)";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateAgentPausedStatusIntoDB(SIPPBXAgent agent, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_agents SET ";

                if(agent.Paused)
                    sqlstr += "Paused=1";
                sqlstr += " WHERE Code = '" + agent.Code + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateAgentStatusInDB(SIPPBXAgent agent, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_agents SET ";

                if(agent.Paused)
                    sqlstr += "Paused=1, ";
                else
                    sqlstr += "Paused=0, ";

                string atExtn = "";
                if (agent.AtExten != null)
                {
                    atExtn += agent.AtExten.UserName;
                    for (int i = 0; i < agent.LoggedInACD.Count; i++)
                    {
                        atExtn += ";" + agent.LoggedInACD[i];
                    }
                    atExtn.TrimEnd(';');
                }
                sqlstr += "AtExten='" + atExtn + "', ";

                sqlstr += "LogInTime='" + SIPPBXWinUtil.GetSQLDateTime(agent.LogInTime) + "', ";
                sqlstr += "LogOutTime='" +SIPPBXWinUtil.GetSQLDateTime(agent.LogOutTime) + "' ";

                sqlstr += " WHERE Code = '" + agent.Code + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateAgentInDB(SIPPBXAgent agent, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_agents SET ";

                sqlstr += "Name='" + agent.Name + "', ";
                sqlstr += "Password='" + agent.Password + "', ";
                sqlstr += "RecordCall=" + (agent.RecordCall ? "1, " : "0, ");
                sqlstr += "SkillLevel=" + agent.SkillLevel.ToString() + ", ";
                sqlstr += "ModTag=1 ";

                sqlstr += " WHERE Code = '" + agent.Code + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadAgentsConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.sip_agents.Clear();

            try
            {
                string sqlstr = "DELETE FROM cfg_agents WHERE ModTag = 2";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "SELECT Name, Code, Password, RecordCall, AtExten, LogInTime, LogOutTime, ModTag, SkillLevel, Paused FROM cfg_agents";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXAgent agent = new SIPPBXAgent();
                        agent.Name = myReader.GetString(0);
                        agent.Code = myReader.GetString(1);
                        agent.Password = myReader.GetString(2);
                        agent.RecordCall = (myReader.GetByte(3) == 1);

                        string extn_username = myReader.GetString(4);
                        if (extn_username.Contains(";"))
                        {
                            char[] delimiters = new char[] { ';', ',', ' ', '|' };
                            string[] members = extn_username.Split(delimiters, StringSplitOptions.None);
                            extn_username = members[0];
                            for (int i = 1; i < members.Length; i++)
                            {
                                if(members[i].Length > 0)
                                    agent.LoggedInACD.Add(members[i]);
                            }
                        }

                        if (extn_username != "")
                        {
                            SIPPBXExten extn = pbx.getExtensionByName(extn_username);
                            if (extn != null)
                            {
                                agent.AtExten = extn;
                                extn.Agent = agent;
                                agent.Paused = (myReader.GetByte(9) == 1);
                            }
                        }

                        agent.LogInTime = myReader.GetDateTime(5);
                        agent.LogOutTime = myReader.GetDateTime(6);

                        agent.SkillLevel = myReader.GetInt16(8);

                        pbx.sip_agents.Add(agent);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                db_set.ExcuteNonQuerySQL("UPDATE cfg_agents SET ModTag = 0", env);
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshIVRsConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            bool bChanged = false;
            SIPPBXIVR ivr = null;
            List<SIPPBXIVR> tempListIVR = new List<SIPPBXIVR>();

            try
            {
                string sqlstr = "SELECT MenuName, Action, MenuSound, TransferTo, MenuDTMFWaitMS, DTMFAcceptExtenWaitMS, DTMFAcceptExten, ModTag FROM cfg_ivrs WHERE ModTag != 0";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        ivr = pbx.getIVRMenuByName(myReader.GetString(0));

                        if (myReader.GetInt16(7) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (ivr != null)
                            {
                                pbx.sip_ivrs.Remove(ivr);
                            }

                            bChanged = true;
                            continue;
                        }

                        if (ivr == null)
                        {
                            ivr = new SIPPBXIVR();
                            ivr.name = myReader.GetString(0);
                            pbx.sip_ivrs.Add(ivr);

                            bChanged = true;
                        }

                        ivr.action = myReader.GetInt32(1);
                        ivr.sound_file = myReader.GetString(2);
                        ivr.transfer_to = myReader.GetString(3);
                        ivr.menu_dtmf_wait_ms = myReader.GetInt32(4);
                        ivr.dtmf_accept_exten_wait_ms = myReader.GetInt32(5);
                        ivr.dtmf_accept_exten = (myReader.GetByte(6) == 1);

                        tempListIVR.Add(ivr);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                for (int i = 0; i < tempListIVR.Count; i++)
                {
                    ivr = tempListIVR[i];

                    ivr.dtmfs.Clear();

                    sqlstr = "SELECT * FROM cfg_ivrsubitems WHERE BelongTo = '" + ivr.name + "'";
                    myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                    try
                    {
                        while (myReader.Read())
                        {
                            SIPPBXDTMF dtmf = new SIPPBXDTMF();
                            dtmf.IVRMenu = new SIPPBXIVR();
                            dtmf.DTMFStr = myReader.GetString(0);
                            dtmf.IVRMenu.action = myReader.GetInt32(1);
                            dtmf.IVRMenu.sound_file = myReader.GetString(2);
                            dtmf.IVRMenu.transfer_to = myReader.GetString(3);
                            ivr.dtmfs.Add(dtmf);
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }

                if (bChanged)
                {
                    sqlstr = "DELETE FROM cfg_ivrs WHERE ModTag = 2";
                    if (db_set.ExcuteNonQuerySQL(sqlstr, env) >= 1)
                    {
                    }
                }

                sqlstr = "UPDATE cfg_ivrs SET ModTag = 0 WHERE ModTag = 1";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) >= 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveIVRFromDB(SIPPBXIVR ivr, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_ivrs SET ModTag=2 WHERE MenuName = '" + ivr.name + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    sqlstr = "DELETE FROM cfg_ivrsubitems WHERE BelongTo = '" + ivr.name + "'";
                    db_set.ExcuteNonQuerySQL(sqlstr, env);
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddIVRToDB(SIPPBXIVR ivr, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "INSERT INTO cfg_ivrs(MenuName, Action, MenuSound, TransferTo, MenuDTMFWaitMS, DTMFAcceptExtenWaitMS, DTMFAcceptExten, ModTag) VALUES('" + ivr.name + "', ";

                sqlstr += ivr.action.ToString() + ", ";
                sqlstr += "'" + ivr.sound_file + "', ";
                sqlstr += "'" + ivr.transfer_to + "', ";
                sqlstr += ivr.menu_dtmf_wait_ms.ToString() + ", ";
                sqlstr += ivr.dtmf_accept_exten_wait_ms.ToString() + ", ";
                sqlstr += ivr.dtmf_accept_exten ? "1, " : "0, ";

                sqlstr += "1)";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    sqlstr = "DELETE FROM cfg_ivrsubitems WHERE BelongTo = '" + ivr.name + "'";
                    db_set.ExcuteNonQuerySQL(sqlstr, env);

                    for (int i = 0; i < ivr.dtmfs.Count; i++)
                    {
                        sqlstr = "INSERT INTO cfg_ivrsubitems VALUES(";
                        sqlstr += "'" + ivr.dtmfs[i].DTMFStr + "', ";
                        sqlstr += ivr.dtmfs[i].IVRMenu.action.ToString() + ", ";
                        sqlstr += "'" + ivr.dtmfs[i].IVRMenu.sound_file + "', ";
                        sqlstr += "'" + ivr.dtmfs[i].IVRMenu.transfer_to + "', ";
                        sqlstr += "'" + ivr.name + "')";
                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) != 1)
                        {
                        }
                    }

                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateIVRInDB(SIPPBXIVR ivr, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_ivrs SET ";

                sqlstr += "Action=" + ivr.action.ToString() + ", ";
                sqlstr += "MenuSound=" + "'" + ivr.sound_file + "', ";
                sqlstr += "TransferTo=" + "'" + ivr.transfer_to + "', ";
                sqlstr += "MenuDTMFWaitMS=" + ivr.menu_dtmf_wait_ms.ToString() + ", ";
                sqlstr += "DTMFAcceptExtenWaitMS=" + ivr.dtmf_accept_exten_wait_ms.ToString() + ", ";
                sqlstr += "DTMFAcceptExten=" + (ivr.dtmf_accept_exten ? "1, " : "0, ");

                sqlstr += " ModTag=1 WHERE MenuName = '" + ivr.name + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    sqlstr = "DELETE FROM cfg_ivrsubitems WHERE BelongTo = '" + ivr.name + "'";
                    db_set.ExcuteNonQuerySQL(sqlstr, env);

                    for (int i = 0; i < ivr.dtmfs.Count; i++)
                    {
                        sqlstr = "INSERT INTO cfg_ivrsubitems VALUES(";
                        sqlstr += "'" + ivr.dtmfs[i].DTMFStr + "', ";
                        sqlstr += ivr.dtmfs[i].IVRMenu.action.ToString() + ", ";
                        sqlstr += "'" + ivr.dtmfs[i].IVRMenu.sound_file + "', ";
                        sqlstr += "'" + ivr.dtmfs[i].IVRMenu.transfer_to + "', ";
                        sqlstr += "'" + ivr.name + "')";
                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) != 1)
                        {
                        }
                    }
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadIVRsConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.sip_ivrs.Clear();
            SIPPBXIVR ivr = null;
            List<SIPPBXIVR> tempListIVR = new List<SIPPBXIVR>();

            try
            {

                string sqlstr = "DELETE FROM cfg_ivrs WHERE ModTag = 2";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "SELECT MenuName, Action, MenuSound, TransferTo, MenuDTMFWaitMS, DTMFAcceptExtenWaitMS, DTMFAcceptExten, ModTag FROM cfg_ivrs";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        ivr = new SIPPBXIVR();
                        ivr.name = myReader.GetString(0);
                        ivr.action = myReader.GetInt32(1);
                        ivr.sound_file = myReader.GetString(2);
                        ivr.transfer_to = myReader.GetString(3);
                        ivr.menu_dtmf_wait_ms = myReader.GetInt32(4);
                        ivr.dtmf_accept_exten_wait_ms = myReader.GetInt32(5);
                        ivr.dtmf_accept_exten = (myReader.GetByte(6) == 1);

                        tempListIVR.Add(ivr);

                        pbx.sip_ivrs.Add(ivr);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                for (int i = 0; i < tempListIVR.Count; i++)
                {
                    ivr = tempListIVR[i];

                    ivr.dtmfs.Clear();

                    sqlstr = "SELECT * FROM cfg_ivrsubitems WHERE BelongTo = '" + ivr.name + "'";
                    myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                    try
                    {
                        while (myReader.Read())
                        {
                            SIPPBXDTMF dtmf = new SIPPBXDTMF();
                            dtmf.IVRMenu = new SIPPBXIVR();
                            dtmf.DTMFStr = myReader.GetString(0);
                            dtmf.IVRMenu.action = myReader.GetInt32(1);
                            dtmf.IVRMenu.sound_file = myReader.GetString(2);
                            dtmf.IVRMenu.transfer_to = myReader.GetString(3);
                            ivr.dtmfs.Add(dtmf);
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }
                    finally
                    {
                        myReader.Close();
                    }
                }

                sqlstr = "UPDATE cfg_ivrs SET ModTag = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshAutoDialerTasks(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            bool bChanged = false;

            try
            {
                string sqlstr = "SELECT Name, Enabled, TypeCode, SIPAcct, DialPlan, RingTimeout, MaxSimCalls, ModTag, EnableDetect, DiscAfterDetect FROM cfg_autodialertasks WHERE ModTag != 0";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        AutoDialerTask task = pbx.getAutoDialerTaskByName(myReader.GetString(0));

                        if (myReader.GetInt16(7) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (task != null)
                            {
                                pbx.auto_dialer_tasks.Remove(task);
                            }

                            bChanged = true;
                            continue;
                        }

                        if (task == null)
                        {
                            task = new AutoDialerTask();
                            task.task_name = myReader.GetString(0);
                            pbx.auto_dialer_tasks.Add(task);
                            bChanged = true;
                        }

                        task.isOn = (myReader.GetByte(1) == 1);
                        task.type_code = myReader.GetInt16(2);
                        task.sip_acc = myReader.GetString(3);
                        task.dial_plan = myReader.GetString(4);
                        task.m_ringTimeout = myReader.GetInt32(5);
                        task.m_maxSimCalls = myReader.GetInt32(6);
                        task.m_bEnableDetect = (myReader.GetByte(8) == 1);
                        task.m_bDiscAfterDetect = (myReader.GetByte(9) == 1);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (bChanged)
                {
                    sqlstr = "DELETE FROM cfg_autodialertasks WHERE ModTag = 2";
                    if (db_set.ExcuteNonQuerySQL(sqlstr, env) >= 1)
                    {
                    }
                }

                sqlstr = "UPDATE cfg_autodialertasks SET ModTag = 0 WHERE ModTag = 1";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) >= 1)
                {
                }                
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }
        /*
                public static bool AddAutoDialerTaskToDB(AutoDialerTask task, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
                {
                    try
                    {
                        SqlCommand catCMD = myConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        string sqlstr = "INSERT INTO cfg_autodialertasks VALUES('" + task.task_name + "', ";
                        sqlstr += task.isOn ? "1, " : "0, ";
                        sqlstr += task.type_code.ToString() + ", ";
                        sqlstr += "'" + task.sip_acc + "', ";
                        sqlstr += "'" + task.dial_plan + "', ";
                        sqlstr += task.m_ringTimeout.ToString() + ", ";
                        sqlstr += task.m_maxSimCalls.ToString() + ", ";
                        sqlstr += "1)";

                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                            return true;
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }

                    return false;
                }
        */

        public static bool AddAutoDialerTasksToDB(AutoDialerTask task, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "INSERT INTO cfg_autodialertasks(Name, Enabled, TypeCode, SIPAcct, DialPlan, RingTimeout, MaxSimCalls, ModTag, EnableDetect, DiscAfterDetect) VALUES('" + task.task_name + "', ";
                sqlstr += task.isOn ? "1, " : "0, ";
                sqlstr += task.type_code.ToString() + ", ";
                sqlstr += "'" + task.sip_acc.ToString() + "', ";
                sqlstr += "'" + task.dial_plan.ToString() + "', ";
                sqlstr += task.m_ringTimeout.ToString() + ", ";
                sqlstr += task.m_maxSimCalls.ToString() + ", ";
                sqlstr += "1, ";
                sqlstr += task.m_bEnableDetect? "1, " : "0, ";
                sqlstr += task.m_bDiscAfterDetect? "1)" : "0)";


                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool RemoveAutoDialerTaskFromDB(AutoDialerTask task, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_autodialertasks SET ModTag=2 WHERE Name = '" + task.task_name + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateAutoDialerTaskInDB(AutoDialerTask task, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_autodialertasks SET ";

                sqlstr += "Enabled=" + (task.isOn ? "1, " : "0, ");
                sqlstr += "TypeCode=" + task.type_code.ToString() + ", ";
                sqlstr += "SIPAcct=" + "'" + task.sip_acc + "', ";
                sqlstr += "DialPlan=" + "'" + task.dial_plan + "', ";
                sqlstr += "RingTimeout=" + task.m_ringTimeout.ToString() + ", ";
                sqlstr += "MaxSimCalls=" + task.m_maxSimCalls.ToString() + ", ";
                sqlstr += "EnableDetect=" + (task.m_bEnableDetect ? "1, " : "0, ");
                sqlstr += "DiscAfterDetect=" + (task.m_bDiscAfterDetect ? "1, " : "0, ");

                sqlstr += " ModTag=1 WHERE Name = '" + task.task_name + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadAutoDialerTasksFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.auto_dialer_tasks.Clear();

            try
            {
                string sqlstr = "DELETE FROM cfg_autodialertasks WHERE ModTag = 2";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "SELECT Name, Enabled, TypeCode, SIPAcct, DialPlan, RingTimeout, MaxSimCalls, ModTag, EnableDetect, DiscAfterDetect FROM cfg_autodialertasks";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        AutoDialerTask task = new AutoDialerTask();
                        task.task_name = myReader.GetString(0);
                        task.isOn = (myReader.GetByte(1) == 1);
                        task.type_code = myReader.GetInt16(2);
                        task.sip_acc = myReader.GetString(3);
                        task.dial_plan = myReader.GetString(4);
                        task.m_ringTimeout = myReader.GetInt32(5);
                        task.m_maxSimCalls = myReader.GetInt32(6);
                        task.m_bEnableDetect = (myReader.GetByte(8) == 1);
                        task.m_bDiscAfterDetect = (myReader.GetByte(9) == 1);

                        pbx.auto_dialer_tasks.Add(task);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                sqlstr = "UPDATE cfg_autodialertasks SET ModTag = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void RefreshPickupGroupConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            bool bChanged = false;

            try
            {
                string sqlstr = "SELECT Name, MemberType, Members, ModTag FROM cfg_pickupgroups WHERE ModTag != 0";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        PickUpGroup pg = pbx.getPickupGroupByName(myReader.GetString(0));

                        if (myReader.GetInt16(3) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (pg != null)
                            {
                                pbx.pickup_groups.Remove(pg);
                            }

                            bChanged = true;
                            continue;
                        }

                        if (pg == null)
                        {
                            pg = new PickUpGroup();
                            pg.name = myReader.GetString(0);
                            pbx.pickup_groups.Add(pg);

                            bChanged = true;
                        }

                        pg.ml.mb_type = myReader.GetInt32(1);

                        pg.ml.members.Clear();
                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = myReader.GetString(2).Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        if (members.Length > 0)
                        {
                            for (int i = 0; i < members.Length; i++)
                            {
                                pg.ml.members.Add(members[i]);
                            }
                        }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (bChanged)
                {
                    sqlstr = "DELETE FROM cfg_pickupgroups WHERE ModTag = 2";
                    if (db_set.ExcuteNonQuerySQL(sqlstr, env) >= 1)
                    {
                    }
                }

                sqlstr = "UPDATE cfg_pickupgroups SET ModTag = 0 WHERE ModTag = 1";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) >= 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemovePickUpGroupFromDB(PickUpGroup pg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_pickupgroups SET ModTag=2 WHERE Name = '" + pg.name + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddPickUpGroupToDB(PickUpGroup pg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "INSERT INTO cfg_pickupgroups(Name, MemberType, Members, ModTag) VALUES('" + pg.name + "', ";
                sqlstr += pg.ml.mb_type.ToString() + ", ";

                string sMembers = "";
                for (int i = 0; i < pg.ml.members.Count; i++)
                {
                    sMembers += pg.ml.members[i];
                    if (i != pg.ml.members.Count - 1)
                        sMembers += ";";
                }
                sqlstr += "'" + sMembers + "', ";
                sqlstr += " 1)";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdatePickUpGroupInDB(PickUpGroup pg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_pickupgroups SET ";

                sqlstr += "MemberType=" + pg.ml.mb_type.ToString() + ", ";

                string sMembers = "";
                for (int i = 0; i < pg.ml.members.Count; i++)
                {
                    sMembers += pg.ml.members[i];
                    if (i != pg.ml.members.Count - 1)
                        sMembers += ";";
                }
                sqlstr += "Members='" + sMembers + "', ";

                sqlstr += "ModTag=1 ";
                sqlstr += "WHERE Name = '" + pg.name + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadPickupGroupConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.pickup_groups.Clear();

            try
            {
                string sqlstr = "DELETE FROM cfg_pickupgroups WHERE ModTag = 2";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "SELECT Name, MemberType, Members, ModTag FROM cfg_pickupgroups";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        PickUpGroup pg = new PickUpGroup();
                        pg.name = myReader.GetString(0);
                        pg.ml.mb_type = myReader.GetInt32(1);

                        pg.ml.members.Clear();
                        char[] delimiters = new char[] { ';', ',', ' ' };
                        string[] members = myReader.GetString(2).Split(delimiters, StringSplitOptions.RemoveEmptyEntries);
                        if (members.Length > 0)
                        {
                            for (int i = 0; i < members.Length; i++)
                            {
                                pg.ml.members.Add(members[i]);
                            }
                        }

                        pbx.pickup_groups.Add(pg);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                sqlstr = "UPDATE cfg_pickupgroups SET ModTag = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

		//service side
        public static void RefreshConferRoomsConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            bool bChanged = false;

            try
            {
                string sqlstr = "SELECT Name, ModTag, MaxCallNum, JoinPrompt, LeavePrompt, MOHDir, DiscCall, HostPW, HostPrompt, RecordCall, EveryonePW FROM cfg_conferencerooms WHERE ModTag != 0";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        SIPConferRoom room = pbx.getConferenceRoomByName(myReader.GetString(0));

                        if (myReader.GetInt16(1) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (room != null)
                            {
                                pbx.sip_conferooms.Remove(room);
                                if (room.conf_handle != IntPtr.Zero)
                                {
                                    room.conf_chans.Clear();
                                    env.DestroyConf(room.conf_handle);
                                }
                            }

                            bChanged = true;
                            continue;
                        }

                        if (room == null)
                        {
                            room = new SIPConferRoom();
							pbx.sip_conferooms.Add(room);  
							room.conf_handle = env.CreateConf();                          
						}
						
						room.conf_name = myReader.GetString(0);
						room.conf_max_num = myReader.GetInt32(2);
						room.join_prompt = myReader.GetString(3);
						room.leave_prompt = myReader.GetString(4);

						room.moh_dir = myReader.GetString(5);
						room.disc_call = (myReader.GetByte(6) == 1) ? true : false;
						room.host_pw = myReader.GetString(7);
						room.host_pw_prompt = myReader.GetString(8);
                        room.conf_record = (myReader.GetByte(9) == 1) ? true : false;
                        room.attendance_need_password = (myReader.GetByte(10) == 1) ? true : false;

						bChanged = true;
					
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (bChanged)
                {
                    db_set.ExcuteNonQuerySQL("DELETE FROM cfg_conferencerooms WHERE ModTag = 2", env);

                    SIPPBXDBUtil.InitConferenceRoomStatusTable(pbx, env, db_set);
                }

                db_set.ExcuteNonQuerySQL("UPDATE cfg_conferencerooms SET ModTag = 0 WHERE ModTag = 1", env);
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

		//GUI side
        public static bool RemoveConferRoomFromDB(SIPConferRoom room, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_conferencerooms SET ModTag=2 WHERE Name = '" + room.conf_name + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

		//GUI side
        public static bool AddConferRoomToDB(SIPConferRoom room, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "INSERT INTO cfg_conferencerooms(Name, ModTag, MaxCallNum, JoinPrompt, LeavePrompt, MOHDir, DiscCall, HostPW, HostPrompt, RecordCall, EveryonePW) VALUES('" + room.conf_name + "', ";
                sqlstr += "1, " + room.conf_max_num.ToString() + ", ";
                sqlstr += "'" + room.join_prompt + "', ";
                sqlstr += "'" + room.leave_prompt + "', ";
                sqlstr += "'" + room.moh_dir + "', ";
                sqlstr += room.disc_call ? "1, " : "0, ";
                sqlstr += "'" + room.host_pw + "', ";
                sqlstr += "'" + room.host_pw_prompt + "', ";
                sqlstr += room.conf_record? "1, " : "0, ";
                sqlstr += room.attendance_need_password ? "1)" : "0)";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

		//GUI side
        public static bool UpdateConferRoomInDB(SIPConferRoom room, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
		    try
            {
                string sqlstr = "UPDATE cfg_conferencerooms SET ";

                sqlstr += "ModTag=1, ";
                sqlstr += "MaxCallNum=" + room.conf_max_num.ToString() + ", ";

                sqlstr += "JoinPrompt='" + room.join_prompt + "', ";
                sqlstr += "LeavePrompt='" + room.leave_prompt + "', ";

                sqlstr += "MOHDir='" + room.moh_dir + "', ";
                sqlstr += "DiscCall=" + (room.disc_call ? "1, " : "0, ");

                sqlstr += "HostPW='" + room.host_pw + "', ";
                sqlstr += "HostPrompt='" + room.host_pw_prompt + "', ";
                sqlstr += "RecordCall=" + (room.conf_record? "1, " : "0, ");
                sqlstr += "EveryonePW=" + (room.attendance_need_password? "1 " : "0 ");

                sqlstr += "WHERE Name = '" + room.conf_name + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;	
        }

		//GUI and Service side both
        public static void LoadConferRoomsConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.sip_conferooms.Clear();

            try
            {
                string sqlstr = "DELETE FROM cfg_conferencerooms WHERE ModTag = 2";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "SELECT Name, ModTag, MaxCallNum, JoinPrompt, LeavePrompt, MOHDir, DiscCall, HostPW, HostPrompt, RecordCall, EveryonePW FROM cfg_conferencerooms";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        SIPConferRoom room = new SIPConferRoom();
                        room.conf_name = myReader.GetString(0);
                        room.conf_max_num = myReader.GetInt32(2);
                        room.join_prompt = myReader.GetString(3);
                        room.leave_prompt = myReader.GetString(4);

                        room.moh_dir = myReader.GetString(5);
                        room.disc_call = (myReader.GetByte(6) == 1) ? true : false;
                        room.host_pw = myReader.GetString(7);
                        room.host_pw_prompt = myReader.GetString(8);
                        room.conf_record = (myReader.GetByte(9) == 1) ? true : false;
                        room.attendance_need_password = (myReader.GetByte(10) == 1) ? true : false;
                        
                        if(pbxMain != null && env != null)
                        {
							//service side
							room.conf_handle = env.CreateConf();
						}
                        
                        pbx.sip_conferooms.Add(room);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                sqlstr = "UPDATE cfg_conferencerooms SET ModTag = 0";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }
        
        
        public static void LoadCallLimitConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.call_credits.Clear();

            try
            {
                string sqlstr = "DELETE FROM cfg_calllimit WHERE ModTag = 2";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "SELECT DialPlan, Seconds, RoundupSeconds, ModTag FROM cfg_calllimit";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        CallLimit cl = new CallLimit();
                        cl.Name = myReader.GetString(0);
						cl.Seconds = myReader.GetInt32(1);
                        cl.roundupSeconds = myReader.GetInt32(2);
						
						//here we need to fill out it is credit according to dialplan, or what
						//cl.dp, or cl.extn, or cl.sipaccount
						pbx.setCallLimitParameters(cl);
						
                        pbx.call_credits.Add(cl);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                sqlstr = "UPDATE cfg_calllimit SET ModTag = 0";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }


        public static void RefreshCallLimitConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            //bool newRow = false;
            //bool bChanged = false;

            try
            {
                string sqlstr = "SELECT DialPlan, Seconds, RoundupSeconds, ModTag FROM cfg_calllimit WHERE ModTag != 0";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        //bChanged = true;

                        //newRow = false;

                        CallLimit cl = pbx.getCallLimitByName(myReader.GetString(0));

                        if (myReader.GetInt16(3) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (cl != null)
                            {
                                pbx.call_credits.Remove(cl);
                            }

                            //bChanged = true;

                            continue;
                        }

                        if (cl == null)
                        {
                            cl = new CallLimit();
                            pbx.call_credits.Add(cl);
                            ///newRow = true;

                            //bChanged = true;
                        }

                        cl.Name = myReader.GetString(0);
						cl.Seconds = myReader.GetInt32(1);
                        cl.roundupSeconds = myReader.GetInt32(2);
						
						pbx.setCallLimitParameters(cl);
						
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                sqlstr = "DELETE FROM cfg_calllimit WHERE ModTag = 2";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_calllimit SET ModTag = 0 WHERE ModTag = 1";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveCallLimitFromDB(CallLimit cl, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_calllimit SET ModTag = 2 WHERE DialPlan = '" + cl.Name + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddCallLimitToDB(CallLimit cl, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "INSERT INTO cfg_calllimit(DialPlan, Seconds, RoundupSeconds, ModTag) VALUES(";
                sqlstr += "'" + cl.Name + "', ";
                sqlstr += cl.Seconds.ToString() + ", " + cl.roundupSeconds.ToString() + ", 1)";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateCallLimitInDB(CallLimit cl, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log, int mod)
        {
            try
            {
                string sqlstr = "UPDATE cfg_calllimit SET ";

                sqlstr += "DialPlan='" + cl.Name + "', ";
                sqlstr += "Seconds=" + cl.Seconds.ToString() + ", ";
                sqlstr += "RoundupSeconds=" + cl.roundupSeconds.ToString() + ", ";
                sqlstr += "ModTag=" + mod.ToString() + " ";
                sqlstr += "WHERE DialPlan = '" + cl.Name + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static void LoadBlackListConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.call_blocks.Clear();
            //string logTxt = "calling LoadBlackListConfigFromDB\r\n";

            try
            {
                string sqlstr = "DELETE FROM cfg_blacklist WHERE ModTag = 2";    
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "SELECT ID, Callee, Caller, ModTag FROM cfg_blacklist";
                //logTxt += catCMD.CommandText + "\r\n";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        CallBlock cb = new CallBlock();
                        cb.ID = myReader.GetInt32(0);
                        cb.Callee = myReader.GetString(1);
						cb.Caller = myReader.GetString(2);
                        //logTxt += cb.ID.ToString() + " " + cb.Callee + " " + cb.Caller + "\r\n";
                        pbx.call_blocks.Add(cb);
                    }

                    //logTxt += pbx.call_blocks.Count.ToString() + " items in list";
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                    //if (log != null) log.LogoutText(logTxt);
                }

                sqlstr = "UPDATE cfg_blacklist SET ModTag = 0";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }


        public static void RefreshBlackListConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {

            try
            {
                string sqlstr = "SELECT ID, Callee, Caller, ModTag FROM cfg_blacklist WHERE ModTag != 0";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        CallBlock cb = pbx.getCallBlockByID(myReader.GetInt32(0));

                        if (myReader.GetInt16(3) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (cb != null)
                            {
                                pbx.call_blocks.Remove(cb);
                            }

                            continue;
                        }

                        if (cb == null)
                        {
                            cb = new CallBlock();
                            pbx.call_blocks.Add(cb);
                        }

                        cb.ID = myReader.GetInt32(0);
                        cb.Callee = myReader.GetString(1);
                        cb.Caller = myReader.GetString(2);
						
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                sqlstr = "DELETE FROM cfg_blacklist WHERE ModTag = 2";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_blacklist SET ModTag = 0 WHERE ModTag = 1";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveBlackListFromDB(CallBlock cb, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_blacklist SET ModTag = 2 WHERE ID = " + cb.ID.ToString();

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddBlackListToDB(CallBlock cb, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            string sqlstr = "";
            try
            {
                sqlstr = "INSERT INTO cfg_blacklist(ID, Callee, Caller, ModTag) VALUES(";
                sqlstr += cb.ID.ToString() + ", '" + cb.Callee + "', ";
                sqlstr += "'" + cb.Caller + "', 1)";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString() + " " + sqlstr);
            }

            return false;
        }

        public static bool UpdateBlackListInDB(CallBlock cb, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_blacklist SET ";

                sqlstr += "Callee='" + cb.Callee + "', ";
                sqlstr += "Caller='" + cb.Caller + "', ";
                sqlstr += "ModTag=1 ";
                sqlstr += "WHERE ID = " + cb.ID.ToString();

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

/////////////////////2016-08-18 CallBack functions//////////////////////////////////////////////////////////
        public static void LoadCallBackConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.call_backlist.Clear();

            try
            {
                string sqlstr = "DELETE FROM cfg_callback WHERE ModTag = 2";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "SELECT ID, Callee, Caller, DialPlan, Exten, ExtraAttr, ModTag FROM cfg_callback";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        CallBack cb = new CallBack();
                        cb.ID = myReader.GetInt32(0);
                        cb.Callee = myReader.GetString(1);
                        cb.Caller = myReader.GetString(2);
                        cb.DialPlan = myReader.GetString(3);
                        cb.Exten = myReader.GetString(4);
                        cb.ExtraAttr = myReader.GetString(5);

                        pbx.call_backlist.Add(cb);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                sqlstr = "UPDATE cfg_callback SET ModTag = 0";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }


        public static void RefreshCallBackConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {

            try
            {
                string sqlstr = "SELECT ID, Callee, Caller, DialPlan, Exten, ExtraAttr, ModTag FROM cfg_callback WHERE ModTag != 0";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        CallBack cb = pbx.getCallBackByID(myReader.GetInt32(0));

                        if (myReader.GetInt16(6) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (cb != null)
                            {
                                pbx.call_backlist.Remove(cb);
                            }

                            continue;
                        }

                        if (cb == null)
                        {
                            cb = new CallBack();
                            pbx.call_backlist.Add(cb);
                        }

                        cb.ID = myReader.GetInt32(0);
                        cb.Callee = myReader.GetString(1);
                        cb.Caller = myReader.GetString(2);
                        cb.DialPlan = myReader.GetString(3);
                        cb.Exten = myReader.GetString(4);
                        cb.ExtraAttr = myReader.GetString(5);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                sqlstr = "DELETE FROM cfg_callback WHERE ModTag = 2";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
                sqlstr = "UPDATE cfg_callback SET ModTag = 0 WHERE ModTag = 1";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveCallBackFromDB(CallBack cb, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_callback SET ModTag = 2 WHERE ID = " + cb.ID.ToString();

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddCallBackToDB(CallBack cb, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "INSERT INTO cfg_callback(ID, Callee, Caller, DialPlan, Exten, ExtraAttr, ModTag) VALUES(";
                sqlstr += cb.ID.ToString() + ", '" + cb.Callee + "', ";
                sqlstr += "'" + cb.Caller + "', ";
                sqlstr += "'" + cb.DialPlan + "', ";
                sqlstr += "'" + cb.Exten + "', ";
                sqlstr += "'" + cb.ExtraAttr + "', ";
                sqlstr += "1)";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateCallBackInDB(CallBack cb, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_callback SET ";

                sqlstr += "Callee='" + cb.Callee + "', ";
                sqlstr += "Caller='" + cb.Caller + "', ";
                sqlstr += "DialPlan='" + cb.DialPlan + "', ";
                sqlstr += "Exten='" + cb.Exten + "', ";
                sqlstr += "ExtraAttr='" + cb.ExtraAttr + "', ";
                sqlstr += "ModTag=1 ";
                sqlstr += "WHERE ID = " + cb.ID.ToString();

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }


/////////////////////2016-06-09 Paging group functions//////////////////////////////////////////////////////
        public static void RefreshPagingGroupConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            bool bChanged = false;
            SIPPBXPagingGroup paging_group = null;

            List<SIPPBXPagingGroup> tempListPagingGroup = new List<SIPPBXPagingGroup>();

            try
            {
                string sqlstr = "SELECT Name, DID, UseGroupName, ModTag FROM cfg_paginggroups WHERE ModTag != 0";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        paging_group = pbx.getPagingGroupByName(myReader.GetString(0));

                        if (myReader.GetInt16(3) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (paging_group != null)
                            {
                                pbx.sip_paginggroups.Remove(paging_group);
                                env.DestroyConf(paging_group.conf_handle);
                            }

                            bChanged = true;
                            continue;
                        }

                        if (paging_group == null)
                        {
                            paging_group = new SIPPBXPagingGroup();
                            paging_group.gpName = myReader.GetString(0);
                            paging_group.conf_handle = env.CreateConf();
                            pbx.sip_paginggroups.Add(paging_group);

                            bChanged = true;
                        }

                        paging_group.did = myReader.GetString(1);
                        paging_group.bUseGroupName = (myReader.GetInt16(2) == 1);
                        tempListPagingGroup.Add(paging_group);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (tempListPagingGroup.Count > 0)
                {
                    for (int i = 0; i < tempListPagingGroup.Count; i++)
                    {
                        paging_group = tempListPagingGroup[i];

                        paging_group.destList.Clear();

                        sqlstr = "SELECT * FROM cfg_dests WHERE BelongTo = '" + paging_group.gpName + "'";
                        myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                        try
                        {
                            while (myReader.Read())
                            {
                                SIPPBXDest dest = new SIPPBXDest();

                                dest.DestType = myReader.GetInt32(0);
                                dest.DestAddr = myReader.GetString(1);
                                dest.RingTimeout = myReader.GetInt32(2);

                                paging_group.destList.Add(dest);
                            }
                        }
                        catch (Exception e)
                        {
                            if (log != null)
                                log.LogoutText(e.ToString());
                        }
                        finally
                        {
                            myReader.Close();
                        }
                    }
                }

                if (bChanged)
                {
                    sqlstr = "DELETE FROM cfg_paginggroups WHERE ModTag = 2";
                    if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    {
                    }
                }

                sqlstr = "UPDATE cfg_paginggroups SET ModTag = 0 WHERE ModTag = 1";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }



        public static bool RemovePagingGroupFromDB(SIPPBXPagingGroup pg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_paginggroups SET ModTag=2 WHERE Name = '" + pg.gpName + "'";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    sqlstr = "DELETE FROM cfg_dests WHERE BelongTo = '" + pg.gpName + "'";
                    db_set.ExcuteNonQuerySQL(sqlstr, env);
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }


        public static bool AddPagingGroupToDB(SIPPBXPagingGroup pg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "INSERT INTO cfg_paginggroups(Name, DID, UseGroupName , ModTag) VALUES('" + pg.gpName + "', '" + pg.did + "', ";
                sqlstr += pg.bUseGroupName ? "1, " : "0, ";
                sqlstr += "1)";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    sqlstr = "DELETE FROM cfg_dests WHERE BelongTo = '" + pg.gpName + "'";
                    db_set.ExcuteNonQuerySQL(sqlstr, env);

                    for (int i = 0; i < pg.destList.Count; i++)
                    {
                        sqlstr = "INSERT INTO cfg_dests VALUES(";
                        sqlstr += pg.destList[i].DestType.ToString() + ", ";
                        sqlstr += "'" + pg.destList[i].DestAddr + "', ";
                        sqlstr += pg.destList[i].RingTimeout.ToString() + ", ";
                        sqlstr += "'" + pg.gpName + "')";
                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) != 1)
                        {
                        }
                    }
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }


        public static bool UpdatePagingGroupInDB(SIPPBXPagingGroup pg, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_paginggroups SET ";
                sqlstr += "DID='" + pg.did + "', ";
                sqlstr += "UseGroupName=" + (pg.bUseGroupName ? "1, " : "0, ");

                sqlstr += " ModTag=1 WHERE Name = '" + pg.gpName + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    sqlstr = "DELETE FROM cfg_dests WHERE BelongTo = '" + pg.gpName + "'";
                    db_set.ExcuteNonQuerySQL(sqlstr, env);

                    for (int i = 0; i < pg.destList.Count; i++)
                    {
                        sqlstr = "INSERT INTO cfg_dests VALUES(";
                        sqlstr += pg.destList[i].DestType.ToString() + ", ";
                        sqlstr += "'" + pg.destList[i].DestAddr + "', ";
                        sqlstr += pg.destList[i].RingTimeout.ToString() + ", ";
                        sqlstr += "'" + pg.gpName + "')";
                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) != 1)
                        {
                        }
                    }

                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }


        public static void LoadPagingGroupConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            SIPPBXPagingGroup pg = null;
            List<SIPPBXPagingGroup> tempListPagingGroup = new List<SIPPBXPagingGroup>();

            pbx.sip_paginggroups.Clear();

            try
            {

                string sqlstr = "DELETE FROM cfg_paginggroups WHERE ModTag = 2";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "SELECT Name, DID, UseGroupName, ModTag FROM cfg_paginggroups";
                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        pg = new SIPPBXPagingGroup();

                        pg.gpName = myReader.GetString(0);
                        pg.did = myReader.GetString(1);
                        pg.bUseGroupName = myReader.GetInt16(2) == 1;

                        tempListPagingGroup.Add(pg);

                        pbx.sip_paginggroups.Add(pg);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                if (tempListPagingGroup.Count > 0)
                {
                    for (int i = 0; i < tempListPagingGroup.Count; i++)
                    {
                        pg = tempListPagingGroup[i];

                        pg.destList.Clear();

                        sqlstr = "SELECT * FROM cfg_dests WHERE BelongTo = '" + pg.gpName + "'";
                        myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                        try
                        {
                            while (myReader.Read())
                            {
                                SIPPBXDest dest = new SIPPBXDest();

                                dest.DestType = myReader.GetInt32(0);
                                dest.DestAddr = myReader.GetString(1);
                                dest.RingTimeout = myReader.GetInt32(2);

                                pg.destList.Add(dest);
                            }
                        }
                        catch (Exception e)
                        {
                            if (log != null)
                                log.LogoutText(e.ToString());
                        }
                        finally
                        {
                            myReader.Close();
                        }
                    }
                }

                sqlstr = "UPDATE cfg_paginggroups SET ModTag = 0 WHERE ModTag != 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        ///////////////////////////////openAI nodes//////////////////////////////////////////////////////////
        public static void LoadOpenAINodesFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.call_backlist.Clear();

            try
            {
                string sqlstr = "DELETE FROM cfg_openainodes WHERE ModTag = 2";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "SELECT NodeName, APIKey, DefDesc, Args, Menus, ModTag FROM cfg_openainodes";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXOpenAINode oaiNode = new SIPPBXOpenAINode();
                        oaiNode.NodeName = myReader.GetString(0);
                        oaiNode.APIKey = myReader.GetString(1);
                        oaiNode.DefDesc = myReader.GetString(2);
                        oaiNode.Args = myReader.GetString(3);
                        oaiNode.Menus = myReader.GetString(4);

                        pbx.openai_nodes.Add(oaiNode);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                sqlstr = "UPDATE cfg_openainodes SET ModTag = 0";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }


        public static void RefreshOpenAINodesConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {

            try
            {
                string sqlstr = "SELECT NodeName, APIKey, DefDesc, Args, Menus, ModTag FROM cfg_openainodes WHERE ModTag != 0";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        SIPPBXOpenAINode node = pbx.getOpenAIAgentByName(myReader.GetString(0));

                        if (myReader.GetInt16(5) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (node != null)
                            {
                                pbx.openai_nodes.Remove(node);
                            }

                            continue;
                        }

                        if (node == null)
                        {
                            node = new SIPPBXOpenAINode();
                            pbx.openai_nodes.Add(node);
                        }

                        node.NodeName = myReader.GetString(0);
                        node.APIKey = myReader.GetString(1);
                        node.DefDesc = myReader.GetString(2);
                        node.Args = myReader.GetString(3);
                        node.Menus = myReader.GetString(4);

                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                sqlstr = "DELETE FROM cfg_openainodes WHERE ModTag = 2";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
                sqlstr = "UPDATE cfg_openainodes SET ModTag = 0 WHERE ModTag = 1";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveOpenAINodeFromDB(SIPPBXOpenAINode node, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_openainodes SET ModTag = 2 WHERE NodeName = '" + node.NodeName + "'";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddOpenAINodeToDB(SIPPBXOpenAINode node, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "INSERT INTO cfg_openainodes(NodeName, APIKey, DefDesc, Args, Menus, ModTag) VALUES(@nodename, @apikey, @defdesc, @args, @menus, 1)";

                SqlCommand command = new SqlCommand(sqlstr, db_set.myConn);

                command.Parameters.AddWithValue("@nodename", node.NodeName);
                command.Parameters.AddWithValue("@apikey", node.APIKey);
                command.Parameters.AddWithValue("@defdesc", node.DefDesc);
                command.Parameters.AddWithValue("@args", node.Args);
                command.Parameters.AddWithValue("@menus", node.Menus);

                //log.LogoutText(sqlstr);

                //if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                if (command.ExecuteNonQuery() == 1)
                {
                    return true;
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool UpdateOpenAINodeInDB(SIPPBXOpenAINode node, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_openainodes SET APIKey=@apikey, DefDesc=@defdesc, Args=@args, Menus=@menus, ModTag=1 WHERE NodeName = @nodename";

                SqlCommand command = new SqlCommand(sqlstr, db_set.myConn);

                command.Parameters.AddWithValue("@nodename", node.NodeName);
                command.Parameters.AddWithValue("@apikey", node.APIKey);
                command.Parameters.AddWithValue("@defdesc", node.DefDesc);
                command.Parameters.AddWithValue("@args", node.Args);
                command.Parameters.AddWithValue("@menus", node.Menus);

                //log.LogoutText(sqlstr);

                //if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                if (command.ExecuteNonQuery() == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }


        /////////////////////////////security DB tables//////////////////////////////////////////////////////
        public static void RefreshSecurityConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            bool newRow = false;

            try
            {
                string sqlstr = "SELECT ID, WhiteOrBlack, FilterType, IPAddr, CallID, MacAddr, ModTag FROM cfg_security WHERE ModTag != 0";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        newRow = false;

                        IPFilter filter = pbx.getSecurityFilterByID(myReader.GetInt32(0));

                        if (myReader.GetInt16(6) == 2)
                        {
                            //ModTag == 2, need remove.
                            if (filter != null)
                            {
                                env.SetIPFilter(filter.IPAddr, filter.WhiteOrBlack, 0); 
                                pbx.IPFilterList.Remove(filter);
                            }

                            continue;
                        }

                        if (filter == null)
                        {
                            filter = new IPFilter();
                            filter.DBIdx = myReader.GetInt32(0);
                            pbx.IPFilterList.Add(filter);
                            newRow = true;
                        }

                        filter.WhiteOrBlack = myReader.GetInt16(1);
                        filter.FilterType = myReader.GetInt16(2); ;
                        filter.IPAddr = myReader.GetString(3);
                        filter.CallID = myReader.GetString(4);
                        filter.MACAddr = myReader.GetString(5);

                        if (newRow)
                        {
                            env.SetIPFilter(filter.IPAddr, filter.WhiteOrBlack, 1); 
                        }
                        else
                        {
                            //just update the filter
                            env.SetIPFilter(filter.IPAddr, filter.WhiteOrBlack, 0);
                            env.SetIPFilter(filter.IPAddr, filter.WhiteOrBlack, 1);
                        }
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                sqlstr = "DELETE FROM cfg_security WHERE ModTag = 2";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_security SET ModTag = 0 WHERE ModTag = 1";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static bool RemoveSecurityFromDB(IPFilter filter, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "UPDATE cfg_security SET ModTag = 2 WHERE ID = " + filter.DBIdx.ToString();
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                    return true;
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        public static bool AddSecurityToDB(IPFilter filter, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "INSERT INTO cfg_security(ID, WhiteOrBlack, FilterType, IPAddr, CallID, MacAddr, ModTag) VALUES(" + filter.DBIdx.ToString() + ", ";
                sqlstr += filter.WhiteOrBlack.ToString() + ", ";
                sqlstr += filter.FilterType.ToString() + ", ";

                sqlstr += "'" + filter.IPAddr + "', ";
                sqlstr += "'" + filter.CallID + "', ";
                sqlstr += "'" + filter.MACAddr + "', ";
 
                sqlstr += "1)";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }

        /*
        public static bool UpdateSecurityInDB(SIPAccount acct, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                SqlCommand catCMD = myConn.CreateCommand();
                catCMD.CommandTimeout = 3;
                string sqlstr = "UPDATE cfg_sipaccounts SET ";

                sqlstr += "DisplayName=" + "'" + acct.DisplayName + "', ";
                sqlstr += "UserName=" + "'" + acct.UserName + "', ";

                sqlstr += "DomainServer=" + "'" + acct.DomainServer + "', ";
                sqlstr += "ProxyServer=" + "'" + acct.ProxyServer + "', ";

                sqlstr += "AuthName=" + "'" + acct.AuthName + "', ";
                sqlstr += "Password=" + "'" + acct.Password + "', ";

                sqlstr += "ExpireSec=" + acct.ExpireSec.ToString() + ", ";
                sqlstr += "RegWithProxyServer=" + (acct.RegWithProxyServer ? "1, " : "0, ");

                string sDIDs = "";
                for (int i = 0; i < acct.DIDList.Count; i++)
                {
                    sDIDs += acct.DIDList[i];
                    if (i != acct.DIDList.Count - 1)
                        sDIDs += ";";
                }
                sqlstr += "DIDS=" + "'" + sDIDs + "', ";
                sqlstr += "Disabled=" + (acct.Disabled ? "1, " : "0, ");
                sqlstr += "AcceptOtherID=" + (acct.OutboundAcceptOtherID ? "1, " : "0, ");
                sqlstr += "AppendExtenID=" + (acct.OutboundAppendExtenID ? "1, " : "0, ");
                sqlstr += "UseLocalIPInFrom=" + (acct.UseLocalIPInFrom ? "1, " : "0, ");
                sqlstr += "MappedExten=" + "'" + acct.MappedExten + "', ";
                sqlstr += "SIPProtocol=" + acct.SIPProtocol.ToString() + ", ";

                sqlstr += "ModTag=1 ";
                sqlstr += "WHERE ID = " + acct.AccID.ToString();

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                    return true;
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            return false;
        }*/

        public static void LoadSecurityFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            pbx.IPFilterList.Clear();

            try
            {
                string sqlstr = "DELETE FROM cfg_security WHERE ModTag = 2";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "SELECT ID, WhiteOrBlack, FilterType, IPAddr, CallID, MacAddr, ModTag FROM cfg_security";

                DbDataReader myReader = db_set.ExcuteQuerySQL(sqlstr, env);

                try
                {
                    while (myReader.Read())
                    {
                        IPFilter filter = new IPFilter();

                        filter.DBIdx = myReader.GetInt32(0);
                        filter.WhiteOrBlack = myReader.GetInt16(1);
                        filter.FilterType = myReader.GetInt16(2);
                        filter.IPAddr = myReader.GetString(3);
                        filter.CallID = myReader.GetString(4);
                        filter.MACAddr = myReader.GetString(5);

                        pbx.IPFilterList.Add(filter);
                    }
                }
                catch (Exception e)
                {
                    if (log != null)
                        log.LogoutText(e.ToString());
                }
                finally
                {
                    myReader.Close();
                }

                sqlstr = "UPDATE cfg_security SET ModTag = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }


/////////////////////////////Security DB tables//////////////////////////////////////////////////////

        

//*****************************************************************************
        /*
                public static void RefreshAutoDialerTasksConfig(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
                {
                    bool bChanged = false;

                    try
                    {
                        SqlCommand catCMD = myConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        string sqlstr = "SELECT * FROM cfg_autodialertasks WHERE ModTag != 0";

                        SqlDataReader myReader = catCMD.ExecuteReader();

                        try
                        {
                            while (myReader.Read())
                            {
                                AutoDialerTask task = pbx.getAutoDialerTaskByName(myReader.GetString(0));

                                if (myReader.GetInt16(7) == 2)
                                {
                                    //ModTag == 2, need remove.
                                    if (task != null)
                                    {
                                        pbx.auto_dialer_tasks.Remove(task);
                                    }

                                    bChanged = true;
                                    continue;
                                }

                                if (task == null)
                                {
                                    task = new AutoDialerTask();
                                    task.task_name = myReader.GetString(0);
                                    pbx.auto_dialer_tasks.Add(task);

                                    bChanged = true;
                                }

                                task.isOn = myReader.GetByte(1) == 1;
                                task.type_code = myReader.GetInt16(2);
                                task.sip_acc = myReader.GetString(3);
                                task.dial_plan = myReader.GetString(4);
                                task.m_ringTimeout = myReader.GetInt32(5);
                                task.m_maxSimCalls = myReader.GetInt32(6);
                            }
                        }
                        catch (Exception e)
                        {
                            if (log != null)
                                log.LogoutText(e.ToString());
                        }
                        finally
                        {
                            myReader.Close();
                        }

                        if (bChanged)
                        {
                            string sqlstr = "DELETE FROM cfg_autodialertasks WHERE ModTag = 2";
                            if (catCMD.ExecuteNonQuery() >= 1)
                            {
                            }
                        }

                        string sqlstr = "UPDATE cfg_autodialertasks SET ModTag = 0 WHERE ModTag = 1";
                        if (catCMD.ExecuteNonQuery() >= 1)
                        {
                        }

                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }

                }

                public static bool RemoveAutoDialerTasksFromDB(AutoDialerTask task, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
                {
                    try
                    {
                        SqlCommand catCMD = myConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        string sqlstr = "UPDATE cfg_autodialertasks SET ModTag=2 WHERE Name = '" + task.task_name + "'";

                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                            return true;
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }

                    return false;
                }

                public static bool UpdateAutoDialerTasksInDB(AutoDialerTask task, SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
                {
                    try
                    {
                        SqlCommand catCMD = myConn.CreateCommand();
                           catCMD.CommandTimeout = 3;
                        string sqlstr = "UPDATE cfg_autodialertasks SET ";

                        sqlstr += "Enabled=" + (task.isOn ? "1, " : "0, ");
                        sqlstr += "Type=" + task.type_code.ToString() + ", ";
                        sqlstr += "SIPAcct='" + task.sip_acc.ToString() + "', ";
                        sqlstr += "DialPlan='" + task.dial_plan.ToString() + "', ";
                        sqlstr += "RingTimeout=" + task.m_ringTimeout.ToString() + ", ";
                        sqlstr += "MaxCalls=" + task.m_maxSimCalls.ToString() + ", ";
                        sqlstr += "ModTag=1 ";
                        sqlstr += "WHERE Name = '" + task.task_name + "'";

                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                        {
                            return true;
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }

                    return false;
                }

                public static void LoadAutoDialerTasksConfigFromDB(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
                {
                    pbx.auto_dialer_tasks.Clear();

                    try
                    {

                        SqlCommand catCMD = myConn.CreateCommand();
                        catCMD.CommandTimeout = 3;
                        string sqlstr = "DELETE FROM cfg_autodialertasks WHERE ModTag = 2";

                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                        {
                        }

                        string sqlstr = "SELECT * FROM cfg_autodialertasks";

                        SqlDataReader myReader = catCMD.ExecuteReader();

                        try
                        {
                            while (myReader.Read())
                            {
                                AutoDialerTask task = new AutoDialerTask();

                                task.task_name = myReader.GetString(0);
                                task.isOn = myReader.GetByte(1) == 1;
                                task.type_code = myReader.GetInt16(2);
                                task.sip_acc = myReader.GetString(3);
                                task.dial_plan = myReader.GetString(4);
                                task.m_ringTimeout = myReader.GetInt32(5);
                                task.m_maxSimCalls = myReader.GetInt32(6);

                                pbx.auto_dialer_tasks.Add(task);
                            }
                        }
                        catch (Exception e)
                        {
                            if (log != null)
                                log.LogoutText(e.ToString());
                        }
                        finally
                        {
                            myReader.Close();
                        }

                        string sqlstr = "UPDATE cfg_autodialertasks SET ModTag = 0";

                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                        {
                        }
                    }
                    catch (Exception e)
                    {
                        if (log != null)
                            log.LogoutText(e.ToString());
                    }

                }
        */

        public static void UpgradeDBTo320(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cdr_agent ADD Param1 varchar(80), Param2 varchar(80), Param3 varchar(80)";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            try
            {
                string sqlstr = "ALTER TABLE cdr_pbx ADD CallDir tinyint";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            try
            {
                string sqlstr = "ALTER TABLE cdr_acd ADD CallDir tinyint";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

            try
            {
                string sqlstr = "ALTER TABLE cdr_exten ADD CallDir tinyint";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo329(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_sipaccounts ADD UseLocalIPInFrom TinyInt NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_sipaccounts SET UseLocalIPInFrom = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo311(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_sipaccounts ADD AcceptOtherID TinyInt NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_sipaccounts SET AcceptOtherID = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo309(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_extensions ADD AuthType INT";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_extensions SET AuthType = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo308(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cdr_pbx ADD CallID varchar(40) NULL";

                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cdr_acd ADD CallID varchar(40) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cdr_exten ADD CallID varchar(40) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void UpgradeDBTo322(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_extensions ADD OnlyAgentLogin TINYINT";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_extensions SET OnlyAgentLogin = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo331(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_extensions ADD MappedContactAddr varchar(120), RegSrcIP varchar(120), RegSrcPort INT";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_extensions SET MappedContactAddr = '', RegSrcIP = '', RegSrcPort = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void UpgradeDBTo346(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_sipaccounts ADD MappedExten varchar(80) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_sipaccounts SET MappedExten = ''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo348(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_agents ADD SkillLevel SmallInt NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_agents SET SkillLevel = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cdr_pbx ADD Transferred tinyint, IVRKeys varchar(256)";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cdr_pbx SET Transferred = 0, IVRKeys = ''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cdr_acd ADD Transferred tinyint";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cdr_acd SET Transferred = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cdr_exten ADD Transferred tinyint";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cdr_exten SET Transferred = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE auto_dialer_jobs ADD TaskID varchar(60) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE auto_dialer_jobs SET TaskID = ''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE auto_dialer_done ADD TaskID varchar(60) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE auto_dialer_done SET TaskID = ''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo350(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_conferencerooms ADD MaxCallNum INT, JoinPrompt varchar(256), LeavePrompt varchar(256)";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_conferencerooms SET MaxCallNum = 0, JoinPrompt='', LeavePrompt=''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE status_channel ADD CallID varchar(40)";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }


            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo351(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_conferencerooms ADD MOHDir varchar(256), DiscCall TinyINT, HostPW varchar(256), HostPrompt varchar(256)";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_conferencerooms SET MOHDir='', DiscCall=0, HostPW='', HostPrompt=''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo352(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE auto_dialer_done ADD DetectResult int NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE auto_dialer_done SET DetectResult=-3";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cfg_autodialertasks ADD EnableDetect TinyINT NULL, DiscAfterDetect TinyINT NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_autodialertasks SET EnableDetect=0, DiscAfterDetect=0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void UpgradeDBTo353(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE voice_mailbox ADD CallID varchar(40) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE voice_mailbox SET CallID=''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cdr_pbx ADD DiscReason varchar(80)";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cdr_pbx SET DiscReason=''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cdr_acd ADD DiscReason varchar(80)";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cdr_acd SET DiscReason=''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cdr_exten ADD DiscReason varchar(80)";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cdr_exten SET DiscReason=''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }


            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }

        }

        public static void UpgradeDBTo354(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_conferencerooms ADD RecordCall TinyINT";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_conferencerooms SET RecordCall=0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cdr_pbx ADD ConfName varchar(80)";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cdr_pbx SET ConfName=''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo357(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE auto_dialer_done ADD FinalCode int NULL, FinalDesc varchar(120) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE auto_dialer_done SET FinalCode=0, FinalDesc=''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo358(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_extensions ADD MultipleCall TINYINT NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_extensions SET MultipleCall=0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo359(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_sipaccounts ADD AppendExtenID TinyInt NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_sipaccounts SET AppendExtenID = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo360(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_ringgroups ADD AnswerCallFirst TinyInt NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_ringgroups SET AnswerCallFirst = 1";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        //for 361, change DiscReason of cdr_pbx to 256, and change all other places which handle discReason to 256 length.

        public static void UpgradeDBTo361(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cdr_pbx ALTER COLUMN DiscReason varchar(256)";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cdr_acd ALTER COLUMN DiscReason varchar(256)";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cdr_exten ALTER COLUMN DiscReason varchar(256)";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo362(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_agents ADD Paused TinyInt NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_agents SET Paused = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo363(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_sipaccounts ADD SIPProtocol TinyInt NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_sipaccounts SET SIPProtocol = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo364(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_extensions ADD VMBPassword varchar(40) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_extensions SET VMBPassword = ''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cfg_huntgroups ADD VMBPassword varchar(40) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_huntgroups SET VMBPassword = ''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cfg_parkingslots ADD VMBPassword varchar(40) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_parkingslots SET VMBPassword = ''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cfg_ringgroups ADD VMBPassword varchar(40) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_ringgroups SET VMBPassword = ''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo365(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_conferencerooms ADD EveryonePW TinyINT";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_conferencerooms SET EveryonePW = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo366(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_extensions ADD MaxRegExpSec INT NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_extensions SET MaxRegExpSec = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo367(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "EXEC sp_rename 'dbo.auto_dialer_jobs.TaskID', 'JobID', 'COLUMN'";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "EXEC sp_rename 'dbo.auto_dialer_done.TaskID', 'JobID', 'COLUMN'";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE auto_dialer_done ADD CallID varchar(40) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE auto_dialer_done SET CallID = ''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo368(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_huntgroups ADD MaxNumOfCalls INT NULL, CallForwardingType SmallInt NULL, CallForwardingPlan varchar(80) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_huntgroups SET MaxNumOfCalls=0, CallForwardingType=0, CallForwardingPlan=''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE status_channel ADD AutoDialerId bigint NULL, AutoDialerJobId varchar(60) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE status_channel SET AutoDialerId=0, AutoDialerJobId=''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo368_1(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            if (db_set.dbType == -1) //SQLite
                return;

            try
            {
                //v3.68f added
                if (!DBServerSetting.ColumnExists(db_set.myConn, "SIPTrunk", "cfg_sipaccounts"))
                {
                    try
                    {
                        string sqlstr = "ALTER TABLE cfg_sipaccounts ADD SIPTrunk TinyInt NULL";
                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                        {
                        }

                        sqlstr = "UPDATE cfg_sipaccounts SET SIPTrunk = 0";
                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                        {
                        }
                    }
                    catch (Exception ex)
                    {
                        //if (log != null) log.LogoutText(e.ToString());
                    }
                }

                //3.68g added
                if (!DBServerSetting.ColumnExists(db_set.myConn, "PromptQueuePosition", "cfg_huntgroups"))
                {
                    try
                    {
                        string sqlstr = "ALTER TABLE cfg_huntgroups ADD PromptQueuePosition SmallInt NULL";
                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                        {
                        }

                        sqlstr = "UPDATE cfg_huntgroups SET PromptQueuePosition = 0";
                        if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                        {
                        }
                    }
                    catch (Exception ex)
                    {
                        //if (log != null) log.LogoutText(e.ToString());
                    }
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo371(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cdr_pbx ADD HangupParty varchar(250) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cdr_pbx SET HangupParty=''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cdr_acd ADD HangupParty varchar(250) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cdr_acd SET HangupParty=''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cdr_exten ADD HangupParty varchar(250) NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cdr_exten SET HangupParty=''";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

        public static void UpgradeDBTo380(SIPPBXMain pbxMain, SIPPBX pbx, GTSIPPBXEnv env, DBServerSetting db_set, SIPPBXLog log)
        {
            try
            {
                string sqlstr = "ALTER TABLE cfg_extensions ADD UseSRTP TINYINT NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_extensions SET UseSRTP = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "ALTER TABLE cfg_sipaccounts ADD UseSRTP TINYINT NULL";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                sqlstr = "UPDATE cfg_sipaccounts SET UseSRTP = 0";
                if (db_set.ExcuteNonQuerySQL(sqlstr, env) == 1)
                {
                }

                
            }
            catch (Exception e)
            {
                if (log != null)
                    log.LogoutText(e.ToString());
            }
        }

    }
}
