using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.IO;
using System.Threading;
using System.Data.SqlClient;
using Microsoft.Win32;
using System.Reflection;
using System.ServiceProcess;


namespace SIPPBXv3
{
    public class SIPPBXWinUtil
    {
        public static bool IsValidIPAddress(string addr)
        {
            //create our match pattern
            string pattern = @"^([1-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\.
    ([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){3}$";
            //create our Regular Expression object
            Regex check = new Regex(pattern);
            //boolean variable to hold the status
            bool valid = false;
            //check to make sure an ip address was provided
            if (addr == "")
            {
                //no address provided so return false
                valid = false;
            }
            else
            {
                //address provided so use the IsMatch Method
                //of the Regular Expression object
                try
                {
                    valid = check.IsMatch(addr, 0);
                }
                catch (Exception)
                {
                }
            }

            //return the results
            return valid;
        }

        public static void AddDigitsToVoiceList(SIPPBX pbx, List<string> a_list, string digits)
        {
            for (int i = 0; i < digits.Length; i++)
            {
                a_list.Add(digits[i].ToString() + ".wav");
            }
        }

        public static void AddShortDateTimeToVoiceList(SIPPBX pbx, List<string> a_list, DateTime dt)
        {
            string amorpm = "";
            int dtHour = dt.Hour;
            if (dtHour >= 12)
                amorpm = "PM.wav";
            else
                amorpm = "AM.wav";
            dtHour = dtHour % 12;
            if (dtHour == 0)
                dtHour = 12;

            a_list.Add(pbx.pbx_dir + "\\audio\\at.wav");
            a_list.Add(pbx.pbx_dir + "\\audio\\" + dtHour.ToString() + ".wav");
            AddNumberToVoiceList(pbx, a_list, dt.Minute);
            a_list.Add(pbx.pbx_dir + "\\audio\\" + amorpm);
            //a_list.Add(pbx.pbx_dir + "\\audio\\minutes.wav");
            //AddNumberToVoiceList(pbx, a_list, dt.Second);
            //a_list.Add(pbx.pbx_dir + "\\audio\\seconds.wav");

            switch (dt.Month)
            {
                case 1:
                    a_list.Add(pbx.pbx_dir + "\\audio\\January.wav");
                    break;
                case 2:
                    a_list.Add(pbx.pbx_dir + "\\audio\\February.wav");
                    break;
                case 3:
                    a_list.Add(pbx.pbx_dir + "\\audio\\March.wav");
                    break;
                case 4:
                    a_list.Add(pbx.pbx_dir + "\\audio\\April.wav");
                    break;
                case 5:
                    a_list.Add(pbx.pbx_dir + "\\audio\\May.wav");
                    break;
                case 6:
                    a_list.Add(pbx.pbx_dir + "\\audio\\June.wav");
                    break;
                case 7:
                    a_list.Add(pbx.pbx_dir + "\\audio\\July.wav");
                    break;
                case 8:
                    a_list.Add(pbx.pbx_dir + "\\audio\\August.wav");
                    break;
                case 9:
                    a_list.Add(pbx.pbx_dir + "\\audio\\September.wav");
                    break;
                case 10:
                    a_list.Add(pbx.pbx_dir + "\\audio\\October.wav");
                    break;
                case 11:
                    a_list.Add(pbx.pbx_dir + "\\audio\\November.wav");
                    break;
                case 12:
                    a_list.Add(pbx.pbx_dir + "\\audio\\December.wav");
                    break;
            }

            AddNumberToVoiceList(pbx, a_list, dt.Day);
            //AddNumberToVoiceList(pbx, a_list, dt.Year);
        }

        public static void AddDateTimeToVoiceList(SIPPBX pbx, List<string> a_list, DateTime dt)
        {
            string amorpm = "";
            int dtHour = dt.Hour;
            if (dtHour >= 12)
                amorpm = "PM.wav";
            else
                amorpm = "AM.wav";
            dtHour = dtHour % 12;
            if(dtHour == 0)
                dtHour = 12;

            a_list.Add(pbx.pbx_dir + "\\audio\\at.wav");
            a_list.Add(pbx.pbx_dir + "\\audio\\" + dtHour.ToString() + ".wav");
            AddNumberToVoiceList(pbx, a_list, dt.Minute);
            a_list.Add(pbx.pbx_dir + "\\audio\\" + amorpm);
            //a_list.Add(pbx.pbx_dir + "\\audio\\minutes.wav");
            AddNumberToVoiceList(pbx, a_list, dt.Second);
            a_list.Add(pbx.pbx_dir + "\\audio\\seconds.wav");

            switch(dt.Month)
            {
                case 1:
                    a_list.Add(pbx.pbx_dir + "\\audio\\January.wav");
                    break;
                case 2:
                    a_list.Add(pbx.pbx_dir + "\\audio\\February.wav");
                    break;
                case 3:
                    a_list.Add(pbx.pbx_dir + "\\audio\\March.wav");
                    break;
                case 4:
                    a_list.Add(pbx.pbx_dir + "\\audio\\April.wav");
                    break;
                case 5:
                    a_list.Add(pbx.pbx_dir + "\\audio\\May.wav");
                    break;
                case 6:
                    a_list.Add(pbx.pbx_dir + "\\audio\\June.wav");
                    break;
                case 7:
                    a_list.Add(pbx.pbx_dir + "\\audio\\July.wav");
                    break;
                case 8:
                    a_list.Add(pbx.pbx_dir + "\\audio\\August.wav");
                    break;
                case 9:
                    a_list.Add(pbx.pbx_dir + "\\audio\\September.wav");
                    break;
                case 10:
                    a_list.Add(pbx.pbx_dir + "\\audio\\October.wav");
                    break;
                case 11:
                    a_list.Add(pbx.pbx_dir + "\\audio\\November.wav");
                    break;
                case 12:
                    a_list.Add(pbx.pbx_dir + "\\audio\\December.wav");
                    break;
            }

            AddNumberToVoiceList(pbx, a_list, dt.Day);
            AddNumberToVoiceList(pbx, a_list, dt.Year);
        }

        public static void AddNumberToVoiceList(SIPPBX pbx, List<string> a_list, int num)
        {
            int million = 0;
            int thousand = 0;
            int hundred = 0;
            int tenty = 0;

            if (num == 0)
            {
                a_list.Add(pbx.pbx_dir + "\\audio\\0.wav");
                return;
            }

            if(num >= 1000000)
            {
                million = num / 1000000;
                num -= million * 1000000;
            }
            if (num >= 1000 && num < 1000000)
            {
                thousand = num / 1000;
                num -= thousand * 1000;
            }
            if (num >= 100 && num < 1000)
            {
                hundred = num / 100;
                num -= hundred * 100;
            }
            if (num >= 20 && num < 100)
            {
                tenty = num / 10;
                num -= tenty * 10;
            }

            if (million > 0)
            {
                AddNumberToVoiceList(pbx, a_list, million);
                a_list.Add(pbx.pbx_dir + "\\audio\\Million.wav");
            }

            if (thousand > 0)
            {
                AddNumberToVoiceList(pbx, a_list, thousand);
                a_list.Add(pbx.pbx_dir + "\\audio\\Thousand.wav");
            }

            if (hundred > 0)
            {
                a_list.Add(pbx.pbx_dir + "\\audio\\" + hundred.ToString() + ".wav");
                a_list.Add(pbx.pbx_dir + "\\audio\\Hundred.wav");
            }

            if (tenty > 0)
            {
                tenty *= 10;
                a_list.Add(pbx.pbx_dir + "\\audio\\" + tenty.ToString() + ".wav");
            }

            if (num > 0)
            {
                a_list.Add(pbx.pbx_dir + "\\audio\\" + num.ToString() + ".wav");
            }
        }

        public static string RemoveOddCharForSQLStr(string sOrg)
        {
            string sRet = "";
            for (int i = 0; i < sOrg.Length; i++)
            {
                if (sOrg[i] != '\'')
                {

                    if ((sOrg[i] >= 'a' && sOrg[i] <= 'z') ||
                        (sOrg[i] >= 'A' && sOrg[i] <= 'Z') ||
                        (sOrg[i] >= '0' && sOrg[i] <= '9'))
                    {
                        sRet += sOrg[i];
                    }
                }
            }
            return sRet;
        }

        public static string GetCallerDisplayName(GTAPIASM.GTAPIChan chan)
        {
            if (chan.originate)
                return GTAPIASM.GTAPIEnv.GetSIPAddressInfo(0, chan.callee_num);
            else
                return GTAPIASM.GTAPIEnv.GetSIPAddressInfo(0, chan.caller_num);
        }

        public static string BuildCallerID(GTAPIASM.GTAPIChan chan/*, SIPPBXExten extn*/, string sAltDisplayName)
        {
            //chan.pEnv.LOG_Trace(4, "BuildCallerID caller:" + chan.caller_num + " callee:" + chan.callee_num);
            string sID = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, chan.caller_num);
            string sDisplayName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(0, chan.caller_num);
            if (chan.originate)
            {
                sID = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, chan.callee_num);
                sDisplayName = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(0, chan.callee_num);
            }

            if (sAltDisplayName.Length > 0)
                sDisplayName = sAltDisplayName;

            //chan.pEnv.LOG_Trace(4, "sID:" + sID);

            string sCaller;

            if (sID.Length > 0)
            {
                /*
                if (chan.originate)
                    sCaller = chan.callee_num;
                else
                    sCaller = chan.caller_num;
                */
                sCaller = sDisplayName + "<sip:" + sID + "@" + chan.pEnv.GetMappedPublicSIPIPAddress() + ":" + chan.pEnv.GetMappedPublicSIPIPPort() + ">";
            }
            else
            {
                //caller id is empty
                //string sExtenIP = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, chan.caller_num);
                //string sExtenPort = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(3, chan.caller_num);

                //sCaller = "<sip:unknown@";
                //sCaller += sExtenIP;

                //if (sExtenPort.Length > 0)
                //{
                //    sCaller += ":";
                //    sCaller += sExtenPort;
                //}
                //sCaller += ">";

                sCaller = sDisplayName + "<sip:unknown@" + chan.pEnv.GetMappedPublicSIPIPAddress() + ":" + chan.pEnv.GetMappedPublicSIPIPPort() + ">";
            }

            //chan.pEnv.LOG_Trace(4, "sCaller:" + sCaller);

            return sCaller;
        }

        public static string BuildCalleeID(GTAPIASM.GTAPIChan chan, SIPPBXExten extn, SIPPBXChan pbx_chan)
        {
            string sCallee = "";
            string sID;
            string sExtenIP = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, extn.ContactAddr);
            string sExtenPort = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(3, extn.ContactAddr);

            if (extn.bAcceptOtherID)
            {
                if (pbx_chan.target_did.Length > 0)
                {
                    sCallee = "<sip:" + pbx_chan.target_did;
                }
                else
                {
                    sID = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, chan.callee_num);
                    if(chan.originate)
                        sID = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, chan.caller_num);

                    if(sID.Length > 0)
                        sCallee = "<sip:" + sID;
                    else
                        sCallee = "<sip:unknown";
                }

                sCallee += "@";
                sCallee += sExtenIP;

                if (sExtenPort.Length > 0)
                {
                    sCallee += ":";
                    sCallee += sExtenPort;
                }

                if (extn.ContactAddr.Contains("transport=tcp")) //extension is on TCP
                {
                    sCallee += ";transport=tcp";
                }

                sCallee += ">";
            }
            else
            {
/*
                if (extn.RegFromID.Length > 0)
                {
                    sCallee = extn.RegFromID; //not good idea, because it may get loop. The ip may be the local pbx ip.
                }
                else
 */
                {
                    sID = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(1, extn.ContactAddr);

                    if (sID.Length > 0)
                        sCallee = "<sip:" + sID;
                    else
                        sCallee = "<sip:" + extn.UserName;

                    sCallee += "@";
                    sCallee += sExtenIP;

                    if (sExtenPort.Length > 0)
                    {
                        sCallee += ":";
                        sCallee += sExtenPort;
                    }

                    if (extn.ContactAddr.Contains("transport=tcp")) //extension is on TCP
                    {
                        sCallee += ";transport=tcp";
                    }

                    sCallee += ">";
                }
            }

            return sCallee;
        }

        public static void SetChanAudioCodec(SIPPBXExten exten, GTSIPPBXEnv env, SIPPBX pbx, SIPPBXChan chan, SIPPBXChan chan1)
        {
            if (exten == null)
            {
                //outline
                if (pbx.pbx_sys_set.PreferOutlineCodec.Length > 0)
                {
                    try
                    {
                        env.SetChanAudioCodec(chan.index, Convert.ToInt32(pbx.pbx_sys_set.PreferOutlineCodec));
                    }
                    catch (Exception)
                    {
                        if (chan1 != null)
                        {
                            if (env.IsChanConnected(chan1.index))
                                env.SetChanAudioCodec(chan.index, env.GetChanAudioCodec(chan1.index));
                        }
                    }
                }
                else
                {
                    if (chan1 != null)
                    {
                        if (env.IsChanConnected(chan1.index))
                            env.SetChanAudioCodec(chan.index, env.GetChanAudioCodec(chan1.index));
                    }
                }
            }
            else
            {
                //to extension
                string sipAddr = GTAPIASM.GTAPIEnv.GetSIPAddressInfo(2, exten.ContactAddr);
                if (!GTAPIASM.GTAPIEnv.IsInPrivateIPAddressRange(sipAddr))
                {
                    //outline
                    if (pbx.pbx_sys_set.PreferOutlineCodec.Length > 0)
                    {
                        try
                        {
                            env.SetChanAudioCodec(chan.index, Convert.ToInt32(pbx.pbx_sys_set.PreferOutlineCodec));
                        }
                        catch (Exception)
                        {
                            if (chan1 != null)
                            {
                                if (env.IsChanConnected(chan1.index))
                                    env.SetChanAudioCodec(chan.index, env.GetChanAudioCodec(chan1.index));
                            }
                        }
                    }
                    else
                    {
                        if (chan1 != null)
                        {
                            if (env.IsChanConnected(chan1.index))
                                env.SetChanAudioCodec(chan.index, env.GetChanAudioCodec(chan1.index));
                        }
                    }
                }
                else
                {
                    if (pbx.pbx_sys_set.PreferExtensionCodec.Length > 0)
                    {
                        try
                        {
                            env.SetChanAudioCodec(chan.index, Convert.ToInt32(pbx.pbx_sys_set.PreferExtensionCodec));
                        }
                        catch (Exception)
                        {
                            if (chan1 != null)
                            {
                                if (env.IsChanConnected(chan1.index))
                                    env.SetChanAudioCodec(chan.index, env.GetChanAudioCodec(chan1.index));
                            }
                        }
                    }
                    else
                    {
                        if (chan1 != null)
                        {
                            if (env.IsChanConnected(chan1.index))
                                env.SetChanAudioCodec(chan.index, env.GetChanAudioCodec(chan1.index));
                        }
                    }
                }
            }

        }

        public static void AddExtensionsIntoComboBox(SIPPBX pbx, ComboBox cb, string defValue)
        {
            int idx = 0;
            cb.Items.Clear();
            if (pbx.sip_exten.Count > 0)
            {
                cb.Enabled = true;
                for (int i = 0; i < pbx.sip_exten.Count; i++)
                {
                    cb.Items.Add(pbx.sip_exten[i].UserName);
                    if (defValue.Length > 0)
                    {
                        if (defValue == pbx.sip_exten[i].UserName)
                            idx = i;
                    }
                }

                if (idx == -1)
                    idx = 0;

                cb.SelectedIndex = idx;
            }
            else
                cb.Enabled = false;
        }

        public static void AddHuntgroupsIntoComboBox(SIPPBX pbx, ComboBox cb, string defValue)
        {
            int idx = 0;
            cb.Items.Clear();
            if (pbx.sip_huntgroups.Count > 0)
            {
                cb.Enabled = true;
                for (int i = 0; i < pbx.sip_huntgroups.Count; i++)
                {
                    cb.Items.Add(pbx.sip_huntgroups[i].hgName);
                    if (defValue.Length > 0)
                    {
                        if (defValue == pbx.sip_huntgroups[i].hgName)
                            idx = i;
                    }
                }

                if (idx == -1)
                    idx = 0;

                cb.SelectedIndex = idx;
            }
            else
                cb.Enabled = false;
        }

        public static void AddRinggroupsIntoComboBox(SIPPBX pbx, ComboBox cb, string defValue)
        {
            int idx = 0;
            cb.Items.Clear();
            if (pbx.sip_ringgroups.Count > 0)
            {
                cb.Enabled = true;
                for (int i = 0; i < pbx.sip_ringgroups.Count; i++)
                {
                    cb.Items.Add(pbx.sip_ringgroups[i].gpName);
                    if (defValue.Length > 0)
                    {
                        if (defValue == pbx.sip_ringgroups[i].gpName)
                            idx = i;
                    }
                }

                if (idx == -1)
                    idx = 0;

                cb.SelectedIndex = idx;
            }
            else
                cb.Enabled = false;
        }

        public static void AddMonitorgroupsIntoComboBox(SIPPBX pbx, ComboBox cb, string defValue)
        {
            int idx = 0;
            cb.Items.Clear();
            if (pbx.sip_monitorgroups.Count > 0)
            {
                cb.Enabled = true;
                for (int i = 0; i < pbx.sip_monitorgroups.Count; i++)
                {
                    cb.Items.Add(pbx.sip_monitorgroups[i].mgName);
                    if (defValue.Length > 0)
                    {
                        if (defValue == pbx.sip_monitorgroups[i].mgName)
                            idx = i;
                    }
                }

                if (idx == -1)
                    idx = 0;

                cb.SelectedIndex = idx;
            }
            else
                cb.Enabled = false;
        }

        public static void AddDialplanIntoComboBox(SIPPBX pbx, ComboBox cb, string defValue)
        {
            int cnt = 0;
            int idx = 0;
            cb.Items.Clear();
            if (pbx.sip_dialplan.Count > 0)
            {
                cb.Enabled = true;
                for (int i = 0; i < pbx.sip_dialplan.Count; i++)
                {
                    if (pbx.sip_dialplan[i].CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND)
                    {
                        cb.Items.Add(pbx.sip_dialplan[i].planName);
                        if (defValue.Length > 0)
                        {
                            if (defValue == pbx.sip_dialplan[i].planName)
                                idx = i;
                        }
                        cnt++;
                    }
                }

                if (idx == -1)
                    idx = 0;

                if(cnt > 0)
                    cb.SelectedIndex = idx;
                else
                    cb.Enabled = false;
            }
            else
                cb.Enabled = false;

        }

        public static void AddIVRMenusIntoComboBox(SIPPBX pbx, ComboBox cb, string defValue)
        {
            int idx = 0;
            cb.Items.Clear();
            if (pbx.sip_ivrs.Count > 0)
            {
                cb.Enabled = true;
                for (int i = 0; i < pbx.sip_ivrs.Count; i++)
                {
                    cb.Items.Add(pbx.sip_ivrs[i].name);
                    if (defValue.Length > 0)
                    {
                        if (defValue == pbx.sip_ivrs[i].name)
                            idx = i;
                    }
                }

                if (idx == -1)
                    idx = 0;

                cb.SelectedIndex = idx;
            }
            else
                cb.Enabled = false;
        }

        public static void AddConferoomsIntoComboBox(SIPPBX pbx, ComboBox cb, string defValue)
        {
            int idx = 0;
            cb.Items.Clear();

            if (pbx.sip_conferooms.Count > 0)
            {
                cb.Enabled = true;
                for (int i = 0; i < pbx.sip_conferooms.Count; i++)
                {
                    cb.Items.Add(pbx.sip_conferooms[i].conf_name);
                    if (defValue.Length > 0)
                    {
                        if (defValue == pbx.sip_conferooms[i].conf_name)
                            idx = i;
                    }
                }

                if (idx == -1)
                    idx = 0;

                cb.SelectedIndex = idx;
            }
            else
                cb.Enabled = false;
        }

        public static void AddPluginsIntoComboBox(SIPPBX pbx, ComboBox cb, string defValue)
        {
            int idx = 0;
            cb.Items.Clear();

            if (pbx.plugins.Count > 0)
            {
                cb.Enabled = true;
                for (int i = 0; i < pbx.plugins.Count; i++)
                {
                    cb.Items.Add(pbx.plugins[i].Name);
                    if (defValue.Length > 0)
                    {
                        if (defValue == pbx.plugins[i].Name)
                            idx = i;
                    }
                }

                if (idx == -1)
                    idx = 0;

                cb.SelectedIndex = idx;
            }
            else
                cb.Enabled = false;
        }

        public static void AddInboundDialplanIntoComboBox(SIPPBX pbx, ComboBox cb, string defValue)
        {
            cb.Items.Clear();
            for (int i = 0; i < pbx.sip_dialplan.Count; i++)
            {
                if (pbx.sip_dialplan[i].CallDirection == SIPPBXDialPlan.DIALPLAN_CALL_DIRECTION.CALL_DIR_INBOUND)
                {
                    cb.Items.Add(pbx.sip_dialplan[i].planName);
                }
            }
            cb.Text = defValue;
        }

        public static DateTime GetDotNetDateTime(string s)
        {
            string temp = "";
            temp += s[0];
            temp += s[1];
            temp += s[2];
            temp += s[3];
            int dtYear = Convert.ToInt32(temp);

            temp = "";
            temp += s[5];
            temp += s[6];
            int dtMonth = Convert.ToInt32(temp);

            temp = "";
            temp += s[8];
            temp += s[9];
            int dtDay = Convert.ToInt32(temp);

            temp = "";
            temp += s[11];
            temp += s[12];
            int dtHour = Convert.ToInt32(temp);

            temp = "";
            temp += s[14];
            temp += s[15];
            int dtMinute = Convert.ToInt32(temp);

            temp = "";
            temp += s[17];
            temp += s[18];
            int dtSecond = Convert.ToInt32(temp);

            DateTime dt = new DateTime(dtYear, dtMonth, dtDay, dtHour, dtMinute, dtSecond);
            return dt;
        }

        /*
         *SQLite DateTime format:
         *A time value can be in any of the following formats shown below. The value is usually a string, though it can be an integer or floating point number in the case of format 12.

        YYYY-MM-DD
        YYYY-MM-DD HH:MM
        YYYY-MM-DD HH:MM:SS
        YYYY-MM-DD HH:MM:SS.SSS
        YYYY-MM-DDTHH:MM
        YYYY-MM-DDTHH:MM:SS
        YYYY-MM-DDTHH:MM:SS.SSS
        HH:MM
        HH:MM:SS
        HH:MM:SS.SSS
        now
        DDDDDDDDDD
         * 
        */

        public static string GetSQLiteDateTime(DateTime dt)
        {
            return dt.ToString("yyyy-MM-dd HH:mm:ss");
        }

        public static string GetSQLDateTime(DateTime dt)
        {
            return dt.ToString("yyyy-MM-ddTHH:mm:ss");
            /*
            string sret = "";
            sret += dt.Year.ToString() + "-" + dt.Month.ToString() + "-" + dt.Day.ToString() + " ";
            sret += dt.Hour.ToString() + ":" + dt.Minute.ToString() + ":" + dt.Second.ToString();
            return sret;
             */
        }

        public static string GetFNDateTime(DateTime dt)
        {
            return dt.ToString("yyyyMMdd-HHmmss");
        }

        public static string GetDirDateTime(DateTime dt)
        {
            return dt.ToString("yyyyMMdd");
        }

        public static string AddFolderDashForDir(string sDir)
        {
            string ret = sDir;
            if (sDir[sDir.Length - 1] != '\\')
                ret += '\\';
            return ret;
        }

        public static void DoCallForwardingForExtension(SIPPBX pbx, GTSIPPBXEnv env, SIPPBXChan pbx_chan, SIPPBXExten extn)
        {
            //if (extn.IsVirtualExten()) return; 
            //2012/05/31 decided remove this limitation to allow virtual extension have VoiceMailBox

            if (extn.CallForwardingPlan.Length == 0)
            {
                //goto extension's default VoiceMailBox
                if (extn.vmb != null)
                {
                    pbx_chan.async_op_compound = new GTOpVMB(pbx, env, pbx_chan, extn.vmb);
                    pbx_chan.async_op_compound.start();
                }
                else
                {
                    string logTxt = "DoCallForwardingForExtension => Disconnecting call because exten " + extn.UserName + " doesn't have a voice mail box defined.";
                    env.LOG_Trace(4, logTxt);
                    env.LogoutText(logTxt);
                    env.DisconnectCall(pbx_chan.index, 0, "", "PBX: " + logTxt);
                }
            }
            else
            {
                //to a special dialplan
                SIPPBXDialPlan dp = pbx.getDialPlanByPlanName(extn.CallForwardingPlan);

                if (dp != null)
                {
                    pbx_chan.dp = dp;
                    env.DoDialPlan(pbx_chan.index, pbx_chan, extn, null);
                }
                else
                {
                    string logTxt = "DoCallForwardingForExtension => Disconnecting call because exten " + extn.UserName + " has an invalid dialplan for call forwarding.";
                    env.LOG_Trace(4, logTxt);
                    env.LogoutText(logTxt);
                    env.DisconnectCall(pbx_chan.index, 0, "",  "PBX: " + logTxt);
                }
            }

        }

        public static ServiceControllerStatus GetWinServiceStatus(string strServiceName)
        {
            ServiceController service = new ServiceController(strServiceName);
            ServiceControllerStatus status = service.Status;
            service.Dispose();
            return status;
        }

        public static void StartWinService(string strServiceName)
        {
            ServiceController service = new ServiceController(strServiceName);
            service.Start();
            service.Dispose();
        }

        public static void StopWinService(string strServiceName)
        {
            ServiceController service = new ServiceController(strServiceName);
            service.Stop();
            service.Dispose();
        }

        public static int RandomNumber(int min, int max)
        {
            Random random = new Random();
            return random.Next(min, max);
        }

        public static string RandomString(int size, bool lowerCase)
        {
            StringBuilder builder = new StringBuilder();
            Random random = new Random();
            char ch;
            for (int i = 0; i < size; i++)
            {
                ch = Convert.ToChar(Convert.ToInt32(Math.Floor(26 * random.NextDouble() + 65)));
                builder.Append(ch);
            }
            if (lowerCase)
                return builder.ToString().ToLower();
            return builder.ToString();
        }

        public static string GetPassword()
        {
            StringBuilder builder = new StringBuilder();
            builder.Append(RandomString(4, true));
            builder.Append(RandomNumber(1000, 9999));
            builder.Append(RandomString(2, false));
            return builder.ToString();
        } 

    }

}
