VERSION 5.00
Object = "{8FFA5210-F180-41C6-8E39-E73616B706E8}#1.0#0"; "vr2ctrl.ocx"
Begin VB.Form Form1 
   Caption         =   "PCBest VoIP Recorder V2 - VB6 Sample"
   ClientHeight    =   5310
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   9735
   LinkTopic       =   "Form1"
   ScaleHeight     =   5310
   ScaleWidth      =   9735
   StartUpPosition =   3  'Windows Default
   Begin VR2CtrlLib.VR2Ctrl VR2Ctrl1 
      Height          =   375
      Left            =   8280
      TabIndex        =   7
      Top             =   240
      Visible         =   0   'False
      Width           =   855
      _Version        =   65536
      _ExtentX        =   1508
      _ExtentY        =   661
      _StockProps     =   0
   End
   Begin VB.CommandButton cmdStartAndStop 
      Caption         =   "Start"
      Height          =   375
      Left            =   7680
      TabIndex        =   6
      Top             =   960
      Width           =   1815
   End
   Begin VB.TextBox TextRoot 
      Height          =   285
      Left            =   3960
      TabIndex        =   5
      Text            =   "Text1"
      Top             =   930
      Width           =   3255
   End
   Begin VB.TextBox TextChan 
      Height          =   285
      Left            =   1320
      TabIndex        =   3
      Text            =   "Text1"
      Top             =   960
      Width           =   615
   End
   Begin VB.ComboBox cbNIC 
      Height          =   315
      ItemData        =   "VR2-VB6.frx":0000
      Left            =   840
      List            =   "VR2-VB6.frx":0002
      TabIndex        =   1
      Top             =   360
      Width           =   5895
   End
   Begin VB.Label Chan4Status 
      Height          =   735
      Left            =   1080
      TabIndex        =   15
      Top             =   4440
      Width           =   8415
   End
   Begin VB.Label Label6 
      Caption         =   "Channel 4:"
      Height          =   255
      Left            =   240
      TabIndex        =   14
      Top             =   4440
      Width           =   855
   End
   Begin VB.Label Chan3Status 
      Height          =   615
      Left            =   1200
      TabIndex        =   13
      Top             =   3480
      Width           =   8415
   End
   Begin VB.Label Label7 
      Caption         =   "Channel 3:"
      Height          =   255
      Left            =   240
      TabIndex        =   12
      Top             =   3480
      Width           =   975
   End
   Begin VB.Label Chan2Status 
      Height          =   615
      Left            =   1200
      TabIndex        =   11
      Top             =   2640
      Width           =   8295
   End
   Begin VB.Label Label5 
      Caption         =   "Channel 2:"
      Height          =   255
      Left            =   240
      TabIndex        =   10
      Top             =   2640
      Width           =   975
   End
   Begin VB.Label Chan1Status 
      Height          =   615
      Left            =   1200
      TabIndex        =   9
      Top             =   1800
      Width           =   8415
   End
   Begin VB.Label Label4 
      Caption         =   "Channel 1:"
      Height          =   255
      Left            =   240
      TabIndex        =   8
      Top             =   1800
      Width           =   1095
   End
   Begin VB.Label Label3 
      Caption         =   "Root Folder:"
      Height          =   255
      Left            =   2520
      TabIndex        =   4
      Top             =   960
      Width           =   1095
   End
   Begin VB.Label Label2 
      Caption         =   "Channles:"
      Height          =   255
      Left            =   360
      TabIndex        =   2
      Top             =   960
      Width           =   855
   End
   Begin VB.Label Label1 
      Caption         =   "NIC:"
      Height          =   255
      Left            =   360
      TabIndex        =   0
      Top             =   360
      Width           =   615
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Dim running As Boolean
Public Sub StartRecord()
        VR2Ctrl1.SetAudioRootFolder TextRoot.Text
        
        'log
        VR2Ctrl1.SetLogFileName "c:\temp\vr2-vb6.txt"
        VR2Ctrl1.SetLogLevel 4
        
        'license key
        'VR2Ctrl1.SetLicenseKey "ABCD-EFGH"
        
        'how many channels
        VR2Ctrl1.SetChannelCount 4
        
        'SIP, SCCP or SKINNY, RTP, H323, IAX2, UNISTIM, MGCP
        'NOTE: ONLY SIP, SCCP, RTP, and MGCP work so far
        VR2Ctrl1.SetProtocol "SIP"
        
        'set capturing on which NIC
        VR2Ctrl1.SetNIC cbNIC.ListIndex
		
		'0 == IP Addr,
		'1 == ID for SIP, please only give the username of SIP address, not full <sip:xxx> string.
		'For example, for SIP address <sip:1234@abc.com>, you set 1234 only here.
		'You can use * from any string, and ? for any character. See the sample below.
		'2 = MAC address
		'VR2Ctrl1.SetFilterType 0
		'VR2Ctrl1.SetFilterCount 2
		'VR2Ctrl1.SetFilterItem 0, "192.168.1.100"
		'VR2Ctrl1.SetFilterItem 1, "192.168.1.101"
        
		
        VR2Ctrl1.StartCapture
        
        running = True
        
        cmdStartAndStop.Caption = "Stop"

End Sub

Public Sub StopRecord()
        VR2Ctrl1.StopCapture
        
        'reset environment
        
        VR2Ctrl1.FreeCapture
        VR2Ctrl1.InitCapture 0
        
        running = False
        
        cmdStartAndStop.Caption = "Start"
End Sub



Private Sub cmdStartAndStop_Click()
    If Not running Then
        StartRecord
    Else
        StopRecord
    End If
    
End Sub

Private Sub Form_Load()
    Dim sNICInfo As String
    VR2Ctrl1.InitCapture 0
    For i = 1 To VR2Ctrl1.GetNICCount
        sNICInfo = VR2Ctrl1.GetNICDescription(i - 1)
        sNICInfo = sNICInfo + " - IP:"
        For j = 1 To VR2Ctrl1.GetNICIPCount(i - 1)
            If VR2Ctrl1.GetNICIP(i - 1, j - 1) <> "0.0.0.0" Then
                sNICInfo = sNICInfo + VR2Ctrl1.GetNICIP(i - 1, j - 1) + ";"
            End If
        Next j
        
        cbNIC.AddItem sNICInfo
    Next i
    cbNIC.ListIndex = 0
    TextChan.Text = "4"
    TextChan.Enabled = False
    TextRoot.Text = "c:\temp"
    
    running = False
    
End Sub


Private Sub Form_Unload(Cancel As Integer)
    If running Then
        StopRecord
    End If
    VR2Ctrl1.FreeCapture
End Sub


Private Sub VR2Ctrl1_CallConnected(ByVal ChanID As Long, ByVal CallerIP As String, ByVal CallerID As String, ByVal CalleeIP As String, ByVal CalleeID As String, ByVal InitTime As Long, ByVal ConnectTime As Long, ByVal UniqueID As String, ByVal AudioFile As String, ByVal CallDir As Long)
    If ChanID = 0 Then
        Chan1Status.Caption = "OnCallConnected " + CallerID + " " + CalleeID + " " + AudioFile
    End If
    If ChanID = 1 Then
        Chan2Status.Caption = "OnCallConnected " + CallerID + " " + CalleeID + " " + AudioFile
    End If
    If ChanID = 2 Then
        Chan3Status.Caption = "OnCallConnected " + CallerID + " " + CalleeID + " " + AudioFile
    End If
    If ChanID = 3 Then
        Chan4Status.Caption = "OnCallConnected " + CallerID + " " + CalleeID + " " + AudioFile
    End If

End Sub

Private Sub VR2Ctrl1_CallIdle(ByVal ChanID As Long, ByVal CallerIP As String, ByVal CallerID As String, ByVal CalleeIP As String, ByVal CalleeID As String, ByVal InitTime As Long, ByVal ConnectTime As Long, ByVal EndTime As Long, ByVal UniqueID As String, ByVal AudioFile As String, ByVal AudioFileNum As Long, ByVal Reason As Long, ByVal CallDir As Long, ByVal DTMFStr As String)
    If ChanID = 0 Then
        Chan1Status.Caption = "OnCallIdle " + CallerID + " " + CalleeID + " " + AudioFile
    End If
    If ChanID = 1 Then
        Chan2Status.Caption = "OnCallIdle " + CallerID + " " + CalleeID + " " + AudioFile
    End If
    If ChanID = 2 Then
        Chan3Status.Caption = "OnCallIdle " + CallerID + " " + CalleeID + " " + AudioFile
    End If
    If ChanID = 3 Then
        Chan4Status.Caption = "OnCallIdle " + CallerID + " " + CalleeID + " " + AudioFile
    End If

End Sub

Private Sub VR2Ctrl1_CallOffered(ByVal ChanID As Long, ByVal CallerIP As String, ByVal CallerID As String, ByVal CalleeIP As String, ByVal CalleeID As String, ByVal CallTime As Long, ByVal UniqueID As String, ByVal AudioFile As String, ByVal CallDir As Long)
    If ChanID = 0 Then
        Chan1Status.Caption = "OnCallOffered " + CallerID + " " + CalleeID + " " + AudioFile
    End If
    If ChanID = 1 Then
        Chan2Status.Caption = "OnCallOffered " + CallerID + " " + CalleeID + " " + AudioFile
    End If
    If ChanID = 2 Then
        Chan3Status.Caption = "OnCallOffered " + CallerID + " " + CalleeID + " " + AudioFile
    End If
    If ChanID = 3 Then
        Chan4Status.Caption = "OnCallOffered " + CallerID + " " + CalleeID + " " + AudioFile
    End If

End Sub
