using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace VR2WinApp
{
    public partial class RTListenerOptions : Form
    {
        public string RTSrvIP;
        public ushort RTSrvPort;

        public ushort RTSoftSIPPort;
        public ushort RTSoftRTPPort;

        public RTListenerOptions()
        {
            InitializeComponent();
        }

        private void RTListenerOptions_Load(object sender, EventArgs e)
        {
            tbIPAddr.Text = RTSrvIP;
            tbIPPort.Text = RTSrvPort.ToString();
            tbSoftSIPPort.Text = RTSoftSIPPort.ToString();
            tbSoftRTPPort.Text = RTSoftRTPPort.ToString();

        }

        private void btnOK_Click(object sender, EventArgs e)
        {
            RTSrvIP = tbIPAddr.Text;
            RTSrvPort = Convert.ToUInt16(tbIPPort.Text);
            RTSoftSIPPort = Convert.ToUInt16(tbSoftSIPPort.Text);
            RTSoftRTPPort = Convert.ToUInt16(tbSoftRTPPort.Text);

            DialogResult = DialogResult.OK;
            Close();
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }
    }
}